; start loader for BGE (begining from v 4.0 used sjasmplus v 1.20.3 or later)  / based of 'linkpack.asm'
; version 2+

    device zxspectrum128


            LUA PASS1
            -- trim implementations /from https://www.folkstalk.com/2022/09/lua-trim-with-code-examples.html
            function trim1(s)
                return (s:gsub("^%s*(.-)%s*$", "%1"))
            end
            -- from PiL2 20.4
            ENDLUA

            INCLUDE "export.asm"
            INCLUDE "Version.asm"
            INCLUDE "local_.asm"

            EMPTYTRD "bge_xxx.trd", BGE_DSKNAME_

; for monoloader puts : bacic, loader, 3 page, 6 page, 7 page, main data



; basic loader
             ORG #5D3B

beginbasic   DISPLAY "basic : ",/a, $

          DB 0,10
          DW len10
line10
          DB #EA,13   ; REM and ASM CODE

runload               ;  
          ld (iy+1),#CC
          ld a,#10
          ld bc,#7FFD
          ld (#5B5C),a
          out (c),a
          xor a
          ld (#5CF9),a   ; set operation load
          ld hl,s_load
         push hl
          ld b,high (lns_load+255)
          ld c,5
          ld de,(#5CF4)
         jp #3D13
len10=$-line10

          DB 0,20
          DW len20
line20
          DB #FB,":",#FD,"0",#0E,0,0,#FE,#5F,0,":"
             ;cls : clear 5ffe :
        ;  DB #F9,#C0,"0",#0E,0,0 : DW runload : DB 0
             ;randomize usr 'runload'
          DB #F9,#C0,"(0",#0E,0,0,0,1,0,"*",#BE,"0",#0E,0,0,#54,#5C,0,"+",#BE,"0",#0E,0,0,#53,#5C,0
          DB "+0",#0E,0,0 : DW runload-beginbasic : DB 0,")"
             ;randomize usr ( 256*PEEK[#5C54] + PEEK[#5C53] + (runload-beginbasic))
          DB 13
len20=$-line20

lenbasic EQU $-beginbasic
          DISPLAY "LenBasic : ",/a, lenbasic

;lnbastrk = high ($-beginbasic+255)

       ;   SAVETRD "bge_xxx.trd","boot.B",beginbasic,$-beginbasic,20

          SAVETRD "bge_xxx.trd",BGE_SFNAME_,beginbasic,$-beginbasic,20

;---------------------------------------------------------------------------------
; loader
            ORG #6000
s_load
            ld hl, InitBGE
           push hl          ;   
            ld hl,LD_dehr   ;    
            ld de,ld_dehr
            ld bc,ln_dload
            ldir

;         BGE (  )
            ld a,#07
            ld (#5C8D),a
            ld (#5C8F),a
            ld (#5C48),a   ; border
            ld hl,#4000
            ld de,#4001
            ld bc,6144
            ld (hl),l
            ld a,e
            ld (#5C3C),a    ;  
            ldir
            ld (hl),7
            ld bc,767
            ldir
            xor a
            out (#FE),a
            ld a,#CC
            ld (#5C3B),a

            ld hl,StartTXT
            call Print_
            ld hl,BasedTXT
            call Print_

           ;   128K
            ld hl,#C000
            xor a
            call setpg
            ld e,(hl)
            ld (hl),a
            inc a
            call setpg
            ld (hl),a
            dec a
            call setpg
            ld a,(hl)
            cp #10
           jr z,2F  ; 

            ld hl,Not128txt  ; 
            call Print_
1           halt
           jr 1B

2           ld hl,dep_loads
           push hl          ;  

            ld hl,txtLoad_

Print_
.l0         ld a,(hl)
            inc hl
            cp #FF
           ret z
            cp 13
           jr z,1F
            rst #10
           jr .l0

1          push hl                   ; SCROLL
           ld de,#5800
           ld hl,#5820
           ld bc,768-32
           ldir

           ld de,#4000
           ld b,23
2          push bc

           ld h,d
           ld a,32
           add a,e
           ld l,a
          jr nc,3F
           ld a,8
           add a,h
           ld h,a

3          push hl

           ld a,8
4          ex af,af'
           push hl
           push de
           ld bc,#0020
           ldir
           pop de
           pop hl
           inc h
           inc d
           ex af,af'
           dec a
          jr nz,4B

           pop de

           pop bc
          djnz 2B
           ld hl,#50E0
           ld c,8
5          ld b,32
           push hl
6          ld (hl),0
           inc l
          djnz 6B
           pop hl
           inc h
           dec c
          jr nz,5B
           pop hl

            ld a,#17
            ld (#5C83),a
            ld (#5C8B),a

            ld a,22
            rst #10
            xor a
            rst #10
            xor a
            rst #10
          jr Print_

Not128txt   DB #13,1,#10,2,"Sorry !",13,"You need 128 K minimum.",#FF


StartTXT    DB #11,0,#10,5,#13,0,22,0,0,"    Burial Graphics Editor",13,13,13,#10,6
            DB "Version: ",#10,7

            DB BGE_VERSION ,#10,6,#17,30

            LUA ALLPASS
             _pc("DB ' "..trim1(string.upper(sj.get_define("LOCAL"))).."'"  )
            ENDLUA

            DB #10,7,"________________________________",13,#FF

BasedTXT    DB 13,13,#10,4
            DB "Based  on the source code of the",13,13,#10,5
            DB "   Burial  Gfx  Editor  3.o5",13
            DB "   (c) 2oo1 Delirium Tremens",13
            DB "          from Freedom",13,13,#10,4
            DB "   - Sinn (coding, etc.)",13
            DB "   - Others of dtr - support",13,#10,7,13
            DB "            - - -",13
            DB "Also used the source code of GUI",13
            DB "    and later developments",13
            DB "________________________________",13,13,13,#FF


txtLoad_    DB "Loading and Depacking ...",22,0,0,#FF



;------------
LD_dehr
            DISP #BE80

ld_dehr     INCLUDE "DEHRUST@.asm"

dep_loads
            ld a,3
            ld hl,#C000
            ld b,LnBl.l3
            call loaddepk

            ld a,6
            ld b,LnBl.l6
            ld hl,#C000
            call loaddepk

            ld a,7
            ld b,LnBl.l7
            ld hl,#DB00
            call loaddepk

            ld hl,#6000
            ld b,LnBl.lm
            xor a
loaddepk           ; a - page , hl -adr.
             push hl
             push af
             ld hl,#6000
             call load
             pop af
             call setpg
             pop de
             ld hl,#6000
             di
             xor a
             call DEHRUST
             ei
            ret

setpg       or #10
            push bc
            ld bc,#7FFD
            ld (#5B5C),a
            out (c),a
            pop bc
           ret
load
            ld c,5
            ld de,(#5CF4)
           jp #3D13

ln_dload   EQU $-ld_dehr

          ASSERT  $ < #C000 ;
             ENT

lns_load   EQU $-s_load

         ;   SAVETRD "bge_xxx.trd",&"boot.B",s_load,$-s_load

             SAVETRD "bge_xxx.trd",&BGE_SFNAME_,s_load,$-s_load

;---------------------------------------------------------------------------------


; length of blocks

LnBl EQU #6000

            ORG LnBl
           INCBIN "bge_3.hst"
.l3 = high ($-LnBl+255)

           ; SAVETRD "bge_xxx.trd",&"boot.B",LnBl,$-LnBl
            SAVETRD "bge_xxx.trd",&BGE_SFNAME_,LnBl,$-LnBl

            ORG LnBl
           INCBIN "bge_6.hst"
.l6 = high ($-LnBl+255)

           ; SAVETRD "bge_xxx.trd",&"boot.B",LnBl,$-LnBl
            SAVETRD "bge_xxx.trd",&BGE_SFNAME_,LnBl,$-LnBl

            ORG LnBl
           INCBIN "bge_7.hst"
.l7 = high ($-LnBl+255)

           ; SAVETRD "bge_xxx.trd",&"boot.B",LnBl,$-LnBl
            SAVETRD "bge_xxx.trd",&BGE_SFNAME_,LnBl,$-LnBl

            ORG LnBl
           INCBIN "bge_main.hst"
.lm = high ($-LnBl+255)

           ; SAVETRD "bge_xxx.trd",&"boot.B",LnBl,$-LnBl
            SAVETRD "bge_xxx.trd",&BGE_SFNAME_,LnBl,$-LnBl



; Save overlays for BGE

            MACRO sv_BGEfl p00000000
             ORG #6000
             INCBIN p00000000
             SAVETRD "bge_xxx.trd",| p00000000 ,#6000,$-#6000  ; trdext3-ok
            ENDM

            sv_BGEfl bge_ovr0.Cod
            sv_BGEfl bge_ovr1.Cod
            sv_BGEfl bge_ovr2.Cod
            sv_BGEfl bge_ovr3.Cod
            sv_BGEfl bge_ovr4.Cod
            sv_BGEfl bge_ovr5.Cod
            sv_BGEfl bge_ovr6.Cod
            sv_BGEfl bge_ovr7.Cod

; Save locals Keyboard Layouts        string.gsub(s, "^%s*(.-)%s*$", "%1")



            MACRO INCLUDE_ADD_L p00000000
              LUA ALLPASS
               local stra = "add/"..trim1(sj.get_define("LOCAL")).."/"
               local strb = trim1(sj.get_define("p00000000",true))
               if (sj.file_exists(stra..strb))
                  then sj.insert_define("_p00000101",stra..strb)
                  elseif (sj.file_exists("add/"..strb))
                      then sj.insert_define("_p00000101","add/"..strb )
                  elseif (sj.file_exists("add/en/"..strb))
                      then sj.insert_define("_p00000101","add/en/"..strb)
                  elseif (sj.file_exists("add/ru/"..strb))
                      then sj.insert_define("_p00000101","add/ru/"..strb)
               end
              ENDLUA
              IFDEF _p00000101
               INCLUDE _p00000101
               UNDEFINE _p00000101
              ENDIF
            ENDM


            INCLUDE_ADD_L keyboards.asm


; Save addition for BGE

            MACRO sv_BGEadd p00000000
             ORG #6000
             INCBIN add/p00000000
             SAVETRD "bge_xxx.trd",| p00000000 ,#6000,$-#6000  ; trdext3-ok
            ENDM


            MACRO sv_BGEaddL p00000001
              ORG #6000
              LUA ALLPASS
               local stra = "add/"..trim1(sj.get_define("LOCAL")).."/"
               local strb = trim1(sj.get_define("p00000001",true))
               if (sj.file_exists(stra..strb))
                  then sj.insert_define("_p00000201",stra..strb)
                  elseif (sj.file_exists("add/"..strb))
                      then sj.insert_define("_p00000201","add/"..strb )
                  elseif (sj.file_exists("add/en/"..strb))
                      then sj.insert_define("_p00000201","add/en/"..strb)
                  elseif (sj.file_exists("add/ru/"..strb))
                      then sj.insert_define("_p00000201","add/ru/"..strb)
               end
              ENDLUA
              IFDEF _p00000201
               INCBIN _p00000201
               SAVETRD "bge_xxx.trd",| p00000001 ,#6000,$-#6000  ; trdext3-ok
               UNDEFINE _p00000201
              ENDIF
            ENDM

            MACRO sv_BGEaph p00000000,p00000001
             ORG #6000
             INCBIN p00000000/p00000001
             SAVETRD "bge_xxx.trd",| p00000001 ,#6000,$-#6000  ; trdext3-ok
            ENDM


            MACRO sv_BGE_ p00000000
             ORG #6000
             INCBIN p00000000
             SAVETRD "bge_xxx.trd",| p00000000 ,#6000,$-#6000  ; trdext3-ok
            ENDM


         ; plugins

            sv_BGEadd add0.add

            sv_BGEaddL spriter.add
            sv_BGEaddL blc.add
            sv_BGEaddL CEv0_4c.add
            sv_BGEaddL chanker.add
            sv_BGEaddL cleaner.add
            sv_BGEaddL deform-6.add
            sv_BGEaddL flager.add
            sv_BGEaddL incliner.add
            sv_BGEaddL magnifer.add
            sv_BGEaddL optim-.add
            sv_BGEaddL optim1_1.add
            sv_BGEaddL scr-txt.add
            sv_BGEaddL slide.add
            sv_BGEaddL spline3.add
            sv_BGEaddL traces.add
            sv_BGEaddL turner.add
            sv_BGEaddL wizzard.add
            sv_BGEaddL zoomer.add

            sv_BGEaddL ScrPrint.add
            sv_BGEaddL DDp-ATM2.add
            sv_BGEaddL ULA+.add

       ;     sv_BGEadd 3color.add
            sv_BGEadd example.add
            sv_BGEadd add9.add


            sv_BGEadd bgepgns.lst        ; list of plugins


          ; other
            sv_BGEadd PrDrBB55.drv       ; printer driver for ScrPrint.add

            sv_BGEaph add/CHR,COMIC.chr  ; example CHR font

            sv_BGEadd Pent-512.ram       ; example RAM-driver for Pentagon 512 K

            sv_BGEadd bgegfx.scr         ; skin for BGE

            sv_BGEadd bge.scr            ; start loading screen for add9.add

            sv_BGEadd bgegfx0.scr        ; example skin

            sv_BGEadd bge0.scr           ; example BGE screen

            sv_BGEadd example.img        ; example double screen


;-------------------------------------------------------------
; boot program for start bge

             ORG #5D3B

beginboot   DISPLAY "save boot"

          DB 0,10
          DW .len10
.line10    DB #F9,#C0,"0",#0E,#00,#00 : DW 15619 : DB 0,":",#EA,":",#F7,#22,BGE_BFNAME_,#22,13
          ; RANDOMIZE USR 0[15619]: REM : RUN "BGE***"
.len10=$-.line10

       SAVETRD "bge_xxx.trd","boot.B",beginboot,$-beginboot,10



    LABELSLIST  "loader.l"
