;   ULA+  BGE v4.XX

      MACRO  mVersion : DB "v.1.0" : ENDM

        device  zxspectrum128

        INCLUDE "../local.asm"  ; for varios localisations

        INCLUDE "../KerBGE.asm"
        INCLUDE "../NumGUI.asm"

        ORG #6128
        INCLUDE "../GuiVar.asm"




        ORG PgnAdr

START           ld (.ex_),hl
                call ULAplus_start
                call LOADSCR
                xor a
.ex_ EQU $+1 : jp 0




ULAplus_start   ld (.sp),sp
                call ERASE_ALLW
                call CLS


.flnewstart EQU $+1 : ld a,1    ; 1-     (   )
                or a
               jr z,.s0
                call .titulWin
               ret nz

                xor a
                ld (.flnewstart),a

                ld hl,(#6100)   ;    BGE 4  .
                ld bc,WULAp.lttDrive4
                ld a,l
                cp "B"
               jr nz,1F
                ld a,h
                cp 4
               jr nc,2F
1               ld de,.Sort1
                ld hl,WULAp.ttDrive
                ld c,WULAp.lttDrive
                xor a
               jr 3F
2               ld de,.Sort40
                ld hl,WULAp.ttDrive4
                ld a,1
3               ld (.fl40),a       ;    >=4.0
                ld (.Sort),de
                ld de,WULAp.tDrive
                ldir

.s0             call OnULAplus
                ld a,(.flULApl)
                or a
               jr z,.l0
                call checkPalette
                call z,SetPalette

.l0             ld a,%1000
                ld ix,WULAp
                ld (ix+6),a
.sp     EQU $+1 :  ld sp,0
                call .GetDrive_
                call .SelectUAttr

                ld de,selector      ;  ULA+ on/off
.flULApl  EQU $+1 : ld a,0
                or a
               jr z,1F
                ld de,selector.yes
1               ld hl,#001D
                ld bc,#0101
                call outSPR


                ld a,Win
                call GUI
                push af
                ld a,NOKEY
                call GUI
                call Oselector
                pop af
                inc a
               ret z
                dec a
               ret z
                ld e,a
                ld bc,.TBL-2
                call TAB_JP


               jr .l0



.TBL
               DW SwitchULAplus ; 1  - ULA+ on/off
               DW .SelectUCol   ; 2  -   
               DW .EditRGB      ; 3  -   
               DW .popWin       ; 4  -    
               DW .Load         ; 5  - 
               DW .Save         ; 6  - 
               DW Driver        ; 7  - 
               DW .StPal1       ; 8  - 
               DW .StPal1_2     ; 9  -  2/4
               DW .StPal2       ; 10 -  2
               DW .StPal2_2     ; 11 -  2 2/4
               DW .ReRead       ; 12 - 
               DW .ReWrite      ; 13 - 
               DW .titulWin     ; 14 - help


.SelectUCol
                ld hl,(ARW_XC)
                ld a,l
                cp 31
               ret nc
                sub 8
               ret c
                ld l,a
                ld a,h
                cp 20
               ret nc
                sub 2
               ret c
                ld h,a
                ld c,l
                xor a
                ld e,a   ; 
                ld b,8
1               cp c
               jr z,2F
                inc a
                cp c
               jr z,2F
                inc a
                inc a
                inc e
               djnz 1B
               ret
2               ld c,h
                xor a
                ld d,a  ; 
                ld b,4
1               cp c
               jr z,2F
                inc a
                inc a
                inc d
                cp c
               jr z,2F
                inc a
                inc a
                inc a
                inc d
               djnz 1B
               ret
2               ld a,d
                add a,a
                add a,a
                add a,a
                or e
                ld (SelectColor_),a

.SelectUAttr    ld a,(SelectColor_)  ; 
                ld c,a
                and #30
                add a,a
                add a,a
                ld b,a
                ld a,c
                and #0F
                ld e,a
                ld d,0
                ld hl,selcolori_
                add hl,de
                ld a,(hl)
                or b
                ld (SelectAttr_),a
.Ret_          ret


.EditRGB        ld hl,(ARW_XC)        ;;;3,21,8,3,%10    ; 3 -   
                ld a,l
                sub 3
               ret c
                cp 8
               ret nc
                ld e,a
                ld a,h
                sub 21
               ret c
                ld d,a

                call inCurRGB     ; / hl -addr in palette, b=0, a=c=%rgb
                ex af,af'
                ld a,e
                ld bc,2*256+%11100011      ; Red
                inc d
                dec d
               jr z,1F            ; 0
                ld bc,5*256+%00011111      ; Green
                dec d
               jr z,1F            ; 1
                or a
                rra
                ld bc,8*256+%11111100      ; Blue

1               rlca
               djnz 1B
                ld e,a
                ex af,af'
                and c
                or e
                ld (hl),a
                ld e,a

.svRGB_         ld a,(.flULApl)
                or a
               ret z
                ld a,(SelectColor_)
               jp svRGBtoULAp       ; in A-num, E - %rgb


.popWin         ld hl,WpopWin
                ld ix,.popwinIXemu
                call pupmnu
                ld (ix+6),%1110
                call WIN_
                ld hl,StandartPalette
                or a
               jr z,1F
                ld hl,BrightPalette
                dec a
               ret nz
1               ld a,(SelectColor_)  ;    
                ld c,a
                ld b,0
                add hl,bc
                ld e,(hl)
                ld hl,Palette
                add hl,bc
                ld (hl),e
                ld a,c
               jr .svRGB_

.popwinIXemu  DB 12,19,8,4,0,0   ;   


.titulWin       ld ix,WTitulWin
                ld (ix+6),%1111
                call WIN_
                or a
               ret


;----------
.Load
.Sort EQU $+1 : ld hl,.Sort40
1               call FilerE
               ret c
                ld hl,Palette.boof
                ld de,(START_SEC)
                ld bc,#0105
                ld a,DOS_FUNC
                call GUI
               ret c
                call GetPalette.mv
               jr .ReWrite


.Sort40          DB %0101 : DW 64    ;  BGE >= v4.0
                DB #FF


.Sort1          DB #00,#01,#FF       ;  BGE < v4.0      


.GetDrive_
.fl40  EQU $+1 : ld a,0
                or a
               ret z
                call GetDrive
                ld (WULAp.tDriveCHR),a
               ret

.Save           call .selFname
               ret c
                ld a,DOS_FUNC
                ld de,64
                ld hl,Palette
                ld bc,#010B  ; save file
                call GUI
               ret

.selFname    ld de,.PalName
             ld hl,(.Sort)
             ld a,(.fl40)
             or a
            jp nz,FNSelect
             ex de,hl
             call FNEdit
            ret c
             ld a,#FF
            ret

.PalName   DB "palette ula",0  ;   




;------------
.StPal1        ld bc,64
              jr 1F
.StPal1_2      ld bc,32
1              ld hl,StandartPalette
              jr 2F
.StPal2        ld bc,64
              jr 1F
.StPal2_2      ld bc,32
1              ld hl,BrightPalette
2              ld de,Palette
               ldir
.ReWrite       ld a,(.flULApl)
               or a
              ret z
              jp SetPalette

.ReRead        ld a,(.flULApl)
               or a
              ret z
              jp GetPalette


WULAp           DB 0,0,32,24,7,7,%0000,0

                DW .txt   ;   - (text object)
                DW .sel   ;   - () (highlighting object)
                DW .hk    ;     (hotkeys)
                DW Nil ;.but  ;   - () (buttons object)
                DW Nil ;.flg  ;   - (flags object)
                DW Nil      ;   -  (radio buttons object)
                DW Nil      ;    (scrollbar)
                DW .Cr       ;      (call on create)
                DW .Imme     ;     "" (call "on interrupt")

                DW #FFFF


.txt            DB 13,22,1,0
                MSG_Title : DB 13,22,20,0
                mVersion : DB 13,22,26,0,"ULA+",13,22,1,3

                MSG_Load : DB 13,13
                MSG_Save : DB 13,22,1,19
                MSG_EXIT : DB 13,22,1,10

                MSG_Standartpal : DB 13
                DB "-- 2/4 --",13,13
                MSG_Brightpal : DB 13
                DB "-- 2/4 --",13,13

                MSG_ReRead : DB 13
                MSG_ReWrite : DB 13

                DB 22,1,7
.tDrive         MSG_Drive4_
.tDriveCHR      DB 0,0,0,0


.ttDrive       MSG_Drive_
.lttDrive    EQU $-.ttDrive
.ttDrive4      MSG_Drive4_
.lttDrive4   EQU $-.ttDrive4


.sel           DB 0,19,6,1,%11    ; 0 - exit
               DB 25,0,6,1,%11    ; 1  - ULA+ on/off
               DB 8,2,23,18,%10   ; 2  -   
               DB 3,21,8,3,%10    ; 3  -   
               DB 11,21,4,3,%10   ; 4  -    
               DB 0,3,7,1,%11     ; 5  - 
               DB 0,5,7,1,%11     ; 6  - 
               DB 0,7,7,1,%11     ; 7  - 
               DB 0,10,7,1,%11    ; 8  - 
               DB 0,11,7,1,%11    ; 9  -  2/4
               DB 0,13,7,1,%11    ; 10 -  2
               DB 0,14,7,1,%11    ; 11 -  2 2/4
               DB 0,16,7,1,%11    ; 12 - 
               DB 0,17,7,1,%11    ; 13 - 

               DB #FF

.hk            DB "U",0       ; ULA on/off
                DW 1
               DB "L",0       ; load
                DW 5
               DB "S",0       ; save
                DW 6
               DB "D",0       ; Disk
                DW 7
               DB "1",0       ; standart
                DW 8
               DB "2",0       ; standart 2/4
                DW 9
               DB "3",0       ; standart 2
                DW 10
               DB "4",0       ; standart 2 2/4
                DW 11
               DB "R",0       ; reread
                DW 12
               DB "Y",0       ; rewrite
                DW 13
               DB "H",0       ; help
                DW 14
     ;          DB "",0
     ;           DW
     ;          DB "",0
     ;           DW
     ;          DB "",0
     ;           DW
     ;          DB "",0
     ;           DW

              DB #FF

;-----------------------------
.Cr             call ORAMKI


                ld hl,#1501
                ld de,RGBspr
                ld bc,#0301
                call outSPR
                ld hl,21*256+16
                ld de,Chanki
                ld bc,#0110
                call outSPR
                ld b,8
                ld hl,22*256+16
1               push bc
                ld de,Obrazetc
                ld bc,#0102
                call outSPR
                pop bc
                inc l
                inc l
               djnz 1B

                ld de,INKspr
                ld a,(SelectColor_)
                bit 3,a
               jr z,1F
                ld de,PAPERspr
1               ld hl,21*256+11
                ld bc,#0304
                call outSPR

                call colpapa


                call Oselector
                call outP_RGB

               ret

.Imme                 ;    
               ld hl,(ARW_X)
               ld a,h
               cp 169
              ret c
               ld a,l
               rra : rra : rra : rra
               and #0F
               sub 8
              ret c
               ld (cnkposit_),a
             jp CnkSelOut  ; call CnkSelOut

           ;   ret



ORAMKI          ld hl,#4120
                call lin4
                ld hl,#5680
                call lin4

                ld hl,#4627   ;     
                call 1F

                ld hl,#46C7   ;     
                call 1F

                ld hl,#4E67   ;     
                call 1F

                ld hl,#5607   ;     

1               ld a,#FF
                call 3F
                ld b,5
2               call downHL_
               djnz 2B
                xor a
3               call lin1
                call downHL_
                call lin2
                call downHL_
                ld b,8
4               call lin3
                call downHL_
               djnz 4B
                call lin2
                call downHL_

lin1            push hl,bc
                ld de,#FFC3
                ld (hl),3
                inc l
                ld b,7
1               ld (hl),d
                inc l
                ld (hl),d
                inc l
                ld (hl),e
                inc l
               djnz 1B
                ld (hl),d
                inc l
                ld (hl),d
                inc l
                ld (hl),#C0
                pop bc,hl
               ret

lin2            push hl,bc
                ld (hl),2
                inc l
                ld b,7
1               inc l
                inc l
                ld (hl),#42
                inc l
               djnz 1B
                inc l
                inc l
                ld (hl),#40
                pop bc,hl
               ret

lin3            push hl,bc
                ld (hl),2
                inc l
                ld b,7
1               ld (hl),a
                inc l
                ld (hl),a
                inc l
                ld (hl),#42
                inc l
               djnz 1B
                ld (hl),a
                inc l
                ld (hl),a
                inc l
                ld (hl),#40
                pop bc,hl
               ret

lin4            ld b,32  ; 
lin5            ld (hl),#FF
                inc l
               djnz lin5
               ret

downHL_         ex af,af'
                call downHL
                ex af,af'
               ret

colpapa
SelectAttr_  EQU $+1 : ld a,5
                ld (#5ACC),a
                ld (#5ACD),a

                ld de,selcolori_
                ld hl,#5848   ;    
                ld b,4
                ld c,%00000000
1               push bc
                call col_lca
                ld bc,96
                add hl,bc
                pop bc
                ld a,%01000000
                add a,c
                ld c,a
               djnz 1B

CnkSelOut
                ld hl,#51F0   ; \ink  paper    
                ld e,7
                ld d,l
                ld a,(SelectColor_)
                and 8
               jr z,1F
                ld a,#FF
1               ld b,16
                ld l,d
2               ld (hl),a
                inc l
               djnz 2B
                inc h
                dec e
               jr nz,1B

                ld hl,#56F0
cnkposit_ EQU $+1 : ld a,1      ;    
                add a,a
                ld c,a
                ld b,0
                push bc        ; \bc/
                add hl,bc
                ld a,(hl)
                xor 3
                ld (hl),a
                inc l
                ld a,(hl)
                xor #C0
                ld (hl),a

                ld de,selcolori_
                ld a,(SelectColor_)
                ld bc,256*%11000111+8
                and c                   ; and 8
               jr z,1F
                ld de,selcolori_+8
                ld b,%11111000
                ld c,1
                ld bc,256*%11111000+1
1               ld a,(SelectAttr_)
                and b
                ld b,8
                ld hl,#5AD0   ; #5AF0
1               ld (hl),a
                set 5,l
                ld (hl),a
                inc l
                ld (hl),a
                res 5,l
                ld (hl),a
                inc l
                add a,c
               djnz 1B
                pop bc        ; /bc\
                ld hl,#5AD0
                add hl,bc
                ld a,(hl)
                ld hl,#5AB0
                ld b,16
1               ld (hl),a
                inc l
               djnz 1B
               ret

col_lca         ld de,selcolori_
                call 2F
                push de
                ld de,64
                add hl,de
                pop de
2               ld b,8
                push hl
3               ld a,(de)
                or c
                inc de
                ld (hl),a
                inc l
                ld (hl),a
                inc l
                inc l
               djnz 3B
                pop hl
               ret




Oselector                    ; /  xor    
               ld a,5
SelectColor_  EQU $-1        ;      (0 - 63)
               ld b,a
               and 7
               ld c,a
               add a,a
               add a,c
               add a,7
               ld l,a        ; X -coord
               ld a,b
               rrca : rrca : rrca
               and 7
               ld b,a
               rra
               ld c,a
               add a,a
               add a,a
               add a,c
               ld c,a
               ld a,b
               and 1
               add a,a
               add a,c
               inc a
               ld h,a         ; Y -coord
               call ADRHL8_
               inc h
               inc h
               inc h
               inc h

Bramka         call .liho
               ld b,14
1              push hl
               ld a,(hl)
               xor #08
               ld (hl),a
               inc l
               inc l
               inc l
               ld a,(hl)
               xor #10
               ld (hl),a
               pop hl
               call downHL
              djnz 1B
.liho          push hl
               ld a,(hl)
               xor #0F
               ld (hl),a
               inc l
               ld a,(hl)
               xor #FF
               ld (hl),a
               inc l
               ld a,(hl)
               xor #FF
               ld (hl),a
               inc l
               ld a,(hl)
               xor #F0
               ld (hl),a
               pop hl
downHL
               inc h
               ld a,h
               and 7
              ret nz
               ld a,l
               add a,32
               ld l,a
              ret c
               ld a,h
               sub 8
               ld h,a
              ret

ADRHL8_      ld a,h     ; HL - 
             rrca
             rrca
             rrca
             and #E0
             or l
             ld l,a
             ld a,h
             and #18
             or #40
             ld h,a
            ret

inCurRGB     ld a,(SelectColor_)  ;    
.a           ld c,a
             ld b,0               ;  out: hl - addr in TAB  A,C - %rgb , B=0
             ld hl,Palette
             add hl,bc
             ld a,(hl)
             ld c,a
            ret

outP_RGB      ;     3,21
             call inCurRGB
             and %00011100   ; Red
             rrca
             rrca
             ld hl,#1503     ; x=3, y=21
             call 2F
             ld a,c
             and %11100000   ; Green
             rlca
             rlca
             rlca
             ld hl,#1603     ; x=3, y=22
             call 2F
             ld a,c
             and %00000011   ; Blue
             ld de,Bdsprs.fill
            jr nz,1F
             ld de,Bdsprs.zero
1            ld hl,#1703     ; x=3, y=23
             inc a
             ld b,a
             ld a,4
             sub b
            push af
             ld a,2
             call 3F
            pop af
            ret z
             ld b,a
             ld de,Bdsprs
            jr 4F
2             ld de,RGdsprs.fill
              or a
             jr nz,1F
              ld de,RGdsprs.zero
1             inc a
              ld b,a
              ld a,8
              sub b
             push af
              ld a,1
              call 3F
             pop af
             ret z
              ld b,a
              ld de,RGdsprs
              call 4F
             ret
3             ld (.c_r),a
4             push bc,de
.c_r EQU $+1 :  ld bc,#0101
              call outSPR
              ld a,c
              add a,l
              ld l,a
              pop de,bc
             djnz 4B
             ret




outSPR    ; in DE - address, HL - x,y , BC - sx,sy
           ld (.dat),hl
           ld (.dat+2),bc
           push ix,hl,bc
           ld ix,.dat
           call LoadWS
           pop bc,hl,ix
          ret

.dat      DB 0,0,1,1
;----------------------


OnULAplus         di            ;  
                  ld bc,#BF3B
                  ld a,#40
                  out (c),a

                  ld b,#FF
                  ld a,#01
                  out (c),a

                  xor a
                  ld b,#BF
                  out (c),a
                  ei
                  halt
FlReadULA_  EQU $+1 : ld a,#FF          ;     ULA+
                  or a
                 jr z,1F

                  ld b,#FF
                  in a,(c)
                  ld e,a
                  ld a,#18
                  out (c),a
                  halt
                  in a,(c)
                  ld d,a
                  ld a,e
                  out (c),a
                  ld a,d
                  cp #18
1                 ld a,#FF
                 jr z,1F
                  xor a
1                 ld (ULAplus_start.flULApl),a
                 ret

SwitchULAplus      ld a,(ULAplus_start.flULApl)
                   or a
                  jr z,OnULAplus
OffULAplus         di              ; return zx ula
                   ld bc,#BF3B
                   ld a,#40
                   out (c),a

                   ld b,#FF
                   xor a
                   out (c),a
                   ld (ULAplus_start.flULApl),a
                   ei
                   halt
                  ret


svRGBtoULAp       ; in A-num, E - %rgb  ;    
                   di
                   ld bc,#BF3B
                   out (c),a
                   ld b,#FF
                   out (c),e
                   ei
                   halt
                  ret

checkPalette       ld hl,Palette.boof
                   di
                   push hl
                   ld de,#BFFF   ; in hl - addres
                   ld bc,#BF3B
                   ld a,#40
                   out (c),a
                   ld b,e
                   ld a,1
                   out (c),a
                   xor a
1                  ld b,d
                   out (c),a
                   ld b,e
                   ex af,af'
                   in a,(c)
                   ld (hl),a
                   inc hl
                   ex af,af'
                   inc a
                   and #3F
                  jr nz,1B
                   pop hl
                   call 1F
                   ei
                  ret
1                  ld b,63
                   ld a,(hl)
                   inc hl
2                  cp (hl)
                  ret nz
                   inc hl
                  djnz 2B
                  ret

SetPalette         di
                   ld hl,Palette
                   ld de,#BFFF
                   ld bc,#BF3B
                   ld a,#40
                   out (c),a
                   ld b,e
                   ld a,1
                   out (c),a
                   xor a
1                  ld b,d
                   out (c),a
                   ld b,e
                   ex af,af'
                   ld a,(hl)
                   inc hl
                   out (c),a
                   ex af,af'
                   inc a
                   and #3f
                  jr nz,1B
                   ei
                  ret


GetPalette         call checkPalette
                  ret nz
.mv                ld hl,Palette.boof
                   ld de,Palette
                   ld bc,64
                   ldir
                  ret

;----------------------



WpopWin        DB 0,0,8,4,7*8,7,%1110,0
                DW .txt   ;   - (text object)
                DW .sel   ;   - () (highlighting object)
                DW #FFFF

.txt            MSG_PopDefault : DB 13
                MSG_PopBright
               DB 0

.sel            DB 1,1,6,1,%11
                DB 1,2,6,1,%11
               DB #FF


WTitulWin       DB 4,2,24,21,7*8,7,%1111,0
                DW .txt   ;   - (text object)
                DW .sel   ;   - () (highlighting object)
                DW .hk
                DW #FFFF

.txt           MSG_Title : DB 13
               MSG_TWinTXT
              DB 0

.sel          DB 0,0,24,21,%10  ; 0
             DB #FF

.hk           DB "H",0
               DW 0
              DB #FF


WIN_            ld a,Win
                call GUI
                push af
                ld a,NOKEY
                call GUI
                call CLOSE
                pop af
               ret

;----------------------
selcolori_   DB #38,#39,#02,#03,#04,#05,#06,#07   ;    INK
             DB #07,#0F,#10,#18,#20,#28,#30,#38   ;    PAPER


Chanki     DB 0,136,136,136,170,170,170,170
           DB 170,170,238,255,255,255,255,255
           DB 0,0,0,0,0,68,68,68
           DB 85,85,85,85,85,119,119,255
           DB 0,0,34,170,170,170,170,170
           DB 170,187,187,187,255,255,255,255
           DB 0,0,0,0,0,0,17,85
           DB 85,85,85,85,85,85,221,255
           DB 0,136,136,136,170,170,170,170
           DB 170,170,238,255,255,255,255,255
           DB 0,0,0,0,0,68,68,68
           DB 85,85,85,85,85,119,119,255
           DB 0,0,34,170,170,170,170,170
           DB 170,187,187,187,255,255,255,255
           DB 0,0,0,0,0,0,17,85
           DB 85,85,85,85,85,85,221,255

Obrazetc   DB 0,0,31,28,50,112,105,234
           DB 83,150,70,76,28,248,0,0


selector   DB 60,66,129,129,129,129,66,60    ; 
.yes       DB 60,66,153,189,189,153,66,60

;notColor   DB 0,127,93,77,85,89,93,127   ; N      


RGBspr     DB 0,254,195,195,252,198,195,0
           DB 0,126,227,192,207,227,126,0
           DB 0,248,198,252,195,195,254,0

Bdsprs     DB 0,0,255,254,128,2,128,2       ; (1,2)   B 
           DB 128,2,128,2,255,254,0,0
.fill      DB 0,0,255,254,255,254,255,254
           DB 255,254,255,254,255,254,0,0
.zero      DB 0,0,255,254,240,2,224,2
           DB 192,2,192,2,255,254,0,0

RGdsprs    DB 0,254,130,130,130,130,254,0   ; (1,1)   R  G 
.fill      DB 0,254,254,254,254,254,254,0
.zero      DB 0,254,242,226,194,194,254,0


INKspr     DB 0,0,0,0,0,58,84,0            ; (4,3)
           DB 0,19,88,0,0,18,212,0
           DB 0,58,84,0,0,0,0,0
           DB 3,255,255,192,2,0,0,64
           DB 2,255,255,64,2,255,255,64
           DB 2,255,255,64,2,255,255,64
           DB 2,255,255,64,2,255,255,64
           DB 2,255,255,64,2,255,255,64
           DB 2,0,0,64,3,255,255,192
           DB 0,0,0,0,0,0,0,0
           DB 0,0,0,0,0,0,0,0
           DB 0,0,0,0,0,0,0,0
PAPERspr   DB 0,0,0,0,1,141,155,0           ; (4,3)
           DB 1,85,90,128,1,221,211,0
           DB 1,21,26,128,0,0,0,0
           DB 3,255,255,192,2,0,0,64
           DB 2,0,0,64,2,0,0,64
           DB 2,0,0,64,2,0,0,64
           DB 2,0,0,64,2,0,0,64
           DB 2,0,0,64,2,0,0,64
           DB 2,0,0,64,3,255,255,192
           DB 0,0,0,0,0,0,0,0
           DB 0,0,0,0,0,0,0,0
           DB 0,0,0,0,0,0,0,0




flPalette     DB 0    ;   
flChangePal   DB 0    ;   
flSavePal     DB 0    ;    


StandartPalette                                  ;   ULA+
            DB #00,#02,#14,#16,#A0,#A2,#B4,#B6    ; ink
            DB #00,#02,#14,#16,#A0,#A2,#B4,#B6    ;   paper
            DB #00,#03,#1C,#1F,#E0,#E3,#FC,#FF    ; ink          +bright
            DB #00,#03,#1C,#1F,#E0,#E3,#FC,#FF    ;   paper
            DB #B6,#B4,#A2,#A0,#16,#14,#02,#00    ; ink          +flash
            DB #B6,#B4,#A2,#A0,#16,#14,#02,#00    ;   paper
            DB #FF,#FC,#E3,#E0,#1F,#1C,#03,#00    ; ink          +bright+flash
            DB #FF,#FC,#E3,#E0,#1F,#1C,#03,#00    ;   paper


BrightPalette                                    ;    
            DB #00,#02,#18,#1B,#C0,#C3,#B8,#DB
            DB #00,#02,#18,#1B,#C0,#C3,#B8,#DB
            DB #00,#03,#1C,#1F,#E0,#E3,#FC,#FF
            DB #00,#03,#1C,#1F,#E0,#E3,#FC,#FF
            DB #DB,#B8,#C3,#C0,#1B,#18,#02,#00
            DB #DB,#B8,#C3,#C0,#1B,#18,#02,#00
            DB #FF,#FC,#E3,#E0,#1F,#1C,#03,#00
            DB #FF,#FC,#E3,#E0,#1F,#1C,#03,#00


Palette                                           ; 
            DB #00,#02,#14,#16,#A0,#A2,#B4,#B6    ; ink
            DB #00,#02,#14,#16,#A0,#A2,#B4,#B6    ;   paper
            DB #00,#03,#1C,#1F,#E0,#E3,#FC,#FF    ; ink          +bright
            DB #00,#03,#1C,#1F,#E0,#E3,#FC,#FF    ;   paper
            DB #B6,#B4,#A2,#A0,#16,#14,#02,#00    ; ink          +flash
            DB #B6,#B4,#A2,#A0,#16,#14,#02,#00    ;   paper
            DB #FF,#FC,#E3,#E0,#1F,#1C,#03,#00    ; ink          +bright+flash
            DB #FF,#FC,#E3,#E0,#1F,#1C,#03,#00    ;   paper

.boof      DS 260                             ;   

;-------------------------------------------------
LEN=$-PgnAdr

      DISPLAY "ULA+ len :",/a, LEN
       ASSERT  $ < #C000

         savebin "ULA+.add",START,LEN

          LabelList