;    (, ,   ..)  BGE
; Work with objects (plots, lines, shapes e.t.) in BGE

ObjectsPgn
                   DISP PgnAdr
;------------------------------------------------- Objects.FigaLUndo
Objects      call SV_UNDO
             ld (.spp),sp

             ld hl,PLOTT  ; #BC00
             ld de,#FC00
             ld bc,#0400
             ldir         ;     
             ld hl,(aplottout)
             ld (.aplotout),hl
             ld hl,plottout
             ld (aplottout),hl
             xor a
             ld (ANDplEqAD_),a

             call INSTALL_PLOT.i  ;   

             call InitLUndo
     ;        call MiniLoupeS5

.l0          call ReWin
             ld a,128+%1111
.l1          ld ix,WObjects
             ld (ix+6),a

             ld sp,0
.spp     EQU $-2
             call ARW_DEFAULT_
          ;   ld hl,WObjects.But+4
             ld a,1
.MODE_  EQU $-1             ;   XOR/OR/AND/NOP
  ;           ld b,4
  ;           call SetBCol
             ld (WObjects.BtMODop),a
             ld a,(Sieve)
             or a
             ld a,6
            jr z,1F
             dec a   ; 5
1            ld (WObjects.pmskCol),a
             ld a,(REALRGB)
             ld (WObjects.RGBcol),a

             call Win_
             ld c,a
             cp #FF
            jr z,.Exit
             cp WObjects.SelQ
            jr c,.ln
             ld a,c
             sub WObjects.SelQ
             ld c,a
             sub 4
            jr c,.SotMode
             cp WObjects.numBop
             ld bc,.TbBut_O
            jr c,.noBut_
             sub WObjects.numBop
             call CLOSE_

             push af
             call LOADSCR
             pop af
             ld bc,.TbBut
             call TAB_JP
            jr .l0

.noBut_      call TAB_JP

.ln          ld a,128+%1101
            jr .l1

.SotMode     ld a,c
             ld (.MODE_),a
            jr .ln


.Exit        call ScrRam
             ld de,PLOTT  ; #BC00
             ld hl,#FC00
             ld bc,#0400
             ldir         ;     
             ld hl,0
.aplotout    EQU $-2
             ld (aplottout),hl
             ld a,#AD   ; [xor l]
             ld (ANDplEqAD_),a
           ;  call CLOSE_
           ; ret
            jp CLOSE_

.TbBut       DW .plots      ; 0 
             DW .line       ; 1 
             DW .lines      ; 2 
             DW .rays       ; 3 
             DW .circle     ; 4 
             DW .ellips     ; 5 
             DW .box        ; 6 
             DW .treug      ; 7 
             DW .erase      ; 8  
             DW NOKEY_      ; 9 (18) hot key Enter - Q view

.TbBut_O     DW PMask   ; 0   
             DW Texture ; 1  
             DW .noRGBs ; 2  no rgb
             DW PRGB2   ; 3  rgb
             DW PRGB2   ; 4  dtrs

.noRGBs      ld hl,WObjects.noRGBcol
            jp SwBut


; ---------------------------------------------------


.erase
               call .initdraw
               ld hl,EraserCur
               ld (ARW_ADR),hl
               ld hl,ErasCurDISP      ;   /DA
               ld (ARW_XDISP),hl
               ld hl,LastUndo
               ld (HK_MiniLope.LastUndo+1),hl
               ld a,#CD    ; call nn
               ld (HK_MiniLope.svLUNDO),a
               ld hl,PlotHotK
               ld (HK_MiniLope.HKadr_),hl           ;  

.lerase        ld hl,HK_MiniLope
               call ARW_SCN_
              jp c,.exitDRW
               ld a,(WObjects.noRGBcol)
               sub 7
              jr z,1F       ; nop
               ld a,#C9     ; ret
1              ld (.eraseC),a
               ld a,ScrPage|#10
               call Ram              ;  
               ld hl,(ARW_X)
               ld c,8      ;   c=sy
               ld de,#00FF  ; 
               ld a,h
               sub high ErasCurDISP
              jr nc,1F
               add a,c
               ld c,a
               xor a
1              ld h,a
               ld a,c
               ld (.eraseSY_),a
               ld a,l
               sub low ErasCurDISP
              jr nc,2F
               neg
               ld b,a
1                sla e
                djnz 1B    ;       
               xor a
2              ld l,a
               and 7
               or a
              jr z,2F
               ld b,a
1                srl e
                 rr d
                djnz 1B  ;   
2              ld a,l
               cp 256-8
              jr c,1F
               ld d,0    ;     
1              push de
               ex de,hl
               call PixHL
               pop de
               ld a,8
.eraseSY_ EQU $-1
1              ex af,af'
               ld c,l
               ld a,#9B
               add a,h
               ld b,a
               ld a,e
               cpl
               and (hl)
               ld (hl),a
               ld a,(bc)
               and e
               or (hl)
               ld (hl),a
               call .eraseC
               ld a,d
               or a
              jr z,2F
               inc l
               inc c
               cpl
               and (hl)
               ld (hl),a
               ld a,(bc)
               and d
               or (hl)
               ld (hl),a
               call .eraseC
               dec l
               dec c
2              call DOWN_HL
               ld a,h
               cp #5B
              jr nc,3F
               ex af,af'
               dec a
              jr nz,1B
3              ld a,GUIPage|#10
               call Ram              ;  GUI

              jp .lerase

.eraseC       nop   ; ret for no rgb
              push hl
              push bc
              ld a,h
              rra
              rra
              rra
              and #03
              or #58
              ld h,a
              add a,#9B
              ld b,a
              ld a,(bc)
              ld (hl),a
              pop bc
              pop hl
             ret

.initdrawE   ld a,4
.initdrawI   ld (MaxCount),a
.initdraw_   ld a,#01    ; ld bc,nn
             ld (HK_MiniLope.svLUNDO),a
.initdraw
             ld de,SnapeCur
             call SV_ARW
             ld hl,WinCurDISP  ;   /DA
             ld (ARW_XDISP),hl

             ld hl,(LINE.plotADR)
             ld (.retAddrPlot),hl
        ;     call .setmode
        ;    ret

.setmode     call guiRAM
.setmode_    ld a,(.MODE_)
             call SET_PL_MODE
             xor a
             ld (.flg_fr_no),a
             ld (LAST_KEY),a
             ld (HK_MiniLope.firenew),a
             ld a,(WObjects.RdSzL)  ;  
             inc a
             ld (PlotOb.siB),a
             rra            ;  c  =0
             ld (PlotOb.dmY),a
             ld (PlotOb.dmY_),a
             ld (PlotOb.dmX),a
             ld (PlotOb.dmX_),a
             ld hl,PLOT_C
             ld a,(WObjects.noRGBcol)
             cp 7
            jr z,1F
             ld hl,PLOT
1            ld (PlotOb.plotADR),hl
            ret

.setoutPlt     ld hl,plottout
               ld de,PlotOb
               ld bc,PlotOb.HiX
              jr 1F
.setprevXOR    ld hl,xormodplt
               ld de,PLOT
               ld bc,Plot_XA
1              ld (aplottout),hl
               ld (LINE.plotADR),de
               ld (EL_.AddrPlot),bc
              ret

.treug         ld hl,.FigaSET
               ld (.tr_call_),hl
               ld hl,.Treug
               ld (.FigAdr_),hl
               ld (.tr_ADR),hl
       ;        ld hl,.treLUndo
       ;        ld (.ltreug+1),hl
               ld hl,.treug_
               ld de,TreuHotK
               call .tre_sel_
.treug_        call .ltreu_
              jr .treug_

;.tre_sel          ;  3- 
;               ld (.lineLUret_),hl
.tre_sel_
               ld (HK_MiniLope.HKadr_),de
               ld a,2
               call  .initdrawI
               ld (.ltreu_+1),sp
.ltreu_        ld sp,#0000
               ld hl,LINE.lineB
               ld (viewPre_.Pre_md_addr),hl
               call .setprevXOR
               ld hl,LastUndo
               ld (HK_MiniLope.LastUndo+1),hl
               call .sel1plot    ;  1- 
               ld (.treREfirst_+1),de
.ltreug        ld hl,.treLUndo             ;     ,   /DA
               ld (HK_MiniLope.LastUndo+1),hl
               call .sel2plot    ;  2- 
               ld (.Tr_1p),de          ; first
               ld (.Tr_2p),hl          ; last
               ld hl,.Treug
.tr_ADR   EQU $-2
               ld (viewPre_.Pre_md_addr),hl
               ld hl,ViewPre_    ;  3- 
               call ARW_SCN_
              jp c,.selPLexit_
               call ViResPrev
               push hl
               call .FigaSET
.tr_call_  EQU $-2
               call SaveLUndo
               pop hl
              ret

.treREfirst    call ViResPrev
.treREfirst_   ld de,#8060
               ld sp,(.ltreu_+1)
               ld (ViewPre_.FirstPLOT),de
              jr .ltreug
.treNEXT       call ViResPrev
              jr .ltreu_

.treLUndo         call ViResPrev
                  call LastUndo
             ;     ld a,STOP_ARW
             ;     call GUI
                  call NOKEY_
                 jr .ltreu_

.Treug          ;   ;  in: hl - 3- 
                ld de,#0000
.Tr_1p    EQU $-2
                ld a,d
                add a,h
                rra
                ld b,a
                ld a,e
                add a,l
                rra
                ld c,a     ; bc -   
                push de
                push bc
                call LINE.lineN
                ld hl,#0000
.Tr_2p    EQU $-2
                pop bc
                ld a,h
                add a,b
                rra
                ld b,a
                ld a,l
                add a,c
                rra
                ld c,a
                ld (.FigCenter),bc    ;   
                call LINE.lineN
                pop hl
                call LINE.lineN
              ret



.box            ld hl,.BOXw
                ld (.FigAdr_),hl
                ld hl,.Box
               jr .FigOUTpre

.ellips         ld hl,.Ellips
               jr .FigOUT

.circle         ld hl,.Circle

.FigOUT        ; in hl - adr OUTproc
               ld (.FigAdr_),hl
.FigOUTpre     ld (viewPre_.Pre_md_addr),hl
               ld hl,FigaHotK
               ld (HK_MiniLope.HKadr_),hl
               call  .initdrawE
               ld (.Figa+1),sp
.Figa          ld sp,#0000
               call .setprevXOR
               ld hl,LastUndo
               ld (HK_MiniLope.LastUndo+1),hl
               call .sel1plot    ;  1- 
               ld (.FigaREfirst_+1),de
.Figs_         ld hl,.FigaLUndo
               ld (HK_MiniLope.LastUndo+1),hl
               call .sel2plot    ;  2- 
               call .FigaSET
               call SaveLUndo
              jr .Figa

.FigaREfirst       call ViResPrev
.FigaREfirst_      ld de,#8060
                   ld sp,(.Figa+1)
                   ld (ViewPre_.FirstPLOT),de
                  jr .Figs_

.FigaNEXT          call ViResPrev
                  jr .Figa

.FigaLUndo        call ViResPrev
                  call LastUndo
             ;     ld a,STOP_ARW
             ;     call GUI
                  call NOKEY_
                 jp .Figa



.FigaSET       ld (.Figa_jp+1),hl
               ld (.Figa_jde+1),de
               call .setoutPlt

               ld a,(WObjects.RdFlMd)
               or a
              jr nz,.FigaFill
               ld a,(.MODE_)
               or a
              jr nz,.Figa_jp  ;      or/and/nop
               ld a,(Sieve)
               or a
              jr z,.FigaXor          ;  xor  
                call NOP_PL
                call .Figa_jp
                call XOR_PL
              jr .FigaXor

.Fig_Set       ld hl,#00B5   ; [or l : nop]  
              jr 1F
.Fig_Res       ld hl,#ADB5   ; [or l:xor l]  
1              ld (modeplt),hl
.Figa_jp       ld hl,#0000  ; hl
.Figa_jde      ld de,#0000  ; de
              jp .Circle
.FigAdr_  EQU $-2
.Figa_PG       ld a,SuxPage|#10
              jp Ram
.Figa_PU       ld a,SuxPage|#10
              jp Ram

               ;  
.FigaXor       call .FigaCLS
               call .Figa_jp
.FigaOscX      call .Figa_mdXOR
.FigaOscr     jp .FigSCR


.FigaFill      call .FigaCLS
               ld hl,modeplt
               ld (aplottout),hl

               call .Figa_jp

               ld hl,#0000       ;
.FigCenter  EQU $-2
               ld a,l
               ld l,h
               ld h,a
               ld de,BFill.SfillHL  ;        hl ;DE -  
               ld bc,FILL_PG*256+2  ; B - , C -  
               call CALLSWPhl    ;     + 
2              call .Figa_PU

                ld a,(WObjects.RdFlMd)
                dec a         ; 1
               jr nz,1F
               ;   
                call .Fig_Res    ;  
                call .Figa_mdRES ;     
               jr  3F              ;    
1               dec a        ; 2
               jr nz,1F         ;  
                ld a,(Sieve)
                or a
               jr z,5F
                call .Fig2SCR
                call .Fig_Pmsk_
                call .FigSievMDrs   ;.Figa_mdRES
                call .FigSCR2
               jr 5F
1                dec a        ; 3
               jr nz,2F
                  ;  
                call .Fig_fillO
               jr .FigaOscr
2               ;    
                call .Fig_Res    ;  
                call .Fig_fillO
3               call cls_a.c     ;  
                call .Fig_Set    ;  
4               ld a,(Sieve)
                or a
               jr z,5F
                call .Fig_Pmsk_
                call .FigSievMDrs      ;.Figa_mdRES
                call .Fig_Set
5               call .Fig_Pmsk
                call .Figa_md
               jr .FigaOscr

.FigSievMDrs    ld a,(.MODE_)
                cp 2
               jr nz,.Figa_mdRES
               jr .Figa_mdOR

.Fig_fillO      ld a,(WObjects.TxtrPut)
                or a
               jr z,1F
                call .Figa_mdRES   ;     
                call .Fig_TXTR
               jp .Figa_mdOR
1               call .Fig_TXTR
               jp .Figa_md

.FigaCLS       call SaveLUndo
               ld a,(SaveLUndo+1)
               xor 1              ;   0/1
               ld (SaveLUndo+1),a
               ld (.Figa_PU+1),a  ;      ))
.FigaCLS_      call cls_a.c       ;  
              jp OR_PL            ; or



.Fig_MD
               ld a,(.MODE_)
.Fig_MD_       ld hl,#00AE   ; [ xor (hl) : nop ]
               or a
              ret z
               ld l,#B6      ; [ or (hl) : nop ]
               dec a
              ret z
               ld h,#AE      ; [or (hl) : xor (hl) ]
               dec a
              ret z
               xor a
               ld l,a
               ld h,a
              ret

.Figa_md       call .Fig_MD
              jr 2F
.Figa_mdNOP    ld a,3
              jr 1F
.Figa_mdXOR    xor a
              jr 1F
.Figa_mdOR     ld a,1
              jr 1F
.Figa_mdRES    ld a,2
              jr 1F
1              call .Fig_MD_
2              ld a,h
               or l
              ret z
               ld (.FigMODE_),hl
.Figa_mode     call .Figa_PU
               ld hl,#4000
               ld de,#C000
               ld bc,#0018
1              ld a,(de)
.FigMODE_      xor (hl) : nop  ;   
               ld (de),a
               inc de
               inc hl
              djnz 1B
               dec c
              jr nz,1B
              ret

.Fig_Pmsk_
                ld a,#2F    ; cpl
               jr 1F
.Fig_Pmsk       xor a       ; nop
1               ld hl,DMSKbuff
                ld (.FigTXbfA),hl
                call .Fig_TXTR_
                ld hl, TxBUFF
                ld (.FigTXbfA),hl
               ret
.Fig_TXTR       xor a
.Fig_TXTR_      ld (.Fig_TX__nop),a
                ld hl,#4000
                ld b,12
1               push bc
                ld de,TxBUFF
.FigTXbfA   EQU $-2
                ld b,16
2               push hl
                push bc
                ld b,16
3               call .Fig_TX__
                inc de
                inc l
                call .Fig_TX__
                inc l
                dec de
               djnz 3B
                pop bc
                pop hl
                call INC_Y
                inc de
                inc de
               djnz 2B
                pop bc
               djnz 1B
              ret
.Fig_TX__
                ld a,(de)
.Fig_TX__nop    nop         ; nop/cpl
                and (hl)
                ld (hl),a
               ret

.FigSCR2       ;    sux
              call .Figa_PG
              ld hl,#DB00
             jr 1F
.Fig2SCR       ;    sux
              call .Figa_PG
              ld hl,#4000
              ld de,#DB00
             jr 2F
.FigSCR        ;  
              ld hl,#C000
1             ld de,#4000
2             ld bc,#1800
              ldir
             ret

.BOXw         ; de - first pixel , hl - last pixel
              ld bc,(PlotOb.plotADR)
              ld (LINE.plotADR),bc
              ld a,(WObjects.RdSzL)
              inc a
             jr .Boxst

.Box          ; de - first pixel , hl - last pixel
              ld a,1
.Boxst        ld (.BoxWgh),a
              ld (.BoxWgh_),a
              ld a,(WObjects.RdECmd)
              or a
             jr nz,.BoxCen
.Boxst_       ld a,d
              add a,h
              rra
              ld b,a
              ld a,e
              add a,l
              rra
              ld c,a
              ld (.FigCenter),bc

              call .normBOXdehl
              ld a,h
              sub d
              ld h,a
              ld a,l
              sub e
              ld l,a

              ld b,1
.BoxWgh    EQU $-1
.lBoxWgh       push bc
               ld b,h
               ld a,b
               or a
              jr z,2F
1              call LINE.plot
               inc d
              djnz 1B
2              ld b,l
               ld a,b
               or a
              jr z,2F
1              call LINE.plot
               inc e
              djnz 1B
2              ld b,h
               ld a,b
               or a
              jr z,2F
1              call LINE.plot
               dec d
              djnz 1B
2              ld b,l
               ld a,b
               or a
              jr z,2F
1              call LINE.plot
               dec e
              djnz 1B
2            pop bc
             inc d
            ret z
             inc e
             ld a,e
             cp 192
            ret nc
             inc h
             dec h
            ret z
             dec h
            ret z
             inc l
             dec l
            ret z
             dec l
            ret z
             dec h
          ;  ret z
            jr nz,1F
             inc h
1            dec l
            jr nz,1F
             inc l
         ;   ret z
1          djnz .lBoxWgh
          ret      ; ret/nop for preview


.BoxCen       ld (.FigCenter),de
              ld a,h
              sub d
             jr nc,1F
              neg
1             ld h,a
              ld a,l
              sub e
             jr nc,1F
              neg
1             ld l,a   ; hl- "" 


              ld b,1
.BoxWgh_   EQU $-1
.lBoxW       push bc
              ld a,h
              or a
             jr z,2F
              ld a,e   ; y0
              sub l
             jr c,1F
              push de
               ld e,a
               call .BoxHorLn
              pop de
1             ld a,e  ; y0
              add a,l
             jr c,2F
              push de
               ld e,a
               call .BoxHorLn
              pop de
2             ld a,l
              or a
             jr z,5F
              inc l
             jr z,4F
              ld a,d  ; x0
              sub h
             jr c,3F
              push de
               ld d,a
               call .BoxVerLn
              pop de
3             ld a,d  ; x0
              add a,h
             jr c,4F
              push de
              ld d,a
               call .BoxVerLn
              pop de
4             dec l
5             pop bc
             dec l
            ret z
             dec h
            ret z
            djnz .lBoxW
           ret

.BoxVerLn     ld b,l
              ld c,192
             push de
1             call LINE.plot
              ld a,e
              or a
             jr z,2F
              dec e
             djnz 1B
2             ld b,l
             pop de
              dec b
             ret z
              inc e
              ld a,e
              cp c
             ret nc
1             call LINE.plot
              inc e
              ld a,e
              cp c
             ret nc
             djnz 1B
            ret

.BoxHorLn     ld b,h
             push de
1             call LINE.plot
              ld a,d
              or a
             jr z,2F
              dec d
             djnz 1B
2             ld b,h
             pop de
              dec b
             ret z
              inc d
             ret z
1             call LINE.plot
              inc d
             ret z
             djnz 1B
            ret




.Circle       ; de - first pixel , hl - last pixel
              xor a
              call EL_.setAIncXY
     ;         ld a,d
     ;         add a,h
     ;         rra
     ;         ld b,a
     ;         ld a,e
     ;         add a,l
     ;         rra
     ;         ld c,a
              ld a,(WObjects.CirRadi) ;  
              or a
             jr nz,2F
              ld a,(WObjects.RdECmd)
              or a
             jr nz,2F

              call .normBOXdehl
              ld a,h
              sub d
              ld h,a

              ld a,l
              sub e
              ld l,a
              cp h
             jr c,1F
              ld a,h
1             or a
              rra
              ld b,a
              call c,EL_.setIncXY

              ld a,h
              or a
              rra
              add a,d
              ld d,a

              ld a,l
              or a
              rra
              add a,e
              ld e,a

              ld l,b

              call .CirCenFde_
             jr .CirFigL_

;              ld d,b
;              ld e,c
2        ;     ld (.FigCenter),de
         ;     ld a,d
         ;     ld (EL_.x0),a
              call .CirCenFde_
              ld a,d
              sub h
             jr nc,1F
              neg
1             ld h,a
              ld a,e
         ;     ld (EL_.y0),a
              sub l
             jr nc,1F
              neg
1             ld l,a
              ld a,h
              or l
             ret z

              ld a,(WObjects.CirRadi) ;  
              or a
             jr z,.CirFig_

              ld c,l
              ld a,h
              call MULS   ; hl= h*h
              ld a,c
              ld b,h
              ld c,l      ; bc=h*h
              call mulsAA ; hl=l*l
              add hl,bc   ;  
              ld a,#FF
             jr c,.CirFigA_    ;    255 
              call SQRT ; hl=sqrt(dhl)
             jr .CirFigL_
.CirFig_      ;     
              ld a,h
              cp l
             jr c,.CirFigA_
.CirFigL_     ld a,l
.CirFigA_     or a
             ret z
              ld (EL_.a),a
              ld (EL_.b),a
              xor a        ; nop
              ld (.El_1),a
              ld (.El_2),a
             jp EL_

.CirCenFde_   ld (.FigCenter),de
              ld a,d
              ld (EL_.x0),a
              ld a,e
              ld (EL_.y0),a
             ret

.Ellips     ; de - first pixel , hl - last pixel
              xor a
              call EL_.setAIncXY
              ld a,(WObjects.RdECmd)
              or a
              ld a,#3D   ; [ dec a ]
             jr nz,.Ello_       ;   
              call EL_.setIncXY
              call .normBOXdehl

              ld a,d           ;   
              add a,h
              rra
              ld d,a
              call nc,EL_.resIncX
             jr nc,1F
              dec h
1
              ld a,e
              add a,l
              rra
              ld e,a
              call nc,EL_.resIncY
             jr nc,1F
              dec l

1             xor a        ; nop
.Ello_        ld (.El_1),a
              ld (.El_2),a
              ld a,d
              ld (EL_.x0),a
              ld a,e
              ld (EL_.y0),a
              ld (.FigCenter),de
              ld a,d
              sub h
             jr nc,1F
              neg
.El_1         dec a  ; dec a / nop
1             ld (EL_.a),a
              ld a,e
              sub l
             jr nc,1F
              neg
.El_2         dec a  ; dec a / nop
1             ld (EL_.b),a
             jp EL_


.normBOXdehl            ;     
              ld a,d
              cp h
             jr c,1F
              ld d,h
              ld h,a
1             ld a,e
              cp l
             ret c
              ld e,l
              ld l,a
             ret


.line          ld hl,.line1_
               call .lline
.line1_        call .lline_
              jr .line1_

.lines         ld hl,.linesU_
               ld a,#FF
               ld (.linesU_+2),a
               call .lline
              jr 2F
1              ld de,(ViewPre_.FirstPLOT)
               ld (.linesU_+1),de
2              ld (ViewPre_.FirstPLOT),hl
               call .llines_
              jr 1B
.linesU_       ld hl,0
               ld a,h
               inc a
              jr z,.lines
              jr 1B


.rays          ld hl,.rays1_
               call .lline
.rays1_        call .llines_
              jr .rays1_


.lineLUndo     call ViResPrev
               call LastUndo
           ;    ld a,STOP_ARW
           ;    call GUI
               call NOKEY_
               ld sp,(.spp)
               dec sp
               dec sp
              jp .line1_
.lineLUret_     EQU $-2


.lline         ld (.lineLUret_),hl
               ld a,2
               call  .initdrawI
               ld hl,LINE.lineB
               ld (viewPre_.Pre_md_addr),hl
               ld hl,LineHotK          ;   
               ld (HK_MiniLope.HKadr_),hl
               ld (.lline_+1),sp
.lline_        ld sp,#0000
               call .setprevXOR
               ld hl,LastUndo
               ld (HK_MiniLope.LastUndo+1),hl
               call .sel1plot    ;  1- 
.llines_       ld hl,.lineLUndo
               ld (HK_MiniLope.LastUndo+1),hl
               call .sel2plot    ;  2- 
               push hl
               push de
               call .setoutPlt
               pop de
               pop hl
               push hl
               call LINE.lineB
               call SaveLUndo
               pop hl
              ret

.llineNEXT     call ViResPrev
              jr .lline_

.sel2plot       ; 2)  2- 
               call .setprevXOR
               ld hl,ViewPre_
               call ARW_SCN_
              jr c,.selPLexit_
               call ViResPrev
               push hl
               call .sel12pl_
               pop hl           ; de - first , hl - last
              ret

.sel1plot       ; 1)  1- 
               call PlotOb.resFirst   ;  
               xor a
               ld (ViewPre_.flgPrev),a ;    
               ld hl,HK_MiniLope
               call ARW_SCN_
              jr c,.selPLexit
               ld hl,(ARW_X)
               ld d,l
               ld e,h
               ld (ViewPre_.FirstPLOT),de
.sel12pl_      push de
               ld a,STOP_ARW
               call GUI
               call NOKEY_
               pop de
              ret

.selPLexit_    call ViResPrev
.selPLexit            ;   cansel
              jr .exitDRW


.plots
               call  .initdraw
               ld hl,LastUndo
               ld (HK_MiniLope.LastUndo+1),hl
               ld a,#CD    ; call nn
               ld (HK_MiniLope.svLUNDO),a
               ld hl,PlotHotK
               ld (HK_MiniLope.HKadr_),hl           ;   
               call .setoutPlt
               ld hl,(ARW_X)
               ld (.lsPlt),hl

.lplots        ld hl,HK_MiniLope
               call ARW_SCN_
              jr nc,1F
.exitDRW       call SuxLUndo
               call SAVESCR
               call LD_ARW
               ld hl,#0000
.retAddrPlot EQU $-2
               ld (LINE.plotADR),hl
              jp .l0    ;      

1              ld hl,(ARW_X)
               ld d,l
               ld e,h

               ld bc,#0000
.lsPlt    EQU $-2
               ld (.lsPlt),hl

               ld a,0
.flg_fr_no  EQU $-1     ;   
               or a
              jr z,.stFplots_
               sbc hl,bc
              jr z,.elplots
               ld a,(WObjects.PlSmooth)
               or a
              jr z,.stFplots
               ld a,h
               inc a
               cp 3
              jr nc,1F
               ld a,l
               inc a
               cp 3
              jr c,.stFplots
1                       ;    
               ex de,hl
               ld d,c
               ld e,b
               call LINE.lineN  ; de - first pixel , hl - last pixel
             jr .stFarwplt

.stFplots_     call PlotOb.resFirst   ;  
.stFplots      call PlotOb
.stFarwplt     ld a,1
               ld (.flg_fr_no),a
.elplots       ld a,STOP_ARW
               call GUI
              jr .lplots




PlotOb         ;      in d-X e-Y
               xor a
.HiX           ld (.hibyteX_),a   ; bit 0 for signed bytes X (for X<0 or X>255)
              push ix
               ld ix,.szx
               ld c,0
.siB   EQU $-1  ;  
               ld b,c
               ld a,e
               cp 192+5
              jr c,1F     ;  Y>=0
               cp 250
              jr c,.jpRetIX_
               sub 0       ;  Y<0
.dmY_        EQU $-1
               add a,b
              jr c,2F
.jpRetIX_     jp .retIX_
1              sub 0
.dmY   EQU $-1
              jr nc,1F
               add a,b ; dy-  
2              or a
              jr z,.jpRetIX_
               ld b,a  ; dy
               xor a
1              ld (ix+1),a
               ld (ix+3),b

               ld a,#00
.hibyteX_  EQU $-1            ;     X
               rra
               ld a,d
              jr nc,1F           ;  X = 0 .. 255
           ;    cp 128
           ;   jr z,.x255pl
               sub #00
.dmX_  EQU $-1
              jr c,3F
               add a,c          ; x<0
              jr c,2F
              jr .jpRetIX_

1              sub 0
.dmX   EQU $-1
              jr nc,3F
               add a,c      ; dx-  
2              or a
              jr z,.jpRetIX_
               ld c,a  ; dx
               xor a
3              ld (ix+0),a
               add a,c
              jr nc,1F
               sub c    ; return a
               ld c,a
               xor a
               sub c
               ld c,a
1              ld (ix+2),c

               ld c,(ix+3)  ; dy
               ld e,(ix+1)
1              ld b,(ix+2)  ; dx
               ld d,(ix+0)
2              push bc
               ld hl,(.szx+6)   ; l=(ix+6),h=(ix+7)
               ld a,h
               or l
              jr z,3F      ;     
               ld a,d       ;x
               sub (ix+4)
              jr c,3F
               cp (ix+6)
              jr nc,3F
               ld a,e       ;y
               sub (ix+5)
              jr c,3F
               cp (ix+7)
              jr c,4F
3              call PLOT_C
.plotADR   EQU $-2
4              pop bc
               inc d
              jr z,5F
              djnz 2B
5              inc e
               ld a,e
               cp 192
              jr nc,6F
               dec c
              jr nz,1B
6              ld hl,(.szx)
               ld (.szx+4),hl
               ld hl,(.szx+2)
               ld (.szx+6),hl
.retIX_       pop ix
              ret

.resFirst      ld hl,0            ;  
               ld (.szx+4),hl
               ld (.szx+6),hl
              ret

.szx    DB 0,0,1,1    ; x,y,dx,dy  ;   +0,1,2,3
        DB 0,0,0,0    ; x,y,dx,dy  ;   +4,5,6,7


ViResPrev     ld de,(ViewPre_.FirstPLOT)  ;  
              ld hl,(ViewPre_.lastPos)
              ld a,(ViewPre_.flgPrev)
              or a
             ret z
viewPre_      push bc
              push de
              push hl
              ld a,(ViewPre_.flgPrev)
              cpl
              ld (ViewPre_.flgPrev),a
              call  LINE.lineB
.Pre_md_addr EQU $-2
              pop hl
              pop de
              pop bc
             ret

ViewPre_   ;     ViewPre_.FirstPLOT
               ld a,(DIRECT)
               and #10
             jr nz,1F
               call INTCOUNT
              jr nz,HK_MiniLope
1
               ld de,0
.FirstPLOT EQU $-2
               ld bc,0
.lastPos   EQU $-2
               ld hl,(ARW_X)
               ld a,l
               ld l,h
               ld h,a
               ld (.lastPos),hl
               ld a,0
.flgPrev   EQU $-1
               or a
              jr z,1F
               sbc hl,bc
              jr z,2F
               ld h,b
               ld l,c
               call viewPre_      ; 
               ld hl,(.lastPos)
1              call viewPre_
2

HK_MiniLope     ;   ,     HK_MiniLope.LastUndo
              ld a,(DIRECT)
              and #10
             jr z,.o1
              ld (.firenew),a   ; !=0
             ret
.o1           xor a
              ld (Objects.flg_fr_no),a

              ld a,1
.firenew    EQU $-1
              or a
             jr z,1F
              xor a
              ld (.firenew),a   ; =0  
.svLUNDO      call SaveLUndo   ; call / ld bc,nn
1             call guiRAM
              ld hl,.hotkeys1
              call .hotkey
              ld hl,PlotHotK
.HKadr_    EQU $-2
              call .hotkey
              ld a,(SaveLUndo+1)
              xor 1
              ld (MiniLoupePG),a
              ld hl,MiniLoupe.normATscr
              ld (MiniLoupe.NORMADR),hl
              ld hl,ARW_X
              ld (MiniLoupe.arw_adr),hl
             jp MiniLoupeHK

.hotkey       ld a,(LAST_KEY)
              or a
             ret z
              cp #61  ; 'a'
             jr c,1F
              res 5,a
1             ld c,a
.lhotk_       ld a,(hl)
              inc hl
              cp #FF
             ret z
              cp c
             jr z,1F
              inc hl
              inc hl
             jr .lhotk_
1             pop af   ;   
             ld a,1
             ld (INTCOUNT.intcount),a
              ld a,(hl)
              inc hl
              ld h,(hl)
              ld l,a
              push hl,bc
              call STOP_ARW_gui
              pop bc,hl
              xor a
              ld (LAST_KEY),a
              ld a,c
           ;   call .jphl
              call JP_HL
              call  Objects.setmode
              call guiRAM
             jp NOKEY_gui
;.jphl         call JP_HL
;             jp  Objects.setmode


.hotkeys1     DB "C"
              DW  PRGB2         ; C - RGB Colour
              DB "N"
              DW  .noRGB        ; N -no RGB
              DB "K"
              DW  Col           ; K - mini RGB
              DB "1"
              DW .s_mode        ; 1 - xor
              DB "2"
              DW .s_mode        ; 2 - or
              DB "3"
              DW  .s_mode       ; 3 - and
              DB "4"
              DW  .s_mode       ; 4 - nop
              DB "W"
              DW .width         ; W - wight plots
              DB "Z"
              DW .LastUndo      ; Z - last undo
              DB "U"
              DW .SWP_Undo      ; U - undo
              DB "Y"
              DW .svUNDO        ; Y - save undo

              DB "T"            ; T - texture
              DW  Texture
              DB ">"            ; ss+T - Put v  mode for texture
              DW .tPutswp
              DB "G"            ; G - pixel MASK
              DW PMask
              DB "<"            ; ss+R - radius flag swap for circle
              DW .rdSwap_
              DB "I"            ; I - inside box or center for drawing figures
              DW .inORcentre
              DB "F"            ; F - fill mode
              DW  .fill_



             DB #FF


.svUNDO        call ViResPrev
              jp SV_UNDO
.SWP_Undo      call ViResPrev
              jp SWP_Undo

.LastUndo     jp LastUndo     ;     


.s_mode       sub "1"               ;    xor,or,and,nop
              ld (Objects.MODE_),a
             ret


.noRGB        ld a,(WObjects.noRGBcol)
              xor 2                    ; 5 swap 7
              ld (WObjects.noRGBcol),a
             ret

.rdSwap_       ld a,(WObjects.CirRadi)
               cpl
               ld (WObjects.CirRadi),a
              ret

.inORcentre    ld a,(WObjects.RdECmd)
               xor 1
               ld (WObjects.RdECmd),a
              ret

.tPutswp       ld a,(WObjects.TxtrPut)
               cpl
               ld (WObjects.TxtrPut),a
              ret

.fill_         ld hl,.filltxt      ;  
               ld de,WObjects.RdFlMd
              jr .question
.width         ld hl,.widthtxt     ;  
               ld de,WObjects.RdSzL
.question      ld (.questAdr_),de
               ld de,SPACE
               ld bc,8
               ldir

               ld ix,.questIX
               call GETBLK
               xor a
               ld (LAST_KEY),a
               ld a,6
               call setv
               ld hl,#50E0
               ld bc,8
               ld a,pr_51
               call GUI
1              ld a,(LAST_KEY)
               ld c,a
               xor a
               ld (LAST_KEY),a
               halt
               ld a,c
               or a
              jr z,1B
               sub "1"
              jr c,2F
               cp 5
              jr nc,2F
               ld (WObjects.RdSzL),a
.questAdr_   EQU $-2
2              call CLOSE
               call Objects.setmode_
               pop ix
              ret

.questIX      DB 0,23,6,1
.widthtxt     MSG_Objs_Width
.filltxt      MSG_Objs_Fill


xormodplt    xor l                 ;  xor- 
             ld (bc),a
            ret

LineHotK       DB 13      ; Enter - following pos.  -  
               DW Objects.llineNEXT

           ;    DB "B"       ; B - bend  -  /   
           ;    DW Ret

NotHotK       DB #FF


FigaHotK      DB 13      ; Enter - following pos.  -  
              DW Objects.FigaNEXT
              DB "R"       ; R - recent -  
              DW Objects.FigaREfirst

              DB #FF

TreuHotK      DB 13        ; Enter - following pos.  -  
              DW Objects.treNEXT
              DB "R"       ; R - recent -  
              DW Objects.treREfirst

             DB #FF

PlotHotK      DB "S"
              DW .smooth              ; S   - Smooth +/-
             DB #FF

.smooth       ld a,(WObjects.PlSmooth)
              cpl
              ld (WObjects.PlSmooth),a
             ret

; ---------------------------------------------------

WObjects     DB 18,2,14,22,5*8,5,128+%1111
; Bit 0 -   / (window with title)
; Bit 1 - ""  / (redraw window)
; Bit 2 -     / (movable window)
; Bit 3 -   -     (CANCEL by clicking outside the window)
; Bit 4 -        (  BGE 4.xx   Bit 3 = 1 ) / Dart Alver
     DB 0          ;  - (reserved for flags)
.T  DW .Txt        ; - (text object)
    DW .Sel        ; - () (highlighting object)
    DW .Hot        ;   (hotkeys)
    DW .But        ; - () (buttons object)
    DW .Flg        ; - (flags object)
    DW .Radi       ; -  (radio buttons object)
    DW Nil         ;  (scrollbar)
    DW .Cr         ;    (call on create)
    DW 2        ;  :     ""      
    DW .Sprt       ;     (sprites object)
    DW #FFFF


.Txt      MSG_Objs_title : DB 13  ; ,22,6,9," F",13,
          DB 22,10,12,"Put",0


.But
           DB 96+4,128+8,128+3,128+2,2,7,%11  ;  
            DW XORS
           DB 5  ;  
.BtMODop    DB 0  ;  
            DW ORS,ANDS,NOPS

.ButOp      ;   
           DB 96+2,128+11,7,2,2  ;       4 , 5
.pmskCol    DB 6,%11
           DW PMSKBUFF
            DB 7
           DW ITxBUFF

           DB 96+2,64+7,19,2,2
.noRGBcol   DB 7,%11
           DW NORGBS    ; 6 no rgb
            DB 6
           DW RGBS      ; 7 rgb

           DB 11,19,2,2,7,%00 ;8 4  dtrs
.RGBcol EQU $-2
           DW DTRS

.numBop  EQU 5      ; EQU ($-.ButOp)/8 -  


           ;   

          DB 1,3,2,2,7,%11 ;9 0 
           DW PLOTS

          DB 96+3,128+1,128+6,2,2,7,%11
           DW LINES,LINES2,RAYS

          DB 96+4,128+1,128+13,2,2,7,%11
           DW CIRCS,ELPS,SQS,TRS

          DB 11,3,2,2,6,%11 ;17 8  
           DW ERASES
           ;for hot Keys
                            ; 18 9 - enter - q view
          DB #FF

.Sel       DB 4,12,8,1,%00        ; 0  /reserved not used/
           DB 3,3,3,1,%11         ; 1  
           DB 3,6,3,128+5,%11     ; 2-6  
           DB 3,13,3,128+2,%11    ; 7-8   
           DB 3,16,3,128+5,%11    ; 9-13   
           DB 3,12,3,1,%11        ; 14     
           DB 10,12,3,1,%11       ; 15 Put v
          DB #FF
.SelQ  EQU 16   ;    

; - (switch)
; x, y,  ,  (#00/#FF)
;       ,  
;     
.Flg        DB 5,3,1,#FF
.PlSmooth  EQU $-1
             DW Nil
            DB 12,12,15,#FF
.TxtrPut   EQU $-1
             DW Nil
            DB 5,12,14,#FF
.CirRadi   EQU $-1
             DW Nil
            DB #FF

; - (radiobuttons)
; x, y,     , -, 
;         ,  
;     
.Radi       DB 5,6,2,5,0   ;  
.RdSzL  EQU $-1
             DW .RadiCOut
            DB 5,13,7,2,0  ;   
.RdECmd EQU $-1
             DW .RadiCOut
            DB 5,16,9,5,0  ;  
.RdFlMd EQU $-1
             DW .RadiCOut
            DB #FF

 ;   (sprites object)


.Sprt        DB 3,3,2,1,5*8,%11
              DW ObjSprt.Smooth

             DB 96+5,128+4,128+6,1,1,5*8,%11
              DW ObjSprt.Size1,ObjSprt.Size2,ObjSprt.Size3,ObjSprt.Size4,ObjSprt.Size5

             DB 96+3,128+3,128+12,2,1,5*8,%11
              DW ObjSprt.Radius,ObjSprt.FigBox,ObjSprt.FigCenter

             DB 96+5,128+3,128+16,2,1,5*8,%11
              DW ObjSprt.Contur,ObjSprt.ConTxtrMsk,ObjSprt.SolFil,ObjSprt.Txtra,ObjSprt.ConTxtr

           ;  DB 6,7,2,2,5*8+3,%11
           ;   DW ObjSprt.Arca

             DB #FF


.Hot         DB SS,"T"        ; ss+T - put texture mode
            DW 15
             DB "S",0         ; S - smooth
            DW 1
             DB SS,"R"        ; ss+R - radiuse mode for circle
            DW 14

             DB "1",0      ; 1 - xor
            DW .SelQ+0
             DB "2",0      ; 2 - or
            DW .SelQ+1
             DB "3",0      ; 3 - and
            DW .SelQ+2
             DB "4",0      ; 4 - nop
            DW .SelQ+3
             DB "G",0      ; G - pixel mask
            DW .SelQ+4
             DB "T",0      ; T - texture
            DW .SelQ+5
             DB "N",0      ; N - norgb
            DW .SelQ+6
             DB "C",0      ; C - color
            DW .SelQ+7
             DB #0D,0      ; Enter - Q view
            DW .SelQ+18
          DB #FF

.Cr    ;  

              ld b,32
              ld hl,BUFF   ;   
1             ld (hl),0
              inc l
             djnz 1B

              call .RadiCOut

              ld hl,(LINE.plotADR)  ;  
              ld (.retAPlot),hl

              ld de,7*256+17       ;   
              call RealWin
              call RASCH
              ld c,15
1             ld b,4
              ld a,l
              ld (hl),#7F
              inc l
2             ld (hl),#FF
              inc l
             djnz 2B
              ld (hl),#FE
              ld l,a
              call DOWN_HL
              dec c
             jr nz,1B

              call Objects.setmode_
              call Objects.setoutPlt
              ld hl,(WObjects)
              add hl,hl
              add hl,hl
              add hl,hl
              ld a,h
              ld h,l
              ld l,a
              ex de,hl   ; de - .   

              ld hl,63*256+119   ; plot
              add hl,de
              push de
              ex de,hl
              call PlotOb
              pop de
              ld hl,63*256+128
              add hl,de
              push de
              ex de,hl
              ld bc,63*256+143
              add hl,bc
              call LINE.lineB
              pop de

              ld hl,(Objects.FigCenter)   ; . 
             push hl
              ld hl,72*256+120
              add hl,de
              ex de,hl
              ld bc,96*256+144
              add hl,bc
              ld a,(.RdFlMd)
              cp 3
             jr nz,1F
              ld a,h
              sub d
              ld h,a
              ld a,l
              sub e
              ld l,a
             jr 2F
1             ld a,(WObjects.RdECmd)
              push af
              xor a
              ld (WObjects.RdECmd),a
              call Objects.BOXw
              pop af
              ld (WObjects.RdECmd),a
              ld a,(.RdFlMd)
              or a
             jr z,.eCrbx
            ; de , hl -  
2             ld (.Crshl_),hl
              ld a,(plottout.lowBFbyte)
              push af
              ld hl,modeplt
              ld a,(Objects.MODE_)
              ld b,a
              ld a,(.RdFlMd)
              dec a
             jr z,1F
              ld a,(.TxtrPut)
              or a
             jr z,2F
1             ld b,1  ; mode or

              ld hl,plottout.mSieve
2
              ld a,(.RdFlMd)
              ld c,a
              ld a,low BUFF     ; 
              dec c
             jr z,2F
              dec c
             jr nz,1F
              ld a,(Objects.MODE_)
              ld b,a
              ld a,low DMSKbuff  ; 
              ld hl,(plottout.mSjpAdr)
             jr 3F

1
              ld a,low TxBUFF
2             ex af,af'
              xor a
              ld (plottout.msi_and),a
              ex af,af'
3             ld (plottout.lowBFbyte),a
              ld a,b
              push hl
              push de
              call SET_PL_MODE
              pop de
              pop hl
              ld (plottout.mSjpAdr),hl


              ld hl,0
.Crshl_   EQU $-2
              inc h
              inc l
1             push de
              ld b,h
2             push de
              push bc
              push hl
              call PLOT
              pop hl
              pop bc
              pop de
              inc d
             djnz 2B
              pop de
              inc e
              dec l
             jr nz,1B

              pop af
              ld (plottout.lowBFbyte),a
.eCrbx
             pop hl
              ld (Objects.FigCenter),hl

              ld hl,0
.retAPlot   EQU $-2
              ld (LINE.plotADR),hl
           ret

.RadiCOut   ld de,#0306
            ld bc,#0205
            ld a,5*8
            call SetAtrW
            ld de,#030D
            ld bc,#0209
            ld a,5*8
            call SetAtrW

            ld e,6
            ld a,(.RdSzL)
            call .R_Cout_
            ld e,13
            ld a,(.RdECmd)
            call .R_Cout_
            ld e,16
            ld a,(.RdFlMd)
            call .R_Cout_

            ld de,#070E
            ld bc,#0605
            push de
            push bc
            call RealWin
            call CleanPix
            pop bc
            pop de
            ld a,(REALRGB)
            call SetAtrW
           ret
.R_Cout_    add a,e
            ld e,a
            ld d,3
            ld bc,#0201
            ld a,8*5+2
           jp SetAtrW



              INCLUDE "ellips.asm"

;   
ObjSprt

.Smooth      DB 0,0,1,192,6,32,6,32
             DB 0,70,0,70,0,56,0,0

;  
.Size1       DB 0,0,0,0,254,0,0,0
.Size2       DB 0,0,0,254,254,0,0,0
.Size3       DB 0,0,254,254,254,0,0,0
.Size4       DB 0,0,254,254,254,254,0,0
.Size5       DB 0,0,254,254,254,254,254,0


;   
.Radius       DB 0,224,49,16,42,40,50,72
              DB 42,8,41,16,0,224,0,0

;   
.FigCenter   DB 0,0,7,192,9,32,19,144
             DB 17,16,8,32,7,192,0,0
;   
.FigBox      DB 48,24,39,200,8,32,16,16
             DB 16,16,8,32,39,200,48,24

;  

.Contur      DB 31,252,16,4,16,164,17,68   ; 
             DB 18,132,16,4,31,252,0,0

.ConTxtrMsk  DB 31,252,16,4,16,4,16,4       ;   
             DB 16,4,16,4,31,252,0,0

.SolFil      DB 31,252,31,252,31,252,31,252 ;  
             DB 31,252,31,252,31,252,0,0

.Txtra       DB 21,84,10,168,21,84,10,168   ;   
             DB 21,84,10,168,21,84,0,0

.ConTxtr     DB 31,252,21,84,26,172,21,84   ;   
             DB 26,172,21,84,31,252,0,0

;  2x2
;.Arca        DB 0,0,6,0,7,128,0,64
;             DB 4,32,0,32,4,16,1,80
;             DB 4,16,0,32,4,32,0,64
;             DB 7,128,6,0,0,0,0,0

; ----------------------------------------------------------------



;-------------------------------------------------
LObjects     EQU $-Objects
               DISPLAY "Objects len   :",/a,LObjects
             ENT
