; AutoHotkey script to create a GUI for the batch file

Version := "1.4"

Gui, Add, Text,, Please select the WAV file:
Gui, Add, Edit, vFile w400
Gui, Add, Button, gBrowse, Browse

Gui, Add, Text,, Do you want to change the default value of -10 LUFS?
Gui, Add, Radio, vChangeLoudness gShowLoudnessEdit, Yes
Gui, Add, Radio, Checked vNoChangeLoudness gHideLoudnessEdit, No

; The input field for the LUFS value is initially hidden
Gui, Add, Text, vLoudnessLabel Hidden, Enter the target loudness value (Default: -10 LUFS):
Gui, Add, Edit, vLoudness w100 Hidden

Gui, Add, Button, gStart, Start
Gui, Show,, melcom's FFmpeg Audio Normalizer v%Version%

return

; Check if ffmpeg.exe exists
CheckFFmpeg:
if not FileExist("ffmpeg.exe")
{
    MsgBox, ffmpeg.exe was not found. Please download the file from here: https://github.com/BtbN/FFmpeg-Builds/releases/tag/latest and copy the file into the directory of this tool.
    ExitApp
}
return
Browse:
FileSelectFile, File, 3, , All Files (*.*)
if not ErrorLevel
{
    SplitPath, File, , , Ext
    if (Ext != "wav")
    {
        MsgBox, This is not a WAV file. Please select a WAV file.
        goto Browse
    }
    GuiControl,, File, %File%
}
return

ShowLoudnessEdit:
GuiControl, Show, LoudnessLabel
GuiControl, Show, Loudness
return

HideLoudnessEdit:
GuiControl, Hide, LoudnessLabel
GuiControl, Hide, Loudness
return
Start:
; Check if ffmpeg.exe exists
if not FileExist("ffmpeg.exe")
{
    MsgBox, ffmpeg.exe was not found. Please download the file from here: https://github.com/BtbN/FFmpeg-Builds/releases/tag/latest and copy the file into the directory of this tool.
    return
}

Gui, Submit, NoHide

if (File = "")
{
    MsgBox, Please select a WAV file.
    ; Call the file selection again
    goto Browse
}

if (NoChangeLoudness)
    Loudness := "-10"
else
    Loudness := Loudness

; Remove the .wav extension and add the new name
StringTrimRight, FileNoExt, File, 4
NormalizedFile := FileNoExt . "-Normalized.wav"

; Initialize common log file
LogFile := "ffmpeg_log.txt"
FormatTime, LogDate,, yyyy-MM-dd HH:mm:ss
NewEntry = ========================================================`n
NewEntry .= "Process started: " LogDate "`n"
NewEntry .= "========================================================`n"
FileAppend, %NewEntry%, %LogFile%
; Check if the output file already exists
if FileExist(NormalizedFile)
{
    MsgBox, The output file already exists. Do you want to overwrite it?
    ifMsgBox, No
    {
        MsgBox, The process was aborted.
        NewEntry = "Process aborted: " LogDate "`n"
        NewEntry .= "========================================================`n"
        FileAppend, %NewEntry%, %LogFile%
        return
    }
    ; Delete the file before overwriting it
    FileDelete, %NormalizedFile%
}

; Show progress window
Progress, b2 zh0 fs18, Please wait, the process is running..., melcom's FFmpeg Audio Normalizer v%Version%
SetTimer, UpdateProgress, 1000
Thread, NoTimers

; Check if the input file exists
if not FileExist(File)
{
    MsgBox, Input file not found. The process will be aborted.
    NewEntry = "Error: Input file not found.`n"
    NewEntry .= "========================================================`n"
    FileAppend, %NewEntry%, %LogFile%
    Progress, Off
    SetTimer, UpdateProgress, Off
    return
}

; Execute the FFmpeg command and log the output
RunWait, %comspec% /c ""ffmpeg.exe" -i "%File%" -af "loudnorm=I=%Loudness%:TP=-1" -ar 48000 -ac 2 -c:a pcm_f32le "%NormalizedFile%" >> "%LogFile%" 2>>&1", , Hide

; Hide progress window
Progress, Off
SetTimer, UpdateProgress, Off

; Add the completion message
FormatTime, LogDate,, yyyy-MM-dd HH:mm:ss
if FileExist(NormalizedFile)
{
    NewEntry = ========================================================`n
    NewEntry .= "Process successfully completed: " LogDate "`n"
    NewEntry .= "========================================================`n"
}
else
{
    NewEntry = ========================================================`n
    NewEntry .= "Error in normalization: " LogDate "`n"
    NewEntry .= "========================================================`n"
    MsgBox, There was a problem creating the output file. Check the log file for details.
    Run, notepad.exe %LogFile%
}
FileAppend, %NewEntry%, %LogFile%

; Show completion message and option to close the tool
if FileExist(NormalizedFile)
{
    if FileExist(LogFile)
    {
        MsgBox, The process was successfully completed.`nThe log file was updated.`nClick OK to process another file.
    }
    else
    {
        MsgBox, The process was successfully completed.`nA new log file was created.`nClick OK to process another file.
    }
}
else
{
    MsgBox, The process could not be completed.`nClick OK to return to the main menu.
}

Gui, Submit, NoHide
GuiControl,, File,    ; Reset the file path input

Progress, Off
SetTimer, UpdateProgress, Off

return

GuiClose:
ExitApp

UpdateProgress:
Progress, 50
return
