		    				 /*-----------------------------------------------------+
							  |				         TXM.h						    |
							  |														|
							  | Je sais c'est une methode de Monde3D mais bon elle  |
							  |   est tellement imposante que j'ai dcid de la 	|
							  |		foutre dans un fichier indpendant vala	        |
							  |														|
							  | 	U2^PoPsy TeAm 1999								|
							  +-----------------------------------------------------*/

#include "U3D3.h"


//----------------------------------------------------------------------------------------------------------------------------------------
//										+---------------------+
//										|    Les Fonctions    |
//										+---------------------+
//----------------------------------------------------------------------------------------------------------------------------------------
BOOL MondeU3D::LoadTXM( LPCSTR nom, U32 flag )
{
	CByteArray*	array	;

	array = U3D3DataManager->GetDataFolder( nom )	;

	if( array )
	{
		CMemFile file( array->GetData(), array->GetSize() )	;
		CArchive ar(&file, CArchive::load )					;

		LoadTXM( ar, flag )	;

		ar.Close()		;
	}
	else
	{
		CFile file	;

		if( file.Open( nom, CFile::modeRead ) )
		TRY
		{
			CArchive ar(&file, CArchive::load )	;

			LoadTXM( ar, flag )	;

			ar.Close()		;
			file.Close()	;
		}
		CATCH_ALL(e)
		{
		#ifdef _DEBUG
			DebugErrorMess( "<U3D> Error loading %s TXM file\n", nom )	;
		#endif
			return FALSE	;
		}
		END_CATCH_ALL
		else
		{
		#ifdef _DEBUG
			DebugErrorMess( "<U3D> Error loading %s TXM file\n", nom )	;
		#endif
			return FALSE	;
		}
	}

	return TRUE	;
}
//----------------------------------------------------------------------------------------------------------------------------------------
void MondeU3D::LoadTXM( CArchive &ar, U32 flag )
{
	char		bufligne[500]		;
	char		mname[256]			;
	char		*chaine				;
	char		buf[256]			;
	BOOL		good=FALSE			;
	BOOL		fin=FALSE			;
	MaterialU3D *mat=NULL			;
	CString		MaskOpen			;
	U32			flagOpenTex = flag	;


	MondeU3D *Save = SetActualMondeU3D( this )	;	// met ce world comme actuel et sauve le prcdent


	while( !fin )
	{
		if( !ar.ReadString( bufligne,500 )	)	fin = TRUE	;
		chaine = bufligne									;

		//--------- cherche un caractere valide
		for(U32 a=0; a<500; a++)
		{
			char C = chaine[a]	; 
			if( (C=='\n') || (C==';') || (C=='/') )
			{
				good = FALSE	;
				break			;
			}
			else if( (C==' ') || (C=='\t') )
			{
				continue	;
			}
			good = TRUE	;
			break		;
		}


		//--------- analyse la ligne et la traite

		if( !good ) continue	;	// passe a la ligne suivante

		if( strnicmp(&bufligne[a],"material",8) == 0)
		{
			if( mat )	mat->Confirm()			;
			sscanf(&bufligne[a+8],"%s",&mname)	;
			mat = GetOrCreateMat( mname )		;
		}
		else if( strnicmp(&bufligne[a],"2side",5) ==0)
		{
			if( mat )	mat->Side()	;
		}
		else if( strnicmp(&bufligne[a],"Couleur Solid",13) == 0)
		{
			U32 r=0,v=0,b=0,A=255	;
			S32 i=a+13				;
			while(chaine[i]!='R') i++	;
			i+=2;
			sscanf(&bufligne[i],"%d",&r)	;
			while(chaine[i]!='V') i++	;
			i+=2;
			sscanf(&bufligne[i],"%d",&v)	;
			while(chaine[i]!='B') i++	;
			i+=2;
			sscanf(&bufligne[i],"%d",&b)	;
			while( (chaine[i]!='A') && (chaine[i]!='\n') && (chaine[i]!='/') && (chaine[i]!=';') )
				i++	;
			if( (chaine[i]!='\n') && (chaine[i]!='/') && (chaine[i]!=';') )
			{
				i+=2						;
				sscanf(&bufligne[i],"%d",&A)	;
			}

			if( mat )	mat->SetColorFromTXM( r, v, b, A )	;
			continue	;
		}
		else if( strnicmp(&bufligne[a],"Shading",7) == 0)
		{
			U32 dest=0	;
			S32 i=a+7	;
			while(chaine[i]==' ') i++	;
			if( strnicmp(&chaine[i],"Fil",3)==0 )
			{
				dest=1						;
				while(chaine[i]!=' ') i++	;
			}
			if( mat )
			{
				while(chaine[i]==' ') i++	;
				if( strnicmp(&chaine[i],"Flat",4) == 0)
					mat->SetShading( MatShadingFlat	)	;
				else if( strnicmp(&chaine[i],"Gouraud",7) == 0)
					mat->SetShading( MatShadingGouraud	)	;
				else if( strnicmp(&chaine[i],"Rien",4) == 0)
					mat->SetShading( MatShadingRien	)	;
				else if( strnicmp(&chaine[i],"Phong",5) == 0)
					mat->SetShading( MatShadingPhong	)	;
			}
			continue	;
		}
		else if( strnicmp(&bufligne[a],"Transp",6) == 0)
		{
			S32 i=a+6	;
			while(chaine[i]==' ') i++	;
			if( mat )
			{
				while(chaine[i]==' ') i++	;
				if( strnicmp(&chaine[i],"Trou",4) == 0)
					mat->SetTransp( MatTranspTrou )	;
				else if( strnicmp(&chaine[i],"Add",3) == 0)
					mat->SetTransp( MatTranspAdd )	;
				else if( strnicmp(&chaine[i],"Mul",3) == 0)
					mat->SetTransp( MatTranspMul )	;
				else if( strnicmp(&chaine[i],"AAdd",4) == 0)
					mat->SetTransp( MatTranspAddAlpha )	;
				else if( strnicmp(&chaine[i],"AMul",4) == 0)
					mat->SetTransp( MatTranspMulAlpha )	;
				else if( strnicmp(&chaine[i],"Alpha",3) == 0)
					mat->SetTransp( MatTranspAlpha )	;
			}
			continue	;
		}
		else if( strnicmp(&bufligne[a],"TexTransp2",10) == 0 )
		{
			S32 i=a+10	;
			while(chaine[i]==' ') i++	;
			if( mat )
			{
				while(chaine[i]==' ') i++	;
				if( strnicmp(&chaine[i],"Trou",4) == 0)
					mat->SetTranspTex2( MatTranspTrou )	;
				else if( strnicmp(&chaine[i],"Add",3) == 0)
					mat->SetTranspTex2( MatTranspAdd )	;
				else if( strnicmp(&chaine[i],"Mul",3) == 0)
					mat->SetTranspTex2( MatTranspMul )	;
				else if( strnicmp(&chaine[i],"AAdd",4) == 0)
					mat->SetTranspTex2( MatTranspAddAlpha )	;
				else if( strnicmp(&chaine[i],"AMul",4) == 0)
					mat->SetTranspTex2( MatTranspMulAlpha )	;
				else if( strnicmp(&chaine[i],"Alpha",3) == 0)
					mat->SetTranspTex2( MatTranspAlpha )	;
			}
			continue	;
		}
		else if( strnicmp(&bufligne[a],"Tex1",4) == 0)
		{
			if( mat )
			{
				S32 i=a+4	;
				while(chaine[i]==' ') i++	;
				sscanf(&chaine[i],"%s",&buf)							;
				mat->SetTexture1( TextureManager::GetForUse( buf ) )	;
			}
		}
		else if( strnicmp(&bufligne[a],"Tex2",4) == 0)
		{
			if( mat )
			{
				S32 i=a+4	;
				while(chaine[i]==' ') i++	;
				sscanf(&chaine[i],"%s",&buf)							;
				mat->SetTexture2( TextureManager::GetForUse( buf ) )	;
			}
		}
		else if( strnicmp(&bufligne[a],"PosTex1",7) ==0)
		{
			if( mat )
			{
				S32 i=a+7	;
				Ufloat u,v	;
				while(chaine[i]!='U') i++	;
				i+=2	;
				sscanf(&bufligne[i],"%f",&u)	;
				while(chaine[i]!='V') i++	;
				i+=2	;
				sscanf(&bufligne[i],"%f",&v)	;

				mat->SetTex1PosFromTXM( u, v )	;
			}
			continue	;
		}
		else if( strnicmp(&bufligne[a],"PosTex2",7) ==0)
		{
			if( mat )
			{
				S32 i=a+7	;
				Ufloat u,v	;
				while(chaine[i]!='U') i++		;
				i+=2							;
				sscanf(&bufligne[i],"%f",&u)	;
				while(chaine[i]!='V') i++		;
				i+=2							;
				sscanf(&bufligne[i],"%f",&v)	;

				mat->SetTex2PosFromTXM( u, v )	;
			}
			continue	;
		}
		else if( strnicmp(&bufligne[a],"DeltaTex1",9) ==0)
		{
			if( mat )
			{
				S32 i=a+9	;
				Ufloat u,v	;
				while(chaine[i]!='U') i++		;
				i+=2							;
				sscanf(&bufligne[i],"%f",&u)	;
				while(chaine[i]!='V') i++		;
				i+=2							;
				sscanf(&bufligne[i],"%f",&v)	;

				mat->SetTex1DeltaFromTXM( u, v )	;
			}
			continue	;
		}
		else if( strnicmp(&bufligne[a],"DeltaTex2",9) ==0)
		{
			if( mat )
			{
				S32 i=a+9	;
				Ufloat u,v	;
				while(chaine[i]!='U') i++		;
				i+=2							;
				sscanf(&bufligne[i],"%f",&u)	;
				while(chaine[i]!='V') i++		;
				i+=2							;
				sscanf(&bufligne[i],"%f",&v)	;

				mat->SetTex2DeltaFromTXM( u, v )	;
			}
			continue	;
		}
		else if( strnicmp(&bufligne[a],"Repertoire", 10) ==0)
		{
			sscanf(&bufligne[a+10],"%s",&buf)		;
			TextureManager::SetRepertoire( buf )	;
		}
		else if( strnicmp(&bufligne[a],"TileTex", 7) ==0 )
		{
			flagOpenTex |= TILE_TEXTURE	;
		}
		else if( strnicmp(&bufligne[a],"MaskOpen", 8) ==0 )
		{
			sscanf(&bufligne[a+8],"%s",&buf)		;
			MaskOpen = buf							;
			flagOpenTex |= ALPHA_TEXTURE			;
		}
		else if( strnicmp(&bufligne[a],"Open", 4) ==0)
		{
			TextureU3D	*textmp	;

			sscanf(&bufligne[a+4],"%s",&buf)						;
			textmp = TextureManager::OpenJpg( buf, flagOpenTex )	;

			if( textmp->IsAlphaTexture() )
				TextureManager::OpenMask( textmp, (LPCSTR)MaskOpen )	;

			flagOpenTex = flag		;	// remet flag par defaut
		}
		else if( strnicmp(&bufligne[a],"EndTXM", 6) ==0)
		{
			fin = TRUE	;	// c'est la fin du fichier !
		}

	}
	if( mat )	mat->Confirm()	;


	ApplyMat()	;	// !!!!!!!!!!! TMPPPPPP !!!!!! un truc ki partira kon j'aurai amlior le TOOLS !


	SetActualMondeU3D( Save )	;	// remete l'ancien monde !
}
//----------------------------------------------------------------------------------------------------------------------------------------
