
#include <math.h>
#include "vectors.h"
#include "obj3d.h"
#include "primitiv.h"


void MakeCube(TObject3D *obj) {
	TPolygon *p;
	int Info[6][4] = { {0, 1, 2, 3}, {4, 0, 3, 7}, {5, 4, 7, 6},
					   {1, 5, 6, 2}, {4, 5, 1, 0}, {3, 2, 6, 7}};
	obj->AddVertex(1, 1, 1);
	obj->AddVertex(-1, 1, 1);
	obj->AddVertex(-1, -1, 1);
	obj->AddVertex(1, -1, 1);
	obj->AddVertex(1, 1, -1);
	obj->AddVertex(-1, 1, -1);
	obj->AddVertex(-1, -1, -1);
	obj->AddVertex(1, -1, -1);
	for (int i = 0; i < 6; i++) {
		p = new TPolygon();
		for (int j = 0; j < 4; j++) p->AddVertex(obj->Vertex[Info[i][j]]);
		obj->AddPolygon(p);
	}
	obj->CalcNormals();
	obj->MapEnviroment();
}


void MakeTorus(TObject3D *obj, double rout, double rin, int sides, int sections, double roll) {
        double a, b, x, y, z;
        int i, j;
        TVertex *v = new TVertex(0, 0, 0);
        TPolygon *p;
		double ustep = 1.0 / sections;
		double vstep = 1.0 / sides;

        b = 0;
        for (j = 0; j < sections; j++) {
                a = 0;
                for (i = 0; i < sides; i++) {
                        v->SetP(rin * cos(a), rin * sin(a), 0);
                        x = v->x * cos(roll) - v->y * sin(roll);
                        y = v->x * sin(roll) + v->y * cos(roll);
                        v->x = x; v->y = y;
                        v->Traslate(rout, 0, 0);
                        x = v->x * cos(b) - v->z * sin(b);
                        z = v->x * sin(b) + v->z * cos(b);
                        v->x = x; v->z = z;
                        obj->AddVertexUV(v->x, v->y, v->z, ustep * j, vstep * i);
                        a += 2 * Pi / sides;
                }
                b += 2 * Pi / sections;
        }

        for (j = 0; j < sections; j++)
                for (i = 0; i < sides; i++) {
                        p = new TPolygon();
                        p->AddVertex(obj->Vertex[j * sides + i]);
                        p->AddVertex(obj->Vertex[j * sides + ((i + 1) % sides)]);
                        p->AddVertex(obj->Vertex[((j + 1) % sections) * sides + ((i + 1) % sides)]);
                        p->AddVertex(obj->Vertex[((j + 1) % sections) * sides + i]);
                        obj->AddPolygon(p);
                }

        obj->CalcNormals();
//        obj->MapEnviroment();
}



void MakeSphere(TObject3D *obj, int a_sections, int b_sections) {
        int i, j;
        double a, b, x, y;
        TVertex *v = new TVertex(0, 0, 0);
        TPolygon *p;

        obj->AddVertex(0, 0, -1);
        obj->AddVertex(0, 0, 1);

        b = 0;
        for (j = 0; j < b_sections; j++) {
                a = Pi / a_sections;
                for (int i = 1; i < a_sections; i++) {
                        v->SetP(sin(a), 0, -cos(a));
                        x = v->x * cos(b) - v->y * sin(b);
                        y = v->x * sin(b) + v->y * cos(b);
                        obj->AddVertex(x, y, v->z);
                        a += Pi / a_sections;
                }
                b += 2 * Pi / b_sections;
        }

        for (j = 0; j < b_sections; j++)
                for (i = 1; i < (a_sections - 1); i++) {
                        p = new TPolygon();
                        p->AddVertex(obj->Vertex[j * (a_sections - 1) + i + 1]);
                        p->AddVertex(obj->Vertex[((j + 1) % b_sections) * (a_sections - 1) + i + 1]);
                        p->AddVertex(obj->Vertex[((j + 1) % b_sections) * (a_sections - 1) + i + 2]);
                        p->AddVertex(obj->Vertex[j * (a_sections - 1) + i + 2]);
                        obj->AddPolygon(p);
                }

        for (j = 0; j < b_sections; j++) {
                p = new TPolygon();
                p->AddVertex(obj->Vertex[0]);
                p->AddVertex(obj->Vertex[((j + 1) % b_sections) * (a_sections - 1) + 2]);
                p->AddVertex(obj->Vertex[j * (a_sections - 1) + 2]);
                obj->AddPolygon(p);

                p = new TPolygon();
                p->AddVertex(obj->Vertex[1]);
                p->AddVertex(obj->Vertex[j * (a_sections - 1) + a_sections]);
                p->AddVertex(obj->Vertex[((j + 1) % b_sections) * (a_sections - 1) + a_sections]);
                obj->AddPolygon(p);
        }

        obj->CalcNormals();
        obj->MapEnviroment();
}


void MakeQuadPatch(TObject3D *obj, int x_sections, int y_sections) {
	TPolygon *p;
	int i, j;
	double ustep = 1.0 / x_sections;
	double vstep = 1.0 / y_sections;
	
	for (j = 0; j <= y_sections; j++)
		for (i = 0; i <= x_sections; i++)
			obj->AddVertexUV(i, j, 0, i * ustep, 1.0 - j * vstep);
			
	for (j = 0; j < y_sections; j++)
		for (i = 0; i < x_sections; i++) {
			p = new TPolygon();
			p->AddVertex(obj->Vertex[j * (x_sections + 1) + i]);
			p->AddVertex(obj->Vertex[(j + 1) * (x_sections + 1) + i]);
			p->AddVertex(obj->Vertex[(j + 1) * (x_sections + 1) + i + 1]);
			p->AddVertex(obj->Vertex[j * (x_sections + 1) + i + 1]);
			obj->AddPolygon(p);
		}
		
	obj->Centre();
	obj->FitSphere(sqrt(2.0));
	obj->CalcNormals();
	for (i = 0; i < obj->NumPolygons; i++) obj->Poly[i]->normal.SetP(0, 0, 0);
}
