--      WOBOBJ.PAS      -- jellycube by FAC for the stupiscupidroopy demo
--
--      not to much to say about this. it's just a stupid rotating
--      green cube with a wobbling effect that is applied AFTER drawing
--      the cube.

--      ugly coding style. lots of globals used. i dont care


unit wobobj;

interface

procedure LoadObjects;  { loads the 3D object (the cube, that is)        }
procedure KillObjects;  { releases the memory used by this unit          }
procedure DoWobblingObject(where : dword);  { draws the cube to a screen }

implementation

uses Mode13PM, Obj3D, Triangle, LightSrc;

{ believe or not, the cube positions and rotations are PRECALCULATED!   }
{ I used the next five tables for the cube motion                       }
var ObjX, ObjY : array[0..255] of integer;
    RotX, RotY, RotZ : array[0..255] of integer;

    ObjControl : byte;    { object motion control (index for the tables) }
    ObjTransPos : byte;   { object wobbling control                      }
    Obj : PTObject3D;     { the cube itself                              }
    ObjTransTable : array[0..255] of longint; { wobbling transformation table }
    ObjTransTableOff : dword;  { offset to the transformation table }

    ObjScr, ObjTransScr : PTVirtual; { two virtual screens are needed }
    ObjOff, ObjTransOff : dword;     { along with their offsets       }


{ the next procedure creates the precalculated motion tables and        }
{ the wobbling table                                                    }
procedure SetupPositionTables;
var a, x, y : longint;
    ang : single;
begin
     for a := 0 to 255 do
     begin
          ang := 2 * Pi * a / 256;
          ObjX[a] := 220 - round(cos(ang) * 50);
          ObjY[a] := 60 + round(sin(2 * ang) * 30);
          RotX[a] := round(sin(ang) * 3) + 1;
          RotY[a] := round(cos(ang) * 2);
          RotZ[a] := round(sin(ang / 2) * 3) - 2;
          x := round(20.0 * cos(ang));
          y := round(10.0 * sin(ang)) + 10;
          ObjTransTable[a] := y * 320 + x;
     end;
     ObjTransTableOff := ofs(ObjTransTable);
end;


{ this procedure does the wobbling effect                               }
{ the idea is the same as the wobbling background effect in BACKGRS.PAS }
procedure WobbleObj; assembler;
asm
   mov esi, [ObjOff]
   mov edi, [ObjTransOff]
   add esi, 320
   add edi, 320
   mov dh, 180
   @loopy: mov ecx, 320
           movzx eax, [ObjTransPos]
           shl eax, 2
           add eax, [ObjTransTableOff]
           mov ebx, [eax]
   @loopx: mov dl, [esi + ebx]
           or dl, dl
           jz @nope1
           mov [edi], dl
   @nope1: inc esi
           inc edi
           dec ecx
           jnz @loopx
           inc [ObjTransPos]
           dec dh
           jnz @loopy
end;


{ this loads and sets up the 3D object }
procedure LoadObjects;
begin
     Obj := new(PTObject3D, Init);
     Load3DObject('bigcube.vkx', Obj);
     Obj^.Scale(0.6, 0.6, 0.6);
end;

{ releases all memory used }
procedure KillObjects;
var i : integer;
begin
     ShutDownVirtual(ObjScr);
     ShutDownVirtual(ObjTransScr);
     dispose(Obj, Done);
end;


{ this procedure puts the effect together }
procedure DoWobblingObject(where : dword);
begin
     ClearScreen(0, ObjOff);            { first, clear both buffers }
     ClearScreen(0, ObjTransOff);

     { move the cube to the next position }
     Obj^.SetCenter(ObjX[ObjControl], ObjY[ObjControl]);
     Obj^.Draw(ObjOff); { and draw it to the first buffer }

     { rotate the cube and the light source }
     Obj^.FlatFastRot(RotX[ObjControl], RotY[ObjControl], RotZ[ObjControl]);
     Light.Rotate(0, 0, 1);

     WobbleObj;  { deform the cube }

     { and blit the result transparently to the screen }
     asm
        mov edi, [where]
        mov esi, [ObjTransOff]
        add edi, 100
        add esi, 100
        mov edx, 180
        @loopy:  mov ecx, 220
        @loopx:  mov al, [esi]
                 or al, al
                 jz @nope
                 mov [edi], al
        @nope:   inc esi
                 inc edi
                 dec ecx
                 jnz @loopx
                 add esi, 100
                 add edi, 100
                 dec edx
                 jnz @loopy
     end;
     inc(ObjControl);           { inc position index }
     dec(ObjTransPos, 182);
end;


{ unit initialization }
begin
     { get memory for the screen buffers and clear them }
     SetupVirtual(ObjScr, ObjOff);
     SetupVirtual(ObjTransScr, ObjTransOff);
     ClearScreen(0, ObjOff);
     ClearScreen(0, ObjTransOff);

     { make precalculated tables }
     SetupPositionTables;

     { and set initial positions }
     ObjControl := 0;
     ObjTransPos := 0;
     StartCol := 0;
     WidthCol := 63;
     SetLightPosition(-1, -1, 2);
end.
