//	rotozoom.cpp

#include <math.h>
#include <string.h>
#include "mode13.h"
#include "vectors.h"
#include "rotozoom.h"


// TRotoZoom implementation

TRotoZoom::TRotoZoom(unsigned int newmap, TPalette newpal) {
	map = newmap;
	memcpy(palette, newpal, sizeof(TPalette));
	StartX = 0;
	StartY = 0;
	Ux = 1.0;
	Uy = 0.0;
	Vx = 0.0;
	Vy = -1.0;
}


void TRotoZoom::Draw(unsigned int where, unsigned char lines) {
	double mu = (Ux * Ux + Uy * Uy) * 0.00390625;
	double mv = (Vx * Vx + Vy * Vy) * 0.00390625;
	int dux = Ux / mu;
	int duy = -Uy / mu;
	int dvx = Vx / mv;
	int dvy = -Vy / mv;
	int ui = -StartX * dux - StartY * duy;
	int vi = -StartX * dvx - StartY * dvy;
	duy = duy - 320 * dux;
	dvy = dvy - 320 * dvx;
	unsigned int off = map;
	_asm {
		mov edi, [where]
//                mov ebx, [off]
		mov esi, [vi]
		mov edx, [ui]
		mov ah, [lines]
		loopy:  mov cx, 320
                loopx:  movzx ebx, si
                        add esi, [dvx]
                        mov bl, dh
                        add ebx, [off]
                        add edx, [dux]                
                        mov al, [ebx]
                        mov [edi], al
                        inc edi
                        dec cx
                        jnz loopx
                        add esi, [dvy]
                        add edx, [duy]
                        dec ah
                        jnz loopy
	}
}


void TRotoZoom::Rotate(int az) {
	if (az < 0) az += 1440;
	double nx = Ux * cost[az] - Uy * sint[az];
	double ny = Ux * sint[az] + Uy * cost[az];
	Ux = nx;
	Uy = ny;
	nx = Vx * cost[az] - Vy * sint[az];
	ny = Vx * sint[az] + Vy * cost[az];
	Vx = nx;
	Vy = ny;
}


void TRotoZoom::Scale(double fs) {
	Ux *= fs;
	Uy *= fs;
	Vx *= fs;
	Vy *= fs;
}

void TRotoZoom::ScaleUV(double us, double vs) {
	Ux *= us;
	Uy *= us;
	Vx *= vs;
	Vy *= vs;
}
