//	obj3d.cpp

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include "triangle.h"
#include "vectors.h"
#include "obj3d.h"

#define _TrianglesOnly_


#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))

int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif


// TPolygon implementation
TPolygon::TPolygon() {
	Vertex = (TVertex **)malloc(MaxPolyVertex * sizeof(TVertex *));
	NumVertex = 0;
}

TPolygon::~TPolygon() {
	free(Vertex);
	NumVertex = 0;
}

void TPolygon::AddVertex(TVertex *v) {
	if (NumVertex < MaxPolyVertex) Vertex[NumVertex++] = v;
}


void TPolygon::Draw(unsigned int where) {
	DrawTriangle(Vertex[0], Vertex[1], Vertex[2], where);
}

void TPolygon::CalcNormal() {
	TVector a = (*Vertex[0]) - (*Vertex[1]);
	TVector b = (*Vertex[2]) - (*Vertex[1]);
	normal = b * a;
	normal.Normalize();
}

int TPolygon::Visible() {
	return ((Vertex[1]->x2d - Vertex[0]->x2d) *
			(Vertex[2]->y2d - Vertex[0]->y2d)) <=
		   ((Vertex[1]->y2d - Vertex[0]->y2d) *
			(Vertex[2]->x2d - Vertex[0]->x2d));
}

void TPolygon::CalcZOrder() {
	double z = 2147483648.0;
	for (int v = 0; v < NumVertex; v++) z += Vertex[v]->z;
	zorder = dtoi(z);
}


// TObject3D implementation

TObject3D::TObject3D() {
	Vertex = (TVertex **)malloc(MaxObjectVertex * sizeof(TVertex *));
	Poly = (TPolygon **)malloc(MaxObjectPoly * sizeof(TPolygon *));
	XCenter = YCenter = NumVertex = NumPolygons = 0;
	for (int v = 0; v < MaxObjectVertex; v++) Vertex[v] = NULL;
	for (int p = 0; p < MaxObjectPoly; p++) Poly[p] = NULL;
}


TObject3D::~TObject3D() {
	for (int v = 0; v < NumVertex; v++) if (Vertex[v]) delete Vertex[v];
	for (int p = 0; p < NumPolygons; p++) if (Poly[p]) delete Poly[p];
	free(Vertex);
	free(Poly);
	NumVertex = 0;
	NumPolygons = 0;
}


void TObject3D::AddVertex(double nx, double ny, double nz) {
	if (NumVertex < MaxObjectVertex) 
		Vertex[NumVertex++] = new TVertex(nx, ny, nz);
}

void TObject3D::AddVertexUV(double nx, double ny, double nz, double nu, double nv) {
	if (NumVertex < MaxObjectVertex) {
		Vertex[NumVertex] = new TVertex(nx, ny, nz);
		Vertex[NumVertex]->u = nu;
		Vertex[NumVertex++]->v = nv;
	}
}

void TObject3D::AddPolygon(TPolygon *poly) {
	if ((poly) && (NumPolygons < MaxObjectPoly)) Poly[NumPolygons++] = poly;
}

void TObject3D::CalcNormals() {
	int v, p;
	for (p = 0; p < NumPolygons; p++) Poly[p]->CalcNormal();
	for (v = 0; v < NumVertex; v++) {
		Vertex[v]->normal.SetP(0, 0, 0);
		for (p = 0; p < NumPolygons; p++) 
			for (int n = 0; n < Poly[p]->NumVertex; n++)
				if (Vertex[v] == Poly[p]->Vertex[n])
					Vertex[v]->normal += Poly[p]->normal;
		Vertex[v]->normal.Normalize();
	}
}

void TObject3D::MapEnviroment() {
	for (int v = 0; v < NumVertex; v++) Vertex[v]->CalcEnvUV();
}

void TObject3D::Traslate(double nx, double ny, double nz) {
	for (int v = 0; v < NumVertex; v++) Vertex[v]->Traslate(nx, ny, nz);
}

void TObject3D::Rotate(int ax, int ay, int az) {
	for (int v = 0; v < NumVertex; v++) Vertex[v]->VRotate(ax, ay, az);
	for (int p = 0; p < NumPolygons; p++) Poly[p]->normal.Rotate(ax, ay, az);
}

void TObject3D::FlatFastRotate(int ax, int ay, int az) {
	for (int v = 0; v < NumVertex; v++) Vertex[v]->Rotate(ax, ay, az);
	for (int p = 0; p < NumPolygons; p++) Poly[p]->normal.Rotate(ax, ay, az);
}

void TObject3D::NotFlatFastRotate(int ax, int ay, int az) {
	for (int v = 0; v < NumVertex; v++) {
		Vertex[v]->Rotate(ax, ay, az);
		Vertex[v]->normal.Rotate(ax, ay, az);
	}
}

void TObject3D::Scale(double sx, double sy, double sz) {
	for (int v = 0; v < NumVertex; v++) Vertex[v]->Scale(sx, sy, sz);
}




     void radix (int byte, long N, TPolygon **source, TPolygon **dest)
     {
       long count[256];
       long index[256];
       memset (count, 0, sizeof (count));
       for ( int i=0; i<N; i++ ) count[((source[i]->zorder)>>(byte<<3))&0xff]++;

       index[0]=0;
       for ( i=1; i<256; i++ ) index[i]=index[i-1]+count[i-1];
       for ( i=0; i<N; i++ ) dest[index[((source[i]->zorder)>>(byte<<3))&0xff]++] = source[i];
     }

     void radixsort (TPolygon **source, TPolygon **temp, long N)
     {
       radix (0, N, source, temp);
       radix (1, N, temp, source);
       radix (2, N, source, temp);
       radix (3, N, temp, source);
     }


void TObject3D::Draw(unsigned int where) {
//        TPolygon *visiblepoly[MaxObjectPoly], *temp[MaxObjectPoly];
//        int n = 0;
	
	for (int v = 0; v < NumVertex; v++) Vertex[v]->Calc2D(XCenter, YCenter);
	for (int p = 0; p < NumPolygons; p++) Poly[p]->Draw(where);
//		if (Poly[p]->Visible()) {
//			Poly[p]->CalcZOrder();
//			visiblepoly[n++] = Poly[p];
//		}
//	radixsort(visiblepoly, temp, n);
//	for (p = 0; p < n; p++) visiblepoly[p]->Draw(where);
}

int fgetint(FILE *file) {
	int b1 = (int)fgetc(file);
	int b2 = ((int)fgetc(file)) << 8;
	int b3 = ((int)fgetc(file)) << 16;
	int b4 = ((int)fgetc(file)) << 24;
	return b1 | b2 | b3 | b4;
}

void Load3DObject(char *filename, TObject3D *obj) {
	FILE *file;
	int i, j, nv, np, x, y, z, u, v;
	TPolygon *p;
	
	if ((file = fopen(filename, "rb")) == NULL) return;
	if ((fgetint(file) & 0xFFFF0000) != 0x1FAC0000) {
		fclose(file);
		return;
	}
	for (i = 0; i < obj->NumVertex; i++) 
		if (obj->Vertex[i]) { delete obj->Vertex[i]; obj->Vertex[i] = NULL; }
	for (i = 0; i < obj->NumPolygons; i++) 
		if (obj->Poly[i]) { delete obj->Poly[i]; obj->Poly[i] = NULL; }
	nv = fgetint(file);
	np = fgetint(file);
	for (i = 0; i < 5; i++) fgetint(file);
	for (i = 0; i < nv; i++) {
		x = fgetint(file);
		y = fgetint(file);
		z = fgetint(file);
		u = fgetint(file);
		v = fgetint(file);
		obj->AddVertexUV(x / 65536.0, y / 65536.0, z / 65536.0, u / 65536.0, v / 65536.0);
	}
	for (i = 0; i < np; i++) {
		p = new TPolygon();
		u = fgetint(file);
		for (j = 0; j < u; j++) {
			v = fgetint(file);
			if (obj->Vertex[v]) p->AddVertex(obj->Vertex[v]);
		}
		obj->AddPolygon(p);
	}
	fclose(file);
	obj->CalcNormals();
}
