
(*
** Personal Database v1.1a
** Written and designed by Bas van Gaalen
** from Summer '95 to Spring '97.
**
**
**
** Why "_P_ersonal _D_atabase"?
** Three reasons:
**
** - It's a database of Persons, not addresses only.
** - It's your PERSONAL database: it's a database of persons you know.
** - This software is _P_ublic _D_omain: you're free to play around with it.
**
**
**
** Keys:
**
** F1    - help
** F10   - menu
** A     - about/information
** B     - birthdates within x days (nofdays on commandline!)
** C     - pack database (clear deleted entrees)
** E     - edit record
** F     - find data in database records
** G     - grep (make selection of ...)
** I     - import from file (ASCII, PD-file, (dBase?))
** J     - jump/goto to record number
** N     - search next
** P     - print (short list, long list, (label?))
** R     - restore Backup
** S     - sort database (on ...)
** T     - define/edit groups/types
** V     - invert tagged selection (toggle)
** X     - export selection/group/rec to file (ASCII-list, PD-file, (dBase?))
** INS   - add new record
** DEL   - delete current/selected record(s)
** ENTER - view/edit current record
** SPACE - select/tag
** -     - de-select all from current list
** +     - select all from current list
** ESC   - quit/exit
**
**
**
** Known 'features':
** - When grep is active, the program becomes a little slow. The reason for
**   this can be found in the 'condition'-function.
**
** - It's possible to chose 'Deleted' or 'Grep' when editing a record. This
**   was deliberatly left in, because the groupfield can be one of those.
**   However, it's not wise to chose one of those. If you chose 'Deleted',
**   you simply delete the person - the primitive way.
**
**
**
** Known bugs: none.
**
**
**
** Suggestions for improvement:
** - There's only one thing bothering in this finished version: the record-
**   fields are hardcoded. I'm planning to make a rewrite of some base-code
**   to make the fields user-configurable. This is gonna be a little hard,
**   though. Maybe I should've thought about this in the first place...
**
** - Password protection (it is a PERSONAL database, isn't it?)
**
** - Autiodial function for the realy lazy people.
**
** - Configuration setup.
**
** - Variable number of groups (20>).
**
** - Please remind me to crank up the limit of possible persons in the
**   database too (currently some 869 due to the limit of dynamic arrays).
**   All this in a possible version 2.0. For now: THIS IS IT!
**
** - Make easy undelete option.
**
** A product like this can be updated endless, so it seems. All this fuzz
** around a little record seems so... overkill! Anyway, have fun!
*)

{$x+,v-}
{$m 16384,0,655360}

program pd;

uses
  dos,printer,u_txt,u_misc,u_kb,keyboard; { <-- change! }
  { keyboard must be called AFTER u_misc and u_kb! }

type
  ni_names=(group,name,address,zip,city,country,phone,
            fax,fidonet,internet,birthdate,comment);

  fieldrec=record
    name:str10;
    len,pos:byte;
  end;

  helpidxtype=(hlp_none,hlp_main,hlp_birth,hlp_del,hlp_edit,
               hlp_edgroup,hlp_export,hlp_find,hlp_goto,hlp_grep,
               hlp_import,hlp_pack,hlp_print,hlp_sort);

{ Optional constants: may be changed to suit your needs }
const
  b_backup:boolean=true;                 { backup-mode on (true)/off(false)? }
  ask_backup:boolean=false;   { ask for backup (true) or just do it (false)? }
  predefcountry='Nederland';                          { predefined 'country' }
  prtmar_left:byte=2;                                 { printer: left margin }

  months:array[1..12] of string[3]=(
    'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');

  { Names, lengths and relative positions of fieldnames for right-alignment }
  ni:array[ni_names] of fieldrec=(
    (name:'Group'; len:5; pos:4),
    (name:'Name'; len:4; pos:5),
    (name:'Address'; len:7; pos:2),
    (name:'Zip'; len:3; pos:6),
    (name:'City'; len:4; pos:5),
    (name:'Country'; len:7; pos:2),
    (name:'Phone'; len:5; pos:4),
    (name:'Fax'; len:3; pos:6),
    (name:'Fidonet'; len:7; pos:2),
    (name:'Internet'; len:8; pos:1),
    (name:'Birthdate'; len:9; pos:0),
    (name:'Comment'; len:7; pos:2));

  { Search-strings for textfile-import/export (used in Gfxfx2-regs) }
  ex_offset=20;
  name_str='name';
  address_str='address';
  zip_str='zipcode';
  city_str='city/state';
  country_str='country';
  phone_str='phone(s)';
  fax_str='fax';
  fido_str='fido/internet';
  inet_str='fido/internet';
  birth_str='birtdate';
  comment_str='comment';

  hlp_lines:array[helpidxtype] of byte=(        { helpfile-related constants }
    0,188,18,19,28,25,31,12,9,9,31,11,13,9);

  hlp_start:array[helpidxtype] of word=(
    0,0,188,206,225,253,278,309,321,330,339,370,381,394);

{ Color configurations }
const
  { Desktop }
  col_shadow:byte=darkgray;
  col_desktop:byte=_lightgray+blue;
  col_desktophi:byte=_lightgray+lightblue;
  col_list_norm:byte=lightgray;
  col_list_sel:byte=yellow;
  col_list_del:byte=darkgray;
  col_list_normhi:byte=_blue+lightcyan;
  col_list_selhi:byte=_blue+white;
  col_list_delhi:byte=_blue+lightgray;
  col_listbar:byte=_cyan+blue;

  { View/Information window }
  col_wintitle:byte=_lightgray+lightblue;
  col_winattr:byte=_lightgray+darkgray;
  col_winlo:byte=_lightgray+darkgray;
  col_winnorm:byte=_lightgray+blue;
  col_winhi:byte=_lightgray+lightblue;
  col_winselect:byte=_blue+lightcyan;
  col_wininput:byte=_lightgray+lightblue;

  { Edit window }
  col_edittitle:byte=_blue+lightcyan;
  col_editattr:byte=_blue+lightblue;
  col_editlo:byte=_blue+cyan;
  col_editnorm:byte=_blue+lightcyan;
  col_edithi:byte=_blue+white;
  col_editinput:byte=_lightgray+blue;

  { Selection list/window }
  col_seltitle:byte=_lightgray+lightblue;
  col_selattr:byte=_lightgray+darkgray;
  col_selnorm:byte=_lightgray+blue;
  col_selhi:byte=_blue+lightcyan;

  { Pull-down menu }
  col_menuactive:byte=_blue+lightgray;
  col_menuattrib:byte=_lightgray;
  col_menutext:byte=_lightgray;
  col_menuhigh:byte=_blue+lightgray;

  { Help window }
  col_hlptitle:byte=_blue+lightcyan;
  col_hlpattr:byte=_blue+lightblue;
  col_hlptext:byte=_blue+cyan;
  col_hlphi:byte=_blue+lightcyan;
  col_hlpscroll:byte=_blue+cyan;

{ Internally used constants - leave 'em alone }
const
  standalone:boolean=false;            { true if ran with commandline option }
  maxtypes=20;                     { maximum number of types - don't change! }
  listfieldsize=74;                            { size of fields in main list }
  sortitemsize=30;                              { size of fields in sortlist }
  selectitemsize=60;                       { field size in selection-routine }
  configitemsize=30;                                 { size of config-fields }
  helpitemsize=60;                                     { width of helpscreen }
  datfname:pathstr='pd.dat';                             { database filename }
  hlpfname:pathstr='pd.hlp';                                 { help filename }
  cfgfname:pathstr='pd.cfg';                               { config filename }
  bckfname:pathstr='pd.bck';                               { backup filename }
  cbufsize=8192;                                        { size of copybuffer }
  group_deleted=1;                       { three predefined/hardcoded groups }
  group_grep=2;
  group_all=3;

type
  datestr=string[8];
  str8=string[8];
  str15=string[15];
  str20=string[20];
  str25=string[25];
  str30=string[30];
  str50=string[50];
  str60=string[60];
  str100=string[100];
  perinf_rec=record                                     { person info record }
    group:byte;                      { hi-bit set: record is tagged/selected }
    name,
    address:str30;
    zip:str8;
    city,
    country:str20;
    phone,
    fax:str15;
    fidonet,
    internet:str50;
    birthdate:datestr;
    comment:str50;
  end;

  perinf_ptr=^perstruc;                            { person-info linked list }
  perstruc=record
    rec:perinf_rec;
    next:perinf_ptr;
  end;

  m_listitem=string[listfieldsize];      { mainlist dynamic array (max: 869) }
  m_listptr=^m_listrec;
  m_listrec=array[0..65200 div sizeof(m_listitem)] of m_listitem;

  sel_item=string[selectitemsize];    { selectlist dynamic array (max: 1068) }
  sel_ptr=^sel_rec;
  sel_rec=array[0..65200 div sizeof(sel_item)] of sel_item;

  cfgtype=array[1..maxtypes] of string[configitemsize];

  sortitem=record                       { sortlist dynamic array (max: 1975) }
    item:string[sortitemsize];
    fidx:word;
  end;
  sortptr=^sortstr;
  sortstr=array[0..65200 div sizeof(sortitem)] of sortitem;

  directiontype=(up,down);                           { moved bar up or down? }

  menuarray=array[1..4] of byte;                  { pulldown-menu structures }
  menudattype=array[1..4,1..4] of byte;
  menutxttype=array[1..4,1..12] of str25;
  menucomtype=array[1..4,1..12] of str60;

  hlp_item=string[helpitemsize];        { helplist dynamic array (max: 1068) }
  hlp_ptr=^hlp_rec;
  hlp_rec=array[0..65200 div sizeof(hlp_item)] of hlp_item;

var
  datfile:file;                                      { config- and data-file }
  hlpfile:text;                                                   { helpfile }
  hlpbuf:array[0..4095] of char;                           { helpfile buffer }
  exepath:pathstr;                                        { path to exe-file }
  globalerrstr:str60;                                   { global errorstring }
  cfg:cfgtype;                                  { config record; set at init }
  fstper,curper,lstper:perinf_ptr;                 { pointers to linked list }
  mainlist:m_listptr;                                { the main browse list! }
  help_idx:helpidxtype;                   { help index - used in helphandler }
  direction:directiontype;                             { cursorbar direction }
  grepstr,grepupstr,                                          { grep strings }
  searchstr:str60;                                           { search string }
  oldexit:pointer;                               { pointer to old exit-queue }
  startupwait,                                           { Startupwait (CFG) }
  lookahead,                     { number of days to look ahead in 'b' (CFG) }
  searchpos,                                         { search start position }
  total_persons,                    { total number of persons in linked list }
  persons,                                  { number of persons in main list }
  nofselect,                                   { number of selections active }
  cursor:word;                                      { cursorshape at startup }
  info_idx,                          { info index: horizontal mainlist-index }
  winsize,                                         { vertical size of screen }
  curgroup:byte;                                  { current shown type/group }
  helpactive,                               { helpscreen currently on screen }
  helppresent,                                           { helpfile present? }
  grepactive,                                                { in grep-mode? }
  changed:boolean;                                       { anything changed? }

{----------------------------------------------------------------------------}
{ Initialization and exit procedures ----------------------------------------}
{----------------------------------------------------------------------------}

{ Forwards ------------------------------------------------------------------}

procedure clearlinked; forward;
procedure loadlinked; forward;
procedure clearmainlist; forward;
procedure loadlist; forward;
procedure loadcfg; forward;
procedure getinfo(var rec:perinf_rec; var recnum:word; num:word); forward;
function searchstrinrec(var str,rec; strsize,recsize:word):boolean; forward;
function keyhandler(key:word):boolean; far; forward;
procedure birthdays(days:word); forward;
procedure backup; forward;
procedure printrec(per:perinf_rec); forward;

{ Added ExitProc ------------------------------------------------------------}

procedure newexitproc; far;
var msg:str80;
begin
  { check backup... }
  if changed and b_backup then backup;
  { restore old exit-queue }
  exitproc:=oldexit;
  { restore screen(s) }
  while v_pageinmem do getscr;
  { clear main list }
  clearmainlist;
  { clear linked list }
  clearlinked;
  { display possible error message }
  if (exitcode>0) and (erroraddr=nil) then begin
    case exitcode of
      1:msg:='Could not create datafile. Disk full?';
      2:msg:='Datafile is corrupt. Delete it!'; { Eh? Something went wrong! }
      3:msg:='Error reading datafile. Configrecord corrupt.'; { Hardly impossible }
      4:msg:='Error reading datafile. Userrecord corrupt.'; { Hm, bad sector? }
      5:msg:='Could not write record. Disk full?'; { Free some space, dude }
      6:msg:='Unable to write record. Bad sector?'; { Buy a new harddisk }
      7:msg:='Unable to save config. Bad sector?'; { Should not happen }
      8:msg:='Error reading groupfile.'; { Reason? Probably a diskerror }
      9:msg:='Error in configfile line '+globalerrstr; { Error reading cfgfile }
    else msg:='Unknown error...';
    end;
    writeln('Error: ',msg);
  end;
  { restore cursorshape }
  setcursorshape(cursor);
end;

{ Initialization ------------------------------------------------------------}

procedure initialize;
var
  cfgfile:text;
  dir:dirstr; name:namestr; ext:extstr;
  cfgline,ident,data:str100;
  cfgcounter,nofbytes,days,cd:word;
  valresult:integer;
  spacepos:byte;
begin
  { pre-init }
  keyhandlerproc:=keyhandler;
  cursor:=getcursorshape;
  mainlist:=nil;
  persons:=0;
  fstper:=nil;
  curper:=fstper;
  lstper:=fstper;
  curgroup:=group_all;
  info_idx:=2;
  searchpos:=0;
  grepactive:=false;
  help_idx:=hlp_main;
  helpactive:=false;
  direction:=down;
  nofselect:=0;
  changed:=false;
  startupwait:=0;
  lookahead:=14;
  globalerrstr:='';
  fillchar(searchstr,sizeof(searchstr),0);
  fillchar(grepstr,sizeof(grepstr),0);
  fillchar(grepupstr,sizeof(grepupstr),0);

  { setup exit procedure }
  oldexit:=exitproc;
  exitproc:=@newexitproc;

  { read cfg/persons or create }
  total_persons:=0;
  exepath:=fexpand(paramstr(0));
  fsplit(exepath,dir,name,ext);
  exepath:=dir;
  assign(datfile,exepath+datfname);
  {$i-} reset(datfile,1); {$i+}
  if ioresult<>0 then begin
    { create cfg/person file }
    fillchar(cfg,sizeof(cfg),0);
    cfg[group_deleted]:='Deleted'; { 1 }
    cfg[group_grep]:='Grep'; { 2 }
    cfg[group_all]:='All'; { 3 }
    rewrite(datfile,1);
    blockwrite(datfile,cfg,sizeof(cfg),nofbytes);
    close(datfile);
    if nofbytes<>sizeof(cfg) then halt(1);
  end
  else begin
    { read cfg-record }
    if filesize(datfile)<sizeof(cfg) then halt(2);
    if filesize(datfile)>sizeof(cfg) then loadlinked;
    {blockread(datfile,cfg,sizeof(cfg),nofbytes);
    if nofbytes<>sizeof(cfg) then halt(3);}
    loadcfg;
  end;

  { check help }
  assign(hlpfile,exepath+hlpfname);
  {$i-} reset(hlpfile); {$i+}
  helppresent:=ioresult=0;
  if helppresent then close(hlpfile);
  settextbuf(hlpfile,hlpbuf);

  { create main list }
  loadlist;

  { see if there's a config-file, if so, process it... }
  cfgcounter:=0;
  assign(cfgfile,exepath+cfgfname);
  {$i-} reset(cfgfile); {$i+}
  if ioresult=0 then begin
    while not eof(cfgfile) do begin
      readln(cfgfile,cfgline);
      inc(cfgcounter);
      if (cfgline<>'') and (not (cfgline[1] in [';','%'])) then begin
        valresult:=0;
        spacepos:=pos(' ',cfgline);
        ident:=strdn(copy(cfgline,1,spacepos-1));
        data:=copy(cfgline,spacepos+1,epos(cfgline,[';','%'],spacepos)-spacepos-1);
        trim(data,' ');
        if ident='startupwait' then val(data,startupwait,valresult)
        else if ident='lookahead' then val(data,lookahead,valresult)
        else begin
          globalerrstr:=tostr(cfgcounter,0)+': '+ident;
          halt(9);
        end;
        if valresult<>0 then begin
          globalerrstr:=tostr(cfgcounter,0)+': '+data;
          halt(9);
        end;
      end;
    end;
    close(cfgfile);
  end;

  { prosess commandline option (birtdate) }
  if paramstr(1)<>'' then begin
    val(paramstr(1),days,cd);
    if cd>0 then halt;
    standalone:=true;
    birthdays(days);
    halt;
  end;

  if not standalone then startupwait:=0;

  { misc screen-related }
  cursoroff;
  setscr;
  with keybehave do begin
    clockon:=true;
    scrsavetime:=0;
    colattr:=col_desktophi;
    xpos:=71; ypos:=rows-2;
  end;
end;

{----------------------------------------------------------------------------}
{ General 'low-level' routines ----------------------------------------------}
{----------------------------------------------------------------------------}

{ Is record part of current selection? --------------------------------------}

{ This function introduces a major slowdown to the program, but since it's a }
{ global function, it can easily be changed: PD keeps working perfectly.     }

function condition(perptr:perinf_ptr):boolean;
var
  tmprec:perinf_rec;
begin
  if grepactive then begin
    tmprec:=perptr^.rec;
    condition:=searchstrinrec(grepupstr,tmprec,length(grepupstr),sizeof(perinf_rec));
  end
  else condition:=((perptr^.rec.group and 127)=curgroup) or
    (curgroup=group_all) or ((perptr^.rec.group and 127)=group_all);
end;

{ Desktop message -----------------------------------------------------------}

function dsk_msgkey(s:str80):word;                { Returns last pressed key }
var i:byte;
begin
  setscr;
  i:=9;
  if length(s)>37 then i:=10;
  nwindow(10,5,50,i,' Message ',pos_hi+pos_le,col_wintitle,col_winattr,col_shadow);
  if i=10 then begin
    i:=37; { Re-use 'i' }
    while s[i]<>' ' do dec(i);   { Search space for wrap - assuming words... }
    dspmul(#0+chr(col_winnorm)+copy(s,1,pred(i)),12,7);
    dspmul(#0+chr(col_winnorm)+copy(s,succ(i),length(s)-i),12,8);
  end
  else dspmul(#0+chr(col_winnorm)+s,12,7);
  dsk_msgkey:=getekey;
  getscr;
end;

procedure dsk_msg(s:str80); { Raw window with text - no screensave! }
var i:byte;
begin
  i:=9;
  if length(s)>37 then i:=10;
  nwindow(10,5,50,i,' Message ',pos_hi+pos_le,col_wintitle,col_winattr,col_shadow);
  if i=10 then begin
    i:=37; { Re-use 'i' }
    while s[i]<>' ' do dec(i);   { Search space for wrap - assuming words... }
    dspmul(#0+chr(col_winnorm)+copy(s,1,pred(i)),12,7);
    dspmul(#0+chr(col_winnorm)+copy(s,succ(i),length(s)-i),12,8);
  end
  else dspmul(#0+chr(col_winnorm)+s,12,7);
end;

{ Write (multiple-color) comment at bottom ----------------------------------}

procedure bar_comment(s:str100);
var tmp:str100;
begin
  filltext(' ',0,pred(rows),pred(cols),pred(rows),col_desktop);
  dspmul(#0+chr(col_desktop)+' '+s,0,pred(rows));
end;

{ Calculate number of years between given dates -----------------------------}

function nofyears(bd,bm,by,nd,nm,ny:word):byte;
var i:byte;
begin
  i:=pred(ny)-by;
  if nm>=bm then begin
    if nm=bm then begin if nd>=bd then inc(i) end
    else inc(i);
  end;
  nofyears:=i;
end;

{ Fill string with spaces ---------------------------------------------------}

function pad(ch:char; num:byte):string;
var
  tmp:string;
  i:byte;
begin
  fillchar(tmp,succ(num),ch);
  tmp[0]:=chr(num);
  pad:=tmp;
end;

{ Clear linked list ---------------------------------------------------------}

procedure clearlinked;
var tmp:perinf_ptr;
begin
  if fstper=nil then exit;
  curper:=fstper;
  while curper<>nil do begin
    tmp:=curper;
    curper:=curper^.next;
    dispose(tmp);
  end;
  total_persons:=0;
  fstper:=nil;
  curper:=fstper;
  lstper:=fstper;
end;

{ Load Linked list ----------------------------------------------------------}

procedure loadlinked;
var nofbytes:word;
begin
  { Clear linked list if one in memory }
  if fstper<>nil then clearlinked;
  { Open datafile and skip config-record }
  reset(datfile,1);
  seek(datfile,sizeof(cfg));
  { Load list }
  new(fstper);
  curper:=fstper;
  while not eof(datfile) do begin
    blockread(datfile,curper^.rec,sizeof(perinf_rec),nofbytes);
    if nofbytes<>sizeof(perinf_rec) then halt(4);
    inc(total_persons);
    if not eof(datfile) then begin
      new(curper^.next);
      curper:=curper^.next;
    end;
  end;
  curper^.next:=nil;
  lstper:=curper;
  close(datfile);
end;

{ Clear Select list dynamic array -------------------------------------------}

procedure clearmainlist;
begin
  if (mainlist=nil) and (persons=0) then exit;
  freemem(mainlist,persons*succ(listfieldsize));   { +1 'cos string-len-byte }
  persons:=0;
  mainlist:=nil;
end;

{ Load Select list dynamic array --------------------------------------------}

{ Sub: Insert record-field in mainlist-line - - - - - - - - - - - - - - - - -}

procedure insertfield(var listline:m_listitem; field:str80; pos,maxlen:byte);
var cut,len:byte;
begin
  len:=length(field);
  if len<=maxlen then cut:=len else cut:=maxlen;
  move(field[1],listline[pos],cut);
  if len>maxlen then listline[pos+maxlen]:=#16;
end;

{- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - }

procedure loadlist;
var
  i:word;
  len:byte;
  check:boolean;
begin
  clearmainlist;
  if total_persons=0 then exit; { leave when database is empty }
  { count persons }
  curper:=fstper;
  while curper<>nil do begin
    if condition(curper) then inc(persons);
    curper:=curper^.next;
  end;

  if persons=0 then exit;
  { create main list }
  getmem(mainlist,persons*succ(listfieldsize));
  i:=0;
  curper:=fstper;
  while curper<>nil do begin
    if condition(curper) then begin
      fillchar(mainlist^[i],succ(listfieldsize),#0);
      mainlist^[i][0]:=chr(listfieldsize);
      move(curper^.rec.name[1],mainlist^[i][2],length(curper^.rec.name));
      if (curgroup=group_all) and ((curper^.rec.group and 127)=group_deleted) then mainlist^[i][1]:='d';
      if (curper^.rec.group and 128)=128 then mainlist^[i][1]:='s';
      with curper^.rec do
        case info_idx of
          0:insertfield(mainlist^[i],cfg[group and 127],35,30);
          1:insertfield(mainlist^[i],address,35,40);
          2:begin
            insertfield(mainlist^[i],zip,35,8);
            insertfield(mainlist^[i],city,45,15);
            insertfield(mainlist^[i],country,63,10);
          end;
          3:begin
            insertfield(mainlist^[i],phone,35,18);
            insertfield(mainlist^[i],fax,55,18);
          end;
          4:insertfield(mainlist^[i],fidonet,35,38);
          5:insertfield(mainlist^[i],internet,35,38);
          6:insertfield(mainlist^[i],birthdate,35,38);
          7:insertfield(mainlist^[i],comment,35,38);
        end;
      inc(i);
    end;
    curper:=curper^.next;
  end;
end;

{ Load config ---------------------------------------------------------------}

procedure loadcfg;
var
  nofbytes:word;
begin
  reset(datfile,1);
  blockread(datfile,cfg,sizeof(cfg),nofbytes);
  close(datfile);
  if nofbytes<>sizeof(cfg) then halt(3);
end;

{----------------------------------------------------------------------------}
{ Record EDIT related procedures and functions ------------------------------}
{----------------------------------------------------------------------------}

{ General selection routine -------------------------------------------------}

function select(x,y,xe,ye:byte; field,title:str80; cur,max,wait:word; listptr:sel_ptr):word;
var
  time:longint absolute $40:$6c;
  startpos,basepos,endtime:longint;
  prescr,scrpos,winsize,offs:byte;
  esc:boolean;

procedure putline(abswinpos:byte; absbasepos:word); begin
  dsptxt(copy(listptr^[absbasepos],1,xe-x-1),x+1,y+offs+abswinpos); end;

procedure dumpscreen(start:word);
var i,last:byte;
begin
  if max<winsize then last:=max else last:=winsize;
  for i:=1 to last do putline(i,start+i-1);
end;

begin
  if listptr=nil then exit;
  if field<>'' then offs:=2 else offs:=0;
  setscr;
  nwindow(x,y,xe,ye+offs,title,pos_hi+pos_mi,col_seltitle,col_selattr,col_shadow);
  fillattr(x+1,y+1,xe-1,ye+offs-1,col_selnorm);
  if field<>''then begin
    filltext('',x+1,y+2,xe-1,y+2,col_selattr);
    dspchar('',x,y+2,col_selattr);
    dspchar('',xe,y+2,col_selattr);
    dspat(copy(field,1,xe-x-1),x+1,y+1,col_selnorm);
  end;
  winsize:=ye-y-1; basepos:=cur;
  if cur<(winsize div 2) then startpos:=0
  else if cur>=max-(winsize div 2) then startpos:=max-winsize
  else startpos:=basepos-(winsize div 2);
  dumpscreen(startpos);
  scrpos:=cur-startpos; prescr:=scrpos;
  fillattr(x+1,y+offs+scrpos,xe-1,y+offs+scrpos,col_selhi);
  if wait>0 then begin
    dspat('  ',xe-6,y,col_selattr);
    if wait>99 then wait:=99;
    endtime:=time+round(wait*18.2);
    while (wait>0) and (not keypressed) do begin
      dspat(tostr(wait,2),xe-5,y,col_seltitle);
      endtime:=time+18;
      while (time<=endtime) and (not keypressed) do;
      dec(wait);
    end;
    if not keypressed then begin
      getscr;
      select:=0;
      exit;
    end
    else filltext('',xe-6,y,xe-2,y,col_selattr);
  end;
  esc:=false;
  repeat
    if prescr<>scrpos then begin
      fillattr(x+1,y+offs+prescr,xe-1,y+offs+prescr,col_selnorm);
      fillattr(x+1,y+offs+scrpos,xe-1,y+offs+scrpos,col_selhi);
      prescr:=scrpos;
    end;
    if max>3 then scrollbar(xe,succ(y)+offs,basepos,winsize,max,col_selnorm);
    case getekey of
      crsrup:if basepos>1 then begin
        prescr:=scrpos;
        dec(basepos);
        if scrpos>1 then dec(scrpos)
        else begin
          scrolltexty('d',x+1,y+offs+1,xe-1,y+offs+winsize);
          putline(scrpos,basepos-1);
        end;
      end;
      crsrdown:if basepos<max then begin
        prescr:=scrpos;
        inc(basepos);
        if scrpos<winsize then inc(scrpos)
        else begin
          scrolltexty('u',x+1,y+offs+1,xe-1,y+offs+winsize);
          putline(scrpos,basepos-1);
        end;
      end;
      crsrhome:if basepos<>1 then begin
        prescr:=scrpos;
        scrpos:=1;
        basepos:=1;
        dumpscreen(0);
      end;
      crsrend:if basepos<>max then begin
        prescr:=scrpos;
        if max<winsize then scrpos:=max else scrpos:=winsize;
        basepos:=max;
        dumpscreen(max-scrpos);
      end;
      crsrpgup:if scrpos>1 then begin
        prescr:=scrpos;
        if basepos-scrpos>0 then dec(basepos,scrpos-1) else basepos:=1;
        scrpos:=1;
      end
      else if basepos>1 then begin
        prescr:=scrpos;
        if basepos>winsize then dec(basepos,winsize) else basepos:=1;
        dumpscreen(basepos-scrpos);
      end;
      crsrpgdn:if scrpos<winsize then begin
        if basepos<>max then begin
          prescr:=scrpos;
          if max<winsize then begin scrpos:=max; basepos:=max; end
          else begin inc(basepos,winsize-scrpos); scrpos:=winsize; end;
        end;
      end
      else if basepos<max then begin
        if basepos<(max-winsize) then inc(basepos,winsize) else basepos:=max;
        dumpscreen(basepos-winsize);
      end;
      crsrcr:begin esc:=true; select:=basepos; end;
      crsresc:begin esc:=true; select:=0; end;
    end;
  until esc;
  getscr;
end;

{ Edit Person record --------------------------------------------------------}

{ Sub: Edit type - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - }

function edittype(var group:byte):word;
var list:sel_ptr; tmp:str30; key:word; types,i:byte;
begin
  dspat(cfg[group and 127],getx,gety,col_editinput);
  halfcursor;
  key:=getekey;
  if key=crsrcr then begin
    types:=maxtypes;
    while cfg[types]='' do dec(types);
    getmem(list,types*succ(selectitemsize));
    for i:=1 to types do
      list^[pred(i)]:=cfg[i];
    i:=select(20,2,21+configitemsize,3+types,'',' Select Group ',group and 127,types,0,list);
    if i>0 then group:=i;
    freemem(list,types*succ(selectitemsize));
    edittype:=crsrcr;
  end else edittype:=key;
  fillx(cfg[group and 127],' ',getx,gety,30,col_editnorm);
  cursoroff;
end;

{ Sub: Edit date - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - }

function editdate(var date:datestr):word;
const
  days:array[0..12] of byte=(1,31,28,31,30,31,30,31,31,30,31,30,31);
var
  old,tmp:datestr;
  key,year,month,day,dow:word;
  x,y,pos:byte;
  esc:boolean;

function checkok(datestr:str8):boolean;
var dummy:word; year,month,day,allow:byte;
begin
  val(copy(datestr,1,2),day,dummy);
  val(copy(datestr,4,2),month,dummy);
  val(copy(datestr,7,2),year,dummy);
  if month in [0..12] then begin
    allow:=days[month];
    if (year mod 4=0) and (month=2) then inc(allow);
  end else allow:=0;
  checkok:=(allow<>0) and (day<=allow);
end;

begin
  if date='' then date:='..-..-..';
  tmp:=date; old:='';
  pos:=1;
  x:=getx; y:=gety;
  halfcursor;
  esc:=false;
  repeat
    if old<>tmp then begin dspat(tmp,x,y,col_editinput); old:=tmp; end;
    placecursor(x+pos-1,y);
    key:=getekey;
    case key of
      crsrbs,crsrleft:if pos>1 then if (pos=4) or (pos=7) then dec(pos,2) else dec(pos);
      crsrright:if pos<8 then if (pos=2) or (pos=5) then inc(pos,2) else inc(pos);
      crsrhome:pos:=1;
      crsrend:pos:=8;
      crsrcend:begin
        getdate(year,month,day,dow);
        year:=year-1900;
        tmp:=lz(day,2)+'-'+lz(month,2)+'-'+lz(year,2);
      end;
      crsrchome:tmp:='..-..-..';
      crsresc,crsrup,crsrdown,crsrtab,crsrstab,
      crsrcr:if checkok(tmp) then begin
        esc:=true; editdate:=key; end
      else begin
        if key=crsresc then tmp:=date
        else dspat('Invalid!',x+9,y,col_edithi);
      end;
      ord('0')..ord('9'):begin
        tmp[pos]:=chr(key);
        if pos<8 then if (pos=2) or (pos=5) then inc(pos,2) else inc(pos);
      end;
    end;
  until esc;
  cursoroff;
  date:=tmp;
  filltext(' ',x+9,y,x+17,y,col_editnorm);                { clear 'Invalid!' }
  dspat(date,x,y,col_editnorm);
end;

{ Main person record edit - - - - - - - - - - - - - - - - - - - - - - - - - -}

function editrec(var per:perinf_rec):boolean;       { Returns true if saved! }
var
  org:perinf_rec;
  j:ni_names;
  tmp:str80;
  key:word;
  i:byte;
  esc:boolean;
begin
  help_idx:=hlp_edit;
  setscr;
  nwindow(6,6,72,19,' Edit Record ',pos_hi+pos_mi,col_edittitle,col_editattr,col_shadow);
  for j:=group to comment do
    dspat(ni[j].name,7+ni[j].pos,7+byte(j),col_editlo);
  with per do begin
    dspat(name,17,8,col_editnorm);
    dspat(address,17,9,col_editnorm);
    dspat(zip,17,10,col_editnorm);
    dspat(city,17,11,col_editnorm);
    dspat(country,17,12,col_editnorm);
    dspat(phone,17,13,col_editnorm);
    dspat(fax,17,14,col_editnorm);
    dspat(fidonet,17,15,col_editnorm);
    dspat(internet,17,16,col_editnorm);
    dspat(birthdate,17,17,col_editnorm);
    dspat(comment,17,18,col_editnorm);
  end;
  move(per,org,sizeof(perinf_rec));
  i:=1; esc:=false;
  repeat
    placecursor(17,6+i);
    case i of
       1:tmp:='Keys: '+#0+chr(col_desktophi)+'Enter '+#0+chr(col_desktop)+'Select a group';
       2..10,12:tmp:='Keys: '+#0+chr(col_desktophi)+'Ctrl-Home '+#0+chr(col_desktop)+'Clear';
      11:tmp:='Enter a valid birthdate';
    end;
    bar_comment(#0+chr(col_desktop)+tmp);
    with per do
      case i of
         1:key:=edittype(group);
         2:key:=input(getx,gety,name,[#30..#166],pred(sizeof(name)),col_editinput,col_editnorm,nocap,pos_le);
         3:key:=input(getx,gety,address,[#30..#166],pred(sizeof(address)),col_editinput,col_editnorm,nocap,pos_le);
         4:key:=input(getx,gety,zip,[#30..#166],pred(sizeof(zip)),col_editinput,col_editnorm,all,pos_le);
         5:key:=input(getx,gety,city,[#30..#166],pred(sizeof(city)),col_editinput,col_editnorm,nocap,pos_le);
         6:key:=input(getx,gety,country,[#30..#166],pred(sizeof(country)),col_editinput,col_editnorm,nocap,pos_le);
         7:key:=input(getx,gety,phone,[#30..#166],pred(sizeof(phone)),col_editinput,col_editnorm,nocap,pos_le);
         8:key:=input(getx,gety,fax,[#30..#166],pred(sizeof(fax)),col_editinput,col_editnorm,nocap,pos_le);
         9:key:=input(getx,gety,fidonet,[#30..#166],pred(sizeof(fidonet)),col_editinput,col_editnorm,nocap,pos_le);
        10:key:=input(getx,gety,internet,[#30..#166],pred(sizeof(internet)),col_editinput,col_editnorm,nocap,pos_le);
        11:key:=editdate(birthdate);
        12:key:=input(getx,gety,comment,[#30..#166],pred(sizeof(comment)),col_editinput,col_editnorm,nocap,pos_le);
      end;
    case key of
      crsresc:esc:=true;
      crsrtab,crsrdown,crsrcr:if i<12 then inc(i) else i:=1;
      crsrstab,crsrup:if i>1 then dec(i) else i:=12;
    end;
  until esc;
  editrec:=false;
  if not equal(per,org,sizeof(perinf_rec)) then begin
    bar_comment('Press '+#0+chr(col_desktophi)+'Y'+#0+chr(col_desktop)+' to save changes.');
    editrec:=dsk_msgkey(#0+chr(col_winnorm)+'Save changes ('#0+chr(col_winhi)+'Y'#0+chr(col_winnorm)+
                     '/'#0+chr(col_winhi)+'n'#0+chr(col_winnorm)+')?') in [ord('y'),ord('Y'),crsrcr];
    changed:=true;
  end;
  getscr;
end;

{ Single Edit ---------------------------------------------------------------}

function singleditrec(pernum:word):boolean;
var
  per:perinf_rec;
  recnum,nofbytes:word;
begin
  if persons=0 then exit;
  getinfo(per,recnum,pernum);
  if editrec(per) then begin
    { Change record in datfile ('recnum' points to record in file) }
    reset(datfile,1);
    seek(datfile,sizeof(cfg)+recnum*sizeof(perinf_rec));
    blockwrite(datfile,per,sizeof(perinf_rec),nofbytes);
    close(datfile);
    if nofbytes<>sizeof(perinf_rec) then halt(6);

    { Change record in linked list ('curper' still points to rec) }
    curper^.rec:=per;
    loadlist;

    { Define function result }
    singleditrec:=true;
  end else singleditrec:=false;
end;

{ Insert Person record ------------------------------------------------------}

procedure addrectolists(per:perinf_rec);
var nofbytes:word;
begin
  { Add record to (end of) datfile }
  reset(datfile,1);
  seek(datfile,filesize(datfile));
  blockwrite(datfile,per,sizeof(perinf_rec),nofbytes);
  close(datfile);
  if nofbytes<>sizeof(perinf_rec) then halt(5);

  { Add record to (end of) linked list (check first rec in list) }
  if fstper<>nil then begin
    curper:=lstper;
    new(curper^.next);
    curper:=curper^.next;
  end
  else begin
    new(fstper);
    curper:=fstper;
  end;
  curper^.rec:=per;
  curper^.next:=nil;
  lstper:=curper;
  inc(total_persons);

  { Add record to main view list (if equal type) }
  loadlist;
end;

procedure insertrec;
var per:perinf_rec;
begin
  fillchar(per,sizeof(perinf_rec),0);
  { pre-define values }
  per.group:=group_all;
  per.country:=predefcountry;
  per.birthdate:='..-..-..';
  if editrec(per) then addrectolists(per);
end;

{ Delete Person record ------------------------------------------------------}

procedure delrecord(recnum:word);
var
  per:perinf_rec;
  pname:str30;
  i,key,fidx,nofbytes:word;
begin
  if persons=0 then exit;
  help_idx:=hlp_del;
  if nofselect=0 then begin
    getinfo(per,fidx,recnum);
    pname:=per.name;
  end else begin
    pname:='the selected person';
    if nofselect>1 then pname:=pname+'s';
  end;
  key:=dsk_msgkey('Are you sure you want to delete '+pname+
    #0+chr(col_winnorm)+' ('#0+chr(col_winhi)+'Y'#0+chr(col_winnorm)+'/'+
    #0+chr(col_winhi)+'n'#0+chr(col_winnorm)+')?');
  if key in [ord('y'),ord('Y'),crsrcr] then begin
    if nofselect=0 then begin { delete current record }
      { Change person-type in record }
      per.group:=group_deleted;

      { Update record in datfile ('fidx' points to record in file) }
      reset(datfile,1);
      seek(datfile,sizeof(cfg)+fidx*sizeof(perinf_rec));
      blockwrite(datfile,per,sizeof(perinf_rec),nofbytes);
      close(datfile);
      if nofbytes<>sizeof(perinf_rec) then halt(6);

      { Update record in linked list ('curper' still points to rec) }
      curper^.rec:=per;
    end
    else begin { delete selected records }
      for i:=persons downto 0 do begin
        getinfo(per,fidx,i);
        if per.group and 128=128 then begin
          { Change person-type in record }
          per.group:=group_deleted;

          { Update record in datfile ('fidx' points to record in file) }
          reset(datfile,1);
          seek(datfile,sizeof(cfg)+fidx*sizeof(perinf_rec));
          blockwrite(datfile,per,sizeof(perinf_rec),nofbytes);
          close(datfile);
          if nofbytes<>sizeof(perinf_rec) then halt(6);

          { Update record in linked list ('curper' still points to rec) }
          curper^.rec:=per;
        end;
      end;
      nofselect:=0;
    end;
    { Reload mainlist }
    loadlist;
    changed:=true;
  end;
end;

{ Select record(s) ----------------------------------------------------------}

procedure tag(pernum:word);
var
  per:perinf_rec;
  recnum:word;
begin
  if persons=0 then exit;
  getinfo(per,recnum,pernum);
  curper^.rec.group:=curper^.rec.group xor 128;
  if curper^.rec.group and 128=128 then inc(nofselect) else dec(nofselect);
  loadlist;
end;

procedure untagall;
var
  per:perinf_rec;
  i,recnum:word;
begin
  if persons=0 then exit;
  setscr;
  dsk_msg('De-selecting all...');
  for i:=0 to persons do begin
    getinfo(per,recnum,i);
    curper^.rec.group:=curper^.rec.group and 127;
  end;
  loadlist;
  nofselect:=0;
  getscr;
end;

procedure tagall;
var
  per:perinf_rec;
  i,recnum:word;
begin
  if persons=0 then exit;
  setscr;
  dsk_msg('Selecting all...');
  for i:=0 to persons do begin
    getinfo(per,recnum,i);
    curper^.rec.group:=curper^.rec.group or 128;
  end;
  loadlist;
  nofselect:=persons;
  getscr;
end;

procedure invtag;
var
  per:perinf_rec;
  i,recnum:word;
begin
  if persons=0 then exit;
  setscr;
  dsk_msg('Inverting all selections...');
  for i:=0 to persons do begin
    getinfo(per,recnum,i);
    curper^.rec.group:=curper^.rec.group xor 128;
  end;
  loadlist;
  nofselect:=persons-nofselect;
  getscr;
end;

{----------------------------------------------------------------------------}
{ Record VIEW related procedures and functions ------------------------------}
{----------------------------------------------------------------------------}

{ Retrieve person info ------------------------------------------------------}

procedure getinfo{(var rec:perinf_rec; var recnum:word; num:word)};
var
  i:word;
begin
  i:=0; recnum:=0; curper:=fstper;
  while (i<=num) and (curper<>nil) do begin
    if condition(curper) then inc(i);
    if i<=num then begin
      curper:=curper^.next;
      inc(recnum);
    end;
  end;
  rec:=curper^.rec;
end;

{ View record ---------------------------------------------------------------}

function viewrec(pernum:word):boolean;            { Returns true when edited }
var
  age:str8;
  per:perinf_rec;
  i:ni_names;
  nd,nm,ny,bd,bm,by,dow,c1,c2,recnum,nofbytes:word;
  prevgroup,j:byte;
  leave:boolean;
begin
  if persons=0 then exit;
  help_idx:=hlp_none;
  viewrec:=false;
  setscr;
  nwindow(4,4,70,17,' View Record ',pos_hi+pos_mi,col_wintitle,col_winattr,col_shadow);
  if not standalone then
    bar_comment(#0+chr(col_desktop)+'Keys: '+
                #0+chr(col_desktophi)+'Enter '+#0+chr(col_desktop)+'Edit   '+
                #0+chr(col_desktophi)+'P '+#0+chr(col_desktop)+'Print (detailed)');
  for i:=group to comment do
    dspat(ni[i].name,5+ni[i].pos,5+byte(i),col_winlo);
  leave:=false;
  repeat
    { Get record-contents of person number 'pernum'; also get file-index }
    getinfo(per,recnum,pernum);
    with per do begin
      fillchar(age,sizeof(age),0);
      getdate(ny,nm,nd,dow);
      val(copy(birthdate,1,2),bd,c1); c2:=c1;
      val(copy(birthdate,4,2),bm,c1); inc(c2,c1);
      val(copy(birthdate,7,2),by,c1); inc(c2,c1);
      by:=by+1900;
      if c2=0 then age:=' ('+tostr(nofyears(bd,bm,by,nd,nm,ny),0)+')';
      fillx(cfg[group and 127],' ',15,5,30,col_winnorm);
      fillx(name,' ',15,6,sizeof(name),col_winnorm);
      fillx(address,' ',15,7,sizeof(address),col_winnorm);
      fillx(zip,' ',15,8,sizeof(zip),col_winnorm);
      fillx(city,' ',15,9,sizeof(city),col_winnorm);
      fillx(country,' ',15,10,sizeof(country),col_winnorm);
      fillx(phone,' ',15,11,sizeof(phone),col_winnorm);
      fillx(fax,' ',15,12,sizeof(fax),col_winnorm);
      fillx(fidonet,' ',15,13,sizeof(fidonet),col_winnorm);
      fillx(internet,' ',15,14,sizeof(internet),col_winnorm);
      fillx(birthdate+age,' ',15,15,sizeof(birthdate)+8,col_winnorm);
      fillx(comment,' ',15,16,sizeof(comment),col_winnorm);
      prevgroup:=group and 127;
    end;
    if standalone then begin waitkey(0); leave:=true; end
    else begin
      case getekey of
        crsrcr:if editrec(per) then begin
          { Change record in datfile ('recnum' points to record in file) }
          reset(datfile,1);
          seek(datfile,sizeof(cfg)+recnum*sizeof(perinf_rec));
          blockwrite(datfile,per,sizeof(perinf_rec),nofbytes);
          close(datfile);
          if nofbytes<>sizeof(perinf_rec) then halt(6);

          { Change record in linked list ('curper' still points to rec) }
          curper^.rec:=per;

          { Check person type against 'curgroup'; leave if type changed }
          if (per.group and 127)<>prevgroup then leave:=true;
          loadlist;

          { Define function result }
          viewrec:=true;
        end;
        ord('p'),ord('P'):begin
          setscr;
          dsk_msg('Printing...');
          printrec(per);
          getscr;
        end;
        else leave:=true;
      end;
    end;
  until leave;
  getscr;
end;

{ Find & Find-Next record ---------------------------------------------------}

{ function searches for string in record: strsize < recsize }
function searchstrinrec;{(var str,rec; strsize,recsize:word):boolean;} assembler;
asm
  push ds

  cld             { forwards }
  xor ax,ax
  mov cx,recsize
  lds si,rec      { ds:si -> rec }

 @loop1:
  lodsb
  cmp al,96       { check 'a'-1 }
  jb  @skip
  cmp al,123      { check 'z'+1 }
  ja  @skip
  and al,5fh      { make upper case }
  mov di,si       { copy ds:si -> es:di }
  mov dx,ds
  mov es,dx
  dec di          { one back }
  stosb           { store uppercase back in rec }

 @skip:
  loop @loop1

  xor ax,ax       { default false }
  mov cx,recsize  { start at end of rec... }
  sub cx,strsize  { ...at recsize-strsize }

 @loop2:
  les di,rec      { es:di -> rec }
  lds si,str      { ds:si -> str }
  inc si          { skip lengte byte }
  add di,cx       { end of rec }
  mov dx,cx       { store cx in dx }
  mov cx,strsize  { size in bytes }
  shr cx,1        { size in words }
  jnc @even       { size is even? }
  cmpsb           { comp odd byte }
  jne @wrong      { equal bytes? }

 @even:
  repe cmpsw      { compare loop }

 @wrong:
  mov cx,dx       { restore cx }
  loopne @loop2   { equal at end? }

  jne @end        { not equal: end }
  inc ax          { return: true }

 @end:
  pop ds          { restore ds }
end;

{- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - }

function find(var base:word; var rel:byte; var start:word):boolean;
var
  tmprec:perinf_rec;
  tmpsearch:str60;
  i:word;
  wsize:byte;
  found:boolean;
begin
  if persons=0 then exit;
  help_idx:=hlp_find;
  if start=0 then begin
    { If not continues search, then ask for searchstring }
    setscr;
    nwindow(5,5,75,7,'',0,0,col_winattr,col_shadow);
    dspat('Search:',7,6,col_winnorm);
    i:=input(15,6,searchstr,[#31..#126],59,col_winhi,col_winnorm,nocap,pos_le);
    getscr;
    if i=crsresc then exit;
  end;

  i:=0;
  { Set pointer-list to first occurence }
  curper:=fstper;
  while not condition(curper) do curper:=curper^.next;

  { If contiunues search, set pointer-list to start occurence }
  while (i<start) and (curper<>nil) do begin
    if condition(curper) then inc(i);
    if i<=start then repeat
      curper:=curper^.next;
    until condition(curper) or (curper=nil);
  end;

  { Search pointer-list... }
  tmpsearch:=strup(searchstr);
  found:=false;
  while (not found) and (curper<>nil) do begin
    tmprec:=curper^.rec;
    found:=searchstrinrec(tmpsearch,tmprec,length(tmpsearch),sizeof(perinf_rec));
    if not found then begin
      repeat
        curper:=curper^.next;
      until condition(curper) or (curper=nil);
      inc(i);
    end;
  end;
  { If found, then set bar to correct position }
  if found then begin
    find:=true;
    wsize:=(rows div 2)-3;
    base:=succ(i);
    start:=base;
    if persons>(rows-3) then begin
      if base<=wsize then rel:=base
      else if (persons-base)<=wsize then rel:=rows div 2+(wsize-(persons-base))
      else rel:=succ(wsize);
    end
    else rel:=base;
  end
  { If not found, display message }
  else begin
    find:=false;
    dsk_msgkey('Searchstring not found.');
    start:=0;
  end;
end;

{ Grep ----------------------------------------------------------------------}

procedure grep;
begin
  if persons=0 then exit;
  help_idx:=hlp_grep;
  { Get grep-string }
  setscr;
  nwindow(5,5,73,7,'',0,0,col_winattr,col_shadow);
  dspat('Grep:',7,6,col_winnorm);
  if input(13,6,grepstr,[#31..#126],59,col_winhi,col_winnorm,nocap,pos_le)<>crsresc then begin
    { Set grep to active and load new mainlist }
    grepactive:=true;
    curgroup:=group_grep;
    grepupstr:=strup(grepstr);
    loadlist;
  end;
  getscr;
end;

{ Goto recordnumber ---------------------------------------------------------}

function gotorec(var base:word; var rel:byte):boolean;
var
  tmpstr:str10;
  i,tmprec:word;
  dummy:integer;
  wsize:byte;
begin
  if persons=0 then exit;
  help_idx:=hlp_goto;
  setscr;
  nwindow(5,10,24,12,'',0,0,col_winattr,col_shadow);
  dspat('Goto record:',7,11,col_winnorm);
  fillchar(tmpstr,sizeof(tmpstr),0);
  i:=input(20,11,tmpstr,['0'..'9'],3,col_winhi,col_winnorm,nocap,pos_le);
  getscr;
  if i=crsresc then exit;
  val(tmpstr,tmprec,dummy);
  if tmprec=0 then exit;
  if tmprec>persons then dsk_msgkey('Recordnumber too large...')
  else begin
    base:=tmprec;
    wsize:=round(rows/2)-3;
    if base<=wsize then rel:=base
    else if (persons-base)<=wsize then rel:=rows div 2+(wsize-(persons-base))
    else rel:=succ(wsize);
    gotorec:=true;
  end;
end;

{----------------------------------------------------------------------------}
{ Type view/edit routine ----------------------------------------------------}
{----------------------------------------------------------------------------}

{ Known bug: when inserting or deleting groups, person-groups get messed up! }

procedure viewtypes;
var
  per:perinf_rec;
  org:cfgtype;
  tmp:string[configitemsize];
  i,recnum,nofbytes:word;
  py,cy,pst,cst,prevgroup:byte;
  leave,update:boolean;
begin
  help_idx:=hlp_edgroup;
  setscr;
  nwindow(4,1,40,22,' Groups ',pos_hi+pos_ri,col_wintitle,col_winattr,col_shadow);
  bar_comment(#0+chr(col_desktop)+'Keys: '+
              #0+chr(col_desktophi)+'Space '+#0+chr(col_desktop)+'Select   '+
              #0+chr(col_desktophi)+'Enter '+#0+chr(col_desktop)+'Edit (First 3 are hardcoded)   '{+
              #0+chr(col_desktophi)+'Ins '+#0+chr(col_desktop)+'Insert line   '+
              #0+chr(col_desktophi)+'Del '+#0+chr(col_desktop)+'Delete line'});
  org:=cfg;
  leave:=false; update:=true;
  prevgroup:=curgroup;
  py:=0; cy:=0; cst:=pred(curgroup); pst:=cst;
  repeat
    if update then begin
      for i:=1 to maxtypes do
        fillx(tostr(i,2)+' '+cfg[i],' ',6,1+i,33,col_winnorm);
      update:=false;
    end;
    fillattr(9,2+py,38,2+py,col_winnorm);
    fillattr(9,2+cy,38,2+cy,col_winselect);
    dspchar(' ',8,2+pst,col_winnorm);
    dspchar('',8,2+cst,col_winhi);
    py:=cy;
    case getekey of
      crsrup:if cy>0 then dec(cy);
      crsrdown:if cy<pred(maxtypes) then inc(cy);
      crsrhome:cy:=0;
      crsrend:cy:=pred(maxtypes);
      { Disabled INS and DEL: they cause shitty bugs in database-groups }
      {crsrins:if cy>=3 then begin
        if cy<pred(maxtypes) then
          for i:=maxtypes downto succ(cy) do cfg[succ(i)]:=cfg[i];
        fillchar(cfg[succ(cy)],succ(configitemsize),0);
        update:=true;
      end;
      crsrdel:if cy>=3 then begin
        if cy<pred(maxtypes) then
          for i:=cy to pred(maxtypes) do cfg[succ(i)]:=cfg[i+2];
        fillchar(cfg[maxtypes],succ(configitemsize),0);
        update:=true;
      end;}
      ord(' '):begin pst:=cst; cst:=cy; end;
      crsrcr:if cy>=3 then begin
        tmp:=cfg[succ(cy)];
        input(9,2+cy,tmp,[#30..#166],30,col_wininput,col_winnorm,nocap,pos_le);
        if tmp<>'' then cfg[succ(cy)]:=tmp
        else begin
          i:=0;
          curper:=fstper;
          while curper<>nil do begin
            if curper^.rec.group and 127=succ(cy) then inc(i);
            curper:=curper^.next;
          end;
          if i>0 then dsk_msgkey('Group is used. Can not erase it.')
          else cfg[succ(cy)]:=tmp;
        end;
        update:=true;
      end;
      crsresc:leave:=true;
    end;
  until leave;

  { If cfg changed, then save it }
  if not equal(cfg,org,sizeof(cfg)) then begin
    reset(datfile,1);
    blockwrite(datfile,cfg,sizeof(cfg),nofbytes);
    if nofbytes<>sizeof(cfg) then halt(7);
    changed:=true;
  end;
  getscr;

  { Determine new type }
  if prevgroup<>succ(cst) then begin
    { Select active? }
    if nofselect>0 then
      if ord(dsk_msgkey('Loose selections'+
             #0+chr(col_winnorm)+' ('#0+chr(col_winhi)+'Y'#0+chr(col_winnorm)+'/'+
             #0+chr(col_winhi)+'n'#0+chr(col_winnorm)+')?')) in
         [ord('y'),ord('Y'),crsrcr] then begin
        for i:=0 to persons do begin
          getinfo(per,recnum,i);
          if per.group and 128=128 then
            curper^.rec.group:=curper^.rec.group and 127;
        end;
        nofselect:=0;
      end;
    curgroup:=succ(cst);
    grepactive:=curgroup=group_grep;
    loadlist;
  end;
end;

{----------------------------------------------------------------------------}
{ Sort routines -------------------------------------------------------------}
{----------------------------------------------------------------------------}

{ Main header - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -}

procedure sort;
const
  sorttypes:array[0..8] of str10=(
    'First name',
    'Last name',
    'Address',
    'Zip code',
    'City',
    'Country',
    'Phone',
    'Fax',
    'Birthdate');
var
  sortlist:sortptr;

{ Sub: Quicksort - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - }

procedure quicksort(l,r:integer);
var tmprec:sortitem; x:str30; i,j:integer;
begin
  i:=l; j:=r; x:=sortlist^[(l+r) div 2].item;
  repeat
    while sortlist^[i].item<x do inc(i);
    while x<sortlist^[j].item do dec(j);
    if i<=j then begin
      tmprec:=sortlist^[i];
      sortlist^[i]:=sortlist^[j];
      sortlist^[j]:=tmprec;
      inc(i); dec(j);
    end;
  until i>J;
  if l<j then quicksort(l,j);
  if i<r then quicksort(i,r);
end;

{ Sub: Read data - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - }

procedure readdata(order:byte);
var i:word; j:byte;
begin
  i:=0; curper:=fstper;
  while curper<>nil do begin
    with sortlist^[i],curper^.rec do begin
      case order of
        1:item:=name;
        2:begin j:=rpos([' '],name); item:=copy(name,succ(j),length(name)-j)+name; end;
        3:item:=address;
        4:item:=zip;
        5:item:=city;
        6:item:=country;
        7:item:=phone;
        8:item:=fax;
        9:item:=copy(birthdate,7,2)+copy(birthdate,4,2)+copy(birthdate,1,2);
      end;
      fidx:=i;
    end;
    curper:=curper^.next;
    inc(i);
  end;
end;

{ Main sort - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -}

var
  tmpfile:file;
  per:perinf_rec;
  typeslist:sel_ptr;
  i,nofbytes:word;
begin
  if persons=0 then exit;
  help_idx:=hlp_sort;
  getmem(typeslist,9*succ(selectitemsize));
  { Get sort-type }
  for i:=0 to 8 do
    typeslist^[i]:=sorttypes[i];
  i:=select(5,5,17,15,'',' Sort on ',1,9,0,typeslist);
  freemem(typeslist,9*succ(selectitemsize));
  if i=0 then exit;
  getmem(sortlist,succ(total_persons)*sizeof(sortitem));
  { Show progress... }
  setscr;
  nwindow(7,7,42,11,' Sort progress ',pos_hi+pos_le,col_wintitle,col_winattr,col_shadow);
  dspat('Reading...',9,9,col_winnorm);
  readdata(i);
  dspat('Sorting...',20,9,col_winnorm);
  quicksort(0,pred(total_persons));
  dspat('Writing...',31,9,col_winnorm);
  { Create temp. file }
  assign(tmpfile,exepath+'pd$$$.tmp');
  rewrite(tmpfile,1);
  { Write configrecord to temp. file }
  blockwrite(tmpfile,cfg,sizeof(cfg),nofbytes);
  if nofbytes<>sizeof(cfg) then halt(5);
  { Open datafile }
  reset(datfile,1);
  { Copy records from datafile to temp. file }
  for i:=0 to pred(total_persons) do begin
    seek(datfile,sizeof(cfg)+sortlist^[i].fidx*sizeof(perinf_rec));
    blockread(datfile,per,sizeof(perinf_rec),nofbytes);
    if nofbytes<>sizeof(perinf_rec) then halt(4);
    blockwrite(tmpfile,per,sizeof(perinf_rec),nofbytes);
    if nofbytes<>sizeof(perinf_rec) then halt(5);
  end;
  close(datfile);
  close(tmpfile);
  { Erase current datafile and replace it with the sorted temp. file }
  erase(datfile);
  rename(tmpfile,exepath+datfname);
  assign(datfile,exepath+datfname);
  freemem(sortlist,succ(total_persons)*sizeof(sortitem));
  { Re-load (sorted) linked list and main selection list }
  loadlinked;
  loadlist;
  getscr;
  changed:=true;
end;

{----------------------------------------------------------------------------}
{ Pack database -------------------------------------------------------------}
{----------------------------------------------------------------------------}

function pack:boolean;
var
  tmpfile:file;
  per:perinf_rec;
  key,nofbytes,i:word;
begin
  if persons=0 then exit;
  pack:=false;
  i:=0;
  curper:=fstper;
  while curper<>nil do begin
    if curper^.rec.group=group_deleted then inc(i);
    curper:=curper^.next;
  end;
  if i=0 then begin
    help_idx:=hlp_none;
    dsk_msgkey('Nothing to pack...');
    exit;
  end;
  help_idx:=hlp_pack;
  key:=dsk_msgkey('Are you sure you want to pack the database '+
    #0+chr(col_winnorm)+'('#0+chr(col_winhi)+'Y'#0+chr(col_winnorm)+'/'+
    #0+chr(col_winhi)+'n'#0+chr(col_winnorm)+')?');
  if not (key in [ord('y'),ord('Y'),crsrcr]) then exit;
  setscr;
  nwindow(10,10,23,12,'',0,0,col_winattr,col_shadow);
  dspat('Packing...',12,11,col_winnorm);
  { Create temp. file }
  assign(tmpfile,exepath+'pd$$$.tmp');
  rewrite(tmpfile,1);
  { Write configrecord to temp. file }
  blockwrite(tmpfile,cfg,sizeof(cfg),nofbytes);
  if nofbytes<>sizeof(cfg) then halt(5);
  { Open datafile }
  reset(datfile,1);
  seek(datfile,sizeof(cfg));
  { Copy undeleted records from datafile to temp. file }
  while not eof(datfile) do begin
    blockread(datfile,per,sizeof(perinf_rec),nofbytes);
    if nofbytes<>sizeof(perinf_rec) then halt(4);
    if (per.group and 127)<>group_deleted then begin
      blockwrite(tmpfile,per,sizeof(perinf_rec),nofbytes);
      if nofbytes<>sizeof(perinf_rec) then halt(5);
    end;
  end;
  close(datfile);
  close(tmpfile);
  { Erase current datafile and replace it with the packed temp. file }
  erase(datfile);
  rename(tmpfile,exepath+datfname);
  assign(datfile,exepath+datfname);
  { Re-load (packed) linked list and main selection list }
  loadlinked;
  loadlist;
  getscr;
  changed:=true;
  pack:=true;
end;

{----------------------------------------------------------------------------}
{ Birthdate -----------------------------------------------------------------}
{----------------------------------------------------------------------------}

procedure birthdays(days:word);
var
  curdays:longint;

{ Sub-sub: Calculate number of days from 1900 -  -  -  -  -  -  -  -  -  -  -}
{ Deliberatly skip leap-years, introducing a small *unimportant* error... }

function daysfrom1900(d,m,y:word):longint;
const cdays:array[1..12] of word=(31,59,90,121,152,182,231,244,274,305,335,366);
var i,nd:longint;
begin
  if y>0 then nd:=pred(y)*365 else nd:=0;
  inc(nd,cdays[m-1]);
  inc(nd,d);
  daysfrom1900:=nd;
end;

{ Sub: Calculate number of days between given dates - - - - - - - - - - - - -}

function nofdays(bd,bm,by,nd,nm,ny:word):word;
var
  d:longint;
begin
  d:=((daysfrom1900(bd,bm,by)-curdays) mod 365)+365;
  if d=365 then d:=0
  else if d>365 then d:=maxint;
  nofdays:=d;
end;

{ Main birthday - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -}

type
  b_ptr=^b_rec;
  b_rec=record
    abs_rec:word;
    name:str30;
    birthdate:datestr;
    days:word;
    years:byte;
    valid:boolean;
    next:b_ptr;
  end;
var
  fst_b,cur_b,lst_b,tmp_b:b_ptr;
  list:sel_ptr;
  per:perinf_rec;
  tmp:str30;
  i,inlist,nd,nm,ny,bd,bm,by,dow,c1,c2,recnum,ndays,cy:word;
  y:byte;
begin
  if persons=0 then exit;
  help_idx:=hlp_birth;
  { Count number of people in list }
  getdate(ny,nm,nd,dow); ny:=ny-1900;
  curdays:=daysfrom1900(nd,nm,ny);
  inlist:=0;
  fst_b:=nil; cur_b:=nil; lst_b:=nil;
  for i:=0 to total_persons-1 do begin
    getinfo(per,recnum,i);
    val(copy(per.birthdate,1,2),bd,c1); c2:=c1;
    val(copy(per.birthdate,4,2),bm,c1); inc(c2,c1);
    val(copy(per.birthdate,7,2),by,c1);
    if (c2=0) and (c1<>0) then ndays:=nofdays(bd,bm,0,nd,nm,0)
    else if (c1+c2=0) then ndays:=nofdays(bd,bm,by,nd,nm,ny)
    else ndays:=65535;
    if ndays<=days then begin
      inc(inlist);
      if fst_b=nil then begin
        new(fst_b);
        cur_b:=fst_b;
      end
      else begin
        new(cur_b^.next);
        cur_b:=cur_b^.next;
      end;
      cur_b^.next:=nil;
      lst_b:=cur_b^.next;
      with cur_b^ do begin
        abs_rec:=i;
        name:=per.name;
        birthdate:=per.birthdate;
        days:=ndays;
        years:=succ(nofyears(succ(bd),bm,by,nd,nm,ny));
        valid:=by>0;
      end;
    end;
  end;
  if inlist=0 then exit;
  { Read and display list }
  getmem(list,inlist*succ(selectitemsize));
  cur_b:=fst_b;
  for i:=0 to inlist-1 do begin
    fillchar(list^[i],succ(selectitemsize),0);
    list^[i]:=cur_b^.name;
    if cur_b^.valid then tmp:=cur_b^.birthdate+' ('+tostr(cur_b^.years,2)+', '
    else tmp:=cur_b^.birthdate+' (??, ';
    if cur_b^.days>1 then tmp:=tmp+tostr(cur_b^.days,0)+' days)'
    else if cur_b^.days=1 then tmp:=tmp+'tomorrow)'
    else if cur_b^.days=0 then tmp:=tmp+'today)';
    move(tmp[1],list^[i][31],length(tmp));
    list^[i][0]:=#54;
    cur_b:=cur_b^.next;
  end;
  if inlist<rows-8 then y:=inlist else y:=rows-8;
  cy:=1;
  repeat
    i:=select(23,4,24+54,5+y,'',' Birthdays within '+tostr(days,0)+' days ',cy,inlist,startupwait,list);
    startupwait:=0;
    cy:=i;
    if i>0 then begin
      cur_b:=fst_b;
      while i>1 do begin cur_b:=cur_b^.next; dec(i); end;
      viewrec(cur_b^.abs_rec);
    end;
  until i=0;
  { Dispose reserved memory }
  cur_b:=fst_b;
  while cur_b<>lst_b do begin
    tmp_b:=cur_b^.next;
    dispose(cur_b);
    cur_b:=tmp_b;
  end;
  freemem(list,inlist*succ(selectitemsize));
end;

{----------------------------------------------------------------------------}
{ Import routines -----------------------------------------------------------}
{----------------------------------------------------------------------------}

procedure _import;
type
  itemlist=array[0..2] of str20;

const
  im_whatlist:itemlist=(
    'Textfile','PD-Group file','dBase');

{ Sub: Change 'what' - - - - - - - - - - - - - - - - - - - - - - - - - - - - }

procedure changeitem(var wh:byte; item:str20; list:itemlist);
var
  typeslist:sel_ptr;
  i:byte;
begin
  getmem(typeslist,3*succ(selectitemsize));
  for i:=0 to 2 do
    typeslist^[i]:=list[i];
  i:=select(40,9,60,13,'',item,1,3,0,typeslist);
  freemem(typeslist,3*succ(selectitemsize));
  if i>0 then wh:=i-1;
end;

{ Sub: Import textfile - - - - - - - - - - - - - - - - - - - - - - - - - - - }

procedure im_textfile(var per:perinf_rec; var ok:boolean);
var
  list:sel_ptr;
  prevpath,globalpath:pathstr;
  curnum,listsize:word;
  nofdrives:byte;

{ Sub-Sub: get number of drives, inc. flops -  -  -  -  -  -  -  -  -  -  -  }

procedure setdrive(drive:byte); assembler; asm                        { 0=A: }
  mov dl,drive; mov ah,0eh; int 21h; end;

function getdrive:byte; assembler; asm                                { 0=A: }
  mov ah,19h; int 21h; end;

function flopdrives:byte; assembler; asm           { 0=none, 1=A:, 2=A: & B: }
  int 11h; test al,1; jz @nodrives; ror al,2; and al,3
  inc ax; jmp @out; @nodrives: xor al,al; @out: end;

function drives:byte;
var cur,dr,i:byte;
begin
  dr:=0;
  cur:=getdrive;
  for i:=2 to 25 do begin
    setdrive(i);
    if getdrive=i then inc(dr);
  end;
  setdrive(cur);
  inc(dr,flopdrives);
  drives:=dr;
end;

{ Sub-Sub: select filename -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  - }

function selectfile(path:pathstr):pathstr;
const
  cdirstr:pathstr='<DIR>';
var
  di:searchrec;
  fname:namestr; fext:extstr; fdir:dirstr;
  tmp:str20;
  dt:datetime;
  i,files:word;
  scrsize,dummy,last,j,dr:byte;

{ Sub-Sub-Sub: Quicksort directory -   -   -   -   -   -   -   -   -   -   - }

procedure quicksort(l,r:integer);
var tmp,x:sel_item; i,j:integer;
begin
  i:=l; j:=r; x:=list^[(l+r) div 2];
  repeat
    while list^[i]<x do inc(i);
    while x<list^[j] do dec(j);
    if i<=j then begin
      tmp:=list^[i];
      list^[i]:=list^[j];
      list^[j]:=tmp;
      inc(i); dec(j);
    end;
  until i>J;
  if l<j then quicksort(l,j);
  if i<r then quicksort(i,r);
end;

{ Selectfile -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -}

begin
  setscr;
  if globalpath<>prevpath then begin
    prevpath:=globalpath;
    if list<>nil then freemem(list,listsize);
    files:=0;
    findfirst('*.*',anyfile and (not volumeid),di);
    while doserror=0 do begin inc(files); findnext(di); end;   { count files }
    inc(files,nofdrives);    { add number of drives to number of total files }
    listsize:=files*sizeof(sel_item);
    getmem(list,listsize);
    i:=0;                                   { read files in select-structure }
    dr:=flopdrives;                                          { floppy-drives }
    last:=getdrive;                                     { save current drive }
    if dr>0 then
      for j:=1 to flopdrives do begin
        fillchar(list^[i],sizeof(sel_item),0);
        list^[i][0]:=chr(selectitemsize);
        tmp:=#17'['+chr(ord('A')+pred(j))+':]';
        move(tmp[1],list^[i][1],length(tmp));
        inc(i);
      end;
    for dr:=2 to 25 do begin                                  { other drives }
      setdrive(dr);
      if getdrive=dr then begin
        fillchar(list^[i],sizeof(sel_item),0);
        list^[i][0]:=chr(selectitemsize);
        tmp:=#17'['+chr(ord('A')+dr)+':]';
        move(tmp[1],list^[i][1],length(tmp));
        inc(i);
      end;
    end;
    setdrive(last);                                     { restore last drive }
    findfirst('*.*',anyfile and (not volumeid),di);
    while doserror=0 do begin
      with di do begin
        fillchar(list^[i],sizeof(sel_item),0);
        list^[i][0]:=chr(selectitemsize);
        if bitson(attr,directory) then begin                   { directories }
          if name<>'.' then begin
            if name<>'..' then name:=#25+name else name:=#24+name;
            move(name[1],list^[i][1],length(name));
            move(cdirstr[1],list^[i][15],7);
            unpacktime(time,dt);
            with dt do tmp:=lz(day,2)+'-'+months[month]+'-'+lz(year-1900,2);
            move(tmp[1],list^[i][24],length(tmp));
            with dt do tmp:=lz(hour,2)+':'+lz(min,2)+':'+lz(sec,2);
            move(tmp[1],list^[i][35],length(tmp));
            inc(i);
          end;
        end
        else begin                                                   { files }
          fsplit(name,fdir,fname,fext);
          if length(fname)>0 then move(fname[1],list^[i][1],length(fname));
          if length(fext)>0 then move(fext[2],list^[i][10],length(fext)-1);
          str(size:7,tmp); move(tmp[1],list^[i][15],7);
          unpacktime(time,dt);
          with dt do tmp:=lz(day,2)+'-'+months[month]+'-'+lz(year-(year div 100)*100,2);
          move(tmp[1],list^[i][24],length(tmp));
          with dt do tmp:=lz(hour,2)+':'+lz(min,2)+':'+lz(sec,2);
          move(tmp[1],list^[i][35],length(tmp));
          inc(i);
        end;
      end;
      findnext(di);
    end;
    scrsize:=v_lines-9;
    if i<scrsize then scrsize:=i;
    files:=i;
    quicksort(0,i-1);                                  { sort directory list }
  end;
  curnum:=select(25,2,69,3+scrsize,path,' Select a Textfile ',curnum,files,0,list);
  i:=curnum;
  if i<>0 then begin
    if list^[i-1][10]<>#0 then selectfile:=copy(list^[i-1],1,pos(#0,list^[i-1])-1)+'.'+copy(list^[i-1],10,3)
    else selectfile:=copy(list^[i-1],1,pos(#0,list^[i-1])-1);
  end else selectfile:='';
  getscr;
end;

{ Sub-Sub: get pathname -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  - }

function getfname:pathstr;      { Get any filename from any dir and/or drive }
var
  curdir,fname,drive:pathstr;
  is_drive,is_dir,is_file:boolean;
begin
  getdir(0,curdir);
  repeat
    fname:=selectfile(curdir);         { select dir, drive or file from list }
    is_drive:=false; is_dir:=false; is_file:=false;
    if fname<>'' then begin                                  { find out type }
      if (fname[1] in [#24,#25]) then is_dir:=true
      else if fname[1]=#17 then is_drive:=true
      else is_file:=true;
    end else is_file:=true;
    if is_drive then begin                { select drive and curdir on drive }
      drive:=copy(fname,3,2);
      chdir(drive);
      getdir(0,curdir);
      globalpath:=noslash(curdir);
      curnum:=1;
    end
    else if is_dir then begin                            { select new curdir }
      if fname[1]=#25 then begin
        if length(curdir)>3 then curdir:=curdir+'\'+copy(fname,2,length(fname)-1)
        else curdir:=curdir+copy(fname,2,length(fname)-1);
      end
      else begin
        curdir:=copy(curdir,1,rpos(['\'],curdir)-1);
        if length(curdir)=2 then curdir:=curdir+'\';
      end;
      chdir(curdir);
      globalpath:=noslash(curdir);
      curnum:=1;
    end;
  until is_file;
  if fname<>'' then getfname:=fexpand(fname) else getfname:='';
end;

{ Sub-Sub: Get string -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -}

function getstring(search:str30; var txt:text):str30;
var
  tmp:string;
  i:byte;
  found:boolean;
begin
  found:=false;
  reset(txt);
  while (not eof(txt)) and (not found) do begin
    readln(txt,tmp);
    found:=pos(search,strdn(tmp))>0;
  end;
  if found then begin
    i:=pos(search,strdn(tmp))+length(search);
    tmp:=copy(tmp,i,1+length(tmp)-i);
    trim(tmp,' ');
    trim(tmp,'_');
    if tmp[1]=':' then delete(tmp,1,1);
    trim(tmp,' ');
    getstring:=tmp;
  end else getstring:='';
end;

{ Import textfile (only one record per file!) }

var
  txtfile:text;
  pathname,olddir:pathstr;
begin
  getdir(0,olddir);
  globalpath:=olddir;
  nofdrives:=drives;
  curnum:=1;
  prevpath:='';
  list:=nil;
  pathname:=getfname;
  if pathname<>'' then begin
    ok:=true;
    fillchar(per,sizeof(perinf_rec),0);
    assign(txtfile,pathname);
    with per do begin
      group:=group_all;
      name:=getstring(name_str,txtfile);
      address:=getstring(address_str,txtfile);
      zip:=getstring(zip_str,txtfile);
      city:=getstring(city_str,txtfile);
      country:=getstring(country_str,txtfile);
      phone:=getstring(phone_str,txtfile);
      fidonet:=getstring(fido_str,txtfile);
      internet:=getstring(inet_str,txtfile);
      birthdate:='..-..-..';
    end;
    close(txtfile);
    if editrec(per) then addrectolists(per);
    changed:=true;
  end else ok:=false;
  chdir(olddir);
end;

{ Sub: Import PD-groupfile - - - - - - - - - - - - - - - - - - - - - - - - - }

procedure im_groupfile(var ok:boolean);

{ Sub-Sub: Get groupfilename -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  }

function getfname:pathstr;            { Get only groupfiles from current dir }
var
  binfile:file;
  descr:string[40];
  list:sel_ptr;
  di:searchrec;
  tmp:str20;
  dt:datetime;
  listsize:word;
  i,files,scrsize:byte;
begin
  getfname:='';

  { Count files }
  files:=0;
  findfirst(exepath+'pd.g??',anyfile and (not volumeid),di); { Search PD-groupfiles }
  while doserror=0 do begin inc(files); findnext(di); end;
  if files=0 then begin
    dsk_msgkey('No PD-groupfiles in PD directory.'); exit; end;
  listsize:=files*sizeof(sel_item);
  getmem(list,listsize);

  { Read PD-groupfiles }
  i:=0;
  findfirst(exepath+'pd.g??',anyfile and (not volumeid),di); { Search PD-groupfiles }
  while doserror=0 do begin
    with di do begin
      fillchar(list^[i],sizeof(sel_item),0);
      list^[i][0]:=chr(selectitemsize);
      move(name[1],list^[i][1],length(name));
      assign(binfile,exepath+name);
      reset(binfile,1);
      blockread(binfile,descr,succ(configitemsize));
      close(binfile);
      if length(descr)>24 then descr:=copy(descr,1,24)+#16;
      descr:=''''+descr+'''';
      move(descr[1],list^[i][9],length(descr));
      str(((size-succ(configitemsize)) div sizeof(perinf_rec)):3,tmp); move(tmp[1],list^[i][37],3);
      unpacktime(time,dt);
      with dt do tmp:=lz(day,2)+'-'+months[month]+'-'+lz(year-(year div 100)*100,2);
      move(tmp[1],list^[i][42],length(tmp));
      with dt do tmp:=lz(hour,2)+':'+lz(min,2)+':'+lz(sec,2);
      move(tmp[1],list^[i][53],length(tmp));
    end;
    inc(i);
    findnext(di);
  end;
  if files<rows-12 then scrsize:=files else scrsize:=rows-12;

  { Select file }
  i:=select(5,9,69,10+scrsize,'File    Description                   #  Date       Time',
    ' Select a PD-Groupfile ',1,files,0,list);
  if i>0 then getfname:=copy(list^[i-1],1,pos(#0,list^[i-1])-1);

  freemem(list,listsize);
end;

{ Import PD-groupfile }

var
  binfile:file;
  list:sel_ptr;
  per:perinf_rec;
  pathname:pathstr;
  descr:str30;
  key,nofbytes,listsize:word;
  i,max,py,cy,dpos:byte;
  leave:boolean;
begin
  ok:=false;
  { Get PD-groupfile }
  pathname:=getfname;
  if pathname<>'' then begin
    {fillchar(per,sizeof(perinf_rec),0);}

    { Open file and get description }
    i:=3;
    assign(binfile,exepath+pathname);
    reset(binfile,1);
    blockread(binfile,descr,sizeof(descr),nofbytes);
    if nofbytes<>sizeof(descr) then halt(8);
    { Add description to end of group-list }
    key:=dsk_msgkey('Add description '''+descr+''' to grouplist'+
      #0+chr(col_winnorm)+' ('#0+chr(col_winhi)+'Y'#0+chr(col_winnorm)+'/'+
      #0+chr(col_winhi)+'n'#0+chr(col_winnorm)+')?');
    if key in [ord('y'),ord('Y'),crsrcr] then begin
      { Search position to add description to (=i) }
      i:=maxtypes;
      while (cfg[i]='') and (i>1) do dec(i);
      inc(i); max:=i;
      if i>maxtypes then begin
        { No more space at end, search other empty space... }
        i:=1;
        while (cfg[i]='') and (i<maxtypes) do inc(i);
        if i=maxtypes then begin { No space to add... Overwrite? }
          key:=dsk_msgkey('No space to add description. Overwrite at end'+
            #0+chr(col_winnorm)+' ('#0+chr(col_winhi)+'Y'#0+chr(col_winnorm)+'/'+
            #0+chr(col_winhi)+'n'#0+chr(col_winnorm)+')?');
          if key in [ord('y'),ord('Y'),crsrcr] then i:=20
          else begin close(binfile); exit; end;
        end;
      end;
      { Add...}
      cfg[i]:=descr;
      reset(datfile,1);
      blockwrite(datfile,cfg,sizeof(cfg));
      close(datfile);
    end;
    dpos:=i-2;

    { Chose group... (=i) }
    max:=maxtypes;
    while (cfg[max]='') and (max>1) do dec(max);
    dec(max,2);
    listsize:=max*sizeof(sel_item);
    getmem(list,listsize);
    for i:=1 to max do
      list^[pred(i)]:=cfg[2+i];
    i:=select(68-configitemsize,9,69,10+max,'',' Select a Group to Add to... ',dpos,max,0,list);
    freemem(list,listsize);
    if i=0 then begin close(binfile); exit; end;
    inc(i,2);

    { Import groupfile }
    reset(datfile,1);
    seek(datfile,filesize(datfile));
    while not eof(binfile) do begin
      blockread(binfile,per,sizeof(perinf_rec),nofbytes);
      if nofbytes<>sizeof(perinf_rec) then halt(8);
      per.group:=i;
      blockwrite(datfile,per,sizeof(perinf_rec),nofbytes);
      if nofbytes<>sizeof(perinf_rec) then halt(5);
    end;
    close(datfile);
    close(binfile);

    { Re-load lists... }
    loadlinked;
    loadlist;

    ok:=true;
    changed:=true;
  end;
end;

{ Sub: Actual import-procedure - - - - - - - - - - - - - - - - - - - - - - - }

procedure do_import(what:byte; var leave:boolean);
var
  per:perinf_rec;
  okay:boolean;
begin
  leave:=false;
  if what=0 then im_textfile(per,leave)                    { Import textfile }
  else if what=1 then im_groupfile(leave)              { Import PD-groupfile }
  else if what=2 then begin
    dsk_msgkey('dBase-import is not implemented yet.'); exit; end;
end;

{ Main import - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -}

var
  key:word;
  im_what,
  cury,prey:byte;
  leave:boolean;
begin
  help_idx:=hlp_import;
  setscr;
  nwindow(40,2,69,7,' Import ',pos_hi+pos_mi,col_wintitle,col_winattr,col_shadow);
  im_what:=0;
  cury:=1; prey:=1;
  leave:=false;
  repeat
    filltext(' ',50,4,68,5,col_winnorm);
    dspmul(#0+chr(col_winhi)+'What?   '+#0+chr(col_winnorm)+im_whatlist[im_what],42,4);
    dspmul(#0+chr(col_winhi)+'Import! ',42,5);
    fillattr(42,3+prey,48,3+prey,col_winhi);
    fillattr(42,3+cury,48,3+cury,col_winselect);
    case cury of
      1:bar_comment(#0+chr(col_desktop)+'What to import. '+#0+chr(col_desktophi)+'Enter '+#0+chr(col_desktop)+'Change.');
      2:bar_comment(#0+chr(col_desktop)+'Import '+im_whatlist[im_what]+'.');
    end;
    key:=getekey;
    prey:=cury;
    case key of
      crsrup:if cury>1 then dec(cury);
      crsrdown:if cury<2 then inc(cury);
      crsrcr:begin
        case cury of
          1:changeitem(im_what,'What',im_whatlist);          { Change 'what' }
          2:do_import(im_what,leave);                              { Import! }
        end;
      end;
      crsresc:leave:=true;
    end;
  until leave;
  getscr;
end;

{----------------------------------------------------------------------------}
{ Export routines -----------------------------------------------------------}
{----------------------------------------------------------------------------}

procedure _export(pernum:word);
type
  itemlist=array[0..2] of str20;

const
  ex_whatlist:itemlist=(
    'Current record','Selected records','Current Group');
  ex_wherelist:itemlist=(
    'Textfile','PD-Group file','dBase');

{ Sub: Change 'what' or 'where' - - - - - - - - - - - - - - - - - - - - - - -}

procedure changeitem(var wh:byte; item:str20; list:itemlist);
var
  typeslist:sel_ptr;
  i:byte;
begin
  getmem(typeslist,3*succ(selectitemsize));
  for i:=0 to 2 do
    typeslist^[i]:=list[i];
  i:=select(5,10,25,14,'',item,1,3,0,typeslist);
  freemem(typeslist,3*succ(selectitemsize));
  if i>0 then wh:=i-1;
end;

{ Sub: Actual export-procedure - - - - - - - - - - - - - - - - - - - - - - - }

procedure do_export(what,where:byte; var leave:boolean);
var
  outf:file;
  per:perinf_rec;
  di:searchrec;
  outfname:pathstr;
  descr:str30;
  max:string[2];
  key,i,j,num,recnum:word;
  prevgroup:byte;

{ Sub-Sub: Export to textfile -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  - }

procedure ex_textfile(per:perinf_rec);

{ Sub-Sub-Sub... }

procedure write_to_file(var f:file; conststr,recstr:str80);
var tmp:string;
begin
  fillchar(tmp,sizeof(tmp),0);
  tmp:=conststr+':';
  while length(tmp)<ex_offset do tmp:=tmp+' ';
  tmp:=tmp+recstr+#$0d+#$0a;
  blockwrite(outf,tmp[1],length(tmp));
end;

var tmp:string;
begin
  with per do begin
    write_to_file(outf,name_str,name);
    write_to_file(outf,address_str,address);
    write_to_file(outf,zip_str,zip);
    write_to_file(outf,city_str,city);
    write_to_file(outf,country_str,country);
    write_to_file(outf,phone_str,phone);
    write_to_file(outf,fax_str,fax);
    write_to_file(outf,fido_str,fidonet+', '+internet);
    write_to_file(outf,birth_str,birthdate);
    write_to_file(outf,comment_str,comment);
  end;
  tmp:='';
  while length(tmp)<80 do tmp:=tmp+'-';
  tmp:=tmp+#$0d+#$0a;
  blockwrite(outf,tmp[1],length(tmp));
end;

{ Sub-Sub: Export to groupfile -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -}

procedure ex_groupfile(per:perinf_rec);
begin
  per.group:=0;
  blockwrite(outf,per,sizeof(perinf_rec));
end;

{ do-export - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -}

begin
  leave:=false;
  { Cannot export selected records if there are none }
  if (what=1) and (nofselect=0) then begin
    dsk_msgkey('There are no selected records.'); exit; end;

  { Init export }
  if where=0 then begin                                   { Ask Textfilename }
    setscr;
    nwindow(5,10,75,14,' Enter textfile name ',pos_hi+pos_le,col_wintitle,col_winattr,col_shadow);
    fillchar(outfname,sizeof(outfname),0);
    dspat('Filename:',7,12,col_winnorm);
    if input(17,12,outfname,[#30..#127],57,col_wininput,col_winnorm,nocap,pos_le)<>crsrcr then begin
      getscr; exit; end;
    getscr;
  end
  else if where=1 then begin { Ask Description and figure out PD-groupfilename }
    setscr;
    nwindow(5,10,51,14,' Enter groupfile-description ',pos_hi+pos_le,col_wintitle,col_winattr,col_shadow);
    fillchar(descr,sizeof(descr),0);
    descr:=cfg[curgroup];
    dspat('Description:',7,12,col_winnorm);
    if input(20,12,descr,[#30..#127],30,col_wininput,col_winnorm,nocap,pos_le)<>crsrcr then begin
      getscr; exit; end;
    getscr;
    max:='00';
    findfirst('pd.g??',anyfile,di);
    while doserror=0 do begin
      if copy(di.name,5,2)>max then max:=copy(di.name,5,2);
      findnext(di);
    end;
    inc(max[2]); if max[2]>'9' then begin max[2]:='0'; inc(max[1]); end;
    outfname:='pd.g'+max;
  end
  else if where=2 then begin                                         { dBase }
    dsk_msgkey('dBase-export is not implemented yet.'); exit; end;

  { Open or create outfile }
  assign(outf,exepath+outfname);
  {$i-} reset(outf,1); {$i+}
  if ioresult=0 then begin
  key:=dsk_msgkey(#0+chr(col_winnorm)+'File already exist. ('+
    #0+chr(col_winhi)+'A'#0+chr(col_winnorm)+')ppend, ('+
    #0+chr(col_winhi)+'O'#0+chr(col_winnorm)+')verwrite or '+
    #0+chr(col_winhi)+'<ESC>'#0+chr(col_winnorm)+' Quit.');
    case key of
      ord('o'),ord('O'):rewrite(outf,1);
      ord('a'),ord('A'):seek(outf,filesize(outf));
      crsresc:begin close(outf); exit; end;
    end;
  end else rewrite(outf,1);

  { Determine number of records to export }
  case what of
    0:num:=1;                                               { Current record }
    1:begin                                               { Selected records }
      num:=nofselect;
      prevgroup:=curgroup;
      curgroup:=group_all;                        { Fool 'getinfo'-procedure }
      j:=0;
    end;
    2:num:=persons;                                          { Current group }
  end;

  if where=1 then blockwrite(outf,descr,sizeof(descr));

  { 'Copy' record(s) }
  for i:=0 to pred(num) do begin
    { Read record }
    case what of
      0:begin                                               { Current record }
        getinfo(per,recnum,pernum);
      end;
      1:begin                                             { Selected records }
        repeat
          getinfo(per,recnum,j);
          inc(j);
        until per.group and 128=128;
      end;
      2:getinfo(per,recnum,i);                               { Current group }
    end;
    { Write record }
    case where of
      0:ex_textfile(per);                                         { Textfile }
      1:ex_groupfile(per);                                        { PD-Group }
      2:;                                                            { dBase }
    end;
  end;

  if what=1 then curgroup:=prevgroup;                     { Restore curgroup }
  close(outf);
  leave:=true;
end;

{ Main export - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -}

var
  key:word;
  ex_what,ex_where,
  cury,prey:byte;
  leave:boolean;
begin
  if persons=0 then exit;
  help_idx:=hlp_export;
  setscr;
  nwindow(5,2,35,8,' Export ',pos_hi+pos_mi,col_wintitle,col_winattr,col_shadow);
  if nofselect>0 then ex_what:=1
  else if curgroup=group_all then ex_what:=0
  else ex_what:=2;
  if ex_what=2 then ex_where:=1 else ex_where:=0;
  cury:=1; prey:=1;
  leave:=false;
  repeat
    filltext(' ',15,4,34,5,col_winnorm);
    dspmul(#0+chr(col_winhi)+'What?   '+#0+chr(col_winnorm)+ex_whatlist[ex_what],7,4);
    dspmul(#0+chr(col_winhi)+'Where?  '+#0+chr(col_winnorm)+ex_wherelist[ex_where],7,5);
    dspmul(#0+chr(col_winhi)+'Export! ',7,6);
    fillattr(7,3+prey,13,3+prey,col_winhi);
    fillattr(7,3+cury,13,3+cury,col_winselect);
    case cury of
      1:bar_comment(#0+chr(col_desktop)+'What to export. '+#0+chr(col_desktophi)+'Enter '+#0+chr(col_desktop)+'Change.');
      2:bar_comment(#0+chr(col_desktop)+'Where to export to. '+#0+chr(col_desktophi)+'Enter '+#0+chr(col_desktop)+'Change.');
      3:bar_comment(#0+chr(col_desktop)+'Export '+ex_whatlist[ex_what]+' to '+ex_wherelist[ex_where]+'.');
    end;
    key:=getekey;
    prey:=cury;
    case key of
      crsrup:if cury>1 then dec(cury);
      crsrdown:if cury<3 then inc(cury);
      crsrcr:begin
        case cury of
          1:changeitem(ex_what,'What',ex_whatlist);          { Change 'what' }
          2:changeitem(ex_where,'Where',ex_wherelist);      { Change 'where' }
          3:do_export(ex_what,ex_where,leave);                     { Export! }
        end;
      end;
      crsresc:leave:=true;
    end;
  until leave;
  getscr;
end;

{----------------------------------------------------------------------------}
{ Record PRINT related procedures and functions -----------------------------}
{----------------------------------------------------------------------------}

procedure printrec{(per:perinf_rec)};
var
  age:str8;
  nd,nm,ny,bd,bm,by,dow,c1,c2:word;
  i:byte;
begin
  fillchar(age,sizeof(age),0);
  getdate(ny,nm,nd,dow);
  val(copy(per.birthdate,1,2),bd,c1); c2:=c1;
  val(copy(per.birthdate,4,2),bm,c1); inc(c2,c1);
  val(copy(per.birthdate,7,2),by,c1); inc(c2,c1);
  by:=by+1900;
  if c2=0 then age:=' ('+tostr(nofyears(bd,bm,by,nd,nm,ny),0)+')';
  writeln(lst,pad(' ',prtmar_left+ni[group].pos),ni[group].name,' ',cfg[per.group and 127]);
  writeln(lst,pad(' ',prtmar_left+ni[name].pos),ni[name].name,' ',per.name);
  writeln(lst,pad(' ',prtmar_left+ni[address].pos),ni[address].name,' ',per.address);
  writeln(lst,pad(' ',prtmar_left+ni[zip].pos),ni[zip].name,' ',per.zip);
  writeln(lst,pad(' ',prtmar_left+ni[city].pos),ni[city].name,' ',per.city);
  writeln(lst,pad(' ',prtmar_left+ni[country].pos),ni[country].name,' ',per.country);
  writeln(lst,pad(' ',prtmar_left+ni[phone].pos),ni[phone].name,' ',per.phone);
  writeln(lst,pad(' ',prtmar_left+ni[fax].pos),ni[fax].name,' ',per.fax);
  writeln(lst,pad(' ',prtmar_left+ni[fidonet].pos),ni[fidonet].name,' ',per.fidonet);
  writeln(lst,pad(' ',prtmar_left+ni[internet].pos),ni[internet].name,' ',per.internet);
  writeln(lst,pad(' ',prtmar_left+ni[birthdate].pos),ni[birthdate].name,' ',per.birthdate+age);
  writeln(lst,pad(' ',prtmar_left+ni[comment].pos),ni[comment].name,' ',per.comment);
  writeln(lst); for i:=0 to 69 do write(lst,''); writeln(lst);
end;

procedure printline(per:perinf_rec);

function fit(s:str80; fld:byte):str80;
begin
  if length(s)>(fld-2) then fit:=copy(s,1,fld-2)+'> '
  else fit:=s+pad(' ',fld-length(s));
end;

begin
  write(lst,pad(' ',prtmar_left+ni[name].pos),' ',fit(per.name,30));
  with per do
    case info_idx of
      0:writeln(lst,cfg[group and 127]);
      1:writeln(lst,address);
      2:writeln(lst,fit(zip,10),fit(city,18),fit(country,20));
      3:writeln(lst,fit(phone,20),fit(fax,20));
      4:writeln(lst,fidonet);
      5:writeln(lst,internet);
      6:writeln(lst,birthdate);
      7:writeln(lst,comment);
    end;
end;

{----------------------------------------------------------------------------}

procedure print(pernum:word);
const
  pr_whatlist:array[0..2] of str20=(
    'Current record','Selected records','Current Group');
  pr_howlist:array[0..1] of str20=(
    'Short list','Long list (detailed)');

{- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - }

procedure changewhat(var what:byte);
var
  typeslist:sel_ptr;
  i:byte;
begin
  getmem(typeslist,3*succ(selectitemsize));
  for i:=0 to 2 do
    typeslist^[i]:=pr_whatlist[i];
  i:=select(25,10,45,14,'',' What ',1,3,0,typeslist);
  freemem(typeslist,3*succ(selectitemsize));
  if i>0 then what:=i-1;
end;

{- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - }

procedure changehow(var how:byte);
var
  typeslist:sel_ptr;
  i:byte;
begin
  getmem(typeslist,3*succ(selectitemsize));
  for i:=0 to 1 do
    typeslist^[i]:=pr_howlist[i];
  i:=select(25,10,50,13,'',' How ',1,2,0,typeslist);
  freemem(typeslist,3*succ(selectitemsize));
  if i>0 then how:=i-1;
end;

{- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - }

procedure do_print(what,how:byte; var leave:boolean);
var
  per:perinf_rec;
  i,j,num,recnum:word;
  prevgroup:byte;
begin
  leave:=false;
  { Cannot print selected records if there are none }
  if (what=1) and (nofselect=0) then begin
    dsk_msgkey('There are no selected records.'); exit; end;

  { Determine number of records to print }
  case what of
    0:num:=1;                                               { Current record }
    1:begin                                               { Selected records }
      num:=nofselect;
      prevgroup:=curgroup;
      curgroup:=group_all;                        { Fool 'getinfo'-procedure }
      j:=0;
    end;
    2:num:=persons;                                          { Current group }
  end;

  { 'Copy' record(s) }
  for i:=0 to pred(num) do begin
    { Read record }
    case what of
      0:begin                                               { Current record }
        getinfo(per,recnum,pernum);
      end;
      1:begin                                             { Selected records }
        repeat
          getinfo(per,recnum,j);
          inc(j);
        until per.group and 128=128;
      end;
      2:getinfo(per,recnum,i);                               { Current group }
    end;
    { Write record }
    case how of
      0:printline(per);                                              { Short }
      1:printrec(per);                                                { Long }
    end;
  end;

  if what=1 then curgroup:=prevgroup;                     { Restore curgroup }
  leave:=true;
end;

{- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - }

var
  key:word;
  pr_what,pr_how,
  cury,prey:byte;
  leave:boolean;
begin
  help_idx:=hlp_print;
  if persons=0 then exit;
  {$i-} writeln(lst,' '); {$i+}
  if ioresult<>0 then begin
    dsk_msgkey('Printer not online or not attached. Please check and try again.');
    exit;
  end;
  setscr;
  nwindow(25,2,55,8,' Print ',pos_hi+pos_mi,col_wintitle,col_winattr,col_shadow);
  if nofselect>0 then pr_what:=1
  else if curgroup=group_all then pr_what:=0
  else pr_what:=2;
  if pr_what=0 then pr_how:=1 else pr_how:=0;
  cury:=1; prey:=1;
  leave:=false;
  repeat
    filltext(' ',27,4,54,5,col_winnorm);
    dspmul(#0+chr(col_winhi)+'What?  '+#0+chr(col_winnorm)+pr_whatlist[pr_what],27,4);
    dspmul(#0+chr(col_winhi)+'How?   '+#0+chr(col_winnorm)+pr_howlist[pr_how],27,5);
    dspmul(#0+chr(col_winhi)+'Print! ',27,6);
    fillattr(27,3+prey,32,3+prey,col_winhi);
    fillattr(27,3+cury,32,3+cury,col_winselect);
    case cury of
      1:bar_comment(#0+chr(col_desktop)+'What to print. '+#0+chr(col_desktophi)+'Enter '+#0+chr(col_desktop)+'Change.');
      2:bar_comment(#0+chr(col_desktop)+'How to print. '+#0+chr(col_desktophi)+'Enter '+#0+chr(col_desktop)+'Change.');
      3:bar_comment(#0+chr(col_desktop)+'Print '+pr_whatlist[pr_what]+' as '+pr_howlist[pr_how]+'.');
    end;
    key:=getekey;
    prey:=cury;
    case key of
      crsrup:if cury>1 then dec(cury);
      crsrdown:if cury<3 then inc(cury);
      crsrcr:begin
        case cury of
          1:changewhat(pr_what);                             { Change 'what' }
          2:changehow(pr_how);                                { Change 'how' }
          3:do_print(pr_what,pr_how,leave);                         { Print! }
        end;
      end;
      crsresc:leave:=true;
    end;
  until leave;
  getscr;
end;

{----------------------------------------------------------------------------}
{ Backup routines -----------------------------------------------------------}
{----------------------------------------------------------------------------}

procedure backup;
var
  inf,outf:file;
  cbuf:pointer;
  key,size:word;
begin
  help_idx:=hlp_none;
  if ask_backup then begin
    key:=dsk_msgkey('The database has changed. Make backup'+
      #0+chr(col_winnorm)+' ('#0+chr(col_winhi)+'Y'#0+chr(col_winnorm)+'/'+
      #0+chr(col_winhi)+'n'#0+chr(col_winnorm)+')?');
    if not (key in [ord('y'),ord('Y'),crsrcr]) then exit;
  end;
  setscr;
  dsk_msg('Backuping...');
  getmem(cbuf,cbufsize);
  assign(inf,exepath+datfname);
  reset(inf,1);
  assign(outf,exepath+bckfname);
  rewrite(outf,1);
  repeat
    blockread(inf,cbuf^,cbufsize,size);
    {$i-} blockwrite(outf,cbuf^,size); {$i+}
    if ioresult<>0 then halt(5);
  until eof(inf) or (size<cbufsize);
  freemem(cbuf,cbufsize);
  close(inf);
  close(outf);
  getscr;
end;

procedure restorebackup;
var
  inf,outf:file;
  cbuf:pointer;
  key,size:word;
begin
  help_idx:=hlp_none;
  assign(inf,exepath+bckfname);
  {$i-} reset(inf,1); {$i+}
  if ioresult<>0 then begin
    dsk_msgkey('Nothing to restore...');
    exit;
  end;
  key:=dsk_msgkey('Are you sure you want to restore the backup?'+
    #0+chr(col_winnorm)+' ('#0+chr(col_winhi)+'Y'#0+chr(col_winnorm)+'/'+
    #0+chr(col_winhi)+'n'#0+chr(col_winnorm)+')?');
  if not (key in [ord('y'),ord('Y'),crsrcr]) then exit;
  setscr;
  dsk_msg('Restoring...');
  getmem(cbuf,cbufsize);
  {assign(inf,exepath+bckfname);
  reset(inf,1);}
  assign(outf,exepath+datfname);
  rewrite(outf,1);
  repeat
    blockread(inf,cbuf^,cbufsize,size);
    {$i-} blockwrite(outf,cbuf^,size); {$i+}
    if ioresult<>0 then halt(5);
  until eof(inf) or (size<cbufsize);
  freemem(cbuf,cbufsize);
  close(inf);
  close(outf);
  getscr;

  { Re-load lists... }
  loadlinked;
  loadlist;
  loadcfg;
end;

{----------------------------------------------------------------------------}
{ About ---------------------------------------------------------------------}
{----------------------------------------------------------------------------}

procedure about;
var i:word;
begin
  help_idx:=hlp_none;
  setscr;
  nwindow(10,5,70,18,' About/Information ',pos_hi+pos_mi,col_hlptitle,col_hlpattr,col_shadow);
  bar_comment('About Personal Database');
  dspat('Personal Database v1.1a',-1,7,col_hlphi);
  dspat('Written by Bas van Gaalen for Gfxfx3',-1,8,col_hlphi);
  dspat('Released in Spring ''97.',-1,10,col_hlptext);
  dspat('Number of records in database: '+tostr(total_persons,0),-1,12,col_hlptext);
  dspat('Number of records in current group: '+tostr(persons,0),-1,13,col_hlptext);
  dspat('Number of selected records: '+tostr(nofselect,0),-1,14,col_hlptext);
  i:=0;
  curper:=fstper;
  while curper<>nil do begin
    if curper^.rec.group=group_deleted then inc(i);
    curper:=curper^.next;
  end;
  dspat('Number of deleted records: '+tostr(i,0),-1,15,col_hlptext);
  i:=maxtypes;
  while (cfg[i]='') and (i>1) do dec(i);
  dspat('Number of active groups: '+tostr(i,0),-1,16,col_hlptext);
  waitkey(0);
  getscr;
end;

{----------------------------------------------------------------------------}
{ Global key-handler & related routines --------------------------------------------------------}
{----------------------------------------------------------------------------}

procedure helphandler; forward;

{ Trap keys -----------------------------------------------------------------}

{ Should return 'true' when a valid key from the handler was pressed }

function keyhandler(key:word):boolean;
begin
  keyhandler:=false;
  case key of
    {altj:dosshell;}
    crsrf1:begin
      helphandler;
      keyhandler:=true;
    end;
  end;
end;

{ Help ----------------------------------------------------------------------}

procedure helphandler;
var
  tmp:str60;
  help:hlp_ptr;
  i,key,helpstart,helpsize,cursor:word;
  py,y,helpwin,max:byte;
  leave:boolean;
begin
  if helpactive then exit;
  helpactive:=true;
  cursor:=getcursorshape;
  cursoroff;
  if not helppresent then begin
    dsk_msgkey('Helpfile not found in current directory. No help available!');
    setcursorshape(cursor);
    helpactive:=false;
    exit;
  end;
  if help_idx=hlp_none then begin
    dsk_msgkey('No help available for current function...');
    setcursorshape(cursor);
    helpactive:=false;
    exit;
  end;

  { Determine help-window size and draw window }
  if hlp_lines[help_idx]>rows-7 then helpwin:=rows-7 else helpwin:=hlp_lines[help_idx];
  setscr;
  nwindow(10,2,70,3+helpwin,' Help ',pos_hi+pos_mi,col_hlptitle,col_hlpattr,col_shadow);
  bar_comment('Help. Use cursorkeys to navigate.');

  { Determine size and start of help-text, reserve mem and load text }
  helpsize:=hlp_lines[help_idx]*succ(helpitemsize);       { Should be < 64kb }
  getmem(help,helpsize);
  helpstart:=hlp_start[help_idx];
  reset(hlpfile);
  while helpstart>0 do begin                         { Read to start of text }
    readln(hlpfile,tmp);
    dec(helpstart);
  end;
  for i:=0 to hlp_lines[help_idx] do                         { Read helptext }
    readln(hlpfile,help^[i]);

  max:=hlp_lines[help_idx]-helpwin;
  y:=0; py:=byte(not y); leave:=false;
  repeat
    if py<>y then begin
      for i:=0 to pred(helpwin) do
        fillx(help^[y+i],' ',12,3+i,58,col_hlptext);
      py:=y;
    end;
    if hlp_lines[help_idx]>helpwin then scrollbar(70,3,succ(y),helpwin,succ(max),col_hlpscroll);
    key:=getekey;
    case key of
      crsrup:if y>0 then dec(y);
      crsrdown:if y<max then inc(y);
      crsrhome:y:=0;
      crsrend:if hlp_lines[help_idx]>helpwin then y:=max else y:=0;
      crsrpgup:if y>helpwin then dec(y,helpwin) else y:=0;
      crsrpgdn:if (y+helpwin)<max then inc(y,helpwin) else y:=max;
      crsresc:leave:=true;
    end;
  until leave;
  setcursorshape(cursor);

  freemem(help,helpsize);
  getscr;
  helpactive:=false;
end;

{----------------------------------------------------------------------------}
{ Pull-down menu ------------------------------------------------------------}
{----------------------------------------------------------------------------}

{ Pull-down menu ------------------------------------------------------------}

procedure pulldownmenu(var menudat:menudattype;
                       var menutxt:menutxttype;
                       var menucom:menucomtype;
                       var menupos:menuarray;
                       var curmenu:byte;
                       menus:byte);
var
  menupre:menuarray;
  menuscr:pointer;
  escape:boolean;
  i,premenu:byte;
begin
  premenu:=0;
  for i:=1 to menus do menupre[i]:=1;
  escape:=false;
  repeat
    if premenu<>curmenu then begin
      if premenu<>0 then begin
        move(menuscr^,mem[v_vidseg:0],(menudat[premenu,3]+4)*v_columns*2);
        freemem(menuscr,(menudat[premenu,3]+4)*v_columns*2);
      end;
      getmem(menuscr,(menudat[curmenu,3]+4)*v_columns*2);
      move(mem[v_vidseg:0],menuscr^,(menudat[curmenu,3]+4)*v_columns*2);
      fillattr(menudat[curmenu,1]+1,0,menudat[curmenu,1]+menudat[curmenu,4],0,col_menuactive);
      if menudat[curmenu,3]<>0 then begin
        nwindow(menudat[curmenu,1],1,menudat[curmenu,1]+menudat[curmenu,2],menudat[curmenu,3]+2,
          '',0,0,col_menuattrib,col_shadow);
        for i:=1 to menudat[curmenu,3] do dspat(menutxt[curmenu,i],menudat[curmenu,1]+2,1+i,col_menutext);
      end;
      premenu:=curmenu;
    end;
    bar_comment(menucom[curmenu,menupos[curmenu]]);
    fillattr(menudat[curmenu,1]+1,menupre[curmenu]+1,menudat[curmenu,1]+menudat[curmenu,2]-1,menupre[curmenu]+1,col_menutext);
    fillattr(menudat[curmenu,1]+1,menupos[curmenu]+1,menudat[curmenu,1]+menudat[curmenu,2]-1,menupos[curmenu]+1,col_menuhigh);
    case getekey of
      crsrhome:begin
        menupre[curmenu]:=menupos[curmenu];
        menupos[curmenu]:=1;
      end;
      crsrend:begin
        menupre[curmenu]:=menupos[curmenu];
        menupos[curmenu]:=menudat[curmenu,3];
      end;
      crsrleft:begin
        premenu:=curmenu;
        if curmenu>1 then dec(curmenu) else curmenu:=menus;
      end;
      crsrright:begin
        premenu:=curmenu;
        if curmenu<menus then inc(curmenu) else curmenu:=1;
      end;
      crsrup:begin
        menupre[curmenu]:=menupos[curmenu];
        if menupos[curmenu]>1 then dec(menupos[curmenu]) else
          menupos[curmenu]:=menudat[curmenu,3];
      end;
      crsrdown:begin
        menupre[curmenu]:=menupos[curmenu];
        if menupos[curmenu]<menudat[curmenu,3] then inc(menupos[curmenu]) else
          menupos[curmenu]:=1;
      end;
      crsrcr:escape:=true;
      crsresc:begin
        escape:=true;
        curmenu:=0;
      end;
    end;
  until escape;
  move(menuscr^,mem[v_vidseg:0],(menudat[premenu,3]+4)*v_columns*2);
  freemem(menuscr,(menudat[premenu,3]+4)*v_columns*2);
end;

{ Pull-down menu ------------------------------------------------------------}

function pdmenu(var cury:byte; var basepos:word):byte;
const
  menus=4;
  menudat:menudattype=(                 { xpos, width, items, promptlength+2 }
    (0,23,11,6),
    (6,27,4,6),
    (12,20,3,8),
    (20,28,4,8));

  menutxt:menutxttype=(
    ('About/Info         A',
     'Import...          I',
     'Export...          X',
     'Edit Groups...     T',
     'Grep...            G',
     'Sort...            S',
     'Birthdates         B',
     'View           Enter',
     'Print              P',
     'Restore backup     R',
     'Quit             Esc',
     ''),
    ('Edit Record...         E',
     'Add Record...        Ins',
     'Delete Record...  Delete',
     'Pack Database...       C',
     '','','','','','','',''),
    ('Find...         F',
     'Search Next     N',
     'Goto Record...  J',
     '','','','','','','','',''),
    ('(De)Select Record   Space',
     'Deselect All            -',
     'Select All              +',
     'Invert Selection        V',
     '','','','','','','',''));

  menucom:menucomtype=(
    ('About Personal Database.',
     'Import record(s) from textfile or PD-groupfile.',
     'Export record, group or selection to textfile or PD-groupfile.',
     'Select/Edit group(s).',
     'Grep a phrase or term.',
     'Sort the database on a certain field.',
     'Show birthdates within 14 days.',
     'View current record.',
     'Print (not active).',
     'Restore backup',
     'Quit Personal Database.',
     ''),
    ('Edit current record.',
     'Add record.',
     'Delete current record.',
     'Pack deleted records.',
     '','','','','','','',''),
    ('Find a phrase or term in the database.',
     'Search Next',
     'Goto a recordnumber.',
     '','','','','','','','',''),
    ('Select or deselect current record.',
     'Deselect all records.',
     'Select all records.',
     'Invert all selections.',
     '','','','','','','',''));

var
  menupos:menuarray;
  i,curmenu:byte;
begin
  help_idx:=hlp_main;
  pdmenu:=byte(not 0); { Any non-zero value }
  setscr;
  filltext(' ',0,0,cols-1,0,col_desktop);
  dspat('  Misc  Edit  Search  Select',0,0,col_desktop);
  curmenu:=1;
  for i:=1 to menus do menupos[i]:=1;
  pulldownmenu(menudat,menutxt,menucom,menupos,curmenu,menus);
  case curmenu of
    1:case menupos[1] of
      1:about;
      2:_import;
      3:_export(pred(basepos));
      4:begin
        i:=curgroup;
        viewtypes;
        if i<>curgroup then begin
          basepos:=1;
          cury:=1;
        end;
      end;
      5:begin
        grep;
        basepos:=1;
        cury:=1;
      end;
      6:sort;
      7:birthdays(14);
      8:viewrec(pred(basepos));
      9:print(pred(basepos));
     10:restorebackup;
     11:pdmenu:=0;
    end;
    2:case menupos[2] of
      1:singleditrec(pred(basepos));
      2:insertrec;
      3:delrecord(pred(basepos));
      4:if pack then begin
        basepos:=1;
        cury:=1;
      end;
    end;
    3:case menupos[3] of
      1:begin
        searchpos:=0;
        find(basepos,cury,searchpos);
      end;
      2:find(basepos,cury,searchpos);
      3:gotorec(basepos,cury);
    end;
    4:case menupos[4] of
      1:begin
        tag(pred(basepos));
        if direction=down then begin
          if basepos<persons then begin
            inc(basepos);
            if cury<winsize then inc(cury);
          end;
        end
        else begin
          if basepos>1 then begin
            dec(basepos);
            if cury>1 then dec(cury);
          end;
        end;
      end;
      2:untagall;
      3:tagall;
      4:invtag;
    end;
  end;
  getscr;
end;

{----------------------------------------------------------------------------}
{ Main routines -------------------------------------------------------------}
{----------------------------------------------------------------------------}

{ Retrieve header -----------------------------------------------------------}

function getheader:str80;
var tmp:str80;
begin
  fillchar(tmp,sizeof(tmp),#0);
  tmp:='  #  Name'; tmp[0]:=#80;
  case info_idx of
    0:move(ni[group].name[1],tmp[39],ni[group].len);
    1:move(ni[address].name[1],tmp[39],ni[address].len);
    2:begin
      move(ni[zip].name[1],tmp[39],ni[zip].len);
      move(ni[city].name[1],tmp[49],ni[city].len);
      move(ni[country].name[1],tmp[67],ni[country].len);
    end;
    3:begin
      move(ni[phone].name[1],tmp[39],ni[phone].len);
      move(ni[fax].name[1],tmp[59],ni[fax].len);
    end;
    4:move(ni[fidonet].name[1],tmp[39],ni[fidonet].len);
    5:move(ni[internet].name[1],tmp[39],ni[internet].len);
    6:move(ni[birthdate].name[1],tmp[39],ni[birthdate].len);
    7:move(ni[comment].name[1],tmp[39],ni[comment].len);
  end;
  getheader:=tmp;
end;

{ Retrieve barpos ------------------------------------------------------------}

function getpos(nr,max:word):str20;
var tmp:str20;
begin
  fillchar(tmp,sizeof(tmp),0);
  if persons=0 then tmp:=#0+chr(col_desktophi)+'Empty  '
  else tmp:=#0+chr(col_desktophi)+tostr(nr,3)+
            #0+chr(col_desktop)+'/'+
            #0+chr(col_desktophi)+tostr(max,3);
  tmp[0]:=#13;
  getpos:=tmp;
end;

{ Retrieve type --------------------------------------------------------------}

function gettype:str30;
var tmp:str30;
begin
  fillchar(tmp,sizeof(tmp),#0);
  tmp:=cfg[curgroup];
  if curgroup=group_grep then tmp:=tmp+' ('+copy(grepstr,1,30)+')';
  tmp[0]:=#30;
  gettype:=tmp;
end;

{ Dump mainlist to screen ---------------------------------------------------}

procedure dumpscreen(start:word);
var i,y:byte;
begin
  i:=start; y:=1;
  if (persons>0) or (mainlist<>nil) then begin
    while (i<persons) and (y<rows-2) do begin
      if mainlist^[i][1]='d' then
        fillx(tostr(succ(i),3)+'  '+copy(mainlist^[i],2,length(mainlist^[i])-1),' ',0,y,cols-1,col_list_del)
      else if mainlist^[i][1]='s' then
        fillx(tostr(succ(i),3)+'  '+copy(mainlist^[i],2,length(mainlist^[i])-1),' ',0,y,cols-1,col_list_sel)
      else
        fillx(tostr(succ(i),3)+' '+mainlist^[i],' ',0,y,cols-1,col_list_norm);
      inc(y);
      inc(i);
    end;
  end;
  if y<rows-2 then filltext(' ',0,y,cols-2,rows-3,0);
end;

{ Main ----------------------------------------------------------------------}

procedure main;
var
  basepos,prevbase,key:word;
  prey,cury,prevgroup,precol,barcol:byte;
  leave,header,us,first:boolean;
begin
  clrscr;
  basepos:=1; prevbase:=1; prey:=1; cury:=1;
  filltext(' ',0,rows-2,pred(cols),rows-1,col_desktop);
  bar_comment(#0+chr(col_desktop)+'Keys: '+
              #0+chr(col_desktophi)+'F1 '+#0+chr(col_desktop)+'Help   '+
              #0+chr(col_desktophi)+'F10 '+#0+chr(col_desktop)+'Menu');
  dspat('Group:',1,rows-2,col_desktop);
  dspat(' Pos:',48,rows-2,col_desktop);
  dspat(' Time:',63,rows-2,col_desktop);
  leave:=false; header:=true; us:=true; first:=true;
  repeat
    if header then begin
      if persons>0 then fillx(getheader,' ',0,0,cols,col_desktop)
      else fillx(' Database is empty...',' ',0,0,cols,col_desktophi);
      header:=false;
    end;
    if persons>0 then
      while basepos>persons do begin
        dec(basepos);
        dec(cury);
      end;
    if us then begin
      winsize:=rows-3;
      dumpscreen(basepos-cury);
    end;
    if persons>0 then begin
      case mainlist^[pred(prevbase)][1] of
        #0:precol:=col_list_norm;
        's':precol:=col_list_sel;
        'd':precol:=col_list_del;
      end;
      case mainlist^[pred(basepos)][1] of
        #0:barcol:=col_list_normhi;
        's':barcol:=col_list_selhi;
        'd':barcol:=col_list_delhi;
      end;
      if not us then fillattr(0,prey,cols-2,prey,precol);
      fillattr(0,cury,cols-2,cury,barcol);
      scrollbar(pred(cols),1,basepos,winsize,persons,col_listbar);
    end;
    us:=false;
    dspat(gettype,8,rows-2,col_desktophi);
    dspmul(getpos(basepos,persons),55,rows-2);
    if first then about;
    help_idx:=hlp_main;
    key:=getekey;
    case key of
      crsrup:begin
        prey:=cury; prevbase:=basepos;
        if basepos>1 then begin
          direction:=up;
          dec(basepos);
          if cury>1 then dec(cury) else us:=true;
        end;
      end;
      crsrdown:begin
        prey:=cury; prevbase:=basepos;
        if basepos<persons then begin
          direction:=down;
          inc(basepos);
          if cury<winsize then inc(cury) else us:=true;
        end;
      end;
      crsrhome:if basepos>1 then begin
        direction:=down;
        prey:=cury; prevbase:=basepos;
        prevbase:=cury;
        cury:=1;
        basepos:=1;
        us:=true;
      end;
      crsrend:if basepos<persons then begin
        direction:=down;
        prey:=cury;
        prevbase:=persons-(rows-3-cury);
        basepos:=persons;
        if persons<winsize then cury:=persons
        else cury:=winsize;
        us:=true;
      end;
      crsrpgup:begin
        direction:=up;
        prey:=cury;
        prevbase:=basepos;
        if cury>1 then begin
          if basepos-cury>0 then dec(basepos,pred(cury))
          else basepos:=1;
          cury:=1;
        end
        else if basepos>1 then begin
          if basepos>winsize then dec(basepos,winsize)
          else basepos:=1;
          us:=true;
        end;
      end;
      crsrpgdn:begin
        direction:=down;
        prey:=cury;
        prevbase:=basepos;
        if cury<winsize then begin
          if basepos<>persons then begin
            if persons<winsize then begin cury:=persons; basepos:=persons; end
            else begin inc(basepos,winsize-cury); cury:=winsize; end;
          end;
        end
        else if basepos<persons then begin
          if basepos<(persons-winsize) then inc(basepos,winsize) else basepos:=persons;
          us:=true;
        end;
      end;

      crsrleft:if info_idx>0 then begin
        dec(info_idx);
        loadlist;
        header:=true;
        us:=true;
      end;
      crsrright:if info_idx<7 then begin
        inc(info_idx);
        loadlist;
        header:=true;
        us:=true;
      end;

      crsrf10:begin
        prey:=cury;
        prevbase:=basepos;
        leave:=pdmenu(cury,basepos)=0;
        header:=true;
        us:=true;
      end;

      ord('a'),ord('A'):about;

      ord('b'),ord('B'):birthdays(lookahead);

      ord('c'),ord('C'):if pack then begin
        us:=true;
        header:=true;
        basepos:=1;
        prey:=cury;
        cury:=1;
      end;

      ord('e'),ord('E'):begin
        us:=singleditrec(pred(basepos));
        header:=us;
      end;

      ord('f'),ord('F'),ord('n'),ord('N'):begin
        prey:=cury; prevbase:=basepos;
        if key in [ord('f'),ord('F')] then searchpos:=0;
        us:=find(basepos,cury,searchpos);
      end;

      ord('g'),ord('G'):begin
        grep;
        basepos:=1;
        prey:=cury;
        cury:=1;
        us:=true;
        header:=true;
      end;

      ord('i'),ord('I'):begin
        _import;
        us:=true;
        header:=true;
      end;

      ord('j'),ord('J'):begin
        prey:=cury;
        us:=gotorec(basepos,cury);
      end;

      ord('p'),ord('P'):print(pred(basepos));

      ord('r'),ord('R'):begin
        restorebackup;
        basepos:=1;
        prey:=cury;
        cury:=1;
        header:=true;
        us:=true;
      end;

      ord('s'),ord('S'):begin
        sort;
        us:=true;
      end;

      ord('t'),ord('T'):begin
        prevgroup:=curgroup;
        viewtypes;
        if prevgroup<>curgroup then begin
          basepos:=1;
          prey:=cury;
          cury:=1;
          header:=true;
          us:=true;
        end;
      end;

      ord('v'),ord('V'):begin
        invtag;
        us:=true;
      end;

      ord('x'),ord('X'):begin
        _export(pred(basepos));
        us:=true;
      end;

      crsrdel:begin
        delrecord(pred(basepos));
        header:=true;
        us:=true;
      end;

      crsrins:begin
        insertrec;
        header:=true;
        us:=true;
      end;

      crsrcr:begin
        us:=viewrec(pred(basepos));
        header:=us;
      end;

      ord(' '):begin
        tag(pred(basepos));
        us:=true;
        prey:=cury; prevbase:=basepos;
        if direction=down then begin
          if basepos<persons then begin
            inc(basepos);
            if cury<winsize then inc(cury);
          end;
        end
        else begin
          if basepos>1 then begin
            dec(basepos);
            if cury>1 then dec(cury);
          end;
        end;
      end;

      ord('-'):begin
        untagall;
        us:=true;
      end;

      ord('+'):begin
        tagall;
        us:=true;
      end;

      crsresc:leave:=true;
    end;

    first:=false;
  until leave;
end;

{----------------------------------------------------------------------------}

begin
  initialize;
  main;
end.
