/*
        JiNX Sound System V1.0f - C Header File (Platform independant)
        < Contains only functions which should not be visible to a JSS user >

        (C) 1997-98, Mark Hodson (Bulk Sound System Code, IT Player, Drivers)
                     Saxon Druce (Windows Port)
                     Chris Bevan (Sound Output Code Prototype)
                     Jeffrey Lim (IT2.14+ Sample Compression Code)
*/

#include "jss_comp.h"

// InitSoundSystemCommon: Initialises the sound system for the desired type/frequency/channels.
// CloseSoundSystemCommon: Disables mixing and frees memory used by the sound system.

int  JiNX_SS_InitSoundSystemCommon(int type, int reverse, int frequency, int num_vcs);
void JiNX_SS_CloseSoundSystemCommon(void);

// TimeAcceptor: An ASM function which accepts an accurate sound system floating point time
// passed on the stack valid at the point in time it is called (assuming perfectly regular
// GenerateData calls, such as those driven by a soundcard interrupt).  By default this is
// NULL, and so leave it be if you have no use for it.

extern void * JSS_VAR JiNX_SS_TimeAcceptor ;

