/*
        JiNX Sound System V1.0f - C Header File Structures Suppliment

        (C) 1997-98, Mark Hodson (Bulk Sound System Code, IT Player, Drivers)
                     Saxon Druce (Windows Port)
                     Chris Bevan (Sound Output Code Prototype)
                     Jeffrey Lim (IT2.14+ Sample Compression Code)
*/

// IT Structures // File Structures /////////////////////////////////////////

#ifndef __ITSTRUCT_H
#define __ITSTRUCT_H

#ifdef _MSC_VER
	#define _Packed /* */
	#pragma pack (push,1)
#endif

typedef _Packed struct {

        unsigned char	ID_string[4];
        unsigned char	Song_Name[28];

        short			OrdNum, InsNum, SmpNum, PatNum;
        short			CrWV, CmWV;
        short			Flags, Special;

        unsigned char	GV,MV,IS,IT;
        unsigned char	Sep,Padding;

        short			MsgLgth;
        int				Message_Offset, Reserved;

        unsigned char	ChnlPan[64];
        unsigned char	ChnlVol[64];

} IT_header;


typedef _Packed struct {

        unsigned char	ID_string[4];
        unsigned char	DOS_FileName[12];

        unsigned char	Padding1,NNA,DCT,DCA;

        short			FadeOut;

        signed char		PPS;

        unsigned char	PPC,GbV,DfP,RV,RP;

        int				Padding2;

        unsigned char	Instrument_Name[28];

        unsigned char	MCh,MPr;
        short			MIDIBnk;

        _Packed struct {
                unsigned char    note;
                unsigned char    sample;
               } NS_table[120];


        _Packed struct {
                unsigned char    Flg,Num,LpB,LpE,SLB,SLE;

                struct {
                        signed char value;
                        short   tick;
                       } node[25];

                unsigned char    Padding;
               } envelope[3];

} IT_instrument;


typedef _Packed struct {

        unsigned char	ID_string[4];
        unsigned char	DOS_FileName[12];

        unsigned char	Padding1,GvL,Flg,Vol;

        unsigned char	Sample_Name[26];

        unsigned char	Cvt,DfP;

        int				length,loop_begin,loop_end,C5Speed;
        int				susloop_begin, susloop_end,sample_offset;

        unsigned char	ViS,ViD,ViR,ViT;

} IT_sample;


typedef _Packed struct {

        unsigned short	Length,Rows;

        int     Padding;

} IT_pattern;


// IT Structures // In-Memory Structures (JTM) //////////////////////////////

typedef _Packed struct {                        // Pattern      8 bytes

        int				number_of_rows;
        unsigned char	*pattern_data_ptr;

} JTM_pattern;


typedef _Packed struct {                        // Sample       64 bytes

        int     global_volume;
        int     default_volume;
        int     default_pan;

        int     sample_flags;
        int     C5_speed;

        int     number_of_samples;
        unsigned char    *sample_data_ptr;

        int     loop_start;
        int     loop_end;
        int     sus_loop_start;
        int     sus_loop_end;

        int     vibrato_speed;
        int     vibrato_depth;
        int     vibrato_rate;
        int     vibrato_waveform;

        int     rate_compensation;

} JTM_sample;


typedef _Packed struct {                        // Instrument   2048 bytes

        int     global_volume;
        int     random_volume;
        int     fadeout_speed;

        int     default_pan;
        int     random_pan;
        int     pitch_pan_separation;
        int     pitch_pan_centre;

        int     NNA,DCT,DCA;

        _Packed struct {
                int     flags;

                int     sus_start_tick;
                int     sus_end_tick;
                int     start_tick;
                int     end_tick;
                int     last_tick;

                signed char *tick_results;
        } envelope[3];

        _Packed struct {
                JTM_sample *sample_ptr;
                int  note_frequency;
        } SFVP_table[120];

        int     reserved[241];

} JTM_instrument;


typedef _Packed struct {                        // Virtual Chn  512 bytes

        int     active_status;                  // General Info
        int     phase;
        int     play_delay;

        void    *tracker;

        JTM_instrument  *instrument;
        JTM_sample      *sample;

        int     note;
        int     zero_volume_ticks;
        int     active_ticks;


        int     master_volume;                  // Instrument Info
        int     master_pan;

        int     note_volume;
        int     note_pan;
        int     note_frequency;

        int     alter_volume;
        int     alter_pan;
        int     alter_frequency;
        int     linear_alter_frequency;

        int     fade_volume;
        int     fade_speed;

        int     final_volume;
        int     final_pan;
        int     final_frequency;

        int     final_vol_left;
        int     final_vol_right;

        int     NNA,DCT,DCA;

        _Packed struct {
                int     flags;

                int     sus_start_tick;
                int     sus_end_tick;
                int     start_tick;
                int     end_tick;
                int     last_tick;

                int     tick_position;
                int     tick_result;

                signed char *tick_results;
        } envelope[3];


        int     sample_flags;                   // Sample Info

        int     number_of_samples;
        unsigned char    *sample_data_ptr;

        int     loop_start;
        int     loop_end;
        int     sus_loop_start;
        int     sus_loop_end;

        int     rate_compensation;

        int     sample_position_frac;
        int     sample_position;
        int     sample_increment_frac;
        int     sample_increment;
        int     sample_direction;

        int     vibrato_speed;
        int     vibrato_depth;
        int     vibrato_rate;
        int     vibrato_waveform;

        int     vibrato_position;
        int     vibrato_res_depth;
        int     vibrato_res_count;

        int     reserved[53];

} JTM_virtual;


typedef _Packed struct JTM_tracker_struct {     // Tracker Chn  128 bytes

        JTM_virtual *virtual;

        int     channel_vol_orig;
        int     channel_pan_orig;
        int     channel_vol;
        int     channel_pan;

        int     pattern_mask;

        int     last_note;
        int     last_instrument;
        int     last_volpan;
        int     last_FX_type;
        int     last_FX_operand;

        int     last_note_volume;
        int     last_note_pan;

        int     VP_type;
        int     VP_operand;
        void    *VP_update;

        int     VPmem_ABCD;

        int     FX_type;
        int     FX_operand;
        unsigned char    *FX_update;

        int     FXmem_DKL;
        int     FXmem_EF;
        int     FXmem_G;
        int     FXmem_HU;
        int     FXmem_I;
        int     FXmem_J;
        int     FXmem_N;
        int     FXmem_O;
        int     FXmem_P;
        int     FXmem_Q;
        int     FXmem_R;
        int     FXmem_S;
        int     FXmem_T;
        int     FXmem_W;
        int     FXmem_Y;

        int     FXworkspace_G_frequency;
        int     FXworkspace_G_direction;
        int     FXworkspace_HU;
        int     FXworkspace_I;
        int     FXworkspace_J;
        int     FXworkspace_Q;
        int     FXworkspace_SBx_order;
        int     FXworkspace_SBx_row;
        int     FXworkspace_SBx_count;
        int     FXworkspace_SCx_count;
        int     FXworkspace_SDx_note;
        int     FXworkspace_SDx_inst;
        int     FXworkspace_SDx_volpan;
        int     FXworkspace_SDx_count;
        int     FXworkspace_Y;
        int     FXworkspace_Filter;

        int     ve_speed;
        int     ve_depth;
        int     ve_waveform;
        int     ve_position;

        int     te_speed;
        int     te_depth;
        int     te_waveform;
        int     te_position;

        int     pe_speed;
        int     pe_depth;
        int     pe_waveform;
        int     pe_position;

        int     reserved[1];

} JTM_tracker;


typedef _Packed struct {                        // Module       96 bytes

        int     global_volume;
        int     mixing_volume;
        int     initial_speed;
        int     initial_tempo;

        int     last_virtual_channel;

        int     current_global_volume;
        int     current_mixing_volume;

        int     current_order;
        int     current_pattern;
        int     current_row;
        int     current_tick;

        int     current_speed;
        int     current_tempo;

        int     current_num_rows;
        unsigned char    *current_pat_ptr;

        int     next_order;
        int     next_first_row;

        int     module_delay;

        JTM_tracker     *tracker_channel;
        JTM_virtual     *virtual_channel;

        unsigned char            *order_set;
        JTM_pattern     *pattern_set;
        JTM_instrument  *instrument_set;
        JTM_sample      *sample_set;

        int     number_of_orders;
        int     number_of_patterns;
        int     number_of_instruments;
        int     number_of_samples;

} JTM_module;

#if _MSC_VER
	#pragma pack (pop)
#endif

#endif // __ITSTRUCT_H

