/*
        JiNX Sound System V1.0e - C Header File Device Suppliment

        (C) 1997-99, Mark Hodson (Bulk Sound System Code, IT Player, Drivers)
                     Chris Bevan (Sound Output Code Prototype)
                     Jeffrey Lim (IT2.14+ Sample Compression Code)
*/

// NumberOfDevices - Range of device numbers supported by the JSS, number of soundcards.
// DeviceDescription - A string describing the device (soundcard).

int    JiNX_SS_ReturnNumberOfDevices(void);
char * JiNX_SS_DeviceDescription(int device);

// DetectDevice - Returns a device number if autodetect is successful, else -1.
// GetDevice??? - Returns additional information gathered by autodetection, or
//                -1 if the information was unobtainable.

int JiNX_SS_DetectDevice(void);

int JiNX_SS_GetDevicePort(void);
int JiNX_SS_GetDeviceIRQ(void);
int JiNX_SS_GetDeviceDMA(void);
int JiNX_SS_GetDeviceDMAHigh(void);

// SetDevice - Sets a device to be used by the JiNX Sound System.

int JiNX_SS_SetDevice(int device, int port, int irq, int dma, int dma_high);

