Program zGetInfo;
                                                                                {
 ## zGetInfo v1.00 by Brian Zhou
 ## Text file parsing routines for Borland Pascal v7
 ## (C)opyright 1998 by Zoob Software.  All Rights Reserved.
 ## 100% Pure code by Brian Zhou (zoob@most-wanted.com)
 ## Feel free to improve on this code.  Email me your changes.
 ## Distribution of modified copies is not permitted.
 ###############################################################################

 Please send any bug reports, comments, or feedback to me:
 zoob@most-wanted.com

 Almost no code is commented, but if someone really needs commenting, I can
 comment the code in the next release.

 Copyright:
 Free for non-commercial use, only for people not affiliated with Microsoft
 in any way.  You may change the code below for your own use, but do not
 distribute modified versions.  If you think you have made an improvement,
 please contact me at the address shown above.
 You may not remove or modify these comments from the beginning up to "***"!

 Disclaimer:
 Use this code at your own risk!
 This code comes as "as-is", and comes with NO WARRANTY whatsoever.
 I guarantee that this code will only take up space.
 
 Files included in archive ZO-ZNFO2.ZIP:

    FILE_ID .DIZ  <-- BBS description file
    ZGETINFO.CFG  <-- Sample Configuration text
    ZGETINFO.PAS  <-- FOSSIL v5 unit

 History:

   v1.00 : >First public release.

 ***
 }


Uses CRT,DOS;

Const
     Version = '1.00';

Var
   T : Text;
   S : String[79];
   Line : Byte;

  (* Writes a new file for information gathering *)
  Procedure WriteNew;
  Begin
    ReWrite(T);
    WriteLn(T,'# zGetInfo v1.00');
    WriteLn(T,'#');
    WriteLn(T,'#');
    WriteLn(T);
    WriteLn(T,'First');
    WriteLn(T,'Second');
    WriteLn(T,'Third');
    Close(T);
    Reset(T);
  End;

  (*
   * Reads one line of text.  If the line starts with a semicolon or is
   * blank, it returns a none.
   *)
  Function ReadInfo(Var T:Text):String;
  Var S:String;
  Begin
    ReadLn(T,S);
    If ((S[1] = '#') or (S='')) Then Repeat
                                     ReadLn(T,S);
                                   Until (((S[1]<>'#') and (S<>'')) or EOF(T));
    If ((EOF(T)) And ((S[1]='#') or (S=''))) then ReadInfo:='None' Else ReadInfo:=S;
  End;


  (* Displays help message if no parameters are detected *)
  Procedure Help;
  Begin
    WriteLn('zGetInfo ignores lines preceeding with a number sign (#) or a blank line');
    WriteLn;
    WriteLn('Run '+paramStr(0)+' <FILENAME.EXT>');
    Halt(1);
  End;


(* Main Program *)
Begin
  WriteLn('zGetInfo v'+Version+' by Brian Zhou');
  WriteLn('---');
  If ParamCount=0 Then Help;
  Assign(T,ParamStr(1));
  {$I-} Reset(T); {$I+}
  If IOResult<>0 Then WriteNew;
  For Line := 1 to 255 Do Begin
     S := ReadInfo(T);
     WriteLn(S);
     If EOF(T) Then Exit;
  End;
End.
