unit comFos;            { FOSSIL Communications Object }

{
     comFos - Copyright 1998 by Brian Zhou
     You are free to use this code in your programs, however
     it may not be included in Source/TPU function libraries
     without my permission.

     You may reach me at zoob@darktech.org
}

interface

uses comAbs;

var
  oport : word;

type

  oFosComm = object(oAbsComm)
    constructor init;
    function    install(cport,baud : word) : boolean; virtual;
    procedure   deinstall;                      virtual;
    procedure   send(c : char);                 virtual;
    function    receive : char;                 virtual;
    function    waiting : boolean;              virtual;
    function    carrier : boolean;              virtual;
    procedure   fRx;                            virtual;
    procedure   fTx;                            virtual;
    procedure   pRx;                            virtual;
    procedure   pTx;                            virtual;
    procedure   dtr(state : boolean);           virtual;
    destructor  done;
  end;
  pFosComm = ^oFosComm;

implementation

uses Dos;

var r:registers;

{ %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%[ oFosComm methods ]%%% }

{ ::: construct object }
constructor oFosComm.init;
  begin
  end;

{ ::: driver installer }
function oFosComm.install(cport,baud : word) : boolean;
  begin
    Dec(cport);
    R.Dx := cPort;
    oPort := R.Dx;
    R.Ah := $4;
    Intr($14, R);
    Install := (R.Ax = $1954);

    Case Baud Div 100 Of
      3 : R.Al := $43;
      6 : R.Al := $63;
      12: R.Al := $83;
      24: R.Al := $A3;
      48: R.Al := $C3;
      96: R.Al := $E3;
     192: R.Al := $03;
     384: R.Al := $23;
     Else R.Al := $23;
    End;
    R.Ah := $0;
    R.Dx := oPort;
    Intr($14, R);
  end;

{ ::: driver deinstaller }
procedure oFosComm.Deinstall;
  begin
    r.ah := $05;
    r.dx := oport;
    intr($14,r);
  end;

{ ::: transmit character }
procedure oFosComm.send(c : char);
  Begin
    R.Ah := $01;
    R.Dx := oPort;
    R.Al := Ord(C);
    Intr($14, R);
  End;

{ ::: receive character }
function oFosComm.receive : char;
  begin
    R.Ah := $02;
    R.Dx := oPort;
    Intr($14, R);
    Receive := Chr(R.Al);
  end;

{ ::: characters waiting to be received? }
function oFosComm.waiting : boolean;
  begin
    r.ah:=$03;
    r.dx:=oport;
    intr($14,r);
    waiting := r.ah and $01 = $01
  end;

{ ::: carrier present? }
function oFosComm.carrier : boolean;
var d : Byte;
  begin
    asm
      mov ah,03h
      mov dx,oport
      int 14h
      mov d,al
    end;
    carrier := (d and $80) = $80;
  end;

{ ::: flush receive buffer }
procedure oFosComm.fRx; assembler;
  asm
    mov ah, $0A
    mov dx, oPort
    int $14
  end;

{ ::: flush transmit buffer }
procedure oFosComm.fTx; assembler;
  asm
    mov ah, $08
    mov dx, oPort
    int $14
  end;

{ ::: purge receive buffer }
procedure oFosComm.pRx; assembler;
  asm
    mov ah, $0A
    mov dx, oPort
    int $14
  end;

{ ::: purge transmit buffer }
procedure oFosComm.pTx; assembler;
  asm
    mov ah, $09
    mov dx, oPort
    int $14
  end;

{ ::: toggle dtr }
procedure oFosComm.dtr(state : boolean); assembler;
  asm
    mov ah, $6
    mov al, state
    mov dx, oPort
    int $14
  end;

{ ::: destruct object }
destructor oFosComm.done;
  begin
  end;

end.
