
/****************************************************************************

                 __,,---,__ _    __,,--, __ _
                 |  ___/---,,__,-|  ___//___,,----,______,,---,__ __ _
       _ __ _____|  \_   _  \_   | \\_  __  \_  __   (___)      `\ tdmHz
           \\_  __  _|   ____|_ \_/  |  \|   |  \|   | `\_   |__//_
            _|  \|  \__  |/  _// |   |_  |  _|   |  _|  _|   |'  _/'' '
     ==== = \\     ___// '  _|   |____/' ' \\____| \\___\__      | = ====
   - -- ---- \____// \_____/__,,-'   \\__,,---'  |____/   \\_,,--' --- -- -

   dEMONIC pRODUCTIONS z024!
   ddtext v1

*****************************************************************************/

#include <string.h>
#include <stdio.h>
#include <curses.h>
#include <ctype.h>
#include <stdlib.h>
#include "macros.h"

#define PROGNAME "ddtext"
#define center(y,s)  mvaddstr(y,(80-strlen(s))/2,s)

#define clrbuf(x,y) y=0;
#define addbuf(x,y,c) x[y++]=c;
#define pbuf(x,y) for(temp=0;temp<y;temp++)if(xp<len){xp++; \
			if(hide!=HIDE_TEST) addmchar(x[temp]);} y=0;

#define TAB_SIZE 8

#define HIDE_NONE 0
#define HIDE_NOCOL 2
#define HIDE_COL 1
#define HIDE_TEST 4
#define HIDE_MACROS 8

#define ALLOW_NUM 1
#define ALLOW_CHAR 2
#define ALLOW_ALL 4
#define ALLOW_TOUP 8

#define MAXCHARS 355

char ansi_codes[]="mHJ";

char leer_block[]={176,176,176,0};
char half_block[]={177,177,177,0};
char full_block[]={219,219,219,0};

void drawit();

//-------------------------------------------------------

#define COPY1 "DayDream Text Editor version 1.0"
#define COPY2 "coded by 2mad^Gilden in 1997, fixed in 1999 by pandur, 2024 by esc"
#define COPY3 "(C)opyrights by Gilden DayDream/Linux Division (private BETA)"

#define HELP1 " <F2> Save             <F7> Goto Index     <F10> Change Color"
#define HELP2 " <F3> Quit (not Save)  <F8> Restore Orig.  <F11> Add Macro   " 
#define HELP3 " <F4> Quit and Save    <F9> Color Mode    <CURSOR> Move        "  
#define HELP4 " <F5> Find Text        <F12> Insert ESC      <INS> Insertmode  "
#define HELP5 " <F6> Find orig. Text                                          "

//--------------------------------------------------------

int test_bg;
int test_fg;
int test_bo;
int test_bl;

int changed=0;
int nlines;
int lines;
int olines;
int tmpline;

int hide=0;				// Actual Hide-mode
char *orig_file;
int temp;
char search_string[80];

int win=0;

int curline=0;
int curdx=0;
int curx=0;
int curlx=0;
int insert=1;
int fg,bg,bl,bo;
int msg=0;

FILE *in;			// File to edit
unsigned char *buffer;		// Edit buffer
unsigned char *obuffer;		// Original Buffer

char hidemodes[3][10]={"normal","color","hidden"};

//---------------------------------------------------------

char colors[]={COLOR_WHITE,COLOR_BLUE,COLOR_GREEN,COLOR_CYAN,COLOR_RED,
		COLOR_MAGENTA,COLOR_YELLOW,COLOR_BLACK};
char bcolors[]={COLOR_BLACK,COLOR_BLUE,COLOR_GREEN,COLOR_CYAN,COLOR_RED,
		COLOR_MAGENTA,COLOR_YELLOW,COLOR_WHITE};



void ssetcol(int x)
{
int bo,bl,fg,bg;
bg=(x&112)>>4;
fg=x&7;
bo=x&8;
bl=x&128;
if(fg==0) fg=7;
else if (fg==7) fg=0;
attrset(COLOR_PAIR(fg+bg*8)|(bo?A_BOLD:0)|(bl?A_BLINK:0));
}

void init_colors()
{
int bg,fg;
start_color();
for(bg=0;bg<8;bg++)
	for(fg=0;fg<8;fg++)
		if((fg+bg*8)>0) init_pair(fg+bg*8,colors[fg],bcolors[bg]);
}



void mborder(int x1,int y1,int x2,int y2,int col)
{
int i;
ssetcol(col);
for(i=0;i<x2-x1;i++) 
	{
	mvaddch(y1,x1+i,ACS_HLINE);
	mvaddch(y2,x1+i,ACS_HLINE);
	}
for(i=0;i<y2-y1;i++)
	{
	mvaddch(y1+i,x1,ACS_VLINE);
	mvaddch(y1+i,x2,ACS_VLINE);
	}
mvaddch(y1,x1,ACS_ULCORNER);
mvaddch(y1,x2,ACS_URCORNER);
mvaddch(y2,x1,ACS_LLCORNER);
mvaddch(y2,x2,ACS_LRCORNER);
}

int strllen(char *s)
{
int i;
for(i=0;s[i]!=0;i++) ;
return(i);
}

void stripansi(char *s,char *d)
{
int p=0,t=0;
int i=0;
int a;
while(s[p])
	{
	a=0;
	if(s[p]=='\e'&&s[p+1]=='[')
		{
		for(i=2;isdigit(s[p+i])||(s[p+i]==';');i++);
		if(isalpha(s[p+i]))
			{
			a=1;
			p+=i+1;
			}
		}
	if(!a)
		d[t++]=toupper(s[p++]);
	}
}

void addmchar(char c)
{
if(c=='\n'||c=='\r') c=' ';
    if(c=='\e')c=174;
    addch((unsigned char)c);
/* waddch(win,(unsigned char)c); */
}

void mvaddcstr(int y,int x,char *s, int n)
{
int i,q,o;
char c;
move(y,x);
q=strlen(s)-1;
refresh();
for(o=0,i=0;o<n;i++,o++) 
	{
	if(q<i) addch(' ');
	else
		{
		c=s[i];
		addmchar(c);
		}
	}
}

//****************************************************//

void ansi_color(int *p,int c,int h)
{
int colors[]={0,4,2,6,1,5,3,7};
int i;
for(i=0;i<c;i++)
	{
	if(p[i]>=40) bg=colors[p[i]-40];
	else if(p[i]>=30&&p[i]<38) fg=colors[p[i]-30];
	else if(p[i]==1) bo=1;
	else if(p[i]==5) bl=1;
	else if(p[i]==0)
		{
		bo=0;
		bl=0;
		fg=7;
		bg=0;
		}
	}
if(h)
	{
	test_fg=fg;
	test_bg=bg;
	test_bo=bo;
	test_bl=bl;
	}
else
ssetcol((fg+bg*16)|(bo?8:0)|(bl?128:0));
refresh();
}

void drawansiline(int x, int y, int len, char *str, int hide)
{
    char form_ends[] = "uds";
    int args[10]; // Numerical arguments for Ansi-code
    int argsc = 0; // Arg-Counter for this one ^
    int state = 0; // Current ansi-state
    int pos = 0; // Pos in String
    int xp = 0; // Pos on Screen
    char c; // Current character
    int strl; // String length of string ;)
    int t, i, k;
    int oldchars[30]; // Old characters
    int oldc = 0; // ^^ counter
    char arg[20];
    int argc = 0;
    int above = 0;
    char *op = (char *)malloc(10);
    if (!op) perror("not enough memory");
    fg = 7;
    bg = 0;
    bo = 0;
    bl = 0;
    ssetcol(7);
    if (hide & HIDE_MACROS) ssetcol(4 * 16 + 15);
    strl = strlen(str) - 1;
    move(y, x);
    while (xp < len)
    {
        above = 0;
        if (pos > strl + 1)
        {
            if (hide != HIDE_TEST)
                addch(' ');
            xp++;
        }
        else
        {
            c = str[pos++];
            if (c == 0)
            {
                pbuf(oldchars, oldc);
            }
            else
                switch (state)
                {
                case 0:
                    if (hide & HIDE_MACROS)
                    {
                        if (c == '%')
                        {
                            addbuf(oldchars, oldc, c);
                            state = 6;
                            break;
                        }
                        else if (c == '~')
                        {
                            addbuf(oldchars, oldc, c);
                            state = 7;
                            break;
                        }
                    }

                    if (c == '\e')
                    {
                        addbuf(oldchars, oldc, c);
                        state = 1;
                    }
                    else if (c == '\t')
                    {
                        if (hide & HIDE_MACROS)
                        {
                            ssetcol(4 * 16 + 14);
                            addmchar(242);
                            xp++;
                            ssetcol(4 * 16 + 15);
                        }
                        else
                        {
                            k = ((xp + TAB_SIZE) / TAB_SIZE) * TAB_SIZE - xp;
                            for (i = 0; i < k && xp < len; i++, xp++)
                                addmchar(' ');
                        }
                    }
                    else if (c == '@')
                    {
                        addbuf(oldchars, oldc, c);
                        state = 4;
                    }
                    else if (c == '\\')
                    {
                        addbuf(oldchars, oldc, c);
                        state = 3;
                    }
                    else
                    {
                        if (hide != HIDE_TEST)
                            addmchar(c);
                        xp++;
                    }
                    break;
                case 1:
                    addbuf(oldchars, oldc, c);
                    if (c == '[')
                        state = 2;
                    else
                    {
                        state = 0;
                        pbuf(oldchars, oldc);
                    }
                    break;

                case 2:
                    addbuf(oldchars, oldc, c);
                    if (isdigit(c) || (c == ';' && argc))
                    {
                        if (argc > 19)
                        {
                            argc = 0;
                            state = 0;
                            pbuf(oldchars, oldc);
                        }
                        arg[argc++] = c;
                    }
                    else if (strchr(ansi_codes, c))
                    {
                        arg[argc] = 0;
                        op = strtok(arg, ";");
                        while (op != NULL)
                        {
                            args[argsc] = atoi(op);
                            if (args[argsc++] > 47)
                            {
                                above = 1;
                                op = NULL;
                            }
                            else
                                op = strtok(NULL, ";");
                        }
                        if (!above)
                            switch (strchr(ansi_codes, c)[0])
                            {
                            case 'm':
                                if (hide & HIDE_TEST)
                                {
                                    ansi_color(args, argsc, 1);
                                    pbuf(oldchars, oldc);
                                }
                                if (hide & HIDE_COL)
                                    ansi_color(args, argsc, 0);
                                if (hide & HIDE_MACROS)
                                {
                                    ssetcol(4 * 16 + 10);
                                    pbuf(oldchars, oldc);
                                    ssetcol(4 * 16 + 15);
                                }
                                break;
                            default:
                                if (hide & HIDE_MACROS)
                                {
                                    ssetcol(4 * 16 + 10);
                                    pbuf(oldchars, oldc);
                                    ssetcol(4 * 16 + 15);
                                }
                                break;
                            }
                        if (above) pbuf(oldchars, oldc);
                        above = 0;
                        argsc = 0;
                        argc = 0;
                        state = 0;
                        clrbuf(oldchars, oldc);
                    }
                    else
                    {
                        argsc = 0;
                        argc = 0;
                        state = 0;
                        pbuf(oldchars, oldc);
                    }
                    break;
                case 3:
                    addbuf(oldchars, oldc, c);
                    switch (c)
                    {
                    case 'a':
                        if (hide & HIDE_MACROS)
                        {
                            ssetcol(4 * 16 + 14);
                            pbuf(oldchars, oldc);
                            ssetcol(4 * 16 + 15);
                        }
                        else
                        {
                            ssetcol(10);
                            addstr("Display: ");
                            xp += strlen("Display: ");
                            clrbuf(oldchars, oldc);
                        }
                        state = 0;
                        break;
                    case 'n':
                        if (hide & HIDE_MACROS)
                        {
                            ssetcol(4 * 16 + 14);
                            pbuf(oldchars, oldc);
                            ssetcol(4 * 16 + 15);
                        }
                        else
                            clrbuf(oldchars, oldc);
                        state = 0;
                        break;
                    case 'e':
                        state = 1;
                        break;
                    case '\\':
                        if (hide & HIDE_MACROS)
                        {
                            pbuf(oldchars, oldc);
                        }
                        else
                        {
                            addch('\\');
                            clrbuf(oldchars, oldc);
                        }
                        state = 0;
                        break;
                    default:
                        state = 0;
                        pbuf(oldchars, oldc);
                        break;
                    }
                    break;
                case 4:
                    addbuf(oldchars, oldc, c);
                    if (c == 'X')
                        state = 5;
                    else
                    {
                        pbuf(oldchars, oldc);
                        state = 0;
                    }
                    break;
                case 5:
                    addbuf(oldchars, oldc, c);
                    if (isxdigit(c))
                        arg[argc++] = c;
                    else
                    {
                        pbuf(oldchars, oldc);
                        argc = 0;
                        state = 0;
                    }
                    if (argc == 2)
                    {
                        arg[argc] = 0;
                        if (hide & HIDE_TEST)
                        {
                            t = strtol(arg, NULL, 16);
                            test_bl = t & 128;
                            test_bo = t & 8;
                            test_bg = (t & 112) >> 4;
                            test_fg = t & 7;
                            pbuf(oldchars, oldc);
                        }
                        else if (hide & HIDE_MACROS)
                        {
                            ssetcol(4 * 16 + 10);
                            pbuf(oldchars, oldc);
                        }
                        else
                            ssetcol(strtol(arg, NULL, 16));
                        clrbuf(oldchars, oldc);
                        argc = 0;
                        state = 0;
                    }
                    break;
                case 6:
                    addbuf(oldchars, oldc, c);
                    if (!(isalnum(c) || ispunct(c) || c == '-'))
                    {
                        state = 0;
                        pbuf(oldchars, oldc);
                    }
                    if (strchr(form_ends, c))
                    {
                        ssetcol(4 * 16 + 14);
                        pbuf(oldchars, oldc);
                        ssetcol(4 * 16 + 15);
                        state = 0;
                    }
                    break;
                case 7:
                    addbuf(oldchars, oldc, c);
                    if (isupper(c))
                    {
                        ssetcol(4 * 16 + 14);
                        pbuf(oldchars, oldc);
                        ssetcol(4 * 16 + 15);
                        state = 0;
                    }
                    else if (c == '#')
                    {
                        argc = 0;
                        state = 8;
                    }
                    else
                    {
                        pbuf(oldchars, oldc);
                        state = 0;
                    }
                    break;
                case 8:
                    addbuf(oldchars, oldc, c);
                    argc++;
                    if (!isupper(c))
                    {
                        pbuf(oldchars, oldc);
                        argc = 0;
                        state = 0;
                    }
                    else if (argc == 2)
                    {
                        argc = 0;
                        ssetcol(4 * 16 + 14);
                        pbuf(oldchars, oldc);
                        ssetcol(4 * 16 + 15);
                        state = 0;
                    }
                    break;
                }
        }
    }
    pbuf(oldchars, oldc);
    free(op); // Free the allocated memory
}

//****************************************************//

//----------------------------------------------------//

void dnewline(int x)
{
if(buffer[x+MAXCHARS*curline]==0) 
	{
	ssetcol(4*16+12);	
	mvaddcstr(15,3,"<<EMPTY>>",74);
	drawansiline(3,17,74,"@X08<<EMPTY>>",HIDE_COL);
	}
else
	{
	ssetcol(4*16+15);
	drawansiline(3,15,74,buffer+x+MAXCHARS*curline,HIDE_MACROS);
	drawansiline(3,17,74,buffer+MAXCHARS*curline,HIDE_COL);
	}
}

void drawline()
{
char lineinfo[50];
int i;
if(curline>olines) 
	{
	ssetcol(8);
	mvaddcstr(14,3,"< Unknown Line entry >",74);
	}
else
	{
	ssetcol(7);
	if(hide==HIDE_NONE)
	mvaddcstr(14,3,obuffer+MAXCHARS*curline,74);
	else drawansiline(3,14,74,obuffer+MAXCHARS*curline,hide);
	}
dnewline(curlx);
ssetcol(10);
snprintf(lineinfo,sizeof(lineinfo),"(%2d)%4d/%4d",curx+curlx+1,curline+1,lines);
mvaddcstr(13,55,lineinfo,15);
mvaddcstr(13,30,hidemodes[hide],10);
mvaddstr(13,24,"Mode:");
if(changed)
mvaddstr(LINES-1,45,"Changed");
else
	{
	ssetcol(1);
	move(LINES-1,45);
	for(i=0;i<8;i++) addch(ACS_HLINE);
	}
ssetcol(10);
if(insert)
mvaddstr(LINES-1,55,"Ins");
else
	{
	ssetcol(1);
	move(LINES-1,55);
	for(i=0;i<4;i++) addch(ACS_HLINE);
	}
}

void update()
{
drawline();
move(15,3+curx);
refresh();
}

void arange()
{
if(curx>MAXCHARS-1)
	{
	curx=0;
	curlx=MAXCHARS-73;
	}	
if(curx>73)
	{
	curlx=curx-73;
	curx=73;
	}
}

void message(char *s)
{
int x,i;
ssetcol(10);
msg=1;
x=(74-strlen(s))/2;
move(19,3);
for(i=0;i<x;i++) addch(' ');
addstr(s);
for(i=0;i<74-strlen(s)-x;i++) addch(' ');
}

int colorbar(int colors)
{
int cur=0;
int i;
int c=0;
mvaddcstr(LINES-3,3,"",74);
for(i=0;i<colors+1;i++)
	{
	ssetcol(!i?10:((i==1)?8:i-1));
	refresh();
	mvaddstr(LINES-3,3+i*4,!i?" No":((i==1)?leer_block:half_block));
	}
do
	{
	ssetcol(!cur?10:((cur==1)?8:cur-1));
	mvaddstr(LINES-3,3+cur*4,!cur?" No":((cur==1)?leer_block:half_block));
	switch(c)
		{
		case KEY_LEFT: if(cur>0) cur--;
				break;
		case KEY_RIGHT: if(cur<colors) cur++;
				break;
		}
	ssetcol(!cur?15:((cur==1)?8:cur-1));
	refresh();
	mvaddstr(LINES-3,3+cur*4,!cur?" No":((cur==1)?half_block:full_block));
	}
while((c=getch())!='\r');
return(cur);
}

void clr(int x,int y, int w,int h)
{
int i;
for(i=0;i<h;i++) mvaddcstr(y+i,x,"",w);
}

int yesno(char *s,int q)
{
int c,cur;
int x;
cur=q&1;
mvaddcstr(LINES-3,3,"",74);
ssetcol(10);
mvaddstr(LINES-3,3,s);
x=strlen(s)+5;
mvaddstr(LINES-3,x,"No");
mvaddstr(LINES-3,x+4,"Yes");
cur=0;
do
	{
	ssetcol(10);
	mvaddstr(LINES-3,x+cur*4,!cur?"No":"Yes");
	switch(c)
		{
		case KEY_LEFT: if(cur>0) cur--;
				break;
		case KEY_RIGHT: if(cur<1) cur++;
				break;
		}
	ssetcol(15);
	refresh();
	mvaddstr(LINES-3,x+cur*4,!cur?"No":"Yes");
	}
while((c=getch())!='\r');
ssetcol(7);
drawit();
update();
return(cur);
}

//************************************************************************//
//        Internal functions                                              //
//************************************************************************//

void quit()
{
clear();
ssetcol(10);
addstr("Thanx for using DayDream Text Editor\n\r");
refresh();
printf("\e(B");
endwin();
exit(0);
}

void save_file()
{
char file[255];
int i;
snprintf(file,sizeof(file),"mv %s %s~",orig_file,orig_file);
if((in=fopen(orig_file,"wt"))==NULL)
	{
	message("Could not open/create file for saving");
	return;
	}
for(i=0;i<lines;i++)
	{
	fwrite(buffer+i*MAXCHARS,strlen(buffer+i*MAXCHARS),1,in);
	if(i<lines-1)fprintf(in,"\n");
	}
fclose(in);
changed=0;
update();
}

void inserttext(char *s)
{
int t,i;
t=strlen(buffer+curline*MAXCHARS);
for(i=t;i>curx+curlx;i--)
	buffer[i+strlen(s)-1+curline*MAXCHARS]=\
		buffer[i-1+curline*MAXCHARS];
for(i=0;i<strlen(s);i++)
	buffer[curx+curlx+curline*MAXCHARS+i]=s[i];
buffer[t+curline*MAXCHARS+strlen(s)]=0;
curx=curx+curlx+strlen(s);
arange();
changed=1;
}


void changecol()
{
    int fg, bg, bl, bo;
    char str[100]; // Increase buffer size
    int colors[] = {0, 4, 2, 6, 1, 5, 3, 7};

    drawansiline(1, 1, curx + curlx, buffer + curline * MAXCHARS, HIDE_TEST);
    int t = strlen(buffer + MAXCHARS * curline);
    if (t > MAXCHARS - 6)
    {
        message("Not enough space for colors");
        return;
    }

    fg = colorbar(16);
    bg = colorbar(8);
    bl = yesno("Blink:", 0);

    bo = (fg > 8) ? 1 : 0;
    if ((test_bo && !bo) || (test_bl && !bl)) bg = test_bg + 1;
    if ((test_bl && !bl) || (test_bo && !bo)) bg = test_bg + 1;
    if (!bg && !fg && !bl) return;

    // Construct the ANSI color string carefully
    snprintf(str, sizeof(str), "\e[%s%s", bl ? "5;" : (test_bl ? "0;" : ""), bo ? "1;" : (test_bo ? "0;" : ""));

    // Use temporary buffer to ensure no overflow
    char temp[20];
    if (fg) {
        snprintf(temp, sizeof(temp), "%d;", 30 + colors[(fg - 1) & 7]);
        strncat(str, temp, sizeof(str) - strlen(str) - 1);
    }
    if (bg) {
        snprintf(temp, sizeof(temp), "%d;", 40 + colors[bg - 1]);
        strncat(str, temp, sizeof(str) - strlen(str) - 1);
    }

    // Ensure the last character is 'm' and no buffer overflow
    size_t str_len = strlen(str);
    if (str_len > 0 && str_len < sizeof(str) - 1) {
        str[str_len - 1] = 'm'; // Replace last semicolon with 'm'
    }

    if ((strlen(str) + t) > MAXCHARS - 1)
    {
        message("Not enough space for colors");
        return;
    }
    inserttext(str);    
    ssetcol(7);
    drawit();
    update();
}

void input(int x,int y,int len,int pcol,int col,char *prompt,char *buf,int allow)
{
int xp,c,i,t;
int p=0;
mvaddcstr(y,x,"",74);
t=strlen(buf);
move(y,x);
ssetcol(pcol);
addstr(prompt);
xp=x+strlen(prompt)+1;
ssetcol(col);
mvaddcstr(y,xp,"",len);
if(t)
	mvaddstr(y,xp,buf);
move(y,xp);
while(1)
	{
	c=getch();
	switch(c)
		{
		case '\r':
			buf[t]=0;
			drawit();
			update();
			return;
			break;
		case KEY_LEFT:
			if(p>0) p--;
			break;
		case KEY_RIGHT:
			if(p<t) p++;
			break;
		case KEY_BACKSPACE:
				if(p<1) break;
					p--;
		case KEY_DC: 
				if(t<1) break;
				for(i=p;i<t-1;i++)
				buf[i]=buf[i+1];
				buf[t-1]=0;
				t--;
				if(p>=t) 
					p=t;
				if(p<0)
					p=0;				
				mvaddcstr(y,xp,buf,len);
				break;
		
		default:
			if( (p<len)&& ((allow&ALLOW_ALL)|| ((allow&ALLOW_NUM)&&isdigit(c)) ))
				{
				c=toupper(c);
				addch(c);
				buf[p]=c;
				p++;
				if(p>t) t=p;
				}			
			break;
		}
	move(y,xp+p);
	}
}

int find_text(char *buf)
{
char bu[MAXCHARS];
int i;
input(3,LINES-3,60,10,4*16+15,"Enter String:",search_string,ALLOW_ALL|ALLOW_TOUP);
for(i=curline;i<lines;i++)
	{
	stripansi(buf+i*MAXCHARS,bu);
	if(strstr(bu,search_string)) return(i);
	}
return(curline);
}

void goto_index()
{
char index[5]="";
int i;
input(3,LINES-3,4,10,4*16+15,"Enter Index:",index,ALLOW_NUM);
i=atoi(index);
if(i>0&&i<lines+1) curline=i-1;
}

void addmacro()
{
int i,c=0;
int curl=0,cury=0;
int max;
if(curline==295) max=M_ACOUNT;
else max=M_COUNT;
clr(40/2,10/2,40,LINES-10);
mborder(20,5,59,LINES-10+4,1);
do
	{
	switch(c)
		{
		case KEY_PPAGE:
			cury-=10;
			if(cury<0)
				{
				curl-=-cury;
				cury=0;
				if(curl<0) curl=0;
				}
			break;
		case KEY_NPAGE:
			cury+=10;
			if(cury>LINES-13)
				{
				curl+=cury-(LINES-13);
				cury=LINES-13;
				if((curl+cury)>max) curl=max-cury;
				}
			break;		
		case KEY_UP: 
 			cury--;
			if(cury<0)
				{
				cury=0;
				if(curl>0) curl--;
				}
			break;
		case KEY_DOWN:
			cury++;
			if(cury>LINES-13)
				{
				cury=LINES-13;
				if(curl<(max-cury)) curl++;					
				}
			break;
		}	
	for(i=0;i<LINES-12;i++)
		{
		if(i==cury) ssetcol(10);
		else ssetcol(2);
		mvaddcstr(6+i,22,macros[i+curl].desc,37);
		if(i==cury) ssetcol(11);
		else ssetcol(10);
		mvaddstr(6+i,54,macros[i+curl].key);
		}
	c=getch();	
	}
while((c!='\r')||(!macros[curl+cury].key[0]));
if(cury+curl)
	{
	inserttext(macros[curl+cury].key);		
	}
refresh();
clr(40/2,10/2,40,LINES-10);
drawit();
update();
}


/****************************************************************\
|                 MAIN EDIT ROUTINE                              |
\****************************************************************/

void doedit()
{
int c,t,i;
int q;
while(1)
	{
	t=strllen(buffer+MAXCHARS*curline);
	c=getch();
	if(msg)
		{
		msg=0;
		ssetcol(7);
		mvaddcstr(19,3,"",74);
		}
	switch(c)
		{
		case KEY_UP:
			curx=0;
			curlx=0;
			if(curline>0) curline--;
			update();
			break;
		case '\r':
		case KEY_DOWN:
			curx=0;
			curlx=0;
			if(curline<lines-1) curline++;
			update();
			break;
		case KEY_LEFT:
			curx--;
			if(curx<0)
				{
				curx=0;
				if(curlx>0)
					{
					curlx--;
					}
				}
			update();
			break;
		case KEY_RIGHT:
			if((curx+curlx)<t)
				{
				curx++;
				if(curx>72)
					{
					curx--;
						curlx++;

					}
				update();
				}
			break;
		case KEY_HOME:
				curx=0;
				curlx=0;
				update();
				break;
		case KEY_END:
				if(t-1<74) 
					{
					curx=t;
					if(t>MAXCHARS-2) curx=t-1;
					arange();
					if(curx<0) curx=0;
					}
				else
					{
					curx=73;
					curlx=t-73;
					if(t>MAXCHARS-2) curlx=t-74;
					}
				update();
				break;
		case KEY_NPAGE:
				curx=0;
				curlx=0;
				curline+=10;
				if(curline>lines-1) curline=lines-1;
				update();
				break;
		case KEY_PPAGE:
				curx=0;
				curlx=0;
				curline-=10;
				if(curline<0) curline=0;
				update();
				break;
		case KEY_IC:
				insert=1-insert;
				update();
				break;

		case KEY_BACKSPACE:
				changed=1;
				if(curx+curlx<1) break;
					curx--;
					if(curx<0)
						{
						curx=0;
						curlx--;
						}

		case KEY_DC:
				if(t<1) break;
				changed=1;
				for(i=curlx+curx;i<t-1;i++)
				buffer[i+MAXCHARS*curline]=\
					buffer[i+1+MAXCHARS*curline];
				buffer[t-1+MAXCHARS*curline]=0;
				t=strllen(buffer+MAXCHARS*curline);
				if(curx+curlx>t)
					{
					curx=t;
					arange();
					}
				if(curx+curlx<0)
					{
					curlx=0;
					curx=0;
					}

				update();
				break;
		case KEY_F(2):
			save_file();
			break;
		case KEY_F(3):
			if(changed)
				{
				if(yesno("File changed. Are you sure",0))
					quit();
				}
			else
			quit();
			break;
		case KEY_F(4):
			if(changed)
			save_file();
			quit();
			break;
		case KEY_F(5):
			curline=find_text(buffer);
			update();
			break;
		case KEY_F(6):
			curline=find_text(obuffer);
			update();
			break;
		case KEY_F(7):
			goto_index();
			update();
			break;
		case KEY_F(8):
			changed=1;
			strcpy(buffer+curline*MAXCHARS,\
				obuffer+curline*MAXCHARS);
			if(curlx+curx>strlen(buffer+curline*MAXCHARS))
				{
				curx=strlen(buffer+curline*MAXCHARS);
				arange();
				}
			update();
			break;
		case KEY_F(9): hide++;
				if(hide>2) hide=0;
				update();
				break;
		case KEY_F(10):
			changecol();
			break;
		case KEY_F(11):
			addmacro();
			break;
		case KEY_F(12):
			c='\e';
		default:
			changed=1;
			if(!insert)
				{
				if((curx+curlx<MAXCHARS-1))
					{
				buffer[(curlx+curx)+MAXCHARS*curline]=(char)c;
				curx++;
				if(curx>73&&(curx+curlx<MAXCHARS-1))
						{
						curx=73;
						curlx++;
						}
					}
				}
			else
				{
				if((curx+curlx<MAXCHARS)&&(t<MAXCHARS-1))
					{
				for(i=t;i>curx+curlx;i--)
					buffer[i+curline*MAXCHARS]=\
						buffer[i-1+curline*MAXCHARS];
					buffer[curx+curlx+curline*MAXCHARS]=(char)c;
					buffer[t+1+curline*MAXCHARS]=0;
					curx++;
					if(curx>73)
						{
						if(curlx+curx<MAXCHARS-1)
						curx=73;
						curlx++;
						}
					}
				}
			update();
		}
	}
}

void usehelp()
{
puts("");
puts("Daydream Text Editor v1 by 2mad^Gilden in 1997, esc!demonic 2024!");
puts("-----------------------------------------------------------------");
puts("   ddtext <filename> [<original-filename>]");
puts("");
exit(1);
}

void error(char *s)
{
printf("%s: %s\n",PROGNAME,s);
exit(1);
}

void readbuffer(unsigned char **ebuf)
{
    char c;
    char *buf = NULL;
    int pos = 0;
    int bufsize = MAXCHARS;
    tmpline = 1;

    buf = (char *)malloc(bufsize);
    if (buf == NULL)
    {
        perror("not enough memory");
    }

    while (!feof(in))
    {
        // Ensure there's enough space for another line
        if ((tmpline * MAXCHARS) > bufsize)
        {
            bufsize += MAXCHARS;
            buf = (char *)realloc(buf, bufsize);
            if (buf == NULL)
            {
                perror("not enough memory");
            }
        }

        pos = 0;
        while ((c = fgetc(in)) != '\n' && !feof(in) && pos < MAXCHARS - 1)
        {
            if (c == '\\')
            {
                if ((c = fgetc(in)) == 'e')
                    buf[(tmpline - 1) * MAXCHARS + pos++] = '\e';
                else
                {
                    buf[(tmpline - 1) * MAXCHARS + pos++] = '\\';
                    buf[(tmpline - 1) * MAXCHARS + pos++] = c;
                }
            }
            else
                buf[(tmpline - 1) * MAXCHARS + pos++] = c;
        }
        buf[(tmpline - 1) * MAXCHARS + pos] = 0;
        tmpline++;
    }
    *ebuf = (unsigned char *)buf;
}

void drawit()
{
ssetcol(1);
box(stdscr,ACS_VLINE,ACS_HLINE);
mborder(1,1,78,4,1);
ssetcol(10);
center(2,COPY1);
center(3,COPY2);

mborder(1,LINES-4,78,LINES-2,1);
ssetcol(10);
mvaddcstr(LINES-3,3,"",74);
center(LINES-3,COPY3);

mborder(1,5,78,11,1);
ssetcol(10);
center(6,HELP1);
center(7,HELP2);
center(8,HELP3);
center(9,HELP4);
center(10,HELP5);

mborder(1,12,78,20,1);
}

void main(int argc, char **argv)
{
    if (argc < 2) usehelp();

    orig_file = argv[1];
    char *oldfile;
    if ((oldfile = (char *)getenv("DDTEXTORIG")) == NULL)
    {
        if (argc < 3) usehelp();
        oldfile = argv[2];
    }

    if ((in = fopen(argv[1], "rt")) == NULL)
    {
        error("Couldn't open input-file");
    }
    readbuffer(&buffer);
    nlines = tmpline - 1;
    fclose(in);

    if ((in = fopen(oldfile, "rt")) == NULL)
    {
        error("Couldn't open original-file");
    }
    readbuffer(&obuffer);
    olines = tmpline - 1;
    fclose(in);

    if (olines > nlines)
    {
        lines = olines;
        buffer = (char *)realloc(buffer, (lines + 1) * MAXCHARS);
        if (buffer == NULL) perror("not enough memory");
    }
    else
    {
        lines = nlines;
    }

    search_string[0] = 0;
    initscr();
    nonl();
    noecho();
    cbreak();
    keypad(stdscr, TRUE);
    printf("\e(U");
    if (has_colors()) init_colors();
    drawit();
    update();
    doedit();
    endwin();

    // Free allocated memory
    free(buffer);
    free(obuffer);
}
