; Vintage Computing Christmas Challenge 2025 - v1e
; Jose Moreno Prieto 'Xeleh' - 08/12/2025

main:
            org     100h
            db      68,50,61,74     ; determinants for locations with '*' char
            db      29,17,2,8       ; data before the code to save 1 byte
            db      18,32,72,98     ; by assuming si init value = 100h
            mov     bl,-9           ; initial row
.row        mov     dl,-9           ; initial column
.col        cmp     dl,9            ; right side overflow?
            jg      .space          ; yes -> print space
            mov     al,bl           ; al = row
            mul     bl              ; al = row * row
            je      .star           ; if central row -> print '*' char
            mov     cl,al           ; cl = row * row
            mov     al,dl           ; al = column
            mul     dl              ; al = column * column
            je      .star           ; if central column -> print '*' char
            add     al,cl           ; al = (col * col) + (row * row)
            mov     di,si           ; set data pointer (si = 100h)
            mov     cl,12           ; set data length
            repne   scasb           ; find determinant in data
            je      .star           ; found? -> print '*' char
.space      mov     al,' '          ; space char
            jmp     .print          ; print
.star       mov     al,'*'          ; '*' char
.print      int     29h             ; print char in al
            inc     dx              ; next column
            cmp     dl,80-9         ; end column? (assumes 80x25 text mode)
            jne     .col            ; no -> loop
            inc     bx              ; next row
            cmp     bl,9+1          ; end row?
            jne     .row            ; no -> loop

%ifdef      debug
            waitkey
            ret
%endif
