org   16514   
        ds   127,$55	; filler of $55, untouched by code
        defb   $fd,$ae,$cf,$8d,$f6,$fb,$6d,$b6
start:              	; Prefix the code with the bitmap data
        push bc     	; At startup “start” is in BC, so C = 9
        pop hl      	; so move it to HL, use as bitmap pointer
row:
        ld b, 9     	; start each col on the 9th row, and first
loop:               	; plot 4 asterisks
        jr c, xloop  	; if bit set then don't plot it
        push hl     	; save HL as it gets used to print
        push bc     	; save BC as it gets destroyed 
        call $8f5   	; point HL at (c,b)
        pop bc      	; retrieve BC
        ld a,18     	; load rotation constant
        cp (hl)     	; use it to check if all 4 plots are done
        ld (hl),23  	; plot a *
        pop hl      	; retrieve HL
        jr c, xloop 	; if all 4 plots already done, x-it the loop
        sub b       	; otherwise A = 18-B
        ld b,c      	; B = C and
        ld c,a      	; C = 18-B => rotate 90º clockwise
        jr nz, loop 	; If col != 0 then continue rotating
        ret         	; otherwise we are done
xloop:
        srl (hl)    	; grab 1 bit from bitmap
        djnz loop	; use this bit for next row, until we run out
        dec c       	; otherwise, move on to next col
        dec hl      	; iterate bitmap pointer
        jr row      	; print the next row
end: