; VCCC 2025 by dplass. For Commodore PET. `sys 1040` to run.

*=$0410
OUTCH=$ffd2
STAR=42
SPACE=32

            ldy #-10 ; row

            ; Start with a newline :)
print_newline
            lda #$0d
            jsr OUTCH

row_loop
            clv ; direction: 0 = shift left, 1 = shift right

            iny
            beq middle_row
            cpy #10
            bne not_done 

            ; the first byte of flakedata is ignored, so we replaced it with 
            ; $60 (rts) so we "return" from here.

flakedata   byte $60,73,146,4,9,114,48,81,2,0

middle_row
            ; Middle row; print 19 stars
            ldx #19
            lda #STAR
starline
            jsr OUTCH
            dex
            bne starline
            beq print_newline ; branch always

not_done
            ; Not the middle row; always prepend a space
            lda #SPACE
            jsr OUTCH

            ; loop through 8 columns, first shifting left, then print a star
            ; then loop through them again, shifting right.
col_loop
            ; Take abs value of row
            tya ; y = row
            tax ; x = row
            bpl positive_row

            eor #$ff
            tax
            inx
positive_row
            lda flakedata,x  ; A = flakedata[abs(row)], note the lowest row is 1

            ldx #8 ; column #
shift_it    
            bvs shift_right
            rol ; rol twice because we're going to undo it with the ror
            rol
shift_right  
            ror
            pha
            lda #STAR
            bcs print_bit ; carry meant the result of the rol or ror was 1
            lda #SPACE
print_bit
            jsr OUTCH
            pla

            dex
            bne shift_it
 
            ; if we got here we're out of columns; print middle star or newline

            ; if v is set, we're in the second iteration, so print newline
            bvs print_newline
            
            ; Print middle star
            lda #STAR
            jsr OUTCH

            ; We can only get here if direction was 0, so set it to 1
            bit $71  ; $71 always has a 1 in the 6th bit, which sets V
            bvs col_loop     ; branch always; re-establishes accumulator
