#version 330 core
in vec2 UV;
in vec4 Normal;
flat in uint type;

out vec4 color;
uniform sampler2DArray TextureSampler;
uniform vec3  uLightDir;
uniform float uFogMin;
uniform float uFogMax;
uniform vec4  uFogColour;
in vec3 vPos;

void main() {
	float NormalMod = dot(normalize(Normal.xyz), normalize(uLightDir));
	NormalMod = clamp(NormalMod, 0.5, 0.75);

	// Sample texture
	color.xyz = texture(TextureSampler, vec3(UV, type)).xyz*NormalMod;
	color.a = texture(TextureSampler, vec3(UV, type)).a; //We don't want alpha to be modified by lights

	// Calculate fog
	float dist = length(vPos);
	float fog_factor = (uFogMax - dist) / (uFogMax - uFogMin);
	fog_factor = clamp(fog_factor, 0.0, 1.0);

	color = mix(uFogColour, color, fog_factor);
}
