/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Matrix33;
import org.openrndr.math.Polar;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector2$;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeContourProvider;
import org.openrndr.shape.ShapeProvider;
import org.openrndr.shape.Triangle$;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 F2\u00020\u00012\u00020\u0002:\u0002FGB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bB9\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\u0011\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0086\u0002J\u0016\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u001fJ\u0011\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u001fH\u0086\u0002J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u001fH\u0086\u0002J\u0011\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010-\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u0004J\t\u00104\u001a\u00020\u0004H\u00c6\u0003J\t\u00105\u001a\u00020\u0004H\u00c6\u0003J\t\u00106\u001a\u00020\u0004H\u00c6\u0003J'\u00107\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u00c6\u0001J\u0013\u00108\u001a\u00020\u00132\b\u00109\u001a\u0004\u0018\u00010:H\u00d6\u0003J\t\u0010;\u001a\u00020\nH\u00d6\u0001J\t\u0010<\u001a\u00020=H\u00d6\u0001J%\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0001\u00a2\u0006\u0002\bER\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010 \u001a\u00020\u001f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u001b\u0010%\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010$\u001a\u0004\b&\u0010\u000fR\u0011\u00101\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006H"}, d2={"Lorg/openrndr/shape/Triangle;", "Lorg/openrndr/shape/ShapeProvider;", "Lorg/openrndr/shape/ShapeContourProvider;", "x1", "Lorg/openrndr/math/Vector2;", "x2", "x3", "<init>", "(Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getX1", "()Lorg/openrndr/math/Vector2;", "getX2", "getX3", "contains", "", "v", "contour", "Lorg/openrndr/shape/ShapeContour;", "getContour", "()Lorg/openrndr/shape/ShapeContour;", "shape", "Lorg/openrndr/shape/Shape;", "getShape", "()Lorg/openrndr/shape/Shape;", "position", "u", "", "area", "getArea", "()D", "area$delegate", "Lkotlin/Lazy;", "centroid", "getCentroid", "centroid$delegate", "times", "scale", "div", "plus", "right", "minus", "bary", "Lorg/openrndr/math/Vector3;", "barycentric", "reversed", "getReversed", "()Lorg/openrndr/shape/Triangle;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_shape", "Companion", "$serializer", "openrndr-shape"})
public final class Triangle
implements ShapeProvider,
ShapeContourProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector2 x1;
    @NotNull
    private final Vector2 x2;
    @NotNull
    private final Vector2 x3;
    @NotNull
    private final Lazy area$delegate;
    @NotNull
    private final Lazy centroid$delegate;

    public Triangle(@NotNull Vector2 x1, @NotNull Vector2 x2, @NotNull Vector2 x3) {
        Intrinsics.checkNotNullParameter(x1, "x1");
        Intrinsics.checkNotNullParameter(x2, "x2");
        Intrinsics.checkNotNullParameter(x3, "x3");
        this.x1 = x1;
        this.x2 = x2;
        this.x3 = x3;
        this.area$delegate = LazyKt.lazy(() -> Triangle.area_delegate$lambda$0(this));
        this.centroid$delegate = LazyKt.lazy(() -> Triangle.centroid_delegate$lambda$1(this));
    }

    @NotNull
    public final Vector2 getX1() {
        return this.x1;
    }

    @NotNull
    public final Vector2 getX2() {
        return this.x2;
    }

    @NotNull
    public final Vector2 getX3() {
        return this.x3;
    }

    public final boolean contains(@NotNull Vector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        Vector2 x23 = this.x2.minus(this.x3);
        Vector2 x32 = this.x3.minus(this.x2);
        Vector2 x31 = this.x3.minus(this.x1);
        Vector2 x13 = this.x1.minus(this.x3);
        double det = x23.y() * x13.x() - x32.x() * x31.y();
        double minD = Math.min(det, 0.0) - 1.0E-5;
        double maxD = Math.max(det, 0.0) + 1.0E-5;
        Vector2 d = v.minus(this.x3);
        double a = x23.y() * d.x() + x32.x() * d.y();
        if (a < minD || a > maxD) {
            return false;
        }
        double b = x31.y() * d.x() + x13.x() * d.y();
        if (b < minD || b > maxD) {
            return false;
        }
        double c2 = det - a - b;
        return !(c2 < minD) && !(c2 > maxD);
    }

    @Override
    @NotNull
    public ShapeContour getContour() {
        Vector2[] vector2Array = new Vector2[]{this.x1, this.x2, this.x3};
        return ShapeContour.Companion.fromPoints$default(ShapeContour.Companion, CollectionsKt.listOf(vector2Array), true, null, 4, null);
    }

    @Override
    @NotNull
    public Shape getShape() {
        return new Shape(CollectionsKt.listOf(this.getContour()));
    }

    @NotNull
    public final Vector2 position(double u, double v) {
        double su0 = Math.sqrt(u);
        double b0 = 1.0 - su0;
        double b1 = v * su0;
        Vector3 b = new Vector3(b0, b1, 1.0 - b0 - b1);
        return this.x1.times(b.x()).plus(this.x2.times(b.y())).plus(this.x3.times(b.z()));
    }

    public final double getArea() {
        Lazy lazy = this.area$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    @NotNull
    public final Vector2 getCentroid() {
        Lazy lazy = this.centroid$delegate;
        return (Vector2)lazy.getValue();
    }

    @NotNull
    public final Triangle times(double scale) {
        return new Triangle(this.x1.times(scale), this.x2.times(scale), this.x3.times(scale));
    }

    @NotNull
    public final Triangle div(double scale) {
        return new Triangle(this.x1.div(scale), this.x2.div(scale), this.x3.div(scale));
    }

    @NotNull
    public final Triangle plus(@NotNull Triangle right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Triangle(this.x1.plus(right.x1), this.x2.plus(right.x2), this.x3.plus(right.x3));
    }

    @NotNull
    public final Triangle minus(@NotNull Triangle right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Triangle(this.x1.minus(right.x1), this.x2.minus(right.x2), this.x3.minus(right.x3));
    }

    @NotNull
    public final Vector2 position(@NotNull Vector3 bary) {
        Intrinsics.checkNotNullParameter(bary, "bary");
        return this.x1.times(bary.x()).plus(this.x2.times(bary.y())).plus(this.x3.times(bary.z()));
    }

    @NotNull
    public final Vector3 barycentric(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        Matrix33 m = Matrix33.Companion.fromColumnVectors(new Vector3(this.x1.x() - this.x3.x(), this.x1.y() - this.x3.y(), 0.0), new Vector3(this.x2.x() - this.x3.x(), this.x2.y() - this.x3.y(), 0.0), Vector3.Companion.getUNIT_Z());
        Vector2 r = position.minus(this.x3);
        Vector2 vector2 = m.inversed().times(r.xy1()).xy();
        double b1 = vector2.component1();
        double b2 = vector2.component2();
        return new Vector3(b1, b2, 1.0 - b1 - b2);
    }

    @NotNull
    public final Triangle getReversed() {
        return new Triangle(this.x3, this.x2, this.x1);
    }

    @NotNull
    public final Vector2 component1() {
        return this.x1;
    }

    @NotNull
    public final Vector2 component2() {
        return this.x2;
    }

    @NotNull
    public final Vector2 component3() {
        return this.x3;
    }

    @NotNull
    public final Triangle copy(@NotNull Vector2 x1, @NotNull Vector2 x2, @NotNull Vector2 x3) {
        Intrinsics.checkNotNullParameter(x1, "x1");
        Intrinsics.checkNotNullParameter(x2, "x2");
        Intrinsics.checkNotNullParameter(x3, "x3");
        return new Triangle(x1, x2, x3);
    }

    public static /* synthetic */ Triangle copy$default(Triangle triangle, Vector2 vector2, Vector2 vector22, Vector2 vector23, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = triangle.x1;
        }
        if ((n & 2) != 0) {
            vector22 = triangle.x2;
        }
        if ((n & 4) != 0) {
            vector23 = triangle.x3;
        }
        return triangle.copy(vector2, vector22, vector23);
    }

    @NotNull
    public String toString() {
        return "Triangle(x1=" + this.x1 + ", x2=" + this.x2 + ", x3=" + this.x3 + ")";
    }

    public int hashCode() {
        int result = this.x1.hashCode();
        result = result * 31 + this.x2.hashCode();
        result = result * 31 + this.x3.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Triangle)) {
            return false;
        }
        Triangle triangle = (Triangle)other;
        if (!Intrinsics.areEqual(this.x1, triangle.x1)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.x2, triangle.x2)) {
            return false;
        }
        return Intrinsics.areEqual(this.x3, triangle.x3);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_shape(Triangle self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, Vector2$.serializer.INSTANCE, self.x1);
        output.encodeSerializableElement(serialDesc, 1, Vector2$.serializer.INSTANCE, self.x2);
        output.encodeSerializableElement(serialDesc, 2, Vector2$.serializer.INSTANCE, self.x3);
    }

    public /* synthetic */ Triangle(int seen0, Vector2 x1, Vector2 x2, Vector2 x3, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.x1 = x1;
        this.x2 = x2;
        this.x3 = x3;
        this.area$delegate = LazyKt.lazy(() -> Triangle._init_$lambda$2(this));
        this.centroid$delegate = LazyKt.lazy(() -> Triangle._init_$lambda$3(this));
    }

    private static final double area_delegate$lambda$0(Triangle this$0) {
        Vector2 u = this$0.x2.minus(this$0.x1);
        Vector2 v = this$0.x3.minus(this$0.x1);
        return u.areaBetween(v) / 2.0;
    }

    private static final Vector2 centroid_delegate$lambda$1(Triangle this$0) {
        return this$0.x1.plus(this$0.x2).plus(this$0.x3).div(3.0);
    }

    private static final double _init_$lambda$2(Triangle this$0) {
        Vector2 u = this$0.x2.minus(this$0.x1);
        Vector2 v = this$0.x3.minus(this$0.x1);
        return u.areaBetween(v) / 2.0;
    }

    private static final Vector2 _init_$lambda$3(Triangle this$0) {
        return this$0.x1.plus(this$0.x2).plus(this$0.x3).div(3.0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\tJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u00a8\u0006\u000e"}, d2={"Lorg/openrndr/shape/Triangle$Companion;", "", "<init>", "()V", "fromCentroid", "Lorg/openrndr/shape/Triangle;", "centroid", "Lorg/openrndr/math/Vector2;", "radius", "", "theta", "rotation", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-shape"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Triangle fromCentroid(@NotNull Vector2 centroid, double radius, double theta, double rotation) {
            Intrinsics.checkNotNullParameter(centroid, "centroid");
            double omega = 180.0 - theta;
            Vector2 x1 = centroid.plus(new Polar(rotation, radius).cartesian());
            Vector2 x2 = centroid.plus(new Polar(omega + rotation, radius).cartesian());
            Vector2 x3 = centroid.plus(new Polar(-omega + rotation, radius).cartesian());
            Vector2 c2 = x1.plus(x2).plus(x3).div(3.0);
            Vector2 delta = centroid.minus(c2);
            return new Triangle(x1.plus(delta), x2.plus(delta), x3.plus(delta));
        }

        public static /* synthetic */ Triangle fromCentroid$default(Companion companion, Vector2 vector2, double d, double d2, double d3, int n, Object object) {
            if ((n & 4) != 0) {
                d2 = 60.0;
            }
            if ((n & 8) != 0) {
                d3 = 0.0;
            }
            return companion.fromCentroid(vector2, d, d2, d3);
        }

        @NotNull
        public final KSerializer<Triangle> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

