/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.EuclideanVector;
import org.openrndr.math.LinearType;
import org.openrndr.utils.tuples.Quadruple;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u001a=\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001H\u0007\u00a2\u0006\u0002\b\u0007\u001aB\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u00052\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001\u001aW\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\t2\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001H\u0007\u00a2\u0006\u0002\b\u000b\u001aS\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012>\u0010\u0006\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00040\u00020\u00010\r\"\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00040\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u000e\u001ar\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u00020\u00040\u000f0\u0001\"\u000e\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\t\"\u000e\b\u0001\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\t2\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020\u00040\u00020\u00012\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u00020\u00040\u00020\u0001\u001a\u00a2\u0001\u0010\b\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00040\u00140\u0001\"\u000e\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\t\"\u000e\b\u0001\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\t\"\u000e\b\u0002\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\t2\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020\u00040\u00020\u00012\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u00020\u00040\u00020\u00012\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00040\u00020\u0001\u001a<\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\u0018\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\t*\b\u0012\u0004\u0012\u0002H\u00030\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00030\u00012\u0006\u0010\u0019\u001a\u00020\u001a\u001aT\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001\"\u0018\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\t*\b\u0012\u0004\u0012\u0002H\u00030\u00052\u0018\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001a\u00a8\u0006\u001c"}, d2={"proportionalize", "", "Lkotlin/Pair;", "T", "", "Lorg/openrndr/math/EuclideanVector;", "input", "proportionalizeWithoutT", "resample", "Lorg/openrndr/math/LinearType;", "ts", "resampleList", "gatherTs", "", "([Ljava/util/List;)Ljava/util/List;", "Lkotlin/Triple;", "T1", "T2", "input1", "input2", "Lorg/openrndr/utils/tuples/Quadruple;", "T3", "input3", "sampleEquidistant", "segments", "count", "", "sampleEquidistantWithT", "openrndr-shape"})
@SourceDebugExtension(value={"SMAP\nShapeTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShapeTools.kt\norg/openrndr/shape/ShapeToolsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,217:1\n1557#2:218\n1628#2,3:219\n1557#2:222\n1628#2,3:223\n1557#2:229\n1628#2,3:230\n10065#3:226\n10487#3,2:227\n10489#3,3:233\n*S KotlinDebug\n*F\n+ 1 ShapeTools.kt\norg/openrndr/shape/ShapeToolsKt\n*L\n12#1:218\n12#1:219,3\n28#1:222\n28#1:223,3\n60#1:229\n60#1:230,3\n60#1:226\n60#1:227,2\n60#1:233,3\n*E\n"})
public final class ShapeToolsKt {
    /*
     * WARNING - void declaration
     */
    @JvmName(name="proportionalizeWithoutT")
    @NotNull
    public static final <T extends EuclideanVector<T>> List<Pair<T, Double>> proportionalizeWithoutT(@NotNull List<? extends T> input) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(input, "input");
        Iterable $this$map$iv = input;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EuclideanVector euclideanVector = (EuclideanVector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair<void, Double>(it, 0.0));
        }
        return ShapeToolsKt.proportionalize((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends EuclideanVector<T>> List<Pair<T, Double>> proportionalize(@NotNull List<? extends Pair<? extends T, Double>> input) {
        void $this$mapTo$iv$iv;
        int i;
        Intrinsics.checkNotNullParameter(input, "input");
        List lengths = new ArrayList();
        double sum = 0.0;
        int n = ((Collection)input).size();
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                sum += ((EuclideanVector)input.get(i).getFirst()).distanceTo((EuclideanVector)input.get(i - 1).getFirst());
            }
            lengths.add(sum);
        }
        i = 0;
        n = ((Collection)lengths).size();
        while (i < n) {
            int n2 = i++;
            lengths.set(n2, ((Number)lengths.get(n2)).doubleValue() / sum);
        }
        Iterable $this$map$iv = CollectionsKt.getIndices(lengths);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void i2;
            int item$iv$iv;
            int n3 = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair(input.get((int)i2).getFirst(), lengths.get((int)i2)));
        }
        return (List)destination$iv$iv;
    }

    @JvmName(name="resampleList")
    @NotNull
    public static final <T extends LinearType<T>> List<Pair<T, Double>> resampleList(@NotNull List<? extends Pair<? extends T, Double>> input, @NotNull List<Double> ts) {
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(ts, "ts");
        List result = new ArrayList();
        int index = 0;
        Iterator<Double> iterator2 = ts.iterator();
        while (iterator2.hasNext()) {
            LinearType linearType;
            double t = ((Number)iterator2.next()).doubleValue();
            while (index < input.size() && ((Number)input.get(index).getSecond()).doubleValue() < t) {
                ++index;
            }
            int i1 = RangesKt.coerceIn(index, CollectionsKt.getIndices((Collection)input));
            int i0 = RangesKt.coerceIn(index - 1, CollectionsKt.getIndices((Collection)input));
            if (i0 == i1) {
                linearType = (LinearType)input.get(i0).getFirst();
            } else {
                double t0 = t - ((Number)input.get(i0).getSecond()).doubleValue();
                double dt = ((Number)input.get(i1).getSecond()).doubleValue() - ((Number)input.get(i0).getSecond()).doubleValue();
                double f = t0 / dt;
                LinearType v0 = (LinearType)input.get(i0).getFirst();
                LinearType v1 = (LinearType)input.get(i1).getFirst();
                linearType = v0.times(1.0 - f).plus(v1.times(f));
            }
            LinearType v = linearType;
            result.add(new Pair<LinearType, Double>(v, t));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Double> gatherTs(List<? extends Pair<? extends LinearType<?>, Double>> ... input) {
        void $this$flatMapTo$iv$iv;
        List<? extends Pair<? extends LinearType<?>, Double>>[] $this$flatMap$iv = input;
        boolean $i$f$flatMap = false;
        List<? extends Pair<? extends LinearType<?>, Double>>[] listArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void $this$mapTo$iv$iv;
            void element$iv$iv;
            void l = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)l;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(((Number)it.getSecond()).doubleValue());
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return CollectionsKt.sorted(CollectionsKt.distinct((List)destination$iv$iv));
    }

    @NotNull
    public static final <T1 extends LinearType<T1>, T2 extends LinearType<T2>> List<Triple<T1, T2, Double>> resample(@NotNull List<? extends Pair<? extends T1, Double>> input1, @NotNull List<? extends Pair<? extends T2, Double>> input2) {
        Intrinsics.checkNotNullParameter(input1, "input1");
        Intrinsics.checkNotNullParameter(input2, "input2");
        List[] listArray = new List[]{input1, input2};
        List<Double> ts = ShapeToolsKt.gatherTs(listArray);
        List resampled1 = ShapeToolsKt.resampleList(input1, ts);
        List resampled2 = ShapeToolsKt.resampleList(input2, ts);
        List result = new ArrayList();
        int n = ((Collection)ts).size();
        for (int i = 0; i < n; ++i) {
            result.add(new Triple(resampled1.get(i).getFirst(), resampled2.get(i).getFirst(), ts.get(i)));
        }
        return result;
    }

    @NotNull
    public static final <T1 extends LinearType<T1>, T2 extends LinearType<T2>, T3 extends LinearType<T3>> List<Quadruple<T1, T2, T3, Double>> resample(@NotNull List<? extends Pair<? extends T1, Double>> input1, @NotNull List<? extends Pair<? extends T2, Double>> input2, @NotNull List<? extends Pair<? extends T3, Double>> input3) {
        Intrinsics.checkNotNullParameter(input1, "input1");
        Intrinsics.checkNotNullParameter(input2, "input2");
        Intrinsics.checkNotNullParameter(input3, "input3");
        List[] listArray = new List[]{input1, input2, input3};
        List<Double> ts = ShapeToolsKt.gatherTs(listArray);
        List resampled1 = ShapeToolsKt.resampleList(input1, ts);
        List resampled2 = ShapeToolsKt.resampleList(input2, ts);
        List resampled3 = ShapeToolsKt.resampleList(input3, ts);
        List result = new ArrayList();
        int n = ((Collection)ts).size();
        for (int i = 0; i < n; ++i) {
            result.add(new Quadruple(resampled1.get(i).getFirst(), resampled2.get(i).getFirst(), resampled3.get(i).getFirst(), ts.get(i)));
        }
        return result;
    }

    @NotNull
    public static final <T extends LinearType<T> & EuclideanVector<T>> List<T> sampleEquidistant(@NotNull List<? extends T> segments, int count2) {
        Intrinsics.checkNotNullParameter(segments, "segments");
        List result = new ArrayList();
        if (segments.isEmpty()) {
            return result;
        }
        double totalLength = 0.0;
        int n = segments.size() - 1;
        for (int i = 0; i < n; ++i) {
            totalLength += ((EuclideanVector)((EuclideanVector)segments.get(i)).minus((LinearType)segments.get(i + 1))).getLength();
        }
        double spacing = totalLength / (double)(count2 - 1);
        double remaining = 0.0;
        Object cursor = null;
        if (count2 > 0) {
            result.add(segments.get(0));
        }
        int n2 = segments.size() - 1;
        for (int i = 0; i < n2; ++i) {
            LinearType direction = ((EuclideanVector)segments.get(i + 1)).minus((LinearType)segments.get(i));
            double segmentLength = ((EuclideanVector)direction).getLength();
            if (segmentLength + remaining < spacing) {
                remaining += segmentLength;
                continue;
            }
            double skipLength = RangesKt.coerceAtLeast(spacing - remaining, 0.0);
            int pointsFromSegment = 1 + MathKt.roundToInt((segmentLength - skipLength) / spacing);
            double skipT = skipLength / segmentLength;
            double spaceT = spacing / segmentLength;
            LinearType start = (LinearType)segments.get(i);
            double t = skipT;
            for (int n3 = 0; n3 < pointsFromSegment; ++n3) {
                if (!(t < 1.000001)) continue;
                cursor = ((EuclideanVector)start).plus(((EuclideanVector)direction).times(t));
                t += spaceT;
                result.add(cursor);
            }
            remaining = (1.0 - (t - spaceT)) * segmentLength;
        }
        if (count2 >= 2) {
            if (result.size() == count2) {
                result.set(CollectionsKt.getLastIndex(result), CollectionsKt.last(segments));
            } else {
                result.add(CollectionsKt.last(segments));
            }
        }
        return result;
    }

    @NotNull
    public static final <T extends LinearType<T> & EuclideanVector<T>> List<Pair<T, Double>> sampleEquidistantWithT(@NotNull List<? extends Pair<? extends T, Double>> segments, int count2) {
        Intrinsics.checkNotNullParameter(segments, "segments");
        List result = new ArrayList();
        if (segments.isEmpty()) {
            return result;
        }
        double totalLength = 0.0;
        int n = segments.size() - 1;
        for (int i = 0; i < n; ++i) {
            totalLength += ((EuclideanVector)((EuclideanVector)segments.get(i).getFirst()).minus((LinearType)segments.get(i + 1).getFirst())).getLength();
        }
        double spacing = totalLength / (double)(count2 - 1);
        double remaining = 0.0;
        Object cursor = null;
        if (count2 > 0) {
            result.add(segments.get(0));
        }
        int n2 = segments.size() - 1;
        for (int i = 0; i < n2; ++i) {
            LinearType direction = ((EuclideanVector)segments.get(i + 1).getFirst()).minus((LinearType)segments.get(i).getFirst());
            double deltaT = ((Number)segments.get(i + 1).getSecond()).doubleValue() - ((Number)segments.get(i).getSecond()).doubleValue();
            double segmentLength = ((EuclideanVector)direction).getLength();
            if (segmentLength + remaining < spacing) {
                remaining += segmentLength;
                continue;
            }
            double skipLength = RangesKt.coerceAtLeast(spacing - remaining, 0.0);
            int pointsFromSegment = 1 + MathKt.roundToInt((segmentLength - skipLength) / spacing);
            double skipL = skipLength / segmentLength;
            double spaceL = spacing / segmentLength;
            Pair<T, Double> start = segments.get(i);
            double l = skipL;
            for (int n3 = 0; n3 < pointsFromSegment; ++n3) {
                if (!(l < 1.000001)) continue;
                cursor = ((EuclideanVector)start.getFirst()).plus(((EuclideanVector)direction).times(l));
                result.add(TuplesKt.to(cursor, ((Number)start.getSecond()).doubleValue() + deltaT * l));
                l += spaceL;
            }
            remaining = (1.0 - (l - spaceL)) * segmentLength;
        }
        if (count2 >= 2) {
            if (result.size() == count2) {
                result.set(CollectionsKt.getLastIndex(result), CollectionsKt.last(segments));
            } else {
                result.add(CollectionsKt.last(segments));
            }
        }
        return result;
    }
}

