/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.Transient;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.kartifex.Path2;
import org.openrndr.kartifex.Path2Kt;
import org.openrndr.kartifex.Ring2;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector2$;
import org.openrndr.math.Vector4;
import org.openrndr.math.YPolarity;
import org.openrndr.shape.ContourPoint;
import org.openrndr.shape.Path;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;
import org.openrndr.shape.Segment2D;
import org.openrndr.shape.Segment2D$;
import org.openrndr.shape.Segment2DKt;
import org.openrndr.shape.SegmentPoint;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeArtifexKt;
import org.openrndr.shape.ShapeContour$;
import org.openrndr.shape.ShapeContourProvider;
import org.openrndr.shape.ShapeProvider;
import org.openrndr.shape.Winding;
import org.openrndr.utils.ResettableDelegate;
import org.openrndr.utils.ResettableDelegateKt;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 {2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0002{|B'\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rBG\b\u0010\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\f\u0010\u0013J\u0011\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010=\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u001fJ\u000e\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u001fJ(\u0010B\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060C2\b\b\u0002\u0010D\u001a\u00020\u001fJ\u0010\u0010E\u001a\u00020\u00002\b\b\u0002\u0010D\u001a\u00020\u001fJ\u000e\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u000fJ\u000e\u0010H\u001a\u00020\u00002\u0006\u0010H\u001a\u00020@J\u0018\u0010I\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\u001f2\u0006\u0010K\u001a\u00020\u001fH\u0016J\u001f\u0010L\u001a\u0004\u0018\u00010\u001f2\u0006\u0010M\u001a\u00020\u00042\b\b\u0002\u0010N\u001a\u00020\u001f\u00a2\u0006\u0002\u0010OJ\u000e\u0010P\u001a\u00020Q2\u0006\u0010M\u001a\u00020\u0004J\u0006\u0010T\u001a\u00020\u0000J\u0006\u0010i\u001a\u00020jJ\u000f\u0010k\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010l\u001a\u00020\tH\u00c6\u0003J\t\u0010m\u001a\u00020\u000bH\u00c6\u0003J-\u0010n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010o\u001a\u00020\t2\b\u0010:\u001a\u0004\u0018\u00010pH\u00d6\u0003J\t\u0010q\u001a\u00020\u000fH\u00d6\u0001J\t\u0010r\u001a\u00020sH\u00d6\u0001J%\u0010t\u001a\u00020j2\u0006\u0010u\u001a\u00020\u00002\u0006\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020yH\u0001\u00a2\u0006\u0002\bzR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b \u0010!R\u0014\u0010\u0010\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001b\u0010&\u001a\u00020'8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010#\u001a\u0004\b(\u0010)R\u001b\u0010+\u001a\u00020,8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010#\u001a\u0004\b-\u0010.R\u001d\u00100\u001a\b\u0012\u0004\u0012\u00020\u00000\u00068F\u00a2\u0006\f\u0012\u0004\b1\u00102\u001a\u0004\b3\u0010\u0015R\u0011\u00104\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0011\u00107\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b8\u00106R\u0014\u0010;\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0017R\u0011\u0010R\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bS\u00106R\u0011\u0010U\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bV\u00106R\u0014\u0010W\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u00106R\u001c\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0Z8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\\\u00102R\u001b\u0010]\u001a\u00020[8@X\u0080\u0084\u0002\u00a2\u0006\f\u001a\u0004\b`\u0010a*\u0004\b^\u0010_R\u001c\u0010b\u001a\b\u0012\u0004\u0012\u00020c0Z8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\bd\u00102R\u001b\u0010e\u001a\u00020c8@X\u0080\u0084\u0002\u00a2\u0006\f\u001a\u0004\bg\u0010h*\u0004\bf\u0010_\u00a8\u0006}"}, d2={"Lorg/openrndr/shape/ShapeContour;", "Lorg/openrndr/shape/ShapeProvider;", "Lorg/openrndr/shape/ShapeContourProvider;", "Lorg/openrndr/shape/Path;", "Lorg/openrndr/math/Vector2;", "segments", "", "Lorg/openrndr/shape/Segment2D;", "closed", "", "polarity", "Lorg/openrndr/math/YPolarity;", "<init>", "(Ljava/util/List;ZLorg/openrndr/math/YPolarity;)V", "seen0", "", "infinity", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;ZLorg/openrndr/math/YPolarity;Lorg/openrndr/math/Vector2;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getSegments", "()Ljava/util/List;", "getClosed", "()Z", "getPolarity", "()Lorg/openrndr/math/YPolarity;", "shape", "Lorg/openrndr/shape/Shape;", "getShape", "()Lorg/openrndr/shape/Shape;", "length", "", "getLength", "()D", "length$delegate", "Lkotlin/Lazy;", "getInfinity", "()Lorg/openrndr/math/Vector2;", "bounds", "Lorg/openrndr/shape/Rectangle;", "getBounds", "()Lorg/openrndr/shape/Rectangle;", "bounds$delegate", "winding", "Lorg/openrndr/shape/Winding;", "getWinding", "()Lorg/openrndr/shape/Winding;", "winding$delegate", "exploded", "getExploded$annotations", "()V", "getExploded", "clockwise", "getClockwise", "()Lorg/openrndr/shape/ShapeContour;", "counterClockwise", "getCounterClockwise", "plus", "other", "empty", "getEmpty", "normal", "ut", "pose", "Lorg/openrndr/math/Matrix44;", "t", "adaptivePositionsAndCorners", "Lkotlin/Pair;", "distanceTolerance", "sampleLinear", "sampleEquidistant", "pointCount", "transform", "sub", "t0", "t1", "on", "point", "error", "(Lorg/openrndr/math/Vector2;D)Ljava/lang/Double;", "nearest", "Lorg/openrndr/shape/ContourPoint;", "open", "getOpen", "close", "reversed", "getReversed", "contour", "getContour", "path2Delegate", "Lorg/openrndr/utils/ResettableDelegate;", "Lorg/openrndr/kartifex/Path2;", "getPath2Delegate$annotations", "path2", "getPath2$openrndr_shape$delegate", "(Lorg/openrndr/shape/ShapeContour;)Ljava/lang/Object;", "getPath2$openrndr_shape", "()Lorg/openrndr/kartifex/Path2;", "ring2Delegate", "Lorg/openrndr/kartifex/Ring2;", "getRing2Delegate$annotations", "ring2", "getRing2$openrndr_shape$delegate", "getRing2$openrndr_shape", "()Lorg/openrndr/kartifex/Ring2;", "resetCache", "", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "toString", "", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_shape", "Companion", "$serializer", "openrndr-shape"})
@SourceDebugExtension(value={"SMAP\nShapeContour.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShapeContour.kt\norg/openrndr/shape/ShapeContour\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,515:1\n1863#2,2:516\n1557#2:518\n1628#2,3:519\n1872#2,3:522\n1557#2:525\n1628#2,3:526\n1557#2:530\n1628#2,3:531\n2341#2,14:534\n1557#2:548\n1628#2,3:549\n1368#2:552\n1454#2,5:553\n1863#2:558\n3467#2,10:559\n1864#2:569\n1557#2:570\n1628#2,3:571\n1557#2:574\n1628#2,3:575\n1368#2:578\n1454#2,5:579\n1863#2:584\n3467#2,10:585\n1864#2:595\n1557#2:596\n1628#2,3:597\n1557#2:600\n1628#2,3:601\n1#3:529\n*S KotlinDebug\n*F\n+ 1 ShapeContour.kt\norg/openrndr/shape/ShapeContour\n*L\n102#1:516,2\n158#1:518\n158#1:519,3\n265#1:522,3\n313#1:525\n313#1:526,3\n440#1:530\n440#1:531,3\n440#1:534,14\n482#1:548\n482#1:549,3\n120#1:552\n120#1:553,5\n131#1:558\n132#1:559,10\n131#1:569\n491#1:570\n491#1:571,3\n498#1:574\n498#1:575,3\n120#1:578\n120#1:579,5\n131#1:584\n132#1:585,10\n131#1:595\n491#1:596\n491#1:597,3\n498#1:600\n498#1:601,3\n*E\n"})
public final class ShapeContour
implements ShapeProvider,
ShapeContourProvider,
Path<Vector2> {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final List<Segment2D> segments;
    private final boolean closed;
    @NotNull
    private final YPolarity polarity;
    @NotNull
    private final Lazy length$delegate;
    @NotNull
    private final Vector2 infinity;
    @NotNull
    private final Lazy bounds$delegate;
    @NotNull
    private final Lazy winding$delegate;
    @NotNull
    private final ResettableDelegate<Path2> path2Delegate;
    @NotNull
    private final ResettableDelegate<Ring2> ring2Delegate;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;
    @NotNull
    private static final ShapeContour EMPTY;

    public ShapeContour(@NotNull List<Segment2D> segments, boolean closed, @NotNull YPolarity polarity) {
        Intrinsics.checkNotNullParameter(segments, "segments");
        Intrinsics.checkNotNullParameter((Object)polarity, "polarity");
        this.segments = segments;
        this.closed = closed;
        this.polarity = polarity;
        Iterable $this$forEach$iv = CollectionsKt.zipWithNext((Iterable)this.getSegments());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            double d = ((Segment2D)it.getFirst()).getEnd().minus(((Segment2D)it.getSecond()).getStart()).length();
            if (d < 1.0E-6) continue;
            boolean bl2 = false;
            String string = "points are too far away from each other " + ((Segment2D)it.getFirst()).getEnd() + " " + ((Segment2D)it.getSecond()).getStart() + " " + d;
            throw new IllegalArgumentException(string.toString());
        }
        this.length$delegate = LazyKt.lazy(() -> ShapeContour.length_delegate$lambda$3(this));
        this.infinity = Vector2.Companion.getINFINITY();
        this.bounds$delegate = LazyKt.lazy(() -> ShapeContour.bounds_delegate$lambda$5(this));
        this.winding$delegate = LazyKt.lazy(() -> ShapeContour.winding_delegate$lambda$8(this));
        this.path2Delegate = ResettableDelegateKt.resettableLazy(() -> ShapeContour.path2Delegate$lambda$19(this));
        this.ring2Delegate = ResettableDelegateKt.resettableLazy(() -> ShapeContour.ring2Delegate$lambda$21(this));
    }

    public /* synthetic */ ShapeContour(List list, boolean bl, YPolarity yPolarity, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            yPolarity = YPolarity.CW_NEGATIVE_Y;
        }
        this(list, bl, yPolarity);
    }

    @Override
    @NotNull
    public List<Segment2D> getSegments() {
        return this.segments;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @NotNull
    public final YPolarity getPolarity() {
        return this.polarity;
    }

    @Override
    @NotNull
    public Shape getShape() {
        return new Shape(CollectionsKt.listOf(this));
    }

    @Override
    public double getLength() {
        Lazy lazy = this.length$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    @Override
    @NotNull
    public Vector2 getInfinity() {
        return this.infinity;
    }

    @NotNull
    public final Rectangle getBounds() {
        Lazy lazy = this.bounds$delegate;
        return (Rectangle)lazy.getValue();
    }

    @NotNull
    public final Winding getWinding() {
        Lazy lazy = this.winding$delegate;
        return (Winding)((Object)lazy.getValue());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ShapeContour> getExploded() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getSegments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment2D segment2D = (Segment2D)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ShapeContour(CollectionsKt.listOf(it), false, this.polarity));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ void getExploded$annotations() {
    }

    @NotNull
    public final ShapeContour getClockwise() {
        return this.getWinding() == Winding.CLOCKWISE ? this : this.getReversed();
    }

    @NotNull
    public final ShapeContour getCounterClockwise() {
        return this.getWinding() == Winding.COUNTER_CLOCKWISE ? this : this.getReversed();
    }

    @NotNull
    public final ShapeContour plus(@NotNull ShapeContour other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (!(this.polarity == other.polarity)) {
            boolean bl = false;
            String string = "shapes have mixed polarities";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.getSegments().isEmpty() && other.getSegments().isEmpty()) {
            return EMPTY;
        }
        if (this.getSegments().isEmpty()) {
            return other;
        }
        if (other.getSegments().isEmpty()) {
            return this;
        }
        List segments = new ArrayList();
        segments.addAll((Collection)this.getSegments());
        if (this.getSegments().get(this.getSegments().size() - 1).getEnd().minus(other.getSegments().get(0).getStart()).length() > 1.0E-6) {
            segments.add(Segment2DKt.Segment2D$default(this.getSegments().get(this.getSegments().size() - 1).getEnd(), other.getSegments().get(0).getStart(), false, 4, null));
        }
        segments.addAll((Collection)other.getSegments());
        return new ShapeContour(segments, false, this.polarity);
    }

    @Override
    public boolean getEmpty() {
        return this == EMPTY || this.getSegments().isEmpty();
    }

    @NotNull
    public final Vector2 normal(double ut) {
        Vector2 vector2;
        if (this.getEmpty()) {
            return Vector2.Companion.getZERO();
        }
        double t = RangesKt.coerceIn(ut, 0.0, 1.0);
        if (t == 0.0) {
            vector2 = this.getSegments().get(0).normal(0.0, this.polarity);
        } else if (t == 1.0) {
            vector2 = CollectionsKt.last(this.getSegments()).normal(1.0, this.polarity);
        } else {
            Pair<Integer, Double> pair = this.segment(t);
            int segment = ((Number)pair.component1()).intValue();
            double segmentOffset = ((Number)pair.component2()).doubleValue();
            vector2 = this.getSegments().get(segment).normal(segmentOffset, this.polarity);
        }
        return vector2;
    }

    @NotNull
    public final Matrix44 pose(double t) {
        Vector2 n = this.normal(t);
        Vector4 dx = n.perpendicular(this.polarity).xy0().xyz0();
        Vector4 dy = n.xy0().xyz0();
        Vector4 dt = ((Vector2)this.position(t)).xy01();
        return Matrix44.Companion.fromColumnVectors(dx, dy, Vector4.Companion.getUNIT_Z(), dt);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<List<Vector2>, List<Boolean>> adaptivePositionsAndCorners(double distanceTolerance) {
        if (this.getEmpty()) {
            return new Pair<List<Vector2>, List<Boolean>>(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
        List adaptivePoints = new ArrayList();
        List corners = new ArrayList();
        for (Segment2D segment : this.getSegments()) {
            List<Vector2> samples2 = segment.adaptivePositions(distanceTolerance);
            int lastSampleIndex = samples2.size() - 1;
            Iterable $this$forEachIndexed$iv = samples2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void it;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Vector2 vector2 = (Vector2)item$iv;
                int index = n;
                boolean bl = false;
                Vector2 last2 = (Vector2)CollectionsKt.lastOrNull(adaptivePoints);
                if (last2 != null && !(last2.squaredDistanceTo((Vector2)it) > 0.0)) continue;
                adaptivePoints.add(it);
                boolean bl2 = index == 0 || index == lastSampleIndex ? corners.add(segment.getCorner()) : corners.add(false);
            }
        }
        return new Pair<List<Vector2>, List<Boolean>>(adaptivePoints, corners);
    }

    public static /* synthetic */ Pair adaptivePositionsAndCorners$default(ShapeContour shapeContour, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return shapeContour.adaptivePositionsAndCorners(d);
    }

    @NotNull
    public final ShapeContour sampleLinear(double distanceTolerance) {
        return this.getEmpty() ? EMPTY : Companion.fromPoints(this.adaptivePositions(distanceTolerance), this.getClosed(), this.polarity);
    }

    public static /* synthetic */ ShapeContour sampleLinear$default(ShapeContour shapeContour, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return shapeContour.sampleLinear(d);
    }

    @NotNull
    public final ShapeContour sampleEquidistant(int pointCount) {
        return this.getEmpty() ? EMPTY : Companion.fromPoints(Path.DefaultImpls.equidistantPositions$default(this, RangesKt.coerceAtLeast(pointCount, 2), 0.0, 2, null), this.getClosed(), this.polarity);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShapeContour transform(@NotNull Matrix44 transform2) {
        ShapeContour shapeContour;
        Intrinsics.checkNotNullParameter(transform2, "transform");
        if (this.getEmpty()) {
            shapeContour = EMPTY;
        } else if (transform2 == Matrix44.Companion.getIDENTITY()) {
            shapeContour = this;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getSegments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Segment2D segment2D = (Segment2D)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.transform(transform2));
            }
            YPolarity yPolarity = this.polarity;
            boolean bl = this.getClosed();
            List list = (List)destination$iv$iv;
            shapeContour = new ShapeContour(list, bl, yPolarity);
        }
        return shapeContour;
    }

    @NotNull
    public ShapeContour sub(double t0, double t1) {
        double length;
        int segment0;
        if (this.getEmpty()) {
            return EMPTY;
        }
        if (!(t0 == t0)) {
            boolean $i$a$-require-ShapeContour$sub$32 = false;
            String $i$a$-require-ShapeContour$sub$32 = "t0 is NaN";
            throw new IllegalArgumentException($i$a$-require-ShapeContour$sub$32.toString());
        }
        if (!(t1 == t1)) {
            boolean bl = false;
            String string = "t1 is NaN";
            throw new IllegalArgumentException(string.toString());
        }
        if (Math.abs(t0 - t1) < 1.0E-6) {
            return EMPTY;
        }
        double u0 = t0;
        double u1 = t1;
        if (this.getClosed() && (u1 < u0 || u1 > 1.0 || u0 > 1.0 || u0 < 0.0 || u1 < 0.0)) {
            double diff = u1 - u0;
            double d = u0;
            double d2 = 1.0;
            double d3 = d % d2;
            double d4 = !(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d2)) ? d3 + d2 : (u0 = d3);
            if (Math.abs(diff) < 0.999999) {
                return diff > 0.0 ? ((u1 = u0 + diff) > 1.0 ? this.sub(u0, 1.0).plus(this.sub(0.0, u1 - 1.0)) : this.sub(u0, u1)) : ((u1 = u0 + diff) < 0.0 ? this.sub(u1 + 1.0, 1.0).plus(this.sub(0.0, u0)) : this.sub(u1, u0));
            }
            double d5 = u1 = diff < 0.0 ? u0 - 1.0 : u0 + 1.0;
            if (u1 > 1.0) {
                return this.sub(u0, 1.0).plus(this.sub(0.0, u1 - 1.0));
            }
            if (u1 < 1.0) {
                return this.sub(u0, 1.0).plus(this.sub(0.0, u1 + 1.0));
            }
        }
        u0 = RangesKt.coerceIn(u0, 0.0, 1.0);
        u1 = RangesKt.coerceIn(u1, 0.0, 1.0);
        double z0 = u0;
        double z1 = u1;
        if (u0 > u1) {
            z0 = u1;
            z1 = u0;
        }
        double segmentOffset0 = (segment0 = (int)(z0 * (length = (double)this.getSegments().size()))) < this.getSegments().size() ? z0 * length % 1.0 : 1.0;
        int segment1 = (int)(z1 * length);
        double segmentOffset1 = segment1 < this.getSegments().size() ? z1 * length % 1.0 : 1.0;
        segment1 = Math.min(this.getSegments().size() - 1, segment1);
        segment0 = Math.min(this.getSegments().size() - 1, segment0);
        List newSegments = new ArrayList();
        int s = segment0;
        int n = segment1;
        if (s <= n) {
            while (true) {
                if (s == segment0 && s == segment1) {
                    newSegments.add(this.getSegments().get(s).sub(segmentOffset0, segmentOffset1));
                } else if (s == segment0) {
                    if (segmentOffset0 < 0.999999) {
                        newSegments.add(this.getSegments().get(s).sub(segmentOffset0, 1.0));
                    }
                } else if (s == segment1) {
                    if (segmentOffset1 > 1.0E-6) {
                        newSegments.add(this.getSegments().get(s).sub(0.0, segmentOffset1));
                    }
                } else {
                    newSegments.add(this.getSegments().get(s));
                }
                if (s == n) break;
                ++s;
            }
        }
        return new ShapeContour(newSegments, false, this.polarity);
    }

    @Nullable
    public final Double on(@NotNull Vector2 point, double error) {
        Intrinsics.checkNotNullParameter(point, "point");
        int n = ((Collection)this.getSegments()).size();
        for (int i = 0; i < n; ++i) {
            Double st = this.getSegments().get(i).on(point, error);
            if (st == null) continue;
            return ((double)i + st) / (double)this.getSegments().size();
        }
        return null;
    }

    public static /* synthetic */ Double on$default(ShapeContour shapeContour, Vector2 vector2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 5.0;
        }
        return shapeContour.on(vector2, d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ContourPoint nearest(@NotNull Vector2 point) {
        Object v0;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(point, "point");
        Iterable $this$map$iv = this.getSegments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment2D segment2D = (Segment2D)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.nearest(point));
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                SegmentPoint it = (SegmentPoint)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.position().distanceTo(point);
                do {
                    Object e$iv = iterator$iv.next();
                    SegmentPoint it2 = (SegmentPoint)e$iv;
                    $i$a$-minByOrNull-ShapeContour$nearest$n$2 = false;
                    double v$iv = it2.position().distanceTo(point);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        SegmentPoint segmentPoint = v0;
        if (segmentPoint == null) {
            throw new IllegalStateException("no segments".toString());
        }
        SegmentPoint n = segmentPoint;
        int segmentIndex = this.getSegments().indexOf(n.segment());
        double t = ((double)segmentIndex + n.segmentT()) / (double)this.getSegments().size();
        return new ContourPoint(this, t, n.segment(), n.segmentT(), n.position());
    }

    @NotNull
    public final ShapeContour getOpen() {
        return this.getEmpty() ? EMPTY : new ShapeContour(this.getSegments(), false, this.polarity);
    }

    @NotNull
    public final ShapeContour close() {
        return this.getEmpty() ? EMPTY : (CollectionsKt.last(this.getSegments()).getEnd().minus(CollectionsKt.first(this.getSegments()).getStart()).squaredLength() < 1.0E-6 ? new ShapeContour(this.getSegments(), true, this.polarity) : new ShapeContour(CollectionsKt.plus((Collection)this.getSegments(), Segment2DKt.Segment2D$default(CollectionsKt.last(this.getSegments()).getEnd(), CollectionsKt.first(this.getSegments()).getStart(), false, 4, null)), true, this.polarity));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShapeContour getReversed() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getSegments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment2D segment2D = (Segment2D)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getReverse());
        }
        YPolarity yPolarity = this.polarity;
        boolean bl = this.getClosed();
        List<Segment2D> list = CollectionsKt.reversed((List)destination$iv$iv);
        return new ShapeContour(list, bl, yPolarity);
    }

    @Override
    @NotNull
    public ShapeContour getContour() {
        return this;
    }

    @Transient
    private static /* synthetic */ void getPath2Delegate$annotations() {
    }

    @NotNull
    public final Path2 getPath2$openrndr_shape() {
        return this.path2Delegate.getValue(this, $$delegatedProperties[0]);
    }

    private static Object getPath2$openrndr_shape$delegate(ShapeContour shapeContour) {
        return shapeContour.path2Delegate;
    }

    @Transient
    private static /* synthetic */ void getRing2Delegate$annotations() {
    }

    @NotNull
    public final Ring2 getRing2$openrndr_shape() {
        return this.ring2Delegate.getValue(this, $$delegatedProperties[1]);
    }

    private static Object getRing2$openrndr_shape$delegate(ShapeContour shapeContour) {
        return shapeContour.ring2Delegate;
    }

    public final void resetCache() {
        this.path2Delegate.reset();
        this.ring2Delegate.reset();
    }

    @NotNull
    public final List<Segment2D> component1() {
        return this.segments;
    }

    public final boolean component2() {
        return this.closed;
    }

    @NotNull
    public final YPolarity component3() {
        return this.polarity;
    }

    @NotNull
    public final ShapeContour copy(@NotNull List<Segment2D> segments, boolean closed, @NotNull YPolarity polarity) {
        Intrinsics.checkNotNullParameter(segments, "segments");
        Intrinsics.checkNotNullParameter((Object)polarity, "polarity");
        return new ShapeContour(segments, closed, polarity);
    }

    public static /* synthetic */ ShapeContour copy$default(ShapeContour shapeContour, List list, boolean bl, YPolarity yPolarity, int n, Object object) {
        if ((n & 1) != 0) {
            list = shapeContour.segments;
        }
        if ((n & 2) != 0) {
            bl = shapeContour.closed;
        }
        if ((n & 4) != 0) {
            yPolarity = shapeContour.polarity;
        }
        return shapeContour.copy(list, bl, yPolarity);
    }

    @NotNull
    public String toString() {
        return "ShapeContour(segments=" + this.segments + ", closed=" + this.closed + ", polarity=" + this.polarity + ")";
    }

    public int hashCode() {
        int result = ((Object)this.segments).hashCode();
        result = result * 31 + Boolean.hashCode(this.closed);
        result = result * 31 + this.polarity.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ShapeContour)) {
            return false;
        }
        ShapeContour shapeContour = (ShapeContour)other;
        if (!Intrinsics.areEqual(this.segments, shapeContour.segments)) {
            return false;
        }
        if (this.closed != shapeContour.closed) {
            return false;
        }
        return this.polarity == shapeContour.polarity;
    }

    @Override
    @NotNull
    public Vector2 position(double ut) {
        return Path.DefaultImpls.position(this, ut);
    }

    @Override
    @NotNull
    public Vector2 direction(double ut) {
        return Path.DefaultImpls.direction(this, ut);
    }

    @Override
    public double curvature(double ut) {
        return Path.DefaultImpls.curvature(this, ut);
    }

    @Override
    public double tForLength(double length) {
        return Path.DefaultImpls.tForLength(this, length);
    }

    @Override
    @NotNull
    public Pair<Integer, Double> segment(double ut) {
        return Path.DefaultImpls.segment(this, ut);
    }

    @Override
    @NotNull
    public Vector2 pointAtLength(double length, double distanceTolerance) {
        return Path.DefaultImpls.pointAtLength(this, length, distanceTolerance);
    }

    @Override
    @NotNull
    public List<Vector2> adaptivePositions(double distanceTolerance) {
        return Path.DefaultImpls.adaptivePositions(this, distanceTolerance);
    }

    @Override
    @NotNull
    public List<Pair<Vector2, Double>> adaptivePositionsWithT(double distanceTolerance) {
        return Path.DefaultImpls.adaptivePositionsWithT(this, distanceTolerance);
    }

    @Override
    @NotNull
    public List<Vector2> equidistantPositions(int pointCount, double distanceTolerance) {
        return Path.DefaultImpls.equidistantPositions(this, pointCount, distanceTolerance);
    }

    @Override
    @NotNull
    public List<Pair<Vector2, Double>> equidistantPositionsWithT(int pointCount, double distanceTolerance) {
        return Path.DefaultImpls.equidistantPositionsWithT(this, pointCount, distanceTolerance);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_shape(ShapeContour self, CompositeEncoder output, SerialDescriptor serialDesc) {
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.getSegments());
        output.encodeBooleanElement(serialDesc, 1, self.getClosed());
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.polarity != YPolarity.CW_NEGATIVE_Y) {
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)kSerializerArray[2], self.polarity);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : !Intrinsics.areEqual(self.getInfinity(), Vector2.Companion.getINFINITY())) {
            output.encodeSerializableElement(serialDesc, 3, Vector2$.serializer.INSTANCE, self.getInfinity());
        }
    }

    public /* synthetic */ ShapeContour(int seen0, List segments, boolean closed, YPolarity polarity, Vector2 infinity, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 3, $serializer.INSTANCE.getDescriptor());
        }
        this.segments = segments;
        this.closed = closed;
        this.polarity = (seen0 & 4) == 0 ? YPolarity.CW_NEGATIVE_Y : polarity;
        Iterable $this$forEach$iv = CollectionsKt.zipWithNext((Iterable)this.getSegments());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            double d = ((Segment2D)it.getFirst()).getEnd().minus(((Segment2D)it.getSecond()).getStart()).length();
            if (d < 1.0E-6) continue;
            boolean bl2 = false;
            String string = "points are too far away from each other " + ((Segment2D)it.getFirst()).getEnd() + " " + ((Segment2D)it.getSecond()).getStart() + " " + d;
            throw new IllegalArgumentException(string.toString());
        }
        this.length$delegate = LazyKt.lazy(() -> ShapeContour._init_$lambda$25(this));
        this.infinity = (seen0 & 8) == 0 ? Vector2.Companion.getINFINITY() : infinity;
        this.bounds$delegate = LazyKt.lazy(() -> ShapeContour._init_$lambda$27(this));
        this.winding$delegate = LazyKt.lazy(() -> ShapeContour._init_$lambda$30(this));
        this.path2Delegate = ResettableDelegateKt.resettableLazy(() -> ShapeContour._init_$lambda$32(this));
        this.ring2Delegate = ResettableDelegateKt.resettableLazy(() -> ShapeContour._init_$lambda$34(this));
    }

    /*
     * WARNING - void declaration
     */
    private static final double length_delegate$lambda$3(ShapeContour this$0) {
        Iterable iterable = this$0.getSegments();
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            Segment2D segment2D = (Segment2D)t;
            double d2 = d;
            boolean bl = false;
            double d3 = it.getLength();
            d = d2 + d3;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    private static final Rectangle bounds_delegate$lambda$5(ShapeContour this$0) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = ShapeContour.sampleLinear$default(this$0, 0.0, 1, null).getSegments();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Segment2D it = (Segment2D)element$iv$iv;
            boolean bl = false;
            Vector2[] vector2Array = new Vector2[]{it.getStart(), it.getEnd()};
            Iterable list$iv$iv = CollectionsKt.listOf(vector2Array);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return RectangleKt.getVector2Bounds((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final Winding winding_delegate$lambda$8(ShapeContour this$0) {
        double sum = 0.0;
        Iterable $this$forEach$iv = this$0.getSegments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Segment2D s = (Segment2D)element$iv;
            boolean bl = false;
            Iterable $this$zipWithNext$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf(s.getStart()), (Iterable)s.getControl()), (Iterable)CollectionsKt.listOf(s.getEnd()));
            boolean $i$f$zipWithNext = false;
            Iterator iterator$iv = $this$zipWithNext$iv.iterator();
            if (!iterator$iv.hasNext()) {
                CollectionsKt.emptyList();
                continue;
            }
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void a;
                void b;
                Object next$iv = iterator$iv.next();
                Vector2 vector2 = (Vector2)next$iv;
                Vector2 vector22 = (Vector2)current$iv;
                List list = result$iv;
                boolean bl2 = false;
                sum += (b.x() - a.x()) * (b.y() + a.y());
                list.add(Unit.INSTANCE);
                current$iv = next$iv;
            }
        }
        Vector2 start = CollectionsKt.first(this$0.getSegments()).getStart();
        Vector2 end = CollectionsKt.last(this$0.getSegments()).getEnd();
        sum += (start.x() - end.x()) * (start.y() + end.y());
        return switch (WhenMappings.$EnumSwitchMapping$0[this$0.polarity.ordinal()]) {
            case 1 -> {
                if (sum < 0.0) {
                    yield Winding.COUNTER_CLOCKWISE;
                }
                yield Winding.CLOCKWISE;
            }
            case 2 -> {
                if (sum < 0.0) {
                    yield Winding.CLOCKWISE;
                }
                yield Winding.COUNTER_CLOCKWISE;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final Path2 path2Delegate$lambda$19(ShapeContour this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.getSegments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment2D segment2D = (Segment2D)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ShapeArtifexKt.toCurve2((Segment2D)it));
        }
        return Path2Kt.Path2((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final Ring2 ring2Delegate$lambda$21(ShapeContour this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.getSegments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment2D segment2D = (Segment2D)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ShapeArtifexKt.toCurve2((Segment2D)it));
        }
        Iterable iterable2 = (List)destination$iv$iv;
        return new Ring2(iterable2);
    }

    /*
     * WARNING - void declaration
     */
    private static final double _init_$lambda$25(ShapeContour this$0) {
        Iterable iterable = this$0.getSegments();
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            Segment2D segment2D = (Segment2D)t;
            double d2 = d;
            boolean bl = false;
            double d3 = it.getLength();
            d = d2 + d3;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    private static final Rectangle _init_$lambda$27(ShapeContour this$0) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = ShapeContour.sampleLinear$default(this$0, 0.0, 1, null).getSegments();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Segment2D it = (Segment2D)element$iv$iv;
            boolean bl = false;
            Vector2[] vector2Array = new Vector2[]{it.getStart(), it.getEnd()};
            Iterable list$iv$iv = CollectionsKt.listOf(vector2Array);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return RectangleKt.getVector2Bounds((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final Winding _init_$lambda$30(ShapeContour this$0) {
        double sum = 0.0;
        Iterable $this$forEach$iv = this$0.getSegments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Segment2D s = (Segment2D)element$iv;
            boolean bl = false;
            Iterable $this$zipWithNext$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf(s.getStart()), (Iterable)s.getControl()), (Iterable)CollectionsKt.listOf(s.getEnd()));
            boolean $i$f$zipWithNext = false;
            Iterator iterator$iv = $this$zipWithNext$iv.iterator();
            if (!iterator$iv.hasNext()) {
                CollectionsKt.emptyList();
                continue;
            }
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void a;
                void b;
                Object next$iv = iterator$iv.next();
                Vector2 vector2 = (Vector2)next$iv;
                Vector2 vector22 = (Vector2)current$iv;
                List list = result$iv;
                boolean bl2 = false;
                sum += (b.x() - a.x()) * (b.y() + a.y());
                list.add(Unit.INSTANCE);
                current$iv = next$iv;
            }
        }
        Vector2 start = CollectionsKt.first(this$0.getSegments()).getStart();
        Vector2 end = CollectionsKt.last(this$0.getSegments()).getEnd();
        sum += (start.x() - end.x()) * (start.y() + end.y());
        return switch (WhenMappings.$EnumSwitchMapping$0[this$0.polarity.ordinal()]) {
            case 1 -> {
                if (sum < 0.0) {
                    yield Winding.COUNTER_CLOCKWISE;
                }
                yield Winding.CLOCKWISE;
            }
            case 2 -> {
                if (sum < 0.0) {
                    yield Winding.CLOCKWISE;
                }
                yield Winding.COUNTER_CLOCKWISE;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final Path2 _init_$lambda$32(ShapeContour this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.getSegments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment2D segment2D = (Segment2D)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ShapeArtifexKt.toCurve2((Segment2D)it));
        }
        return Path2Kt.Path2((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final Ring2 _init_$lambda$34(ShapeContour this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.getSegments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment2D segment2D = (Segment2D)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ShapeArtifexKt.toCurve2((Segment2D)it));
        }
        Iterable iterable2 = (List)destination$iv$iv;
        return new Ring2(iterable2);
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ShapeContour.class, "path2", "getPath2$openrndr_shape()Lorg/openrndr/kartifex/Path2;", 0)), Reflection.property1(new PropertyReference1Impl(ShapeContour.class, "ring2", "getRing2$openrndr_shape()Lorg/openrndr/kartifex/Ring2;", 0))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new KSerializer[]{new ArrayListSerializer(Segment2D$.serializer.INSTANCE), null, EnumsKt.createSimpleEnumSerializer((String)"org.openrndr.math.YPolarity", (Enum[])YPolarity.values()), null};
        $childSerializers = objectArray;
        EMPTY = new ShapeContour(CollectionsKt.emptyList(), false, null, 4, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J&\u0010\u0012\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/openrndr/shape/ShapeContour$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/openrndr/shape/ShapeContour;", "getEMPTY", "()Lorg/openrndr/shape/ShapeContour;", "fromSegments", "segments", "", "Lorg/openrndr/shape/Segment2D;", "closed", "", "polarity", "Lorg/openrndr/math/YPolarity;", "distanceTolerance", "", "fromPoints", "points", "Lorg/openrndr/math/Vector2;", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-shape"})
    @SourceDebugExtension(value={"SMAP\nShapeContour.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShapeContour.kt\norg/openrndr/shape/ShapeContour$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,515:1\n1557#2:516\n1628#2,3:517\n1557#2:520\n1628#2,3:521\n1557#2:524\n1628#2,3:525\n*S KotlinDebug\n*F\n+ 1 ShapeContour.kt\norg/openrndr/shape/ShapeContour$Companion\n*L\n55#1:516\n55#1:517,3\n82#1:520\n82#1:521,3\n91#1:524\n91#1:525,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ShapeContour getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ShapeContour fromSegments(@NotNull List<Segment2D> segments, boolean closed, @NotNull YPolarity polarity, double distanceTolerance) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(segments, "segments");
            Intrinsics.checkNotNullParameter((Object)polarity, "polarity");
            if (segments.isEmpty()) {
                return this.getEMPTY();
            }
            Iterable $this$map$iv = CollectionsKt.zipWithNext((Iterable)segments);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                double distance = ((Segment2D)it.getFirst()).getEnd().squaredDistanceTo(((Segment2D)it.getSecond()).getStart());
                if (!(distance < distanceTolerance)) {
                    boolean bl2 = false;
                    String string = "distance between segment end and start is " + distance + " (max: " + distanceTolerance + ")";
                    throw new IllegalArgumentException(string.toString());
                }
                collection.add(Segment2D.copy$default((Segment2D)it.getFirst(), null, null, ((Segment2D)it.getSecond()).getStart(), false, 11, null));
            }
            YPolarity yPolarity = polarity;
            boolean bl = closed;
            List<Segment2D> list = CollectionsKt.plus((Collection)((List)destination$iv$iv), CollectionsKt.last(segments));
            return new ShapeContour(list, bl, yPolarity);
        }

        public static /* synthetic */ ShapeContour fromSegments$default(Companion companion, List list, boolean bl, YPolarity yPolarity, double d, int n, Object object) {
            if ((n & 4) != 0) {
                yPolarity = YPolarity.CW_NEGATIVE_Y;
            }
            if ((n & 8) != 0) {
                d = 0.001;
            }
            return companion.fromSegments(list, bl, yPolarity, d);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ShapeContour fromPoints(@NotNull List<Vector2> points2, boolean closed, @NotNull YPolarity polarity) {
            ShapeContour shapeContour;
            Intrinsics.checkNotNullParameter(points2, "points");
            Intrinsics.checkNotNullParameter((Object)polarity, "polarity");
            if (points2.isEmpty()) {
                shapeContour = this.getEMPTY();
            } else if (!closed) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = RangesKt.until(0, points2.size() - 1);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Segment2DKt.Segment2D$default(points2.get((int)it), points2.get((int)(it + true)), false, 4, null));
                }
                YPolarity yPolarity = polarity;
                boolean bl = closed;
                List list = (List)destination$iv$iv;
                shapeContour = new ShapeContour(list, bl, yPolarity);
            } else {
                void $this$mapTo$iv$iv;
                double d = CollectionsKt.last(points2).minus(CollectionsKt.first(points2)).squaredLength();
                List<Vector2> usePoints = d > 1.0E-6 ? points2 : CollectionsKt.dropLast(points2, 1);
                Iterable $this$map$iv = CollectionsKt.getIndices((Collection)usePoints);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator3 = $this$mapTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator3).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Segment2DKt.Segment2D$default(usePoints.get((int)it), usePoints.get((int)((it + true) % usePoints.size())), false, 4, null));
                }
                YPolarity yPolarity = polarity;
                boolean bl = true;
                List list = (List)destination$iv$iv;
                shapeContour = new ShapeContour(list, bl, yPolarity);
            }
            return shapeContour;
        }

        public static /* synthetic */ ShapeContour fromPoints$default(Companion companion, List list, boolean bl, YPolarity yPolarity, int n, Object object) {
            if ((n & 4) != 0) {
                yPolarity = YPolarity.CW_NEGATIVE_Y;
            }
            return companion.fromPoints(list, bl, yPolarity);
        }

        @NotNull
        public final KSerializer<ShapeContour> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[YPolarity.values().length];
            try {
                nArray[YPolarity.CCW_POSITIVE_Y.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[YPolarity.CW_NEGATIVE_Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

