/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.IntVector3;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lorg/openrndr/shape/IntBox;", "", "corner", "Lorg/openrndr/math/IntVector3;", "width", "", "height", "depth", "<init>", "(Lorg/openrndr/math/IntVector3;III)V", "getCorner", "()Lorg/openrndr/math/IntVector3;", "getWidth", "()I", "getHeight", "getDepth", "xRange", "Lkotlin/ranges/IntRange;", "getXRange", "()Lkotlin/ranges/IntRange;", "yRange", "getYRange", "zRange", "getZRange", "openrndr-shape"})
public final class IntBox {
    @NotNull
    private final IntVector3 corner;
    private final int width;
    private final int height;
    private final int depth;

    public IntBox(@NotNull IntVector3 corner, int width, int height, int depth) {
        Intrinsics.checkNotNullParameter(corner, "corner");
        this.corner = corner;
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    @NotNull
    public final IntVector3 getCorner() {
        return this.corner;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getDepth() {
        return this.depth;
    }

    @NotNull
    public final IntRange getXRange() {
        return RangesKt.until(Math.min(this.corner.x(), this.corner.x() + this.width), Math.max(this.corner.x(), this.corner.x() + this.width));
    }

    @NotNull
    public final IntRange getYRange() {
        return RangesKt.until(Math.min(this.corner.y(), this.corner.y() + this.height), Math.max(this.corner.y(), this.corner.y() + this.height));
    }

    @NotNull
    public final IntRange getZRange() {
        return RangesKt.until(Math.min(this.corner.z(), this.corner.z() + this.depth), Math.max(this.corner.z(), this.corner.z() + this.depth));
    }
}

