/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.LinearType;
import org.openrndr.math.Polar;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector2$;
import org.openrndr.shape.Circle$;
import org.openrndr.shape.CircleKt;
import org.openrndr.shape.ContourBuilder;
import org.openrndr.shape.Movable;
import org.openrndr.shape.Scalable1D;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeBuilderKt;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeContourProvider;
import org.openrndr.shape.ShapeProvider;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 F2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\b\u0012\u0004\u0012\u00020\u00000\u00052\u00020\u0006:\u0002FGB\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB-\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u000b\u0010\u0011J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\bH\u0007J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\nH\u0007J \u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\nH\u0016J\u0011\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\bH\u0086\u0002J*\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0.0-2\u0006\u0010/\u001a\u00020\u00002\b\b\u0002\u00100\u001a\u00020#J\u001a\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0.2\u0006\u0010$\u001a\u00020\bJ\u0011\u00101\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\nH\u0096\u0002J\u0011\u00102\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\nH\u0096\u0002J\u0011\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0000H\u0096\u0002J\u0011\u00105\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0000H\u0096\u0002J\t\u00106\u001a\u00020\bH\u00c6\u0003J\t\u00107\u001a\u00020\nH\u00c6\u0003J\u001d\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u00109\u001a\u00020#2\b\u0010/\u001a\u0004\u0018\u00010:H\u00d6\u0003J\t\u0010;\u001a\u00020\u000eH\u00d6\u0001J\t\u0010<\u001a\u00020=H\u00d6\u0001J%\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0001\u00a2\u0006\u0002\bER\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010%\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0013R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010(R\u0014\u0010)\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010+\u00a8\u0006H"}, d2={"Lorg/openrndr/shape/Circle;", "Lorg/openrndr/shape/Movable;", "Lorg/openrndr/shape/Scalable1D;", "Lorg/openrndr/shape/ShapeProvider;", "Lorg/openrndr/shape/ShapeContourProvider;", "Lorg/openrndr/math/LinearType;", "Ljava/lang/Record;", "center", "Lorg/openrndr/math/Vector2;", "radius", "", "<init>", "(Lorg/openrndr/math/Vector2;D)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILorg/openrndr/math/Vector2;DLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()Lorg/openrndr/math/Vector2;", "()D", "corner", "scale", "moved", "offset", "movedBy", "movedTo", "scaled", "scaledBy", "uAnchor", "vAnchor", "scaledTo", "position", "u", "v", "contains", "", "point", "area", "shape", "Lorg/openrndr/shape/Shape;", "()Lorg/openrndr/shape/Shape;", "contour", "Lorg/openrndr/shape/ShapeContour;", "()Lorg/openrndr/shape/ShapeContour;", "tangents", "", "Lkotlin/Pair;", "other", "isInner", "times", "div", "plus", "right", "minus", "component1", "component2", "copy", "equals", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_shape", "Companion", "$serializer", "openrndr-shape"})
@SourceDebugExtension(value={"SMAP\nCircle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Circle.kt\norg/openrndr/shape/Circle\n+ 2 Functions.kt\norg/openrndr/math/FunctionsKt\n*L\n1#1,199:1\n87#2:200\n*S KotlinDebug\n*F\n+ 1 Circle.kt\norg/openrndr/shape/Circle\n*L\n176#1:200\n*E\n"})
public final class Circle
extends Record
implements Movable,
Scalable1D,
ShapeProvider,
ShapeContourProvider,
LinearType<Circle> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector2 center;
    private final double radius;
    @NotNull
    private static final Circle INVALID = new Circle(Vector2.Companion.getINFINITY(), 0.0);

    public Circle(@NotNull Vector2 center, double radius) {
        Intrinsics.checkNotNullParameter(center, "center");
        this.center = center;
        this.radius = radius;
    }

    @NotNull
    public final Vector2 center() {
        return this.center;
    }

    public final double radius() {
        return this.radius;
    }

    @NotNull
    public final Vector2 corner() {
        return this.center.minus(this.scale());
    }

    @NotNull
    public Vector2 scale() {
        return new Vector2(this.radius);
    }

    @Deprecated(message="Vague naming", replaceWith=@ReplaceWith(expression="movedBy(offset)", imports={}))
    @NotNull
    public final Circle moved(@NotNull Vector2 offset) {
        Intrinsics.checkNotNullParameter(offset, "offset");
        return new Circle(this.center.plus(offset), this.radius);
    }

    @Override
    @NotNull
    public Circle movedBy(@NotNull Vector2 offset) {
        Intrinsics.checkNotNullParameter(offset, "offset");
        return new Circle(this.center.plus(offset), this.radius);
    }

    @Override
    @NotNull
    public Circle movedTo(@NotNull Vector2 center) {
        Intrinsics.checkNotNullParameter(center, "center");
        return new Circle(center, this.radius);
    }

    @Deprecated(message="Vague naming", replaceWith=@ReplaceWith(expression="scaledBy(scale)", imports={}))
    @NotNull
    public final Circle scaled(double scale) {
        return new Circle(this.center, this.radius * scale);
    }

    @Override
    @NotNull
    public Circle scaledBy(double scale, double uAnchor, double vAnchor) {
        Vector2 anchorPosition = this.position(uAnchor, vAnchor);
        return new Circle(anchorPosition, this.radius * scale);
    }

    @Override
    @NotNull
    public Circle scaledTo(double radius) {
        return new Circle(this.center, radius);
    }

    @Override
    @NotNull
    public Vector2 position(double u, double v) {
        return this.corner().plus(new Vector2(u * (double)2 * this.radius, v * (double)2 * this.radius));
    }

    public final boolean contains(@NotNull Vector2 point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return point.minus(this.center).squaredLength() < this.radius * this.radius;
    }

    public final double area() {
        return this.radius * this.radius * Math.PI;
    }

    @NotNull
    public Shape shape() {
        return new Shape(CollectionsKt.listOf(this.contour()));
    }

    @NotNull
    public ShapeContour contour() {
        if (Intrinsics.areEqual(this, INVALID)) {
            return ShapeContour.Companion.getEMPTY();
        }
        double x = this.center.x() - this.radius;
        double y = this.center.y() - this.radius;
        double width = this.radius * 2.0;
        double height = this.radius * 2.0;
        double kappa = 0.5522848;
        double ox = width / (double)2 * kappa;
        double oy = height / (double)2 * kappa;
        double xe = x + width;
        double ye = y + height;
        double xm = x + width / (double)2;
        double ym = y + height / (double)2;
        return ShapeBuilderKt.contour(arg_0 -> Circle._get_contour_$lambda$0(x, ym, oy, xm, ox, y, xe, ye, arg_0));
    }

    @NotNull
    public final List<Pair<Vector2, Vector2>> tangents(@NotNull Circle other, boolean isInner) {
        double rDiff;
        Intrinsics.checkNotNullParameter(other, "other");
        if (Intrinsics.areEqual(this, INVALID) || Intrinsics.areEqual(other, INVALID)) {
            return CollectionsKt.emptyList();
        }
        double distSq = this.center.squaredDistanceTo(other.center);
        if (isInner ? Math.sqrt(distSq) <= this.radius + other.radius : distSq <= (rDiff = this.radius - other.radius) * rDiff) {
            return CollectionsKt.emptyList();
        }
        double otherRadiusSigned = isInner ? -other.radius : other.radius;
        Vector2 hyp = other.center.minus(this.center);
        double adj = this.radius - otherRadiusSigned;
        Vector2 a = hyp.times(adj);
        Vector2 b = Vector2.perpendicular$default(hyp, null, 1, null).times(Math.sqrt(distSq - adj * adj));
        Vector2 v1 = a.minus(b).div(distSq);
        Vector2 v2 = a.plus(b).div(distSq);
        Pair[] pairArray = new Pair[]{new Pair<Vector2, Vector2>(this.center.plus(v1.times(this.radius)), other.center.plus(v1.times(otherRadiusSigned))), new Pair<Vector2, Vector2>(this.center.plus(v2.times(this.radius)), other.center.plus(v2.times(otherRadiusSigned)))};
        return CollectionsKt.listOf(pairArray);
    }

    public static /* synthetic */ List tangents$default(Circle circle, Circle circle2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return circle.tangents(circle2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Vector2, Vector2> tangents(@NotNull Vector2 point) {
        void $this$asDegrees$iv;
        Intrinsics.checkNotNullParameter(point, "point");
        if (Intrinsics.areEqual(this, INVALID)) {
            return new Pair<Vector2, Vector2>(Vector2.Companion.getINFINITY(), Vector2.Companion.getINFINITY());
        }
        Polar v = Polar.Companion.fromVector(point.minus(this.center));
        double b = v.radius();
        double d = Math.acos(this.radius / b);
        boolean $i$f$getAsDegrees = false;
        void theta = $this$asDegrees$iv * 57.29577951308232;
        double d1 = v.theta() + theta;
        double d2 = v.theta() - theta;
        Vector2 tp = this.center.plus(new Polar(d1, this.radius).cartesian());
        Vector2 tp2 = this.center.plus(new Polar(d2, this.radius).cartesian());
        return new Pair<Vector2, Vector2>(tp, tp2);
    }

    @Override
    @NotNull
    public Circle times(double scale) {
        return new Circle(this.center.times(scale), this.radius * scale);
    }

    @Override
    @NotNull
    public Circle div(double scale) {
        return new Circle(this.center.div(scale), this.radius / scale);
    }

    @Override
    @NotNull
    public Circle plus(@NotNull Circle right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Circle(this.center.plus(right.center), this.radius + right.radius);
    }

    @Override
    @NotNull
    public Circle minus(@NotNull Circle right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Circle(this.center.minus(right.center), this.radius - right.radius);
    }

    @NotNull
    public final Vector2 component1() {
        return this.center;
    }

    public final double component2() {
        return this.radius;
    }

    @NotNull
    public final Circle copy(@NotNull Vector2 center, double radius) {
        Intrinsics.checkNotNullParameter(center, "center");
        return new Circle(center, radius);
    }

    public static /* synthetic */ Circle copy$default(Circle circle, Vector2 vector2, double d, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = circle.center;
        }
        if ((n & 2) != 0) {
            d = circle.radius;
        }
        return circle.copy(vector2, d);
    }

    @Override
    @NotNull
    public String toString() {
        return "Circle(center=" + this.center + ", radius=" + this.radius + ")";
    }

    @Override
    public int hashCode() {
        int result = this.center.hashCode();
        result = result * 31 + Double.hashCode(this.radius);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Circle)) {
            return false;
        }
        Circle circle = (Circle)other;
        if (!Intrinsics.areEqual(this.center, circle.center)) {
            return false;
        }
        return Double.compare(this.radius, circle.radius) == 0;
    }

    @Override
    @NotNull
    public Vector2 position(@NotNull Vector2 uv) {
        return Scalable1D.DefaultImpls.position(this, uv);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_shape(Circle self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, Vector2$.serializer.INSTANCE, self.center);
        output.encodeDoubleElement(serialDesc, 1, self.radius);
    }

    public /* synthetic */ Circle(int seen0, Vector2 center, double radius, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 3, $serializer.INSTANCE.getDescriptor());
        }
        this.center = center;
        this.radius = radius;
    }

    private static final Unit _get_contour_$lambda$0(double $x, double $ym, double $oy, double $xm, double $ox, double $y, double $xe, double $ye, ContourBuilder $this$contour) {
        Intrinsics.checkNotNullParameter($this$contour, "$this$contour");
        $this$contour.moveTo(new Vector2($x, $ym));
        $this$contour.curveTo(new Vector2($x, $ym - $oy), new Vector2($xm - $ox, $y), new Vector2($xm, $y));
        $this$contour.curveTo(new Vector2($xm + $ox, $y), new Vector2($xe, $ym - $oy), new Vector2($xe, $ym));
        $this$contour.curveTo(new Vector2($xe, $ym + $oy), new Vector2($xm + $ox, $ye), new Vector2($xm, $ye));
        $this$contour.curveTo(new Vector2($xm - $ox, $ye), new Vector2($x, $ym + $oy), new Vector2($x, $ym));
        $this$contour.close();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/openrndr/shape/Circle$Companion;", "", "<init>", "()V", "INVALID", "Lorg/openrndr/shape/Circle;", "getINVALID", "()Lorg/openrndr/shape/Circle;", "fromPoints", "a", "Lorg/openrndr/math/Vector2;", "b", "c", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-shape"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Circle getINVALID() {
            return INVALID;
        }

        @NotNull
        public final Circle fromPoints(@NotNull Vector2 a, @NotNull Vector2 b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            Vector2 center = a.plus(b).times(0.5);
            return new Circle(center, b.minus(center).length());
        }

        @NotNull
        public final Circle fromPoints(@NotNull Vector2 a, @NotNull Vector2 b, @NotNull Vector2 c2) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            Intrinsics.checkNotNullParameter(c2, "c");
            double det = (a.x() - b.x()) * (b.y() - c2.y()) - (b.x() - c2.x()) * (a.y() - b.y());
            if (Math.abs(det) < 1.0E-7) {
                return this.getINVALID();
            }
            double offset = b.x() * b.x() + b.y() * b.y();
            double bc = (a.x() * a.x() + a.y() * a.y() - offset) / (double)2;
            double cd = (offset - c2.x() * c2.x() - c2.y() * c2.y()) / (double)2;
            double x = (bc * (b.y() - c2.y()) - cd * (a.y() - b.y())) / det;
            double y = (cd * (a.x() - b.x()) - bc * (b.x() - c2.x())) / det;
            double radius = Math.sqrt((b.x() - x) * (b.x() - x) + (b.y() - y) * (b.y() - y));
            return CircleKt.Circle(x, y, radius);
        }

        @NotNull
        public final KSerializer<Circle> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

