/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.poissonfill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ArrayCubemapAttachment;
import org.openrndr.draw.ArrayTextureAttachment;
import org.openrndr.draw.ColorAttachment;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferAttachment;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.CubemapAttachment;
import org.openrndr.draw.Filter;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.math.IntVector2;
import org.openrndr.poissonfill.Convolution;
import org.openrndr.poissonfill.ConvolutionPyramidKt;
import org.openrndr.poissonfill.Downscale;
import org.openrndr.poissonfill.Upscale;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,J\u0006\u0010/\u001a\u000200R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R\u000e\u0010\"\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/openrndr/poissonfill/ConvolutionPyramid;", "", "width", "", "height", "padding", "cutOff", "downscale", "Lorg/openrndr/poissonfill/Downscale;", "upscale", "Lorg/openrndr/poissonfill/Upscale;", "filter", "Lorg/openrndr/poissonfill/Convolution;", "type", "Lorg/openrndr/draw/ColorType;", "<init>", "(IIIILorg/openrndr/poissonfill/Downscale;Lorg/openrndr/poissonfill/Upscale;Lorg/openrndr/poissonfill/Convolution;Lorg/openrndr/draw/ColorType;)V", "getType", "()Lorg/openrndr/draw/ColorType;", "h1", "", "getH1", "()[F", "setH1", "([F)V", "h2", "", "getH2", "()F", "setH2", "(F)V", "g", "getG", "setG", "size", "resolution", "Lorg/openrndr/math/IntVector2;", "minResolution", "depth", "levelsIn", "", "Lorg/openrndr/draw/RenderTarget;", "levelsOut", "result", "Lorg/openrndr/draw/ColorBuffer;", "process", "input", "destroy", "", "orx-poisson-fill"})
@SourceDebugExtension(value={"SMAP\nConvolutionPyramid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvolutionPyramid.kt\norg/openrndr/poissonfill/ConvolutionPyramid\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1863#2:141\n1863#2,2:142\n1864#2:144\n*S KotlinDebug\n*F\n+ 1 ConvolutionPyramid.kt\norg/openrndr/poissonfill/ConvolutionPyramid\n*L\n126#1:141\n127#1:142,2\n126#1:144\n*E\n"})
public final class ConvolutionPyramid {
    private final int padding;
    @NotNull
    private final Downscale downscale;
    @NotNull
    private final Upscale upscale;
    @NotNull
    private final Convolution filter;
    @NotNull
    private final ColorType type;
    @NotNull
    private float[] h1;
    private float h2;
    @NotNull
    private float[] g;
    private final int size;
    @NotNull
    private final IntVector2 resolution;
    private final int minResolution;
    private final int depth;
    @NotNull
    private final List<RenderTarget> levelsIn;
    @NotNull
    private final List<RenderTarget> levelsOut;
    @NotNull
    private final ColorBuffer result;

    public ConvolutionPyramid(int width, int height, int padding, int cutOff, @NotNull Downscale downscale, @NotNull Upscale upscale, @NotNull Convolution filter2, @NotNull ColorType type) {
        Intrinsics.checkNotNullParameter(downscale, "downscale");
        Intrinsics.checkNotNullParameter(upscale, "upscale");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        this.padding = padding;
        this.downscale = downscale;
        this.upscale = upscale;
        this.filter = filter2;
        this.type = type;
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        this.h1 = fArray;
        fArray = new float[]{0.0f, 0.0f, 0.0f};
        this.g = fArray;
        this.size = 5;
        this.resolution = new IntVector2(width + 2 * this.padding, height + 2 * this.padding);
        this.minResolution = Math.min(this.resolution.x(), this.resolution.y());
        this.depth = Math.min(cutOff, (int)Math.ceil(MathKt.log2((double)this.minResolution)));
        this.levelsIn = new ArrayList();
        this.levelsOut = new ArrayList();
        this.result = ColorBufferKt.colorBuffer$default(width, height, 0.0, null, this.type, null, 0, null, 236, null);
        int levelWidth = this.resolution.x() + 2 * this.size;
        int levelHeight = this.resolution.y() + 2 * this.size;
        int n = this.depth;
        for (int i = 0; i < n; ++i) {
            this.levelsIn.add(RenderTargetKt.renderTarget$default(levelWidth, levelHeight, 0.0, null, null, arg_0 -> ConvolutionPyramid._init_$lambda$0(this, arg_0), 28, null));
            this.levelsOut.add(RenderTargetKt.renderTarget$default(levelWidth, levelHeight, 0.0, null, null, arg_0 -> ConvolutionPyramid._init_$lambda$1(this, arg_0), 28, null));
            levelWidth /= 2;
            levelHeight /= 2;
            levelWidth += 2 * this.size;
            levelHeight += 2 * this.size;
        }
    }

    public /* synthetic */ ConvolutionPyramid(int n, int n2, int n3, int n4, Downscale downscale, Upscale upscale, Convolution convolution, ColorType colorType, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 4) != 0) {
            n3 = 0;
        }
        if ((n5 & 8) != 0) {
            n4 = 10000;
        }
        if ((n5 & 0x10) != 0) {
            downscale = new Downscale(null, 1, null);
        }
        if ((n5 & 0x20) != 0) {
            upscale = new Upscale(null, 1, null);
        }
        if ((n5 & 0x40) != 0) {
            convolution = new Convolution(null, 1, null);
        }
        if ((n5 & 0x80) != 0) {
            colorType = ColorType.FLOAT32;
        }
        this(n, n2, n3, n4, downscale, upscale, convolution, colorType);
    }

    @NotNull
    public final ColorType getType() {
        return this.type;
    }

    @NotNull
    public final float[] getH1() {
        return this.h1;
    }

    public final void setH1(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter(fArray, "<set-?>");
        this.h1 = fArray;
    }

    public final float getH2() {
        return this.h2;
    }

    public final void setH2(float f) {
        this.h2 = f;
    }

    @NotNull
    public final float[] getG() {
        return this.g;
    }

    public final void setG(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter(fArray, "<set-?>");
        this.g = fArray;
    }

    @NotNull
    public final ColorBuffer process(@NotNull ColorBuffer input) {
        int i;
        Intrinsics.checkNotNullParameter(input, "input");
        for (RenderTarget l : this.levelsIn) {
            l.clearColor(0, ColorRGBa.Companion.getTRANSPARENT());
        }
        for (RenderTarget l : this.levelsOut) {
            l.clearColor(0, ColorRGBa.Companion.getTRANSPARENT());
        }
        this.downscale.setH1(this.h1);
        this.upscale.setG(this.g);
        this.upscale.setH1(this.h1);
        this.upscale.setH2(this.h2);
        this.filter.setG(this.g);
        ConvolutionPyramidKt.access$getPassthrough().setPadding((this.levelsIn.get(0).getWidth() - input.getWidth()) / 2);
        Filter.apply$default((Filter)ConvolutionPyramidKt.access$getPassthrough(), input, this.levelsIn.get(0).colorBuffer(0), null, 4, null);
        ConvolutionPyramidKt.access$getPassthrough().setPadding(0);
        int n = this.levelsIn.size();
        for (i = 1; i < n; ++i) {
            this.downscale.setPadding(0);
            Filter.apply$default((Filter)this.downscale, this.levelsIn.get(i - 1).colorBuffer(0), this.levelsIn.get(i).colorBuffer(0), null, 4, null);
        }
        Filter.apply$default((Filter)this.filter, CollectionsKt.last(this.levelsIn).colorBuffer(0), CollectionsKt.last(this.levelsOut).colorBuffer(0), null, 4, null);
        for (i = this.levelsOut.size() - 2; -1 < i; --i) {
            this.upscale.setPadding(0);
            ColorBuffer[] colorBufferArray = new ColorBuffer[]{this.levelsIn.get(i).colorBuffer(0), this.levelsOut.get(i + 1).colorBuffer(0)};
            ColorBuffer[] colorBufferArray2 = colorBufferArray;
            colorBufferArray = new ColorBuffer[]{this.levelsOut.get(i).colorBuffer(0)};
            Filter.apply$default((Filter)this.upscale, colorBufferArray2, colorBufferArray, null, 4, null);
        }
        ConvolutionPyramidKt.access$getPassthrough().setPadding(-this.size - this.padding);
        Filter.apply$default((Filter)ConvolutionPyramidKt.access$getPassthrough(), this.levelsOut.get(0).colorBuffer(0), this.result, null, 4, null);
        ConvolutionPyramidKt.access$getPassthrough().setPadding(0);
        return this.result;
    }

    public final void destroy() {
        this.result.destroy();
        Iterable $this$forEach$iv = CollectionsKt.plus((Collection)this.levelsIn, (Iterable)this.levelsOut);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RenderTarget it = (RenderTarget)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = it.getColorAttachments();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ColorAttachment it2 = (ColorAttachment)element$iv2;
                boolean bl2 = false;
                ColorAttachment colorAttachment = it2;
                if (colorAttachment instanceof ColorBufferAttachment) {
                    ((ColorBufferAttachment)it2).getColorBuffer().destroy();
                    continue;
                }
                if (colorAttachment instanceof CubemapAttachment) {
                    ((CubemapAttachment)it2).getCubemap().destroy();
                    continue;
                }
                if (colorAttachment instanceof ArrayTextureAttachment) {
                    ((ArrayTextureAttachment)it2).getArrayTexture().destroy();
                    continue;
                }
                if (!(colorAttachment instanceof ArrayCubemapAttachment)) continue;
                ((ArrayCubemapAttachment)it2).getArrayCubemap().destroy();
            }
            it.detachColorAttachments();
            it.destroy();
        }
    }

    private static final Unit _init_$lambda$0(ConvolutionPyramid this$0, RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        RenderTargetBuilder.colorBuffer$default($this$renderTarget, null, this$0.type, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ConvolutionPyramid this$0, RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        RenderTargetBuilder.colorBuffer$default($this$renderTarget, null, this$0.type, 1, null);
        return Unit.INSTANCE;
    }
}

