/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.platform;

import java.io.File;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.platform.GenericPlatformDriver;
import org.openrndr.platform.MacOSPlatformDriver;
import org.openrndr.platform.PlatformArchitecture;
import org.openrndr.platform.PlatformDriver;
import org.openrndr.platform.PlatformType;
import org.openrndr.platform.WindowsPlatformDriver;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\b\u0010\t\u001a\u00020\bH\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0005J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0005J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lorg/openrndr/platform/Platform;", "", "<init>", "()V", "property", "", "key", "driver", "Lorg/openrndr/platform/PlatformDriver;", "instantiateDriver", "type", "Lorg/openrndr/platform/PlatformType;", "getType", "()Lorg/openrndr/platform/PlatformType;", "type$delegate", "Lkotlin/Lazy;", "architecture", "Lorg/openrndr/platform/PlatformArchitecture;", "getArchitecture", "()Lorg/openrndr/platform/PlatformArchitecture;", "architecture$delegate", "tempDirectory", "Ljava/io/File;", "cacheDirectory", "programName", "supportDirectory", "path", "", "openrndr-platform"})
public final class Platform {
    @NotNull
    public static final Platform INSTANCE = new Platform();
    @NotNull
    private static final PlatformDriver driver = INSTANCE.instantiateDriver();
    @NotNull
    private static final Lazy type$delegate = LazyKt.lazy(Platform::type_delegate$lambda$0);
    @NotNull
    private static final Lazy architecture$delegate = LazyKt.lazy(Platform::architecture_delegate$lambda$1);

    private Platform() {
    }

    @Nullable
    public final String property(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return System.getProperty(key);
    }

    private final PlatformDriver instantiateDriver() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        String os = string3;
        return StringsKt.startsWith$default(os, "windows", false, 2, null) ? (PlatformDriver)new WindowsPlatformDriver() : (StringsKt.startsWith$default(os, "mac", false, 2, null) ? (PlatformDriver)new MacOSPlatformDriver() : (PlatformDriver)new GenericPlatformDriver());
    }

    @NotNull
    public final PlatformType getType() {
        Lazy lazy = type$delegate;
        return (PlatformType)((Object)lazy.getValue());
    }

    @NotNull
    public final PlatformArchitecture getArchitecture() {
        Lazy lazy = architecture$delegate;
        return (PlatformArchitecture)((Object)lazy.getValue());
    }

    @NotNull
    public final File tempDirectory() {
        return driver.temporaryDirectory();
    }

    @NotNull
    public final File cacheDirectory(@NotNull String programName) {
        Intrinsics.checkNotNullParameter(programName, "programName");
        return driver.cacheDirectory(programName);
    }

    @NotNull
    public final File supportDirectory(@NotNull String programName) {
        Intrinsics.checkNotNullParameter(programName, "programName");
        return driver.supportDirectory(programName);
    }

    @NotNull
    public final List<File> path() {
        return driver.path();
    }

    private static final PlatformType type_delegate$lambda$0() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        String os = string3;
        return StringsKt.startsWith$default(os, "windows", false, 2, null) ? PlatformType.WINDOWS : (StringsKt.startsWith$default(os, "mac", false, 2, null) ? PlatformType.MAC : PlatformType.GENERIC);
    }

    private static final PlatformArchitecture architecture_delegate$lambda$1() {
        String arch;
        String string = System.getProperty("os.arch");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String string3 = arch = string2;
        return Intrinsics.areEqual(string3, "amd64") ? PlatformArchitecture.X86_64 : (Intrinsics.areEqual(string3, "aarch64") ? PlatformArchitecture.AARCH64 : PlatformArchitecture.UNKNOWN);
    }
}

