/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel.style;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.panel.style.Property;
import org.openrndr.panel.style.PropertyBehaviour;
import org.openrndr.panel.style.PropertyBehaviours;
import org.openrndr.panel.style.PropertyInheritance;
import org.openrndr.panel.style.StyleSheet;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0086\u0002\u00a2\u0006\u0002\u0010\u0016J,\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/openrndr/panel/style/PropertyHandler;", "T", "", "name", "", "inheritance", "Lorg/openrndr/panel/style/PropertyInheritance;", "initial", "<init>", "(Ljava/lang/String;Lorg/openrndr/panel/style/PropertyInheritance;Ljava/lang/Object;)V", "getName", "()Ljava/lang/String;", "getInheritance", "()Lorg/openrndr/panel/style/PropertyInheritance;", "getInitial", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getValue", "stylesheet", "Lorg/openrndr/panel/style/StyleSheet;", "property", "Lkotlin/reflect/KProperty;", "(Lorg/openrndr/panel/style/StyleSheet;Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "setValue", "", "value", "(Lorg/openrndr/panel/style/StyleSheet;Lkotlin/reflect/KProperty;Ljava/lang/Object;)V", "orx-panel"})
public final class PropertyHandler<T> {
    @NotNull
    private final String name;
    @NotNull
    private final PropertyInheritance inheritance;
    private final T initial;

    public PropertyHandler(@NotNull String name, @NotNull PropertyInheritance inheritance, T initial) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter((Object)inheritance, "inheritance");
        this.name = name;
        this.inheritance = inheritance;
        this.initial = initial;
        Map map2 = PropertyBehaviours.INSTANCE.getBehaviours();
        String string = this.name;
        T t = this.initial;
        Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Any");
        PropertyBehaviour propertyBehaviour = new PropertyBehaviour(this.inheritance, t);
        map2.put(string, propertyBehaviour);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final PropertyInheritance getInheritance() {
        return this.inheritance;
    }

    public final T getInitial() {
        return this.initial;
    }

    public final T getValue(@NotNull StyleSheet stylesheet, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter(stylesheet, "stylesheet");
        Intrinsics.checkNotNullParameter(property, "property");
        Property property2 = stylesheet.getProperty(this.name);
        Object value = property2 != null ? property2.value() : null;
        Object object = value;
        if (object == null) {
            PropertyBehaviour propertyBehaviour = PropertyBehaviours.INSTANCE.getBehaviours().get(this.name);
            Intrinsics.checkNotNull(propertyBehaviour);
            object = propertyBehaviour.intitial();
        }
        return (T)object;
    }

    public final void setValue(@NotNull StyleSheet stylesheet, @NotNull KProperty<?> property, @Nullable T value) {
        Intrinsics.checkNotNullParameter(stylesheet, "stylesheet");
        Intrinsics.checkNotNullParameter(property, "property");
        stylesheet.setProperty(this.name, value);
    }
}

