/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.KeyModifier;
import org.openrndr.MouseEvent;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.LineCap;
import org.openrndr.events.Event;
import org.openrndr.extra.textwriter.Cursor;
import org.openrndr.extra.textwriter.TextWriter;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Vector2;
import org.openrndr.panel.ControlManager;
import org.openrndr.panel.FontManager;
import org.openrndr.panel.elements.Body;
import org.openrndr.panel.elements.DisposableElement;
import org.openrndr.panel.elements.Element;
import org.openrndr.panel.elements.ElementKt;
import org.openrndr.panel.elements.ElementType;
import org.openrndr.panel.style.StyleSheetKt;
import org.openrndr.panel.tools.Tooltip;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u000278B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0006R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001a\u0010!\u001a\u00020\u0019X\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001dR \u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0012\u0010*\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010+R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u000200X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102\u00a8\u00069"}, d2={"Lorg/openrndr/panel/elements/SequenceEditorBase;", "Lorg/openrndr/panel/elements/Element;", "Lorg/openrndr/panel/elements/DisposableElement;", "type", "", "<init>", "(Ljava/lang/String;)V", "disposed", "", "getDisposed", "()Z", "setDisposed", "(Z)V", "baseValue", "", "", "getBaseValue$orx_panel", "()Ljava/util/List;", "setBaseValue$orx_panel", "(Ljava/util/List;)V", "label", "getLabel", "()Ljava/lang/String;", "setLabel", "precision", "", "getPrecision", "()I", "setPrecision", "(I)V", "maximumSequenceLength", "getMaximumSequenceLength$orx_panel", "setMaximumSequenceLength$orx_panel", "minimumSequenceLength", "getMinimumSequenceLength$orx_panel", "setMinimumSequenceLength$orx_panel", "range", "Lkotlin/ranges/ClosedRange;", "getRange", "()Lkotlin/ranges/ClosedRange;", "setRange", "(Lkotlin/ranges/ClosedRange;)V", "selectedIndex", "Ljava/lang/Integer;", "tooltip", "Lorg/openrndr/panel/tools/Tooltip;", "footerHeight", "baseEvents", "Lorg/openrndr/panel/elements/SequenceEditorBase$Events;", "getBaseEvents$orx_panel", "()Lorg/openrndr/panel/elements/SequenceEditorBase$Events;", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "ValueChangedEvent", "Events", "orx-panel"})
@SourceDebugExtension(value={"SMAP\nSequenceEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SequenceEditor.kt\norg/openrndr/panel/elements/SequenceEditorBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n1557#2:215\n1628#2,3:216\n1557#2:219\n1628#2,3:220\n1557#2:223\n1628#2,3:224\n*S KotlinDebug\n*F\n+ 1 SequenceEditor.kt\norg/openrndr/panel/elements/SequenceEditorBase\n*L\n97#1:215\n97#1:216,3\n107#1:219\n107#1:220,3\n160#1:223\n160#1:224,3\n*E\n"})
public class SequenceEditorBase
extends Element
implements DisposableElement {
    private boolean disposed;
    @NotNull
    private List<Double> baseValue;
    @NotNull
    private String label;
    private int precision;
    private int maximumSequenceLength;
    private int minimumSequenceLength;
    @NotNull
    private ClosedRange<Double> range;
    @Nullable
    private Integer selectedIndex;
    @Nullable
    private Tooltip tooltip;
    private final double footerHeight;
    @NotNull
    private final Events baseEvents;

    public SequenceEditorBase(@NotNull String type) {
        Intrinsics.checkNotNullParameter(type, "type");
        super(new ElementType(type));
        Double[] doubleArray = new Double[]{0.0};
        this.baseValue = CollectionsKt.mutableListOf(doubleArray);
        this.label = "sequence";
        this.precision = 2;
        this.maximumSequenceLength = 16;
        this.minimumSequenceLength = 1;
        this.range = RangesKt.rangeTo(-1.0, 1.0);
        this.footerHeight = 20.0;
        this.baseEvents = new Events();
        this.getMouse().getClicked().listen(arg_0 -> SequenceEditorBase._init_$lambda$0(this, arg_0));
        this.getMouse().getPressed().listen(arg_0 -> SequenceEditorBase._init_$lambda$3(this, arg_0));
        Ref.ObjectRef hoverJob = new Ref.ObjectRef();
        this.getMouse().getExited().listen(arg_0 -> SequenceEditorBase._init_$lambda$4(hoverJob, this, arg_0));
        this.getMouse().getMoved().listen(arg_0 -> SequenceEditorBase._init_$lambda$6(hoverJob, this, arg_0));
        this.getMouse().getDragged().listen(arg_0 -> SequenceEditorBase._init_$lambda$9(this, arg_0));
    }

    public /* synthetic */ SequenceEditorBase(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "sequence-editor-base";
        }
        this(string);
    }

    @Override
    public boolean getDisposed() {
        return this.disposed;
    }

    @Override
    public void setDisposed(boolean bl) {
        this.disposed = bl;
    }

    @NotNull
    public final List<Double> getBaseValue$orx_panel() {
        return this.baseValue;
    }

    public final void setBaseValue$orx_panel(@NotNull List<Double> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.baseValue = list;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.label = string;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final void setPrecision(int n) {
        this.precision = n;
    }

    public int getMaximumSequenceLength$orx_panel() {
        return this.maximumSequenceLength;
    }

    public void setMaximumSequenceLength$orx_panel(int n) {
        this.maximumSequenceLength = n;
    }

    public int getMinimumSequenceLength$orx_panel() {
        return this.minimumSequenceLength;
    }

    public void setMinimumSequenceLength$orx_panel(int n) {
        this.minimumSequenceLength = n;
    }

    @NotNull
    public final ClosedRange<Double> getRange() {
        return this.range;
    }

    public final void setRange(@NotNull ClosedRange<Double> closedRange) {
        Intrinsics.checkNotNullParameter(closedRange, "<set-?>");
        this.range = closedRange;
    }

    @NotNull
    public final Events getBaseEvents$orx_panel() {
        return this.baseEvents;
    }

    @Override
    public void draw(@NotNull Drawer drawer) {
        block1: {
            Intrinsics.checkNotNullParameter(drawer, "drawer");
            Rectangle controlArea = RectangleKt.Rectangle(0.0, 0.0, this.getLayout().getScreenWidth(), this.getLayout().getScreenHeight() - this.footerHeight);
            ColorRGBa colorRGBa = StyleSheetKt.getEffectiveColor(this.getComputedStyle());
            drawer.setStroke(colorRGBa != null ? colorRGBa.opacify(0.25) : null);
            drawer.setStrokeWeight(1.0);
            double zeroHeight = RangesKt.coerceIn(MappingKt.doubleMap$default(0.0, ((Number)this.range.getStart()).doubleValue(), ((Number)this.range.getEndInclusive()).doubleValue(), -1.0, 1.0, false, 16, null), -1.0, 1.0) * controlArea.height() / -2.0;
            drawer.lineSegment(0.0, controlArea.height() / 2.0 + zeroHeight, this.getLayout().getScreenWidth(), controlArea.height() / 2.0 + zeroHeight);
            drawer.setStrokeWeight(7.0);
            drawer.setFill(StyleSheetKt.getEffectiveColor(this.getComputedStyle()));
            int n = ((Collection)this.baseValue).size();
            for (int i = 0; i < n; ++i) {
                double dx = this.getLayout().getScreenWidth() / (double)(this.baseValue.size() + 1);
                double height = -RangesKt.coerceIn(MappingKt.doubleMap$default(((Number)this.baseValue.get(i)).doubleValue(), ((Number)this.range.getStart()).doubleValue(), ((Number)this.range.getEndInclusive()).doubleValue(), -1.0, 1.0, false, 16, null), -1.0, 1.0) * controlArea.height() / 2.0;
                double x = dx * (double)(i + 1);
                drawer.setLineCap(LineCap.ROUND);
                drawer.setStroke(StyleSheetKt.getEffectiveColor(this.getComputedStyle()));
                drawer.lineSegment(x, controlArea.height() / 2.0 + zeroHeight, x, controlArea.height() / 2.0 + height);
                ColorRGBa colorRGBa2 = StyleSheetKt.getEffectiveColor(this.getComputedStyle());
                drawer.setStroke(colorRGBa2 != null ? colorRGBa2.shade(1.1) : null);
                drawer.setFill(ColorRGBa.Companion.getPINK());
                drawer.circle(x, controlArea.height() / 2.0 + height, 7.0);
            }
            DrawerKt.isolated(drawer, arg_0 -> SequenceEditorBase.draw$lambda$11(drawer, controlArea, this, arg_0));
            Tooltip tooltip = this.tooltip;
            if (tooltip == null) break block1;
            tooltip.draw(drawer);
        }
    }

    @Override
    public void dispose() {
        DisposableElement.DefaultImpls.dispose(this);
    }

    private static final Vector2 _init_$query(SequenceEditorBase this$0, Vector2 position) {
        double x = (position.x() - this$0.getLayout().getScreenX()) / this$0.getLayout().getScreenWidth();
        double y = 1.0 - (position.y() - this$0.getLayout().getScreenY()) / ((this$0.getLayout().getScreenHeight() - this$0.footerHeight) * 0.5);
        return new Vector2(x, y);
    }

    private static final Unit _init_$lambda$0(SequenceEditorBase this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.cancelPropagation();
        ElementKt.requestRedraw(this$0);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$3(SequenceEditorBase this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!((Collection)this$0.baseValue).isEmpty()) {
            double dx = this$0.getLayout().getScreenWidth() / (double)(this$0.baseValue.size() + 1);
            double index = (it.getPosition().x() - this$0.getLayout().getScreenX()) / dx;
            double d = index - Math.rint(index);
            double dp = d * dx;
            double dpa = Math.abs(dp);
            if (dpa < 10.0) {
                Integer n;
                SequenceEditorBase sequenceEditorBase = this$0;
                if (!it.getModifiers().contains((Object)KeyModifier.CTRL)) {
                    n = (int)Math.rint(index);
                } else {
                    if (this$0.baseValue.size() > this$0.getMinimumSequenceLength$orx_panel()) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable = this$0.baseValue;
                        SequenceEditorBase sequenceEditorBase2 = sequenceEditorBase;
                        boolean $i$f$map = false;
                        void var15_13 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it2;
                            double d2 = ((Number)item$iv$iv).doubleValue();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add((double)it2);
                        }
                        sequenceEditorBase = sequenceEditorBase2;
                        List oldValue = (List)destination$iv$iv;
                        this$0.baseValue.remove((int)Math.rint(index) - 1);
                        this$0.baseEvents.getValueChanged().trigger(new ValueChangedEvent(this$0, oldValue, this$0.baseValue));
                    }
                    n = null;
                }
                sequenceEditorBase.selectedIndex = n;
            } else if (!it.getModifiers().contains((Object)KeyModifier.CTRL) && this$0.baseValue.size() < this$0.getMaximumSequenceLength$orx_panel()) {
                void $this$mapTo$iv$iv;
                Vector2 q = SequenceEditorBase._init_$query(this$0, it.getPosition());
                Iterable $this$map$iv = this$0.baseValue;
                boolean $i$f$map = false;
                Iterable destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    double d3 = ((Number)item$iv$iv).doubleValue();
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add((double)it3);
                }
                List oldValue = (List)destination$iv$iv2;
                this$0.baseValue.add((int)index, MappingKt.doubleMap$default(q.y(), -1.0, 1.0, ((Number)this$0.range.getStart()).doubleValue(), ((Number)this$0.range.getEndInclusive()).doubleValue(), false, 16, null));
                this$0.baseEvents.getValueChanged().trigger(new ValueChangedEvent(this$0, oldValue, this$0.baseValue));
            }
        }
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(Ref.ObjectRef $hoverJob, SequenceEditorBase this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Job job = (Job)$hoverJob.element;
        if (job != null) {
            Job.DefaultImpls.cancel$default(job, null, 1, null);
        }
        if (this$0.tooltip != null) {
            this$0.tooltip = null;
            ElementKt.requestRedraw(this$0);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(Ref.ObjectRef $hoverJob, SequenceEditorBase this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Job job = (Job)$hoverJob.element;
        if (job != null) {
            Job job2 = job;
            boolean bl = false;
            Job.DefaultImpls.cancel$default(job2, null, 1, null);
        }
        if (this$0.tooltip != null) {
            this$0.tooltip = null;
            ElementKt.requestRedraw(this$0);
        }
        if (!((Collection)this$0.baseValue).isEmpty()) {
            double dx = this$0.getLayout().getScreenWidth() / (double)(this$0.baseValue.size() + 1);
            double index = (it.getPosition().x() - this$0.getLayout().getScreenX()) / dx;
            double d = index - Math.rint(index);
            double dp = d * dx;
            double dpa = Math.abs(dp);
            if (dpa < 10.0) {
                $hoverJob.element = BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(index, this$0, it, null){
                    int label;
                    final /* synthetic */ double $index;
                    final /* synthetic */ SequenceEditorBase this$0;
                    final /* synthetic */ MouseEvent $it;
                    {
                        this.$index = $index;
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                int readIndex = MathKt.roundToInt(this.$index) - 1;
                                if (readIndex >= 0 && readIndex < this.this$0.getBaseValue$orx_panel().size()) {
                                    String string = "%.0" + this.this$0.getPrecision() + "f";
                                    Object[] objectArray = new Object[]{this.this$0.getBaseValue$orx_panel().get(readIndex)};
                                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                                    Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                                    String value = string2;
                                    SequenceEditorBase.access$setTooltip$p(this.this$0, new Tooltip(this.this$0, this.$it.getPosition().minus(new Vector2(this.this$0.getLayout().getScreenX(), this.this$0.getLayout().getScreenY())), String.valueOf(value)));
                                    ElementKt.requestRedraw(this.this$0);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 3, null);
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$9(SequenceEditorBase this$0, MouseEvent it) {
        block2: {
            Intrinsics.checkNotNullParameter(it, "it");
            Vector2 q = SequenceEditorBase._init_$query(this$0, it.getPosition());
            Integer n = this$0.selectedIndex;
            if (n == null) break block2;
            int index = ((Number)n).intValue();
            boolean bl = false;
            int writeIndex = index - 1;
            if (writeIndex >= 0 && writeIndex < this$0.baseValue.size()) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this$0.baseValue;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    double d = ((Number)item$iv$iv).doubleValue();
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add((double)it2);
                }
                List oldValue = (List)destination$iv$iv;
                this$0.baseValue.set(writeIndex, MappingKt.doubleMap$default(RangesKt.coerceIn(q.y(), -1.0, 1.0), -1.0, 1.0, ((Number)this$0.range.getStart()).doubleValue(), ((Number)this$0.range.getEndInclusive()).doubleValue(), false, 16, null));
                this$0.baseEvents.getValueChanged().trigger(new ValueChangedEvent(this$0, oldValue, this$0.baseValue));
            }
            ElementKt.requestRedraw(this$0);
        }
        return Unit.INSTANCE;
    }

    private static final Unit draw$lambda$11(Drawer $drawer, Rectangle $controlArea, SequenceEditorBase this$0, Drawer $this$isolated) {
        block0: {
            Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
            Drawer.translate$default($drawer, 0.0, $controlArea.height(), null, 4, null);
            $drawer.setFill(StyleSheetKt.getEffectiveColor(this$0.getComputedStyle()));
            Element element = this$0.root();
            Object object = element instanceof Body ? (Body)element : null;
            if (object == null || (object = ((Body)object).getControlManager()) == null || (object = ((ControlManager)object).getFontManager()) == null) break block0;
            Object it = object;
            boolean bl = false;
            FontImageMap font = ((FontManager)it).font(this$0.getComputedStyle());
            TextWriter writer = new TextWriter($drawer);
            $drawer.setFontMap(font);
            $drawer.setFill(StyleSheetKt.getEffectiveColor(this$0.getComputedStyle()));
            writer.setCursor(new Cursor(0.0, 4.0));
            writer.setBox(RectangleKt.Rectangle(0.0, 4.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
            writer.newLine();
            TextWriter.text$default(writer, this$0.label, false, 2, null);
        }
        return Unit.INSTANCE;
    }

    public SequenceEditorBase() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$setTooltip$p(SequenceEditorBase $this, Tooltip tooltip) {
        $this.tooltip = tooltip;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/panel/elements/SequenceEditorBase$Events;", "", "<init>", "()V", "valueChanged", "Lorg/openrndr/events/Event;", "Lorg/openrndr/panel/elements/SequenceEditorBase$ValueChangedEvent;", "getValueChanged", "()Lorg/openrndr/events/Event;", "orx-panel"})
    public static final class Events {
        @NotNull
        private final Event<ValueChangedEvent> valueChanged = new Event("sequence-editor-base-value-changed", false, 2, null);

        @NotNull
        public final Event<ValueChangedEvent> getValueChanged() {
            return this.valueChanged;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/openrndr/panel/elements/SequenceEditorBase$ValueChangedEvent;", "", "source", "Lorg/openrndr/panel/elements/SequenceEditorBase;", "oldValue", "", "", "newValue", "<init>", "(Lorg/openrndr/panel/elements/SequenceEditorBase;Ljava/util/List;Ljava/util/List;)V", "getSource", "()Lorg/openrndr/panel/elements/SequenceEditorBase;", "getOldValue", "()Ljava/util/List;", "getNewValue", "orx-panel"})
    public static final class ValueChangedEvent {
        @NotNull
        private final SequenceEditorBase source;
        @NotNull
        private final List<Double> oldValue;
        @NotNull
        private final List<Double> newValue;

        public ValueChangedEvent(@NotNull SequenceEditorBase source, @NotNull List<Double> oldValue, @NotNull List<Double> newValue) {
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(oldValue, "oldValue");
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            this.source = source;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @NotNull
        public final SequenceEditorBase getSource() {
            return this.source;
        }

        @NotNull
        public final List<Double> getOldValue() {
            return this.oldValue;
        }

        @NotNull
        public final List<Double> getNewValue() {
            return this.newValue;
        }
    }
}

