/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector3;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\u0002\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0086\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u001e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0002\u001a\u0010\u0010\t\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\n\u001a\u0010\u0010\u000b\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\n\u00a8\u0006\f"}, d2={"times", "Lorg/openrndr/math/Vector3;", "", "v", "min", "a", "b", "max", "mix", "sum", "", "average", "openrndr-math"})
public final class Vector3Kt {
    @NotNull
    public static final Vector3 times(double $this$times, @NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return v.times($this$times);
    }

    @NotNull
    public static final Vector3 min(@NotNull Vector3 a, @NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return new Vector3(Math.min(a.x(), b.x()), Math.min(a.y(), b.y()), Math.min(a.z(), b.z()));
    }

    @NotNull
    public static final Vector3 max(@NotNull Vector3 a, @NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return new Vector3(Math.max(a.x(), b.x()), Math.max(a.y(), b.y()), Math.max(a.z(), b.z()));
    }

    @NotNull
    public static final Vector3 mix(@NotNull Vector3 a, @NotNull Vector3 b, double mix) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return a.times(1.0 - mix).plus(b.times(mix));
    }

    @NotNull
    public static final Vector3 sum(@NotNull Iterable<Vector3> $this$sum) {
        Intrinsics.checkNotNullParameter($this$sum, "<this>");
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (Vector3 v : $this$sum) {
            x += v.x();
            y += v.y();
            z += v.z();
        }
        return new Vector3(x, y, z);
    }

    @NotNull
    public static final Vector3 average(@NotNull Iterable<Vector3> $this$average) {
        Intrinsics.checkNotNullParameter($this$average, "<this>");
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int count2 = 0;
        for (Vector3 v : $this$average) {
            x += v.x();
            y += v.y();
            z += v.z();
            ++count2;
        }
        return new Vector3(x / (double)count2, y / (double)count2, z / (double)count2);
    }
}

