/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.IntVector2;
import org.openrndr.math.IntVector4$;
import org.openrndr.math.Vector4;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 72\u00020\u0001:\u000278B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB;\b\u0010\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0007\u0010\fJ\u0011\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0003H\u0086\u0002J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J1\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u00d6\u0003J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001J%\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0001\u00a2\u0006\u0002\b6R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0018\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\"\u00a8\u00069"}, d2={"Lorg/openrndr/math/IntVector4;", "Ljava/lang/Record;", "x", "", "y", "z", "w", "<init>", "(IIII)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IIIIILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()I", "length", "", "()D", "squaredLength", "dot", "right", "xy", "Lorg/openrndr/math/IntVector2;", "()Lorg/openrndr/math/IntVector2;", "yx", "xx", "yy", "plus", "v", "minus", "times", "d", "div", "vector4", "Lorg/openrndr/math/Vector4;", "()Lorg/openrndr/math/Vector4;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_math", "Companion", "$serializer", "openrndr-math"})
public final class IntVector4
extends Record {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int x;
    private final int y;
    private final int z;
    private final int w;
    @NotNull
    private static final IntVector4 ZERO = new IntVector4(0, 0, 0, 0);
    @NotNull
    private static final IntVector4 ONE = new IntVector4(1, 1, 1, 1);
    @NotNull
    private static final IntVector4 UNIT_X = new IntVector4(1, 0, 0, 0);
    @NotNull
    private static final IntVector4 UNIT_Y = new IntVector4(0, 1, 0, 0);
    @NotNull
    private static final IntVector4 UNIT_Z = new IntVector4(0, 0, 1, 0);
    @NotNull
    private static final IntVector4 UNIT_W = new IntVector4(0, 0, 0, 1);

    public IntVector4(int x, int y, int z, int w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public final int x() {
        return this.x;
    }

    public final int y() {
        return this.y;
    }

    public final int z() {
        return this.z;
    }

    public final int w() {
        return this.w;
    }

    public final double length() {
        return Math.sqrt(1.0 * (double)this.x * (double)this.x + (double)(this.y * this.y) + (double)(this.z * this.z) + (double)(this.w * this.w));
    }

    public final int squaredLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public final int dot(@NotNull IntVector4 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.x * right.x + this.y * right.y + this.z * right.z + this.w * right.w;
    }

    @NotNull
    public final IntVector2 xy() {
        return new IntVector2(this.x, this.y);
    }

    @NotNull
    public final IntVector2 yx() {
        return new IntVector2(this.y, this.x);
    }

    @NotNull
    public final IntVector2 xx() {
        return new IntVector2(this.x, this.x);
    }

    @NotNull
    public final IntVector2 yy() {
        return new IntVector2(this.y, this.y);
    }

    @NotNull
    public final IntVector4 plus(@NotNull IntVector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new IntVector4(this.x + v.x, this.y + v.y, this.z + v.z, this.w + v.w);
    }

    @NotNull
    public final IntVector4 minus(@NotNull IntVector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new IntVector4(this.x - v.x, this.y - v.y, this.z - v.z, this.w - v.w);
    }

    @NotNull
    public final IntVector4 times(int d) {
        return new IntVector4(this.x * d, this.y * d, this.z * d, this.w * d);
    }

    @NotNull
    public final IntVector4 div(int d) {
        return new IntVector4(this.x / d, this.y / d, this.z / d, this.w / d);
    }

    @NotNull
    public final Vector4 vector4() {
        return new Vector4(this.x, this.y, this.z, this.w);
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    public final int component3() {
        return this.z;
    }

    public final int component4() {
        return this.w;
    }

    @NotNull
    public final IntVector4 copy(int x, int y, int z, int w) {
        return new IntVector4(x, y, z, w);
    }

    public static /* synthetic */ IntVector4 copy$default(IntVector4 intVector4, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = intVector4.x;
        }
        if ((n5 & 2) != 0) {
            n2 = intVector4.y;
        }
        if ((n5 & 4) != 0) {
            n3 = intVector4.z;
        }
        if ((n5 & 8) != 0) {
            n4 = intVector4.w;
        }
        return intVector4.copy(n, n2, n3, n4);
    }

    @Override
    @NotNull
    public String toString() {
        return "IntVector4(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + ")";
    }

    @Override
    public int hashCode() {
        int result = Integer.hashCode(this.x);
        result = result * 31 + Integer.hashCode(this.y);
        result = result * 31 + Integer.hashCode(this.z);
        result = result * 31 + Integer.hashCode(this.w);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntVector4)) {
            return false;
        }
        IntVector4 intVector4 = (IntVector4)other;
        if (this.x != intVector4.x) {
            return false;
        }
        if (this.y != intVector4.y) {
            return false;
        }
        if (this.z != intVector4.z) {
            return false;
        }
        return this.w == intVector4.w;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_math(IntVector4 self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeIntElement(serialDesc, 0, self.x);
        output.encodeIntElement(serialDesc, 1, self.y);
        output.encodeIntElement(serialDesc, 2, self.z);
        output.encodeIntElement(serialDesc, 3, self.w);
    }

    public /* synthetic */ IntVector4(int seen0, int x, int y, int z, int w, SerializationConstructorMarker serializationConstructorMarker) {
        if (15 != (0xF & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 15, $serializer.INSTANCE.getDescriptor());
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/openrndr/math/IntVector4$Companion;", "", "<init>", "()V", "ZERO", "Lorg/openrndr/math/IntVector4;", "getZERO", "()Lorg/openrndr/math/IntVector4;", "ONE", "getONE", "UNIT_X", "getUNIT_X", "UNIT_Y", "getUNIT_Y", "UNIT_Z", "getUNIT_Z", "UNIT_W", "getUNIT_W", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-math"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntVector4 getZERO() {
            return ZERO;
        }

        @NotNull
        public final IntVector4 getONE() {
            return ONE;
        }

        @NotNull
        public final IntVector4 getUNIT_X() {
            return UNIT_X;
        }

        @NotNull
        public final IntVector4 getUNIT_Y() {
            return UNIT_Y;
        }

        @NotNull
        public final IntVector4 getUNIT_Z() {
            return UNIT_Z;
        }

        @NotNull
        public final IntVector4 getUNIT_W() {
            return UNIT_W;
        }

        @NotNull
        public final KSerializer<IntVector4> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

