/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.ScalarsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a \u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u001a\u001e\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0016\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001\u001a&\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u001e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a.\u0010\u0012\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0006\u001a&\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DISCRIMINANT_EPSILON", "", "SOLUTION_EPSILON", "MACHINE_EPSILON", "EPSILON", "trim", "", "acc", "len", "", "split", "n", "discriminant", "a", "b", "c", "solveLinear", "solveQuadratic", "solveCubic", "d", "openrndr-math"})
public final class EquationsKt {
    private static final double DISCRIMINANT_EPSILON = 1.0E-10;
    private static final double SOLUTION_EPSILON = 1.0E-8;
    private static final double MACHINE_EPSILON = Math.ulp(1.0);
    private static final double EPSILON = 1.0E-14;

    private static final double[] trim(double[] acc, int len) {
        double[] dArray = Arrays.copyOf(acc, len);
        Intrinsics.checkNotNullExpressionValue(dArray, "copyOf(...)");
        return dArray;
    }

    private static final double[] split(double n) {
        double x = n * (double)0x8000001;
        double y = n - x;
        double hi = y + x;
        double lo = n - hi;
        double[] dArray = new double[]{hi, lo};
        return dArray;
    }

    private static final double discriminant(double a, double b, double c2) {
        double D2 = b * b - a * c2;
        double E = b * b + a * c2;
        if (Math.abs(D2) * (double)3 < E) {
            double[] ad = EquationsKt.split(a);
            double[] bd = EquationsKt.split(b);
            double[] cd = EquationsKt.split(c2);
            double p = b * b;
            double dp = bd[0] * bd[0] - p + (double)2 * bd[0] * bd[1] + bd[1] * bd[1];
            double q = a * c2;
            double dq = ad[0] * cd[0] - q + ad[0] * cd[1] + ad[1] * cd[0] + ad[1] * cd[1];
            D2 = p - q + (dp - dq);
        }
        return D2;
    }

    public static final int solveLinear(double a, double b, @NotNull double[] acc) {
        int n;
        Intrinsics.checkNotNullParameter(acc, "acc");
        if (Math.abs(a) < 1.0E-14) {
            n = 0;
        } else {
            acc[0] = -b / a;
            n = 1;
        }
        return n;
    }

    @NotNull
    public static final double[] solveLinear(double a, double b) {
        double[] acc = new double[1];
        return EquationsKt.trim(acc, EquationsKt.solveLinear(a, b, acc));
    }

    public static final int solveQuadratic(double a, double b, double c2, @NotNull double[] acc) {
        int n;
        double k;
        double D2;
        Intrinsics.checkNotNullParameter(acc, "acc");
        double a2 = a;
        double b2 = b;
        double c3 = c2;
        if (Math.abs(a2) < 1.0E-14) {
            return EquationsKt.solveLinear(b2, c3, acc);
        }
        b2 *= -0.5;
        if ((D2 = EquationsKt.discriminant(a2 *= (k = ScalarsKt.normalizationFactor(a2, b2, c3)), b2 *= k, c3 *= k)) >= -1.0E-10) {
            double Q = D2 < 0.0 ? 0.0 : Math.sqrt(D2);
            double R2 = b2 + (b2 < 0.0 ? -Q : Q);
            if (R2 == 0.0) {
                acc[0] = c3 / a2;
                acc[1] = -c3 / a2;
            } else {
                acc[0] = R2 / a2;
                acc[1] = c3 / R2;
            }
            int writeIdx = 0;
            for (int readIdx = 0; readIdx < 2; ++readIdx) {
                double x = acc[readIdx];
                double y = a2 * x * x + (double)-2 * b2 * x + c3;
                if (!(Math.abs(y) < 1.0E-8)) continue;
                acc[writeIdx++] = x;
            }
            n = writeIdx;
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public static final double[] solveQuadratic(double a, double b, double c2) {
        double[] acc = new double[2];
        return EquationsKt.trim(acc, EquationsKt.solveQuadratic(a, b, c2, acc));
    }

    public static final int solveCubic(double a, double b, double c2, double d, @NotNull double[] acc) {
        Intrinsics.checkNotNullParameter(acc, "acc");
        double a2 = a;
        double b2 = b;
        double c3 = c2;
        double d2 = d;
        double k = ScalarsKt.normalizationFactor(a2, b2, c3, d2);
        a2 *= k;
        b2 *= k;
        c3 *= k;
        d2 *= k;
        double x = 0.0;
        double b1 = 0.0;
        double c22 = 0.0;
        double qd = 0.0;
        double q = 0.0;
        if (Math.abs(a2) < 1.0E-14) {
            return EquationsKt.solveQuadratic(b2, c3, d2, acc);
        }
        if (Math.abs(d2) < 1.0E-14) {
            b1 = b2;
            c22 = c3;
            x = 0.0;
        } else {
            double td;
            double rd;
            x = -(b2 / a2) / (double)3;
            b1 = a2 * x + b2;
            c22 = b1 * x + c3;
            qd = (a2 * x + b1) * x + c22;
            q = c22 * x + d2;
            double t = q / a2;
            double r = Math.pow(Math.abs(t), 0.3333333333333333);
            double s = t < 0.0 ? -1.0 : 1.0;
            double x0 = x - s * (rd = (td = -qd / a2) > 0.0 ? 1.324717957244746 * Math.max(r, Math.sqrt(td)) : r);
            if (!(x0 == x)) {
                do {
                    x = x0;
                    b1 = a2 * x + b2;
                    c22 = b1 * x + c3;
                    qd = (a2 * x + b1) * x + c22;
                    q = c22 * x + d2;
                } while (s * (x0 = qd == 0.0 ? x : x - q / (qd / (1.0 + MACHINE_EPSILON))) > s * x);
                if (Math.abs(a2) * x * x > Math.abs(d2 / x)) {
                    c22 = -d2 / x;
                    b1 = (c22 - c3) / x;
                }
            }
        }
        int solutions = EquationsKt.solveQuadratic(a2, b1, c22, acc);
        int n = solutions;
        for (int i = 0; i < n; ++i) {
            if (!(acc[i] == x)) continue;
            return solutions;
        }
        double y = a2 * x * x * x + b2 * x * x + c3 * x + d2;
        if (Math.abs(y) < 1.0E-8) {
            acc[solutions++] = x;
        }
        return solutions;
    }

    @NotNull
    public static final double[] solveCubic(double a, double b, double c2, double d) {
        double[] acc = new double[3];
        return EquationsKt.trim(acc, EquationsKt.solveCubic(a, b, c2, d, acc));
    }
}

