/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.ktessellation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.ktessellation.GLUhalfEdge;
import org.openrndr.ktessellation.GLUvertex;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u001e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J&\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010!\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\""}, d2={"Lorg/openrndr/ktessellation/Geom;", "", "<init>", "()V", "EdgeEval", "", "u", "Lorg/openrndr/ktessellation/GLUvertex;", "v", "w", "EdgeSign", "TransEval", "TransSign", "VertCCW", "", "Interpolate", "a", "x", "b", "y", "EdgeIntersect", "", "o1", "d1", "o2", "d2", "VertEq", "VertLeq", "TransLeq", "EdgeGoesLeft", "e", "Lorg/openrndr/ktessellation/GLUhalfEdge;", "EdgeGoesRight", "VertL1dist", "openrndr-ktessellation"})
public final class Geom {
    @NotNull
    public static final Geom INSTANCE = new Geom();

    private Geom() {
    }

    public final double EdgeEval(@NotNull GLUvertex u, @NotNull GLUvertex v, @NotNull GLUvertex w) {
        double gapR;
        Intrinsics.checkNotNullParameter(u, "u");
        Intrinsics.checkNotNullParameter(v, "v");
        Intrinsics.checkNotNullParameter(w, "w");
        if (!(this.VertLeq(u, v) && this.VertLeq(v, w))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        double gapL = v.getS() - u.getS();
        return gapL + (gapR = w.getS() - v.getS()) > 0.0 ? (gapL < gapR ? v.getT() - u.getT() + (u.getT() - w.getT()) * (gapL / (gapL + gapR)) : v.getT() - w.getT() + (w.getT() - u.getT()) * (gapR / (gapL + gapR))) : 0.0;
    }

    public final double EdgeSign(@NotNull GLUvertex u, @NotNull GLUvertex v, @NotNull GLUvertex w) {
        double gapR;
        Intrinsics.checkNotNullParameter(u, "u");
        Intrinsics.checkNotNullParameter(v, "v");
        Intrinsics.checkNotNullParameter(w, "w");
        if (!(this.VertLeq(u, v) && this.VertLeq(v, w))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        double gapL = v.getS() - u.getS();
        return gapL + (gapR = w.getS() - v.getS()) > 0.0 ? (v.getT() - w.getT()) * gapL + (v.getT() - u.getT()) * gapR : 0.0;
    }

    public final double TransEval(@NotNull GLUvertex u, @NotNull GLUvertex v, @NotNull GLUvertex w) {
        double gapR;
        Intrinsics.checkNotNullParameter(u, "u");
        Intrinsics.checkNotNullParameter(v, "v");
        Intrinsics.checkNotNullParameter(w, "w");
        if (!(this.TransLeq(u, v) && this.TransLeq(v, w))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        double gapL = v.getT() - u.getT();
        return gapL + (gapR = w.getT() - v.getT()) > 0.0 ? (gapL < gapR ? v.getS() - u.getS() + (u.getS() - w.getS()) * (gapL / (gapL + gapR)) : v.getS() - w.getS() + (w.getS() - u.getS()) * (gapR / (gapL + gapR))) : 0.0;
    }

    public final double TransSign(@NotNull GLUvertex u, @NotNull GLUvertex v, @NotNull GLUvertex w) {
        double gapR;
        Intrinsics.checkNotNullParameter(u, "u");
        Intrinsics.checkNotNullParameter(v, "v");
        Intrinsics.checkNotNullParameter(w, "w");
        if (!(this.TransLeq(u, v) && this.TransLeq(v, w))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        double gapL = v.getT() - u.getT();
        return gapL + (gapR = w.getT() - v.getT()) > 0.0 ? (v.getS() - w.getS()) * gapL + (v.getS() - u.getS()) * gapR : 0.0;
    }

    public final boolean VertCCW(@NotNull GLUvertex u, @NotNull GLUvertex v, @NotNull GLUvertex w) {
        Intrinsics.checkNotNullParameter(u, "u");
        Intrinsics.checkNotNullParameter(v, "v");
        Intrinsics.checkNotNullParameter(w, "w");
        return u.getS() * (v.getT() - w.getT()) + v.getS() * (w.getT() - u.getT()) + w.getS() * (u.getT() - v.getT()) >= 0.0;
    }

    public final double Interpolate(double a, double x, double b, double y) {
        double a2 = a;
        double b2 = b;
        a2 = a2 < 0.0 ? 0.0 : a2;
        double d = b2 = b2 < 0.0 ? 0.0 : b2;
        return a2 <= b2 ? (b2 == 0.0 ? (x + y) / 2.0 : x + (y - x) * (a2 / (a2 + b2))) : y + (x - y) * (b2 / (a2 + b2));
    }

    public final void EdgeIntersect(@NotNull GLUvertex o1, @NotNull GLUvertex d1, @NotNull GLUvertex o2, @NotNull GLUvertex d2, @NotNull GLUvertex v) {
        GLUvertex temp;
        Intrinsics.checkNotNullParameter(o1, "o1");
        Intrinsics.checkNotNullParameter(d1, "d1");
        Intrinsics.checkNotNullParameter(o2, "o2");
        Intrinsics.checkNotNullParameter(d2, "d2");
        Intrinsics.checkNotNullParameter(v, "v");
        GLUvertex o12 = o1;
        GLUvertex d12 = d1;
        GLUvertex o22 = o2;
        GLUvertex d22 = d2;
        double z1 = 0.0;
        double z2 = 0.0;
        if (!this.VertLeq(o12, d12)) {
            temp = o12;
            o12 = d12;
            d12 = temp;
        }
        if (!this.VertLeq(o22, d22)) {
            temp = o22;
            o22 = d22;
            d22 = temp;
        }
        if (!this.VertLeq(o12, o22)) {
            temp = o12;
            o12 = o22;
            o22 = temp;
            temp = d12;
            d12 = d22;
            d22 = temp;
        }
        if (!this.VertLeq(o22, d12)) {
            v.setS((o22.getS() + d12.getS()) / 2.0);
        } else if (this.VertLeq(d12, d22)) {
            z1 = this.EdgeEval(o12, o22, d12);
            if (z1 + (z2 = this.EdgeEval(o22, d12, d22)) < 0.0) {
                z1 = -z1;
                z2 = -z2;
            }
            v.setS(this.Interpolate(z1, o22.getS(), z2, d12.getS()));
        } else {
            z1 = this.EdgeSign(o12, o22, d12);
            if (z1 + (z2 = -this.EdgeSign(o12, d22, d12)) < 0.0) {
                z1 = -z1;
                z2 = -z2;
            }
            v.setS(this.Interpolate(z1, o22.getS(), z2, d22.getS()));
        }
        if (!this.TransLeq(o12, d12)) {
            temp = o12;
            o12 = d12;
            d12 = temp;
        }
        if (!this.TransLeq(o22, d22)) {
            temp = o22;
            o22 = d22;
            d22 = temp;
        }
        if (!this.TransLeq(o12, o22)) {
            temp = o22;
            o22 = o12;
            o12 = temp;
            temp = d22;
            d22 = d12;
            d12 = temp;
        }
        if (!this.TransLeq(o22, d12)) {
            v.setT((o22.getT() + d12.getT()) / 2.0);
        } else if (this.TransLeq(d12, d22)) {
            z1 = this.TransEval(o12, o22, d12);
            if (z1 + (z2 = this.TransEval(o22, d12, d22)) < 0.0) {
                z1 = -z1;
                z2 = -z2;
            }
            v.setT(this.Interpolate(z1, o22.getT(), z2, d12.getT()));
        } else {
            z1 = this.TransSign(o12, o22, d12);
            if (z1 + (z2 = -this.TransSign(o12, d22, d12)) < 0.0) {
                z1 = -z1;
                z2 = -z2;
            }
            v.setT(this.Interpolate(z1, o22.getT(), z2, d22.getT()));
        }
    }

    public final boolean VertEq(@NotNull GLUvertex u, @NotNull GLUvertex v) {
        Intrinsics.checkNotNullParameter(u, "u");
        Intrinsics.checkNotNullParameter(v, "v");
        return u.getS() == v.getS() && u.getT() == v.getT();
    }

    public final boolean VertLeq(@NotNull GLUvertex u, @NotNull GLUvertex v) {
        Intrinsics.checkNotNullParameter(u, "u");
        Intrinsics.checkNotNullParameter(v, "v");
        return u.getS() < v.getS() || u.getS() == v.getS() && u.getT() <= v.getT();
    }

    public final boolean TransLeq(@NotNull GLUvertex u, @NotNull GLUvertex v) {
        Intrinsics.checkNotNullParameter(u, "u");
        Intrinsics.checkNotNullParameter(v, "v");
        return u.getT() < v.getT() || u.getT() == v.getT() && u.getS() <= v.getS();
    }

    public final boolean EdgeGoesLeft(@NotNull GLUhalfEdge e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Object object = e.getSym();
        if (object == null || (object = ((GLUhalfEdge)object).getOrg()) == null) {
            throw new IllegalStateException("sym.org == null".toString());
        }
        GLUvertex gLUvertex = e.getOrg();
        if (gLUvertex == null) {
            throw new IllegalStateException("e.org == null".toString());
        }
        return this.VertLeq((GLUvertex)object, gLUvertex);
    }

    public final boolean EdgeGoesRight(@NotNull GLUhalfEdge e) {
        Intrinsics.checkNotNullParameter(e, "e");
        GLUvertex gLUvertex = e.getOrg();
        if (gLUvertex == null) {
            throw new IllegalStateException("e.org == null".toString());
        }
        Object object = e.getSym();
        if (object == null || (object = ((GLUhalfEdge)object).getOrg()) == null) {
            throw new IllegalStateException("e.sym.org == null".toString());
        }
        return this.VertLeq(gLUvertex, (GLUvertex)object);
    }

    public final double VertL1dist(@NotNull GLUvertex u, @NotNull GLUvertex v) {
        Intrinsics.checkNotNullParameter(u, "u");
        Intrinsics.checkNotNullParameter(v, "v");
        return Math.abs(u.getS() - v.getS()) + Math.abs(u.getT() - v.getT());
    }
}

