/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.kartifex.Vec2;
import org.openrndr.kartifex.Vec3;
import org.openrndr.kartifex.Vec4;
import org.openrndr.kartifex.utils.ScalarsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0015\bf\u0018\u0000 -*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001-J%\u0010\u0003\u001a\u00028\u00002\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007H&\u00a2\u0006\u0002\u0010\bJ.\u0010\t\u001a\u00020\u00062\u001c\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\u0006H&J&\u0010\t\u001a\u00020\u00062\u001c\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\nj\u0002`\u000bH&J3\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u00002\u001c\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\nj\u0002`\u000bH&\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u00020\u00112\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u0005j\u0002`\u0012H&J \u0010\u0013\u001a\u00020\u00112\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u0005j\u0002`\u0012H&J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H&J\b\u0010\u0017\u001a\u00020\u0016H&J\b\u0010\u0018\u001a\u00020\u0019H&J\r\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010 \u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010 \u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010!\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010!\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010#\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010#\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0002\u0010\u001fJ\r\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010%\u001a\u00020\u0006H\u0016J\b\u0010&\u001a\u00020\u0006H\u0016J\r\u0010'\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\r\u0010(\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010,\u00a8\u0006."}, d2={"Lorg/openrndr/kartifex/Vec;", "T", "", "map", "f", "Lkotlin/Function1;", "", "Lorg/openrndr/kartifex/DoubleUnaryOperator;", "(Lkotlin/jvm/functions/Function1;)Lorg/openrndr/kartifex/Vec;", "reduce", "Lkotlin/Function2;", "Lorg/openrndr/kartifex/DoubleBinaryOperator;", "init", "zip", "v", "(Lorg/openrndr/kartifex/Vec;Lkotlin/jvm/functions/Function2;)Lorg/openrndr/kartifex/Vec;", "every", "", "Lorg/openrndr/kartifex/DoublePredicate;", "any", "nth", "idx", "", "dim", "array", "", "negate", "()Lorg/openrndr/kartifex/Vec;", "add", "(Lorg/openrndr/kartifex/Vec;)Lorg/openrndr/kartifex/Vec;", "n", "(D)Lorg/openrndr/kartifex/Vec;", "sub", "mul", "k", "div", "abs", "lengthSquared", "length", "norm", "pseudoNorm", "clamp", "min", "max", "(DD)Lorg/openrndr/kartifex/Vec;", "Companion", "openrndr-kartifex"})
public interface Vec<T extends Vec<T>>
extends Comparable<T> {
    @NotNull
    public static final Companion Companion = org.openrndr.kartifex.Vec$Companion.$$INSTANCE;

    @NotNull
    public T map(@NotNull Function1<? super Double, Double> var1);

    public double reduce(@NotNull Function2<? super Double, ? super Double, Double> var1, double var2);

    public double reduce(@NotNull Function2<? super Double, ? super Double, Double> var1);

    @NotNull
    public T zip(@NotNull T var1, @NotNull Function2<? super Double, ? super Double, Double> var2);

    public boolean every(@NotNull Function1<? super Double, Boolean> var1);

    public boolean any(@NotNull Function1<? super Double, Boolean> var1);

    public double nth(int var1);

    public int dim();

    @NotNull
    public double[] array();

    @NotNull
    public T negate();

    @NotNull
    public T add(@NotNull T var1);

    @NotNull
    public T add(double var1);

    @NotNull
    public T sub(@NotNull T var1);

    @NotNull
    public T sub(double var1);

    @NotNull
    public T mul(@NotNull T var1);

    @NotNull
    public T mul(double var1);

    @NotNull
    public T div(@NotNull T var1);

    @NotNull
    public T div(double var1);

    @NotNull
    public T abs();

    public double lengthSquared();

    public double length();

    @NotNull
    public T norm();

    @NotNull
    public T pseudoNorm();

    @NotNull
    public T clamp(double var1, double var3);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dJ+\u0010\u001e\u001a\u00020\u0006\"\u000e\b\u0001\u0010\u001f*\b\u0012\u0004\u0012\u0002H\u001f0 2\u0006\u0010!\u001a\u0002H\u001f2\u0006\u0010\"\u001a\u0002H\u001f\u00a2\u0006\u0002\u0010#J\u0016\u0010\u001e\u001a\u00020\u00062\u0006\u0010!\u001a\u00020$2\u0006\u0010\"\u001a\u00020$J3\u0010%\u001a\u0002H\u001f\"\u000e\b\u0001\u0010\u001f*\b\u0012\u0004\u0012\u0002H\u001f0 2\u0006\u0010!\u001a\u0002H\u001f2\u0006\u0010\"\u001a\u0002H\u001f2\u0006\u0010&\u001a\u00020\u0006\u00a2\u0006\u0002\u0010'J\u001e\u0010%\u001a\u00020$2\u0006\u0010!\u001a\u00020$2\u0006\u0010\"\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0006J3\u0010%\u001a\u0002H\u001f\"\u000e\b\u0001\u0010\u001f*\b\u0012\u0004\u0012\u0002H\u001f0 2\u0006\u0010!\u001a\u0002H\u001f2\u0006\u0010\"\u001a\u0002H\u001f2\u0006\u0010&\u001a\u0002H\u001f\u00a2\u0006\u0002\u0010(J\u001e\u0010%\u001a\u00020$2\u0006\u0010!\u001a\u00020$2\u0006\u0010\"\u001a\u00020$2\u0006\u0010&\u001a\u00020$J3\u0010)\u001a\u00020*\"\u000e\b\u0001\u0010\u001f*\b\u0012\u0004\u0012\u0002H\u001f0 2\u0006\u0010!\u001a\u0002H\u001f2\u0006\u0010\"\u001a\u0002H\u001f2\u0006\u0010+\u001a\u00020\u0006\u00a2\u0006\u0002\u0010,R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR'\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR'\u0010\u000f\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR'\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR'\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR'\u0010\u0015\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR'\u0010\u0017\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR'\u0010\u0019\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000e\u00a8\u0006-"}, d2={"Lorg/openrndr/kartifex/Vec$Companion;", "", "<init>", "()V", "NEGATE", "Lkotlin/Function1;", "", "Lorg/openrndr/kartifex/DoubleUnaryOperator;", "getNEGATE", "()Lkotlin/jvm/functions/Function1;", "ADD", "Lkotlin/Function2;", "Lorg/openrndr/kartifex/DoubleBinaryOperator;", "getADD", "()Lkotlin/jvm/functions/Function2;", "MUL", "getMUL", "SUB", "getSUB", "DIV", "getDIV", "DELTA", "getDELTA", "MIN", "getMIN", "MAX", "getMAX", "from", "ary", "", "dot", "T", "Lorg/openrndr/kartifex/Vec;", "a", "b", "(Lorg/openrndr/kartifex/Vec;Lorg/openrndr/kartifex/Vec;)D", "Lorg/openrndr/kartifex/Vec2;", "lerp", "t", "(Lorg/openrndr/kartifex/Vec;Lorg/openrndr/kartifex/Vec;D)Lorg/openrndr/kartifex/Vec;", "(Lorg/openrndr/kartifex/Vec;Lorg/openrndr/kartifex/Vec;Lorg/openrndr/kartifex/Vec;)Lorg/openrndr/kartifex/Vec;", "equals", "", "tolerance", "(Lorg/openrndr/kartifex/Vec;Lorg/openrndr/kartifex/Vec;D)Z", "openrndr-kartifex"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Function1<Double, Double> NEGATE;
        @NotNull
        private static final Function2<Double, Double, Double> ADD;
        @NotNull
        private static final Function2<Double, Double, Double> MUL;
        @NotNull
        private static final Function2<Double, Double, Double> SUB;
        @NotNull
        private static final Function2<Double, Double, Double> DIV;
        @NotNull
        private static final Function2<Double, Double, Double> DELTA;
        @NotNull
        private static final Function2<Double, Double, Double> MIN;
        @NotNull
        private static final Function2<Double, Double, Double> MAX;

        private Companion() {
        }

        @NotNull
        public final Function1<Double, Double> getNEGATE() {
            return NEGATE;
        }

        @NotNull
        public final Function2<Double, Double, Double> getADD() {
            return ADD;
        }

        @NotNull
        public final Function2<Double, Double, Double> getMUL() {
            return MUL;
        }

        @NotNull
        public final Function2<Double, Double, Double> getSUB() {
            return SUB;
        }

        @NotNull
        public final Function2<Double, Double, Double> getDIV() {
            return DIV;
        }

        @NotNull
        public final Function2<Double, Double, Double> getDELTA() {
            return DELTA;
        }

        @NotNull
        public final Function2<Double, Double, Double> getMIN() {
            return MIN;
        }

        @NotNull
        public final Function2<Double, Double, Double> getMAX() {
            return MAX;
        }

        @NotNull
        public final Object from(@NotNull double[] ary) {
            Intrinsics.checkNotNullParameter(ary, "ary");
            return switch (ary.length) {
                case 2 -> new Vec2(ary[0], ary[1]);
                case 3 -> new Vec3(ary[0], ary[1], ary[2]);
                case 4 -> new Vec4(ary[0], ary[1], ary[2], ary[3]);
                default -> throw new IllegalStateException("ary must have a length in [1,4]".toString());
            };
        }

        public final <T extends Vec<T>> double dot(@NotNull T a, @NotNull T b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return a.mul(b).reduce(ADD);
        }

        public final double dot(@NotNull Vec2 a, @NotNull Vec2 b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return a.x() * b.x() + a.y() * b.y();
        }

        @NotNull
        public final <T extends Vec<T>> T lerp(@NotNull T a, @NotNull T b, double t) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return a.add(b.sub(a).mul(t));
        }

        @NotNull
        public final Vec2 lerp(@NotNull Vec2 a, @NotNull Vec2 b, double t) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return new Vec2(a.x() + (b.x() - a.x()) * t, a.y() + (b.y() - a.y()) * t);
        }

        @NotNull
        public final <T extends Vec<T>> T lerp(@NotNull T a, @NotNull T b, @NotNull T t) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            Intrinsics.checkNotNullParameter(t, "t");
            return a.add(b.sub(a).mul(t));
        }

        @NotNull
        public final Vec2 lerp(@NotNull Vec2 a, @NotNull Vec2 b, @NotNull Vec2 t) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            Intrinsics.checkNotNullParameter(t, "t");
            return new Vec2(a.x() + (b.x() - a.x()) * t.x(), a.y() + (b.y() - a.y()) * t.y());
        }

        public final <T extends Vec<T>> boolean equals(@NotNull T a, @NotNull T b, double tolerance) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return a.zip(b, DELTA).every(arg_0 -> Companion.equals$lambda$8(tolerance, arg_0));
        }

        private static final double NEGATE$lambda$0(double n) {
            return -n;
        }

        private static final double ADD$lambda$1(double a, double b) {
            return a + b;
        }

        private static final double MUL$lambda$2(double a, double b) {
            return a * b;
        }

        private static final double SUB$lambda$3(double a, double b) {
            return a - b;
        }

        private static final double DIV$lambda$4(double a, double b) {
            return a / b;
        }

        private static final double DELTA$lambda$5(double a, double b) {
            return Math.abs(a - b);
        }

        private static final double MIN$lambda$6(double a, double b) {
            return Math.min(a, b);
        }

        private static final double MAX$lambda$7(double a, double b) {
            return Math.max(a, b);
        }

        private static final boolean equals$lambda$8(double $tolerance, double i) {
            return i <= $tolerance;
        }

        static {
            $$INSTANCE = new Companion();
            NEGATE = Companion::NEGATE$lambda$0;
            ADD = Companion::ADD$lambda$1;
            MUL = Companion::MUL$lambda$2;
            SUB = Companion::SUB$lambda$3;
            DIV = Companion::DIV$lambda$4;
            DELTA = Companion::DELTA$lambda$5;
            MIN = Companion::MIN$lambda$6;
            MAX = Companion::MAX$lambda$7;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static <T extends Vec<T>> T negate(@NotNull Vec<T> $this) {
            return $this.map(Companion.getNEGATE());
        }

        @NotNull
        public static <T extends Vec<T>> T add(@NotNull Vec<T> $this, @NotNull T v) {
            Intrinsics.checkNotNullParameter(v, "v");
            return $this.zip(v, Companion.getADD());
        }

        @NotNull
        public static <T extends Vec<T>> T add(@NotNull Vec<T> $this, double n) {
            return $this.map(arg_0 -> DefaultImpls.add$lambda$0(n, arg_0));
        }

        @NotNull
        public static <T extends Vec<T>> T sub(@NotNull Vec<T> $this, @NotNull T v) {
            Intrinsics.checkNotNullParameter(v, "v");
            return $this.zip(v, Companion.getSUB());
        }

        @NotNull
        public static <T extends Vec<T>> T sub(@NotNull Vec<T> $this, double n) {
            return $this.map(arg_0 -> DefaultImpls.sub$lambda$1(n, arg_0));
        }

        @NotNull
        public static <T extends Vec<T>> T mul(@NotNull Vec<T> $this, @NotNull T v) {
            Intrinsics.checkNotNullParameter(v, "v");
            return $this.zip(v, Companion.getMUL());
        }

        @NotNull
        public static <T extends Vec<T>> T mul(@NotNull Vec<T> $this, double k) {
            return $this.map(arg_0 -> DefaultImpls.mul$lambda$2(k, arg_0));
        }

        @NotNull
        public static <T extends Vec<T>> T div(@NotNull Vec<T> $this, @NotNull T v) {
            Intrinsics.checkNotNullParameter(v, "v");
            return $this.zip(v, Companion.getDIV());
        }

        @NotNull
        public static <T extends Vec<T>> T div(@NotNull Vec<T> $this, double k) {
            return $this.mul(1.0 / k);
        }

        @NotNull
        public static <T extends Vec<T>> T abs(@NotNull Vec<T> $this) {
            return $this.map(DefaultImpls::abs$lambda$3);
        }

        public static <T extends Vec<T>> double lengthSquared(@NotNull Vec<T> $this) {
            Intrinsics.checkNotNull($this, "null cannot be cast to non-null type T of org.openrndr.kartifex.Vec");
            return Companion.dot($this, $this);
        }

        public static <T extends Vec<T>> double length(@NotNull Vec<T> $this) {
            return Math.sqrt($this.lengthSquared());
        }

        @NotNull
        public static <T extends Vec<T>> T norm(@NotNull Vec<T> $this) {
            Vec<T> vec;
            double l = $this.lengthSquared();
            if (l == 1.0) {
                Intrinsics.checkNotNull($this, "null cannot be cast to non-null type T of org.openrndr.kartifex.Vec");
                vec = $this;
            } else {
                vec = $this.div(Math.sqrt(l));
            }
            return (T)vec;
        }

        @NotNull
        public static <T extends Vec<T>> T pseudoNorm(@NotNull Vec<T> $this) {
            Object object;
            int exponent = ScalarsKt.getExponent($this.reduce(Companion.getMAX()));
            if ((double)exponent < -8.0 || (double)exponent > 8.0) {
                object = $this.mul(Math.pow(2.0, -((double)exponent)));
            } else {
                Intrinsics.checkNotNull($this, "null cannot be cast to non-null type T of org.openrndr.kartifex.Vec");
                object = $this;
            }
            return object;
        }

        @NotNull
        public static <T extends Vec<T>> T clamp(@NotNull Vec<T> $this, double min, double max) {
            return $this.map(arg_0 -> DefaultImpls.clamp$lambda$4(min, max, arg_0));
        }

        private static double add$lambda$0(double $n, double i) {
            return i + $n;
        }

        private static double sub$lambda$1(double $n, double i) {
            return i - $n;
        }

        private static double mul$lambda$2(double $k, double i) {
            return i * $k;
        }

        private static double abs$lambda$3(double a) {
            return Math.abs(a);
        }

        private static double clamp$lambda$4(double $min, double $max, double x) {
            return RangesKt.coerceIn(x, $min, $max);
        }
    }
}

