/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.kartifex.Bezier2;
import org.openrndr.kartifex.Box;
import org.openrndr.kartifex.Box2;
import org.openrndr.kartifex.Curve2;
import org.openrndr.kartifex.Line2;
import org.openrndr.kartifex.Matrix3;
import org.openrndr.kartifex.Region2;
import org.openrndr.kartifex.Vec;
import org.openrndr.kartifex.Vec2;
import org.openrndr.kartifex.utils.Intersections;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0002!\"B/\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0017\b\u0016\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lorg/openrndr/kartifex/Ring2;", "", "curves", "", "Lorg/openrndr/kartifex/Curve2;", "bounds", "Lorg/openrndr/kartifex/Box2;", "isClockwise", "", "area", "", "<init>", "([Lorg/openrndr/kartifex/Curve2;Lorg/openrndr/kartifex/Box2;ZD)V", "cs", "", "(Ljava/lang/Iterable;)V", "getCurves", "()[Lorg/openrndr/kartifex/Curve2;", "[Lorg/openrndr/kartifex/Curve2;", "getBounds", "()Lorg/openrndr/kartifex/Box2;", "()Z", "getArea", "()D", "region", "Lorg/openrndr/kartifex/Region2;", "test", "Lorg/openrndr/kartifex/Ring2$Result;", "p", "Lorg/openrndr/kartifex/Vec2;", "transform", "m", "Lorg/openrndr/kartifex/Matrix3;", "Result", "Companion", "openrndr-kartifex"})
@SourceDebugExtension(value={"SMAP\nRing2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ring2.kt\norg/openrndr/kartifex/Ring2\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n37#2:179\n36#2,3:180\n11158#3:183\n11493#3,3:184\n11158#3:204\n11493#3,3:205\n774#4:187\n865#4,2:188\n2341#4,14:190\n*S KotlinDebug\n*F\n+ 1 Ring2.kt\norg/openrndr/kartifex/Ring2\n*L\n59#1:179\n59#1:180,3\n100#1:183\n100#1:184,3\n129#1:204\n129#1:205,3\n108#1:187\n108#1:188,2\n109#1:190,14\n*E\n"})
public final class Ring2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Curve2[] curves;
    @NotNull
    private final Box2 bounds;
    private final boolean isClockwise;
    private final double area;

    @NotNull
    public final Curve2[] getCurves() {
        return this.curves;
    }

    @NotNull
    public final Box2 getBounds() {
        return this.bounds;
    }

    public final boolean isClockwise() {
        return this.isClockwise;
    }

    public final double getArea() {
        return this.area;
    }

    private Ring2(Curve2[] curves, Box2 bounds, boolean isClockwise, double area) {
        this.curves = curves;
        this.bounds = bounds;
        this.isClockwise = isClockwise;
        this.area = area;
    }

    public Ring2(@NotNull Iterable<? extends Curve2> cs) {
        Intrinsics.checkNotNullParameter(cs, "cs");
        Box2 bounds = Box2.Companion.getEMPTY();
        double signedArea = 0.0;
        ArrayDeque<Curve2> list = new ArrayDeque<Curve2>();
        for (Curve2 curve2 : cs) {
            for (Curve2 b : curve2.split(curve2.inflections())) {
                list.addLast(b);
                bounds = (Box2)((Box2)bounds.union((Vec)b.start())).union((Vec)b.end());
                signedArea += b.signedArea();
            }
        }
        this.isClockwise = signedArea < 0.0;
        this.area = Math.abs(signedArea);
        this.bounds = bounds;
        Collection $this$toTypedArray$iv = list;
        boolean n = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.curves = thisCollection$iv.toArray(new Curve2[0]);
        int n2 = this.curves.length - 1;
        for (int i = 0; i < n2; ++i) {
            this.curves[i] = this.curves[i].endpoints(this.curves[i].start(), this.curves[i + 1].start());
        }
        int lastIdx = this.curves.length - 1;
        this.curves[lastIdx] = this.curves[lastIdx].endpoints(this.curves[lastIdx].start(), this.curves[0].start());
    }

    @NotNull
    public final Region2 region() {
        return new Region2((Iterable<Ring2>)CollectionsKt.listOf(this));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Result test(@NotNull Vec2 p) {
        Intrinsics.checkNotNullParameter(p, "p");
        if (!((Box2)this.bounds.expand(1.0E-5)).contains((Vec)p)) {
            return Result.Companion.getOUTSIDE();
        }
        Line2 ray = Line2.Companion.line(p, new Vec2(this.bounds.getUx() + 1.0, p.y()));
        int count2 = 0;
        for (Curve2 c2 : this.curves) {
            Object v1;
            void $this$minByOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            boolean flat;
            Box2 b = c2.bounds();
            boolean bl = flat = b.height() == 0.0;
            if (p.x() < b.getLx()) {
                if (!(p.y() >= b.getLy()) || !(p.y() < b.getUy())) continue;
                ++count2;
                continue;
            }
            if (!((Box2)b.expand((Vec)new Vec2(1.0E-5, 0.0))).contains((Vec)p)) continue;
            Vec2[] vec2Array = Intersections.INSTANCE.lineCurve(ray, c2);
            boolean $i$f$map = false;
            void var13_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void v;
                void item$iv$iv;
                void var21_27 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(v.map(Ring2::test$lambda$1$lambda$0));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Vec2 v = (Vec2)element$iv$iv;
                boolean bl3 = false;
                if (!Intersections.INSTANCE.getPARAMETRIC_BOUNDS().contains((Vec)v)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    Vec2 v = (Vec2)minElem$iv;
                    boolean bl4 = false;
                    double minValue$iv = v.x();
                    do {
                        Object e$iv = iterator$iv.next();
                        Vec2 v2 = (Vec2)e$iv;
                        $i$a$-minByOrNull-Ring2$test$i$3 = false;
                        double v$iv = v2.x();
                        if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            Vec2 i = v1;
            if (i == null) continue;
            if (i.x() == 0.0) {
                return new Result(c2);
            }
            if (flat || !(p.y() < b.getUy())) continue;
            ++count2;
        }
        return count2 % 2 == 1 ? Result.Companion.getINSIDE() : Result.Companion.getOUTSIDE();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Ring2 transform(@NotNull Matrix3 m) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(m, "m");
        Curve2[] $this$map$iv = this.curves;
        boolean $i$f$map = false;
        Curve2[] curve2Array = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void c2;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(c2.transform(m));
        }
        Iterable iterable = (List)destination$iv$iv;
        return new Ring2(iterable);
    }

    private static final double test$lambda$1$lambda$0(double n) {
        return Intersections.INSTANCE.round(n, 1.0E-5);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\u0005\u00a8\u0006\f"}, d2={"Lorg/openrndr/kartifex/Ring2$Companion;", "", "<init>", "()V", "of", "Lorg/openrndr/kartifex/Ring2;", "cs", "", "Lorg/openrndr/kartifex/Curve2;", "([Lorg/openrndr/kartifex/Curve2;)Lorg/openrndr/kartifex/Ring2;", "square", "circle", "openrndr-kartifex"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Ring2 of(Curve2 ... cs) {
            Intrinsics.checkNotNullParameter(cs, "cs");
            return new Ring2((Iterable<? extends Curve2>)ArraysKt.toList(cs));
        }

        @NotNull
        public final Ring2 square() {
            return Box.Companion.box(new Vec2(0.0, 0.0), new Vec2(1.0, 1.0)).outline();
        }

        @NotNull
        public final Ring2 circle() {
            double k = 1.3333333333333333 * (Math.sqrt(2.0) - 1.0);
            Curve2[] curve2Array = new Curve2[]{Bezier2.INSTANCE.curve(new Vec2(1.0, 0.0), new Vec2(1.0, k), new Vec2(k, 1.0), new Vec2(0.0, 1.0)), Bezier2.INSTANCE.curve(new Vec2(0.0, 1.0), new Vec2(-k, 1.0), new Vec2(-1.0, k), new Vec2(-1.0, 0.0)), Bezier2.INSTANCE.curve(new Vec2(-1.0, 0.0), new Vec2(-1.0, -k), new Vec2(-k, -1.0), new Vec2(0.0, -1.0)), Bezier2.INSTANCE.curve(new Vec2(0.0, -1.0), new Vec2(k, -1.0), new Vec2(1.0, -k), new Vec2(1.0, 0.0))};
            return this.of(curve2Array);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lorg/openrndr/kartifex/Ring2$Result;", "", "inside", "", "curve", "Lorg/openrndr/kartifex/Curve2;", "<init>", "(ZLorg/openrndr/kartifex/Curve2;)V", "(Lorg/openrndr/kartifex/Curve2;)V", "getInside", "()Z", "getCurve", "()Lorg/openrndr/kartifex/Curve2;", "toString", "", "Companion", "openrndr-kartifex"})
    public static final class Result {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean inside;
        @Nullable
        private final Curve2 curve;
        @NotNull
        private static final Result INSIDE = new Result(true, null);
        @NotNull
        private static final Result OUTSIDE = new Result(false, null);

        private Result(boolean inside, Curve2 curve) {
            this.inside = inside;
            this.curve = curve;
        }

        public final boolean getInside() {
            return this.inside;
        }

        @Nullable
        public final Curve2 getCurve() {
            return this.curve;
        }

        public Result(@NotNull Curve2 curve) {
            Intrinsics.checkNotNullParameter(curve, "curve");
            this(true, curve);
        }

        @NotNull
        public String toString() {
            return this.inside ? (this.curve == null ? "INSIDE" : "EDGE: " + this.curve) : "OUTSIDE";
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/openrndr/kartifex/Ring2$Result$Companion;", "", "<init>", "()V", "INSIDE", "Lorg/openrndr/kartifex/Ring2$Result;", "getINSIDE", "()Lorg/openrndr/kartifex/Ring2$Result;", "OUTSIDE", "getOUTSIDE", "openrndr-kartifex"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Result getINSIDE() {
                return INSIDE;
            }

            @NotNull
            public final Result getOUTSIDE() {
                return OUTSIDE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

