/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.kartifex.Box;
import org.openrndr.kartifex.Box2;
import org.openrndr.kartifex.Interval;
import org.openrndr.kartifex.Matrix3;
import org.openrndr.kartifex.Vec;
import org.openrndr.kartifex.Vec2;
import org.openrndr.kartifex.utils.Intersections;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0005H&J\b\u0010\u0007\u001a\u00020\u0005H&J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u001b\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\r2\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H&J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\u001b\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0003H&J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u001f\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#H&J\b\u0010$\u001a\u00020\u0000H&J\b\u0010%\u001a\u00020\u0018H&J\u001b\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010'\u001a\u00020\u0000H\u0016\u00a2\u0006\u0002\u0010(\u00a8\u0006)"}, d2={"Lorg/openrndr/kartifex/Curve2;", "", "position", "Lorg/openrndr/kartifex/Vec2;", "t", "", "signedArea", "length", "start", "end", "endpoints", "direction", "split", "", "(D)[Lorg/openrndr/kartifex/Curve2;", "isFlat", "", "epsilon", "range", "interval", "Lorg/openrndr/kartifex/Interval;", "tMin", "tMax", "unsafeTs", "", "([D)[Lorg/openrndr/kartifex/Curve2;", "nearestPoint", "p", "bounds", "Lorg/openrndr/kartifex/Box2;", "subdivide", "error", "(D)[Lorg/openrndr/kartifex/Vec2;", "transform", "m", "Lorg/openrndr/kartifex/Matrix3;", "reverse", "inflections", "intersections", "c", "(Lorg/openrndr/kartifex/Curve2;)[Lorg/openrndr/kartifex/Vec2;", "openrndr-kartifex"})
public interface Curve2 {
    @NotNull
    public Vec2 position(double var1);

    public double signedArea();

    public double length();

    @NotNull
    public Vec2 start();

    @NotNull
    public Vec2 end();

    @NotNull
    public Curve2 endpoints(@NotNull Vec2 var1, @NotNull Vec2 var2);

    @NotNull
    public Vec2 direction(double var1);

    @NotNull
    public Curve2[] split(double var1);

    public boolean isFlat(double var1);

    @NotNull
    public Curve2 range(@NotNull Interval var1);

    @NotNull
    public Curve2 range(double var1, double var3);

    @NotNull
    public Curve2[] split(@NotNull double[] var1);

    public double nearestPoint(@NotNull Vec2 var1);

    @NotNull
    public Box2 bounds();

    @NotNull
    public Vec2[] subdivide(double var1);

    @NotNull
    public Curve2 transform(@NotNull Matrix3 var1);

    @NotNull
    public Curve2 reverse();

    @NotNull
    public double[] inflections();

    @NotNull
    public Vec2[] intersections(@NotNull Curve2 var1);

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nCurve2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Curve2.kt\norg/openrndr/kartifex/Curve2$DefaultImpls\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,155:1\n1#2:156\n11218#3:157\n11553#3,3:158\n37#4:161\n36#4,3:162\n*S KotlinDebug\n*F\n+ 1 Curve2.kt\norg/openrndr/kartifex/Curve2$DefaultImpls\n*L\n97#1:157\n97#1:158,3\n117#1:161\n117#1:162,3\n*E\n"})
    public static final class DefaultImpls {
        @NotNull
        public static Vec2 start(@NotNull Curve2 $this) {
            return $this.position(0.0);
        }

        @NotNull
        public static Vec2 end(@NotNull Curve2 $this) {
            return $this.position(1.0);
        }

        @NotNull
        public static Curve2 range(@NotNull Curve2 $this, @NotNull Interval interval) {
            Intrinsics.checkNotNullParameter(interval, "interval");
            return $this.range(interval.getLo(), interval.getHi());
        }

        @NotNull
        public static Curve2 range(@NotNull Curve2 $this, double tMin, double tMax) {
            if (!(!(tMin == tMax))) {
                boolean $i$a$-require-Curve2$range$32 = false;
                String $i$a$-require-Curve2$range$32 = "range must be non-zero";
                throw new IllegalArgumentException($i$a$-require-Curve2$range$32.toString());
            }
            if (!(tMax >= tMin)) {
                boolean bl = false;
                String string = "tMin must be less than tMax";
                throw new IllegalArgumentException(string.toString());
            }
            return tMin == 0.0 && tMax == 1.0 ? $this : (tMin == 0.0 ? $this.split(tMax)[0] : (tMax == 1.0 ? $this.split(tMin)[1] : $this.split(tMin)[1].split((tMax - tMin) / (1.0 - tMin))[0].endpoints($this.position(tMin), $this.position(tMax))));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Curve2[] split(@NotNull Curve2 $this, @NotNull double[] unsafeTs) {
            Curve2[] $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(unsafeTs, "unsafeTs");
            double previous = Double.POSITIVE_INFINITY;
            int tCount = 0;
            int n = unsafeTs.length;
            for (int i = 0; i < n; ++i) {
                if (!(unsafeTs[i] == previous)) {
                    ++tCount;
                }
                previous = unsafeTs[i];
            }
            double[] ts = new double[tCount];
            tCount = 0;
            previous = Double.POSITIVE_INFINITY;
            int n2 = unsafeTs.length;
            for (int i = 0; i < n2; ++i) {
                if (!(unsafeTs[i] == previous)) {
                    ts[tCount] = unsafeTs[i];
                    ++tCount;
                }
                previous = unsafeTs[i];
            }
            if (ts.length == 0) {
                Curve2[] i = new Curve2[]{$this};
                return i;
            }
            double[] $this$map$iv = ts;
            boolean $i$f$map = false;
            double[] dArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            int $i$f$mapTo = 0;
            int n3 = $this$mapTo$iv$iv.length;
            for (int i = 0; i < n3; ++i) {
                void it;
                void item$iv$iv;
                void var15_20 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((double)it);
            }
            ts = CollectionsKt.toDoubleArray((List)destination$iv$iv);
            ArraysKt.sort(ts);
            int offset = ts[0] == 0.0 ? 1 : 0;
            int len = ts.length - offset - (ts[ts.length - 1] == 1.0 ? 1 : 0);
            ArraysKt.copyInto(ts, ts, 0, offset, offset + len);
            switch (len) {
                case 0: {
                    $this$mapTo$iv$iv = new Curve2[]{$this};
                    return $this$mapTo$iv$iv;
                }
                case 1: {
                    return $this.split(ts[0]);
                }
            }
            Curve2[] result = new Curve2[len + 1];
            result[0] = $this.range(0.0, ts[0]);
            $i$f$mapTo = len - 1;
            for (int i = 0; i < $i$f$mapTo; ++i) {
                result[i + 1] = $this.range(ts[i], ts[i + 1]);
            }
            result[len] = $this.range(ts[len - 1], 1.0);
            Collection $this$toTypedArray$iv = ArraysKt.filterNotNull(result);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Curve2[0]);
        }

        @NotNull
        public static Box2 bounds(@NotNull Curve2 $this) {
            Box2 bounds = Box.Companion.box($this.start(), $this.end());
            for (double t : $this.inflections()) {
                bounds = (Box2)bounds.union((Vec)$this.position(t));
            }
            return bounds;
        }

        @NotNull
        public static Vec2[] intersections(@NotNull Curve2 $this, @NotNull Curve2 c2) {
            Intrinsics.checkNotNullParameter(c2, "c");
            return Intersections.INSTANCE.intersections($this, c2);
        }
    }
}

