/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3.extensions;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.Extension;
import org.openrndr.Program;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.ResizableRenderTarget;
import org.openrndr.draw.ResizableRenderTargetKt;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lorg/openrndr/internal/gl3/extensions/BackBuffer;", "Lorg/openrndr/Extension;", "<init>", "()V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "shadeStyle", "Lorg/openrndr/draw/ShadeStyle;", "getShadeStyle", "()Lorg/openrndr/draw/ShadeStyle;", "rt", "Lorg/openrndr/draw/ResizableRenderTarget;", "getRt", "()Lorg/openrndr/draw/ResizableRenderTarget;", "beforeDraw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "program", "Lorg/openrndr/Program;", "afterDraw", "openrndr-gl3"})
public final class BackBuffer
implements Extension {
    private boolean enabled = true;
    @NotNull
    private final ShadeStyle shadeStyle = ShadeStyleKt.shadeStyle(BackBuffer::shadeStyle$lambda$0);
    @NotNull
    private final ResizableRenderTarget rt;

    public BackBuffer() {
        BackBuffer backBuffer = this;
        BackBuffer backBuffer2 = this;
        boolean bl = false;
        RenderTarget art = RenderTarget.Companion.getActive();
        backBuffer2.rt = ResizableRenderTargetKt.resizableRenderTarget$default(art.getWidth(), art.getHeight(), art.getContentScale(), art.getMultisample(), null, BackBuffer::rt$lambda$2$lambda$1, 16, null);
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @NotNull
    public final ShadeStyle getShadeStyle() {
        return this.shadeStyle;
    }

    @NotNull
    public final ResizableRenderTarget getRt() {
        return this.rt;
    }

    @Override
    public void beforeDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        Intrinsics.checkNotNullParameter(program2, "program");
        this.rt.resize(RenderTarget.Companion.getActive());
        this.rt.getRenderTarget().bind();
        ColorRGBa bc = program2.getBackgroundColor();
        if (bc != null) {
            drawer.clear(bc);
        }
        Extension.DefaultImpls.beforeDraw(this, drawer, program2);
    }

    @Override
    public void afterDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        Intrinsics.checkNotNullParameter(program2, "program");
        this.rt.getRenderTarget().unbind();
        DrawerKt.isolated(drawer, arg_0 -> BackBuffer.afterDraw$lambda$3(drawer, this, arg_0));
    }

    @Override
    public void setup(@NotNull Program program2) {
        Extension.DefaultImpls.setup(this, program2);
    }

    @Override
    public void shutdown(@NotNull Program program2) {
        Extension.DefaultImpls.shutdown(this, program2);
    }

    private static final Unit shadeStyle$lambda$0(ShadeStyle $this$shadeStyle) {
        Intrinsics.checkNotNullParameter($this$shadeStyle, "$this$shadeStyle");
        $this$shadeStyle.setFragmentTransform("const float t = 0.00313066844250063;\nvec3 del = vec3(\n    x_fill.r <= t ? x_fill.r * 12.92 : 1.055 * pow(x_fill.r, 1.0 / 2.4) - 0.055,\n    x_fill.g <= t ? x_fill.g * 12.92 : 1.055 * pow(x_fill.g, 1.0 / 2.4) - 0.055,\n    x_fill.b <= t ? x_fill.b * 12.92 : 1.055 * pow(x_fill.b, 1.0 / 2.4) - 0.055\n);\nx_fill.rgb = del;");
        return Unit.INSTANCE;
    }

    private static final Unit rt$lambda$2$lambda$1(RenderTargetBuilder $this$resizableRenderTarget) {
        Intrinsics.checkNotNullParameter($this$resizableRenderTarget, "$this$resizableRenderTarget");
        RenderTargetBuilder.colorBuffer$default($this$resizableRenderTarget, null, ColorType.UINT8, 1, null);
        RenderTargetBuilder.depthBuffer$default($this$resizableRenderTarget, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit afterDraw$lambda$3(Drawer $drawer, BackBuffer this$0, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.defaults();
        $drawer.setShadeStyle(this$0.shadeStyle);
        $drawer.image(this$0.rt.getRenderTarget().colorBuffer(0));
        return Unit.INSTANCE;
    }
}

