/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3.angle;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.internal.gl3.DriverGL3Configuration;
import org.openrndr.internal.gl3.angle.Angle;
import org.openrndr.platform.Platform;
import org.openrndr.platform.PlatformArchitecture;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0006\u0010\u0002\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "extractAngleLibraries", "", "openrndr-gl3"})
public final class AngleKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(AngleKt::logger$lambda$0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void extractAngleLibraries() {
        String platform = "macos";
        String arch = switch (WhenMappings.$EnumSwitchMapping$0[Platform.INSTANCE.getArchitecture().ordinal()]) {
            case 1 -> "x64";
            case 2 -> "arm64";
            default -> throw new IllegalStateException("architecture not supported".toString());
        };
        String[] stringArray = new String[]{"libEGL.dylib", "libGLESv2.dylib", "libMoltenVK.dylib"};
        List<String> libraries = CollectionsKt.listOf(stringArray);
        logger.debug(AngleKt::extractAngleLibraries$lambda$1);
        File targetDirectory = new File(".");
        for (String library : libraries) {
            if (Angle.class.getResourceAsStream("/org/openrndr/internal/gl3/angle/" + platform + "/" + arch + "/" + library) == null) {
                throw new IllegalStateException((library + " not found in resources").toString());
            }
            File target2 = new File(targetDirectory, library);
            if (!target2.exists() || DriverGL3Configuration.INSTANCE.getOverwriteExistingAngle()) {
                Closeable closeable = new FileOutputStream(target2);
                Throwable throwable = null;
                try {
                    InputStream resource;
                    FileOutputStream it = (FileOutputStream)closeable;
                    boolean bl = false;
                    long l = ByteStreamsKt.copyTo$default(resource, it, 0, 2, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            if (!DriverGL3Configuration.INSTANCE.getDeleteAngleOnExit()) continue;
            target2.deleteOnExit();
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object extractAngleLibraries$lambda$1() {
        return "Loading ANGLE libraries from resources";
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlatformArchitecture.values().length];
            try {
                nArray[PlatformArchitecture.X86_64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformArchitecture.AARCH64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

