/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL12C;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GL44C;
import org.lwjgl.opengl.GL45;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengles.GLES32;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.MagnifyingFilter;
import org.openrndr.draw.MinifyingFilter;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.draw.Session;
import org.openrndr.draw.VolumeTexture;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.ColorBufferGL3;
import org.openrndr.internal.gl3.ColorBufferGL3Kt;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.DriverGL3Configuration;
import org.openrndr.internal.gl3.DriverGL3Kt;
import org.openrndr.internal.gl3.DriverTypeGL;
import org.openrndr.internal.gl3.DriverVersionGL;
import org.openrndr.internal.gl3.GL3Exception;
import org.openrndr.internal.gl3.GLGLESKt;
import org.openrndr.internal.gl3.RenderTargetGL3;
import org.openrndr.internal.gl3.TextureStorageModeGL;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 D2\u00020\u0001:\u0001DBQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\"\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b#J\b\u0010$\u001a\u00020%H\u0016J\u0016\u0010&\u001a\u00020%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020%0(H\u0002J0\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u0003H\u0016J\u0010\u00100\u001a\u00020%2\u0006\u00101\u001a\u000202H\u0016J0\u00103\u001a\u00020%2\u0006\u0010*\u001a\u00020\u00032\u0006\u00104\u001a\u00020,2\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u0003H\u0016J(\u00103\u001a\u00020%2\u0006\u00104\u001a\u00020,2\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u0003H\u0016J(\u0010)\u001a\u00020%2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u0003H\u0016J(\u00107\u001a\u00020%2\u0006\u00104\u001a\u0002082\u0006\u0010*\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u00032\u0006\u0010:\u001a\u00020\u0003H\u0016J\u0018\u0010;\u001a\u00020%2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020%2\u0006\u0010A\u001a\u00020\u0003H\u0016J\b\u0010B\u001a\u00020%H\u0016J\b\u0010C\u001a\u00020%H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\r\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/openrndr/internal/gl3/VolumeTextureGL3;", "Lorg/openrndr/draw/VolumeTexture;", "texture", "", "storageMode", "Lorg/openrndr/internal/gl3/TextureStorageModeGL;", "width", "height", "depth", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "levels", "session", "Lorg/openrndr/draw/Session;", "<init>", "(ILorg/openrndr/internal/gl3/TextureStorageModeGL;IIILorg/openrndr/draw/ColorFormat;Lorg/openrndr/draw/ColorType;ILorg/openrndr/draw/Session;)V", "getTexture", "()I", "getStorageMode", "()Lorg/openrndr/internal/gl3/TextureStorageModeGL;", "getWidth", "getHeight", "getDepth", "getFormat", "()Lorg/openrndr/draw/ColorFormat;", "getType", "()Lorg/openrndr/draw/ColorType;", "getLevels", "getSession", "()Lorg/openrndr/draw/Session;", "destroyed", "", "glFormat", "glFormat$openrndr_gl3", "destroy", "", "bound", "f", "Lkotlin/Function0;", "write", "layer", "source", "Ljava/nio/ByteBuffer;", "sourceFormat", "sourceType", "level", "fill", "color", "Lorg/openrndr/color/ColorRGBa;", "read", "target", "targetFormat", "targetType", "copyTo", "Lorg/openrndr/draw/ColorBuffer;", "fromLevel", "toLevel", "filter", "min", "Lorg/openrndr/draw/MinifyingFilter;", "mag", "Lorg/openrndr/draw/MagnifyingFilter;", "bind", "textureUnit", "generateMipmaps", "close", "Companion", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nVolumeTextureGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VolumeTextureGL3.kt\norg/openrndr/internal/gl3/VolumeTextureGL3\n+ 2 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 3 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$checkGLErrors$1\n+ 4 DriverGL3.kt\norg/openrndr/internal/gl3/DriverGL3Kt\n+ 5 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$debugGLErrors$1\n+ 6 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n*L\n1#1,311:1\n50#2,14:312\n65#2:327\n67#2,3:332\n51#2,13:335\n65#2,7:349\n67#2,3:356\n51#2,13:359\n65#2,7:373\n67#2,3:380\n51#2,13:383\n65#2,7:397\n50#2,14:404\n65#2:419\n67#2,3:426\n51#2,13:429\n65#2,7:443\n67#2,3:450\n51#2,13:453\n65#2,7:467\n67#2,3:474\n51#2,13:477\n65#2,7:491\n67#2,3:498\n51#2,13:501\n65#2,7:515\n50#3:326\n50#3:418\n71#4,4:328\n67#5:348\n67#5:372\n67#5:396\n67#5:442\n67#5:466\n67#5:490\n67#5:514\n1169#6,3:420\n1154#6,3:423\n*S KotlinDebug\n*F\n+ 1 VolumeTextureGL3.kt\norg/openrndr/internal/gl3/VolumeTextureGL3\n*L\n38#1:312,14\n38#1:327\n90#1:332,3\n90#1:335,13\n90#1:349,7\n105#1:356,3\n105#1:359,13\n105#1:373,7\n114#1:380,3\n114#1:383,13\n114#1:397,7\n150#1:404,14\n150#1:419\n63#1:426,3\n63#1:429,13\n63#1:443,7\n78#1:450,3\n78#1:453,13\n78#1:467,7\n80#1:474,3\n80#1:477,13\n80#1:491,7\n175#1:498,3\n175#1:501,13\n175#1:515,7\n38#1:326\n150#1:418\n85#1:328,4\n90#1:348\n105#1:372\n114#1:396\n63#1:442\n78#1:466\n80#1:490\n175#1:514\n163#1:420,3\n193#1:423,3\n*E\n"})
public final class VolumeTextureGL3
implements VolumeTexture {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int texture;
    @NotNull
    private final TextureStorageModeGL storageMode;
    private final int width;
    private final int height;
    private final int depth;
    @NotNull
    private final ColorFormat format;
    @NotNull
    private final ColorType type;
    private final int levels;
    @Nullable
    private final Session session;
    private boolean destroyed;
    private static final boolean useNamedTexture = DriverGL3Kt.getGlVersion(Driver.Companion).compareTo((Enum)DriverVersionGL.GL_VERSION_4_5) >= 0 && DriverGL3Kt.getGlType(Driver.Companion) == DriverTypeGL.GL;

    public VolumeTextureGL3(int texture, @NotNull TextureStorageModeGL storageMode, int width, int height, int depth, @NotNull ColorFormat format, @NotNull ColorType type, int levels, @Nullable Session session) {
        Intrinsics.checkNotNullParameter((Object)storageMode, "storageMode");
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        this.texture = texture;
        this.storageMode = storageMode;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.format = format;
        this.type = type;
        this.levels = levels;
        this.session = session;
    }

    public final int getTexture() {
        return this.texture;
    }

    @NotNull
    public final TextureStorageModeGL getStorageMode() {
        return this.storageMode;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    @NotNull
    public ColorFormat getFormat() {
        return this.format;
    }

    @Override
    @NotNull
    public ColorType getType() {
        return this.type;
    }

    @Override
    public int getLevels() {
        return this.levels;
    }

    @Override
    @Nullable
    public Session getSession() {
        return this.session;
    }

    public final int glFormat$openrndr_gl3() {
        return ((Number)ColorBufferGL3Kt.internalFormat(this.getFormat(), this.getType()).getFirst()).intValue();
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            Session session = this.getSession();
            if (session != null) {
                session.untrack(this);
            }
            GLGLESKt.glDeleteTextures(this.texture);
            this.destroyed = true;
            boolean $i$f$checkGLErrors = false;
            int error$iv = GLGLESKt.glGetError();
            if (error$iv != 0) {
                Object message$iv = switch (error$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv + ">";
                };
                int n = error$iv;
                Object object = message$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var9_8 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var9_8;
                throw new GL3Exception(string);
            }
        }
    }

    private final void bound(Function0<Unit> f) {
        VolumeTexture.DefaultImpls.bind$default(this, 0, 1, null);
        f.invoke();
    }

    @Override
    public void write(int layer, @NotNull ByteBuffer source, @NotNull ColorFormat sourceFormat, @NotNull ColorType sourceType, int level) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter((Object)sourceFormat, "sourceFormat");
        Intrinsics.checkNotNullParameter((Object)sourceType, "sourceType");
        this.bound(() -> VolumeTextureGL3.write$lambda$0(level, sourceType, layer, this, sourceFormat, source));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fill(@NotNull ColorRGBa color) {
        void $this$require$iv;
        Intrinsics.checkNotNullParameter(color, "color");
        Driver driver = Driver.Companion.getInstance();
        Intrinsics.checkNotNull(driver, "null cannot be cast to non-null type org.openrndr.internal.gl3.DriverGL3");
        DriverVersionGL driverVersionGL = ((DriverGL3)driver).getVersion();
        Object minimum$iv = DriverVersionGL.GL_VERSION_4_4;
        boolean $i$f$require = false;
        if (!($this$require$iv.ordinal() >= ((Enum)minimum$iv).ordinal())) {
            boolean bl = false;
            String string = "Feature is not supported on current OpenGL configuration (configuration: " + $this$require$iv.getVersionString() + ", required: " + ((DriverVersionGL)((Object)minimum$iv)).getVersionString() + ")";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.storageMode == TextureStorageModeGL.STORAGE)) {
            minimum$iv = "Failed requirement.";
            throw new IllegalArgumentException(minimum$iv.toString());
        }
        minimum$iv = new float[4];
        minimum$iv[0] = (float)color.getR();
        minimum$iv[1] = (float)color.getG();
        minimum$iv[2] = (float)color.getB();
        minimum$iv[3] = (float)color.getAlpha();
        Object floatData = minimum$iv;
        int n = this.getLevels();
        for (int level = 0; level < n; ++level) {
            GL44C.glClearTexImage(this.texture, level, ColorBufferGL3Kt.glFormat(ColorFormat.RGBa), ColorBufferGL3Kt.glType(ColorType.FLOAT32), (float[])floatData);
            boolean $i$f$debugGLErrors = false;
            if (!DriverGL3Configuration.INSTANCE.getUseDebugContext()) continue;
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv == 0) continue;
            Object message$iv$iv = switch (error$iv$iv) {
                case 1282 -> "GL_INVALID_OPERATION";
                case 1281 -> "GL_INVALID_VALUE";
                case 1280 -> "GL_INVALID_ENUM";
                case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                case 1285 -> "GL_OUT_OF_MEMORY";
                case 1284 -> "GL_STACK_UNDERFLOW";
                case 1283 -> "GL_STACK_OVERFLOW";
                default -> "<untranslated: " + error$iv$iv + ">";
            };
            int n2 = error$iv$iv;
            Object object = message$iv$iv;
            long l = Driver.Companion.getInstance().getContextID();
            boolean bl = false;
            int it = n2;
            Object var15_16 = null;
            String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var15_16;
            throw new GL3Exception(string);
        }
    }

    @Override
    public void read(int layer, @NotNull ByteBuffer target2, @NotNull ColorFormat targetFormat, @NotNull ColorType targetType, int level) {
        Intrinsics.checkNotNullParameter(target2, "target");
        Intrinsics.checkNotNullParameter((Object)targetFormat, "targetFormat");
        Intrinsics.checkNotNullParameter((Object)targetType, "targetType");
        if (!useNamedTexture) {
            throw new IllegalStateException("only implemented for opengl 4.5".toString());
        }
        GL45.glGetTextureSubImage(this.texture, level, 0, 0, layer, this.getWidth(), this.getHeight(), 1, ColorBufferGL3Kt.glFormat(targetFormat), ColorBufferGL3Kt.glType(targetType), target2);
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var15_14 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var15_14;
                throw new GL3Exception(string);
            }
        }
    }

    @Override
    public void read(@NotNull ByteBuffer target2, @NotNull ColorFormat targetFormat, @NotNull ColorType targetType, int level) {
        Intrinsics.checkNotNullParameter(target2, "target");
        Intrinsics.checkNotNullParameter((Object)targetFormat, "targetFormat");
        Intrinsics.checkNotNullParameter((Object)targetType, "targetType");
        if (useNamedTexture) {
            GL45C.glGetTextureImage(this.texture, level, ColorBufferGL3Kt.glFormat(targetFormat), ColorBufferGL3Kt.glType(targetType), target2);
        } else {
            GL12C.glGetTexImage(32879, level, ColorBufferGL3Kt.glFormat(targetFormat), ColorBufferGL3Kt.glType(targetType), target2);
        }
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var14_13 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var14_13;
                throw new GL3Exception(string);
            }
        }
    }

    @Override
    public void write(@NotNull ByteBuffer source, @NotNull ColorFormat sourceFormat, @NotNull ColorType sourceType, int level) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter((Object)sourceFormat, "sourceFormat");
        Intrinsics.checkNotNullParameter((Object)sourceType, "sourceType");
        if (useNamedTexture) {
            GL45C.glTextureSubImage3D(this.texture, level, 0, 0, 0, this.getWidth(), this.getHeight(), this.getDepth(), ColorBufferGL3Kt.glFormat(sourceFormat), ColorBufferGL3Kt.glType(sourceType), source);
        } else {
            GLGLESKt.glBindTexture(32879, this.texture);
            GLGLESKt.glTexSubImage3D(32879, level, 0, 0, 0, this.getWidth(), this.getHeight(), this.getDepth(), ColorBufferGL3Kt.glFormat(sourceFormat), ColorBufferGL3Kt.glType(sourceType), source);
        }
        boolean $i$f$checkGLErrors = false;
        int error$iv = GLGLESKt.glGetError();
        if (error$iv != 0) {
            Object message$iv = switch (error$iv) {
                case 1282 -> "GL_INVALID_OPERATION";
                case 1281 -> "GL_INVALID_VALUE";
                case 1280 -> "GL_INVALID_ENUM";
                case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                case 1285 -> "GL_OUT_OF_MEMORY";
                case 1284 -> "GL_STACK_UNDERFLOW";
                case 1283 -> "GL_STACK_OVERFLOW";
                default -> "<untranslated: " + error$iv + ">";
            };
            int n = error$iv;
            Object object = message$iv;
            long l = Driver.Companion.getInstance().getContextID();
            boolean bl = false;
            int it = n;
            Object var13_12 = null;
            String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var13_12;
            throw new GL3Exception(string);
        }
    }

    @Override
    public void copyTo(@NotNull ColorBuffer target2, int layer, int fromLevel, int toLevel) {
        RenderTargetGL3 readTarget;
        int toDiv;
        Intrinsics.checkNotNullParameter(target2, "target");
        if (Intrinsics.areEqual(target2.getMultisample(), BufferMultisample.Disabled.INSTANCE)) {
            int fromDiv = 1 << fromLevel;
            toDiv = 1 << toLevel;
            RenderTarget renderTarget = RenderTargetKt.renderTarget$default(this.getWidth() / fromDiv, this.getHeight() / fromDiv, 0.0, null, null, arg_0 -> VolumeTextureGL3.copyTo$lambda$1(this, layer, fromLevel, arg_0), 28, null);
            Intrinsics.checkNotNull(renderTarget, "null cannot be cast to non-null type org.openrndr.internal.gl3.RenderTargetGL3");
            readTarget = (RenderTargetGL3)renderTarget;
            ColorBufferGL3 cfr_ignored_0 = (ColorBufferGL3)target2;
            readTarget.bind();
            int src$iv = 36064;
            boolean $i$f$glReadBuffer = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glReadBuffer(src$iv);
                    break;
                }
                case 2: {
                    GLES32.glReadBuffer(src$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        } else {
            throw new IllegalArgumentException("cannot copy to multisample target");
        }
        ((ColorBufferGL3)target2).bound(arg_0 -> VolumeTextureGL3.copyTo$lambda$2(target2, toLevel, toDiv, arg_0));
        readTarget.unbind();
        readTarget.detachColorAttachments();
        readTarget.destroy();
    }

    @Override
    public void filter(@NotNull MinifyingFilter min, @NotNull MagnifyingFilter mag) {
        Intrinsics.checkNotNullParameter((Object)min, "min");
        Intrinsics.checkNotNullParameter((Object)mag, "mag");
        GLGLESKt.glTexParameteri(32879, 10241, ColorBufferGL3Kt.toGLFilter(min));
        GLGLESKt.glTexParameteri(32879, 10240, ColorBufferGL3Kt.toGLFilter(mag));
    }

    @Override
    public void bind(int textureUnit) {
        if (!(!this.destroyed)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int texture$iv = 33984 + textureUnit;
        boolean $i$f$glActiveTexture = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                GL45C.glActiveTexture(texture$iv);
                break;
            }
            case 2: {
                GLES32.glActiveTexture(texture$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        GLGLESKt.glBindTexture(32879, this.texture);
    }

    @Override
    public void generateMipmaps() {
        this.bound(VolumeTextureGL3::generateMipmaps$lambda$3);
    }

    @Override
    public void close() {
        this.destroy();
    }

    private static final Unit write$lambda$0(int $level, ColorType $sourceType, int $layer, VolumeTextureGL3 this$0, ColorFormat $sourceFormat, ByteBuffer $source) {
        int error$iv$iv;
        boolean $i$f$checkGLErrors;
        boolean $i$f$debugGLErrors;
        int div = 1 << $level;
        if ($sourceType.getCompressed()) {
            GL33C.glCompressedTexSubImage3D(32879, $level, 0, 0, $layer, this$0.getWidth() / div, this$0.getHeight() / div, 1, ColorBufferGL3Kt.compressedType($sourceFormat, $sourceType), $source);
            $i$f$debugGLErrors = false;
            if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                $i$f$checkGLErrors = false;
                error$iv$iv = GLGLESKt.glGetError();
                if (error$iv$iv != 0) {
                    Object message$iv$iv = switch (error$iv$iv) {
                        case 1282 -> "GL_INVALID_OPERATION";
                        case 1281 -> "GL_INVALID_VALUE";
                        case 1280 -> "GL_INVALID_ENUM";
                        case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                        case 1285 -> "GL_OUT_OF_MEMORY";
                        case 1284 -> "GL_STACK_UNDERFLOW";
                        case 1283 -> "GL_STACK_OVERFLOW";
                        default -> "<untranslated: " + error$iv$iv + ">";
                    };
                    int n = error$iv$iv;
                    Object object = message$iv$iv;
                    long l = Driver.Companion.getInstance().getContextID();
                    boolean bl = false;
                    int it = n;
                    Object var16_25 = null;
                    String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var16_25;
                    throw new GL3Exception(string);
                }
            }
        } else {
            GL33C.glTexSubImage3D(32879, $level, 0, 0, $layer, this$0.getWidth() / div, this$0.getHeight() / div, 1, ColorBufferGL3Kt.glFormat($sourceFormat), ColorBufferGL3Kt.glType($sourceType), $source);
            $i$f$debugGLErrors = false;
            if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                $i$f$checkGLErrors = false;
                error$iv$iv = GLGLESKt.glGetError();
                if (error$iv$iv != 0) {
                    Object message$iv$iv = switch (error$iv$iv) {
                        case 1282 -> "GL_INVALID_OPERATION";
                        case 1281 -> "GL_INVALID_VALUE";
                        case 1280 -> "GL_INVALID_ENUM";
                        case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                        case 1285 -> "GL_OUT_OF_MEMORY";
                        case 1284 -> "GL_STACK_UNDERFLOW";
                        case 1283 -> "GL_STACK_OVERFLOW";
                        default -> "<untranslated: " + error$iv$iv + ">";
                    };
                    int it = error$iv$iv;
                    Object object = message$iv$iv;
                    long l = Driver.Companion.getInstance().getContextID();
                    boolean bl = false;
                    Object var16_26 = null;
                    String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var16_26;
                    throw new GL3Exception(string);
                }
            }
        }
        $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            $i$f$checkGLErrors = false;
            error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int it = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                Object var16_27 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var16_27;
                throw new GL3Exception(string);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit copyTo$lambda$1(VolumeTextureGL3 this$0, int $layer, int $fromLevel, RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        $this$renderTarget.volumeTexture(this$0, $layer, $fromLevel);
        return Unit.INSTANCE;
    }

    private static final Unit copyTo$lambda$2(ColorBuffer $target, int $toLevel, int $toDiv, ColorBufferGL3 $this$bound) {
        Intrinsics.checkNotNullParameter($this$bound, "$this$bound");
        GLGLESKt.glCopyTexSubImage2D(((ColorBufferGL3)$target).getTarget(), $toLevel, 0, 0, 0, 0, ((ColorBufferGL3)$target).getWidth() / $toDiv, ((ColorBufferGL3)$target).getHeight() / $toDiv);
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            boolean $i$f$checkGLErrors = false;
            int error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var13_12 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var13_12;
                throw new GL3Exception(string);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateMipmaps$lambda$3() {
        GLGLESKt.glGenerateMipmap(34067);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/openrndr/internal/gl3/VolumeTextureGL3$Companion;", "", "<init>", "()V", "useNamedTexture", "", "getUseNamedTexture", "()Z", "create", "Lorg/openrndr/internal/gl3/VolumeTextureGL3;", "width", "", "height", "depth", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "levels", "session", "Lorg/openrndr/draw/Session;", "openrndr-gl3"})
    @SourceDebugExtension(value={"SMAP\nVolumeTextureGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VolumeTextureGL3.kt\norg/openrndr/internal/gl3/VolumeTextureGL3$Companion\n+ 2 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 3 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n+ 4 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$checkGLErrors$1\n*L\n1#1,311:1\n68#2,2:312\n51#2,21:314\n50#2,14:338\n65#2:353\n50#2,14:354\n65#2:369\n50#2,14:370\n65#2:385\n1154#3,3:335\n50#4:352\n50#4:368\n50#4:384\n*S KotlinDebug\n*F\n+ 1 VolumeTextureGL3.kt\norg/openrndr/internal/gl3/VolumeTextureGL3$Companion\n*L\n220#1:312,2\n220#1:314,21\n271#1:338,14\n271#1:353\n279#1:354,14\n279#1:369\n298#1:370,14\n298#1:385\n263#1:335,3\n271#1:352\n279#1:368\n298#1:384\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getUseNamedTexture() {
            return useNamedTexture;
        }

        @NotNull
        public final VolumeTextureGL3 create(int width, int height, int depth, @NotNull ColorFormat format, @NotNull ColorType type, int levels, @Nullable Session session) {
            Intrinsics.checkNotNullParameter((Object)format, "format");
            Intrinsics.checkNotNullParameter((Object)type, "type");
            if (!(levels >= 1)) {
                boolean $i$a$-require-VolumeTextureGL3$Companion$create$22 = false;
                String $i$a$-require-VolumeTextureGL3$Companion$create$22 = "should have at least 1 mipmap level (requested " + levels + ")";
                throw new IllegalArgumentException($i$a$-require-VolumeTextureGL3$Companion$create$22.toString());
            }
            int internalFormat = ((Number)ColorBufferGL3Kt.internalFormat(format, type).component1()).intValue();
            boolean $i$f$debugGLErrors = false;
            if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
                boolean $i$f$checkGLErrors = false;
                int error$iv$iv = GLGLESKt.glGetError();
                if (error$iv$iv != 0) {
                    Object message$iv$iv = switch (error$iv$iv) {
                        case 1282 -> "GL_INVALID_OPERATION";
                        case 1281 -> "GL_INVALID_VALUE";
                        case 1280 -> "GL_INVALID_ENUM";
                        case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                        case 1285 -> "GL_OUT_OF_MEMORY";
                        case 1284 -> "GL_STACK_UNDERFLOW";
                        case 1283 -> "GL_STACK_OVERFLOW";
                        default -> "<untranslated: " + error$iv$iv + ">";
                    };
                    int n = error$iv$iv;
                    Object object = message$iv$iv;
                    long l = Driver.Companion.getInstance().getContextID();
                    boolean bl = false;
                    String string = "pre-existing errors";
                    String string2 = "[context=" + l + "] GL ERROR: " + (String)object + " " + string;
                    throw new GL3Exception(string2);
                }
            }
            int texture = GLGLESKt.glGenTextures();
            int texture$iv = 33984;
            boolean $i$f$glActiveTexture = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glActiveTexture(texture$iv);
                    break;
                }
                case 2: {
                    GLES32.glActiveTexture(texture$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            GLGLESKt.glBindTexture(32879, texture);
            TextureStorageModeGL storageMode = DriverGL3Kt.getCapabilities(Driver.Companion).getTextureStorage() ? TextureStorageModeGL.STORAGE : TextureStorageModeGL.IMAGE;
            boolean $i$f$checkGLErrors = false;
            int error$iv = GLGLESKt.glGetError();
            if (error$iv != 0) {
                Object message$iv = switch (error$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv + ">";
                };
                int n = error$iv;
                Object object = message$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n;
                Object var25_32 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var25_32;
                throw new GL3Exception(string);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[storageMode.ordinal()]) {
                case 1: {
                    if (this.getUseNamedTexture()) {
                        GL45C.glTextureStorage3D(texture, levels, internalFormat, width, height, depth);
                    } else {
                        GLGLESKt.glTexStorage3D(32879, levels, internalFormat, width, height, depth);
                    }
                    boolean $i$f$checkGLErrors2 = false;
                    int error$iv2 = GLGLESKt.glGetError();
                    if (error$iv2 == 0) break;
                    Object message$iv = switch (error$iv2) {
                        case 1282 -> "GL_INVALID_OPERATION";
                        case 1281 -> "GL_INVALID_VALUE";
                        case 1280 -> "GL_INVALID_ENUM";
                        case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                        case 1285 -> "GL_OUT_OF_MEMORY";
                        case 1284 -> "GL_STACK_UNDERFLOW";
                        case 1283 -> "GL_STACK_OVERFLOW";
                        default -> "<untranslated: " + error$iv2 + ">";
                    };
                    int n = error$iv2;
                    Object object = message$iv;
                    long l = Driver.Companion.getInstance().getContextID();
                    boolean bl = false;
                    int it = n;
                    Object var25_33 = null;
                    String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var25_33;
                    throw new GL3Exception(string);
                }
                case 2: {
                    for (int level = 0; level < levels; ++level) {
                        int div = 1 << level;
                        ByteBuffer nullBB = null;
                        GLGLESKt.glTexImage3D(32879, level, internalFormat, width / div, height / div, depth / div, 0, ColorBufferGL3Kt.glFormat(format), ColorBufferGL3Kt.glType(type), nullBB);
                        boolean $i$f$checkGLErrors3 = false;
                        int error$iv3 = GLGLESKt.glGetError();
                        if (error$iv3 == 0) continue;
                        Object message$iv = switch (error$iv3) {
                            case 1282 -> "GL_INVALID_OPERATION";
                            case 1281 -> "GL_INVALID_VALUE";
                            case 1280 -> "GL_INVALID_ENUM";
                            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                            case 1285 -> "GL_OUT_OF_MEMORY";
                            case 1284 -> "GL_STACK_UNDERFLOW";
                            case 1283 -> "GL_STACK_OVERFLOW";
                            default -> "<untranslated: " + error$iv3 + ">";
                        };
                        int n = error$iv3;
                        Object object = message$iv;
                        long l = Driver.Companion.getInstance().getContextID();
                        boolean bl = false;
                        int it = n;
                        Object var25_34 = null;
                        String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var25_34;
                        throw new GL3Exception(string);
                    }
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            GLGLESKt.glTexParameteri(32879, 33084, 0);
            GLGLESKt.glTexParameteri(32879, 33085, levels - 1);
            return new VolumeTextureGL3(texture, storageMode, width, height, depth, format, type, levels, session);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TextureStorageModeGL.values().length];
                try {
                    nArray[TextureStorageModeGL.STORAGE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TextureStorageModeGL.IMAGE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

