/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengles.GLES32;
import org.openrndr.draw.BufferTexture;
import org.openrndr.draw.BufferTextureShadow;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Session;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.BufferTextureShadowGL3;
import org.openrndr.internal.gl3.ColorBufferGL3Kt;
import org.openrndr.internal.gl3.DriverGL3Configuration;
import org.openrndr.internal.gl3.GL3Exception;
import org.openrndr.internal.gl3.GLGLESKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 72\u00020\u0001:\u00017B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u0018\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0019J \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003H\u0016J \u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0016J\u0010\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020\u0003H\u0016J\b\u00105\u001a\u00020%H\u0016J\b\u00106\u001a\u00020%H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010/\u001a\u000200X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u00068"}, d2={"Lorg/openrndr/internal/gl3/BufferTextureGL3;", "Lorg/openrndr/draw/BufferTexture;", "texture", "", "buffer", "elementCount", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "session", "Lorg/openrndr/draw/Session;", "<init>", "(IIILorg/openrndr/draw/ColorFormat;Lorg/openrndr/draw/ColorType;Lorg/openrndr/draw/Session;)V", "getTexture", "()I", "getBuffer", "getElementCount", "getFormat", "()Lorg/openrndr/draw/ColorFormat;", "getType", "()Lorg/openrndr/draw/ColorType;", "getSession", "()Lorg/openrndr/draw/Session;", "glFormat", "glFormat$openrndr_gl3", "realShadow", "Lorg/openrndr/internal/gl3/BufferTextureShadowGL3;", "getRealShadow$openrndr_gl3", "()Lorg/openrndr/internal/gl3/BufferTextureShadowGL3;", "setRealShadow$openrndr_gl3", "(Lorg/openrndr/internal/gl3/BufferTextureShadowGL3;)V", "shadow", "Lorg/openrndr/draw/BufferTextureShadow;", "getShadow", "()Lorg/openrndr/draw/BufferTextureShadow;", "read", "", "target", "Ljava/nio/ByteBuffer;", "offset", "elementReadCount", "write", "source", "elementWriteCount", "bind", "unit", "destroyed", "", "getDestroyed$openrndr_gl3", "()Z", "setDestroyed$openrndr_gl3", "(Z)V", "destroy", "close", "Companion", "openrndr-gl3"})
@SourceDebugExtension(value={"SMAP\nBufferTextureGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferTextureGL3.kt\norg/openrndr/internal/gl3/BufferTextureGL3\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n+ 3 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt\n+ 4 ErrorGL3.kt\norg/openrndr/internal/gl3/ErrorGL3Kt$debugGLErrors$1\n*L\n1#1,115:1\n48#2,3:116\n48#2,3:119\n83#2,3:146\n1154#2,3:173\n67#3,3:122\n51#3,13:125\n65#3,7:139\n67#3,3:149\n51#3,13:152\n65#3,7:166\n67#4:138\n67#4:165\n*S KotlinDebug\n*F\n+ 1 BufferTextureGL3.kt\norg/openrndr/internal/gl3/BufferTextureGL3\n*L\n82#1:116,3\n91#1:119,3\n93#1:146,3\n99#1:173,3\n92#1:122,3\n92#1:125,13\n92#1:139,7\n94#1:149,3\n94#1:152,13\n94#1:166,7\n92#1:138\n94#1:165\n*E\n"})
public final class BufferTextureGL3
extends BufferTexture {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int texture;
    private final int buffer;
    private final int elementCount;
    @NotNull
    private final ColorFormat format;
    @NotNull
    private final ColorType type;
    @Nullable
    private final Session session;
    @Nullable
    private BufferTextureShadowGL3 realShadow;
    private boolean destroyed;

    public BufferTextureGL3(int texture, int buffer, int elementCount, @NotNull ColorFormat format, @NotNull ColorType type, @Nullable Session session) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        this.texture = texture;
        this.buffer = buffer;
        this.elementCount = elementCount;
        this.format = format;
        this.type = type;
        this.session = session;
    }

    public final int getTexture() {
        return this.texture;
    }

    public final int getBuffer() {
        return this.buffer;
    }

    @Override
    public int getElementCount() {
        return this.elementCount;
    }

    @Override
    @NotNull
    public ColorFormat getFormat() {
        return this.format;
    }

    @Override
    @NotNull
    public ColorType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Session getSession() {
        return this.session;
    }

    public final int glFormat$openrndr_gl3() {
        return ((Number)ColorBufferGL3Kt.internalFormat(this.getFormat(), this.getType()).getFirst()).intValue();
    }

    @Nullable
    public final BufferTextureShadowGL3 getRealShadow$openrndr_gl3() {
        return this.realShadow;
    }

    public final void setRealShadow$openrndr_gl3(@Nullable BufferTextureShadowGL3 bufferTextureShadowGL3) {
        this.realShadow = bufferTextureShadowGL3;
    }

    @Override
    @NotNull
    public BufferTextureShadow getShadow() {
        if (this.realShadow == null) {
            this.realShadow = new BufferTextureShadowGL3(this);
        }
        BufferTextureShadowGL3 bufferTextureShadowGL3 = this.realShadow;
        Intrinsics.checkNotNull(bufferTextureShadowGL3);
        return bufferTextureShadowGL3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void read(@NotNull ByteBuffer target2, int offset, int elementReadCount) {
        Intrinsics.checkNotNullParameter(target2, "target");
        int oldLimit = target2.limit();
        target2.limit(target2.position() + elementReadCount * this.getFormat().getComponentCount() * this.getType().getComponentSize());
        int n = 35882;
        int buffer$iv = this.buffer;
        boolean $i$f$glBindBuffer = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                void target$iv;
                GL45C.glBindBuffer((int)target$iv, buffer$iv);
                break;
            }
            case 2: {
                void target$iv;
                GLES32.glBindBuffer((int)target$iv, buffer$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        GL33C.glGetBufferSubData(35882, 0L, target2);
        target2.limit(oldLimit);
    }

    @Override
    public void write(@NotNull ByteBuffer source, int offset, int elementWriteCount) {
        int error$iv$iv;
        boolean $i$f$checkGLErrors;
        int target$iv;
        Intrinsics.checkNotNullParameter(source, "source");
        if (!source.isDirect()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int oldLimit = source.limit();
        source.limit(source.position() + elementWriteCount * this.getFormat().getComponentCount() * this.getType().getComponentSize());
        int n = 35882;
        int buffer$iv = this.buffer;
        boolean $i$f$glBindBuffer = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                GL45C.glBindBuffer(target$iv, buffer$iv);
                break;
            }
            case 2: {
                GLES32.glBindBuffer(target$iv, buffer$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            $i$f$checkGLErrors = false;
            error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int n2 = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                int it = n2;
                Object var15_22 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var15_22;
                throw new GL3Exception(string);
            }
        }
        target$iv = 35882;
        long offset$iv = 0L;
        boolean $i$f$glBufferSubData = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                GL45C.glBufferSubData(target$iv, offset$iv, source);
                break;
            }
            case 2: {
                GLES32.glBufferSubData(target$iv, offset$iv, source);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $i$f$debugGLErrors = false;
        if (DriverGL3Configuration.INSTANCE.getUseDebugContext()) {
            $i$f$checkGLErrors = false;
            error$iv$iv = GLGLESKt.glGetError();
            if (error$iv$iv != 0) {
                Object message$iv$iv = switch (error$iv$iv) {
                    case 1282 -> "GL_INVALID_OPERATION";
                    case 1281 -> "GL_INVALID_VALUE";
                    case 1280 -> "GL_INVALID_ENUM";
                    case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
                    case 1285 -> "GL_OUT_OF_MEMORY";
                    case 1284 -> "GL_STACK_UNDERFLOW";
                    case 1283 -> "GL_STACK_OVERFLOW";
                    default -> "<untranslated: " + error$iv$iv + ">";
                };
                int it = error$iv$iv;
                Object object = message$iv$iv;
                long l = Driver.Companion.getInstance().getContextID();
                boolean bl = false;
                Object var15_23 = null;
                String string = "[context=" + l + "] GL ERROR: " + (String)object + " " + var15_23;
                throw new GL3Exception(string);
            }
        }
        source.limit(oldLimit);
    }

    @Override
    public void bind(int unit) {
        int texture$iv = 33984 + unit;
        boolean $i$f$glActiveTexture = false;
        switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
            case 1: {
                GL45C.glActiveTexture(texture$iv);
                break;
            }
            case 2: {
                GLES32.glActiveTexture(texture$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        GLGLESKt.glBindTexture(35882, this.texture);
    }

    public final boolean getDestroyed$openrndr_gl3() {
        return this.destroyed;
    }

    public final void setDestroyed$openrndr_gl3(boolean bl) {
        this.destroyed = bl;
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            Session session = this.getSession();
            if (session != null) {
                session.untrack(this);
            }
            GLGLESKt.glDeleteTextures(this.texture);
            this.destroyed = true;
        }
    }

    @Override
    public void close() {
        this.destroy();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u000e"}, d2={"Lorg/openrndr/internal/gl3/BufferTextureGL3$Companion;", "", "<init>", "()V", "create", "Lorg/openrndr/internal/gl3/BufferTextureGL3;", "elementCount", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "session", "Lorg/openrndr/draw/Session;", "openrndr-gl3"})
    @SourceDebugExtension(value={"SMAP\nBufferTextureGL3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferTextureGL3.kt\norg/openrndr/internal/gl3/BufferTextureGL3$Companion\n+ 2 GLGLES.kt\norg/openrndr/internal/gl3/GLGLESKt\n*L\n1#1,115:1\n48#2,3:116\n55#2,3:119\n48#2,3:122\n*S KotlinDebug\n*F\n+ 1 BufferTextureGL3.kt\norg/openrndr/internal/gl3/BufferTextureGL3$Companion\n*L\n51#1:116,3\n52#1:119,3\n59#1:122,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BufferTextureGL3 create(int elementCount, @NotNull ColorFormat format, @NotNull ColorType type, @Nullable Session session) {
            int target$iv;
            Intrinsics.checkNotNullParameter((Object)format, "format");
            Intrinsics.checkNotNullParameter((Object)type, "type");
            int sizeInBytes = format.getComponentCount() * type.getComponentSize() * elementCount;
            int[] buffers = new int[1];
            GL33C.glGenBuffers(buffers);
            int n = 35882;
            int buffer$iv22 = buffers[0];
            boolean $i$f$glBindBuffer = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    GL45C.glBindBuffer(target$iv, buffer$iv22);
                    break;
                }
                case 2: {
                    GLES32.glBindBuffer(target$iv, buffer$iv22);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            target$iv = 35882;
            long buffer$iv22 = sizeInBytes;
            int usage$iv = 35040;
            boolean $i$f$glBufferData = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    void size$iv;
                    GL45C.glBufferData(target$iv, (long)size$iv, usage$iv);
                    break;
                }
                case 2: {
                    void size$iv;
                    GLES32.glBufferData(target$iv, (long)size$iv, usage$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int[] textures = new int[1];
            GL33C.glGenTextures(textures);
            GLGLESKt.glBindTexture(35882, textures[0]);
            GL33C.glTexBuffer(35882, ((Number)ColorBufferGL3Kt.internalFormat(format, type).getFirst()).intValue(), buffers[0]);
            int size$iv = 35882;
            int buffer$iv = 0;
            boolean $i$f$glBindBuffer2 = false;
            switch (GLGLESKt.WhenMappings.$EnumSwitchMapping$0[GLGLESKt.getDriverType().ordinal()]) {
                case 1: {
                    void target$iv2;
                    GL45C.glBindBuffer((int)target$iv2, buffer$iv);
                    break;
                }
                case 2: {
                    void target$iv2;
                    GLES32.glBindBuffer((int)target$iv2, buffer$iv);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return new BufferTextureGL3(textures[0], buffers[0], elementCount, format, type, session);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

