/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;
import org.openrndr.Program;
import org.openrndr.WindowConfiguration;
import org.openrndr.WindowMultisample;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.ApplicationGLFWGL3;
import org.openrndr.internal.gl3.ApplicationGLFWGL3Kt;
import org.openrndr.internal.gl3.ApplicationWindowGLFW;
import org.openrndr.internal.gl3.DriverGL3Configuration;
import org.openrndr.internal.gl3.DriverGL3Kt;
import org.openrndr.internal.gl3.DriverTypeGL;
import org.openrndr.internal.gl3.DriverVersionGL;
import org.openrndr.internal.gl3.GlesBackend;
import org.openrndr.math.IntVector2;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "createApplicationWindowGlfw", "Lorg/openrndr/internal/gl3/ApplicationWindowGLFW;", "application", "Lorg/openrndr/internal/gl3/ApplicationGLFWGL3;", "configuration", "Lorg/openrndr/WindowConfiguration;", "program", "Lorg/openrndr/Program;", "openrndr-gl3"})
public final class ApplicationWindowGLFWKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(ApplicationWindowGLFWKt::logger$lambda$0);

    @NotNull
    public static final ApplicationWindowGLFW createApplicationWindowGlfw(@NotNull ApplicationGLFWGL3 application, @NotNull WindowConfiguration configuration, @NotNull Program program2) {
        WindowMultisample ms;
        Intrinsics.checkNotNullParameter(application, "application");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Intrinsics.checkNotNullParameter(program2, "program");
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(131079, 0);
        GLFW.glfwWindowHint(131078, 0);
        GLFW.glfwWindowHint(131075, configuration.resizable() ? 1 : 0);
        GLFW.glfwWindowHint(131077, configuration.hideDecorations() ? 0 : 1);
        switch (WhenMappings.$EnumSwitchMapping$0[DriverGL3Configuration.INSTANCE.getDriverType().ordinal()]) {
            case 1: {
                GLFW.glfwWindowHint(139270, 1);
                GLFW.glfwWindowHint(139272, 204801);
                break;
            }
            case 2: {
                boolean useAngle;
                GLFW.glfwWindowHint(139265, 196610);
                boolean bl = useAngle = DriverGL3Configuration.INSTANCE.getGlesBackend() == GlesBackend.ANGLE;
                if (useAngle) {
                    GLFW.glfwWindowHint(327682, 225288);
                }
                GLFW.glfwWindowHint(139275, 221186);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        GLFW.glfwWindowHint(135169, 8);
        GLFW.glfwWindowHint(135170, 8);
        GLFW.glfwWindowHint(135171, 8);
        GLFW.glfwWindowHint(135174, 8);
        GLFW.glfwWindowHint(135173, 24);
        GLFW.glfwWindowHint(135182, 1);
        GLFW.glfwWindowHint(131076, 0);
        IntVector2 position = configuration.position();
        if (position != null) {
            GLFW.glfwWindowHint(131086, position.x());
            GLFW.glfwWindowHint(131087, position.y());
        }
        if (Intrinsics.areEqual(ms = configuration.multisample(), WindowMultisample.SystemDefault.INSTANCE)) {
            GLFW.glfwWindowHint(135181, -1);
        } else if (Intrinsics.areEqual(ms, WindowMultisample.Disabled.INSTANCE)) {
            GLFW.glfwWindowHint(135181, 1);
        } else if (ms instanceof WindowMultisample.SampleCount) {
            GLFW.glfwWindowHint(135181, ((WindowMultisample.SampleCount)ms).getCount());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DriverVersionGL version = DriverGL3Kt.getGlVersion(Driver.Companion);
        GLFW.glfwWindowHint(139266, version.getMajorVersion());
        GLFW.glfwWindowHint(139267, version.getMinorVersion());
        if (configuration.alwaysOnTop()) {
            GLFW.glfwWindowHint(131079, 1);
        }
        long childWindow = GLFW.glfwCreateWindow(configuration.width(), configuration.height(), configuration.title(), 0L, ApplicationGLFWGL3Kt.getPrimaryWindow());
        logger.debug(() -> ApplicationWindowGLFWKt.createApplicationWindowGlfw$lambda$1(childWindow));
        GLFW.glfwMakeContextCurrent(childWindow);
        GLFW.glfwShowWindow(childWindow);
        GLFW.glfwSwapBuffers(childWindow);
        ApplicationWindowGLFW window2 = new ApplicationWindowGLFW(application, childWindow, configuration.title(), configuration.resizable(), configuration.multisample(), configuration.closable(), program2);
        window2.setDefaultIcon();
        return window2;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object createApplicationWindowGlfw$lambda$1(long $childWindow) {
        return "created child window " + $childWindow;
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DriverTypeGL.values().length];
            try {
                nArray[DriverTypeGL.GL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DriverTypeGL.GLES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

