/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BatchesKt;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.DrawerConfiguration;
import org.openrndr.draw.RectangleBatch;
import org.openrndr.draw.Session;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Rectangle;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0015J2\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\t2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\tJ4\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ$\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\tJ6\u0010#\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ&\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/openrndr/internal/RectangleDrawer;", "", "<init>", "()V", "vertices", "Lorg/openrndr/draw/VertexBuffer;", "count", "", "singleBatches", "", "Lorg/openrndr/draw/RectangleBatch;", "batch", "getBatch$openrndr_draw", "()Lorg/openrndr/draw/RectangleBatch;", "setBatch$openrndr_draw", "(Lorg/openrndr/draw/RectangleBatch;)V", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "ensureBatchSize", "", "size", "ensureBatchSize$openrndr_draw", "drawRectangles", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "positions", "Lorg/openrndr/math/Vector2;", "dimensions", "width", "", "height", "rectangles", "Lorg/openrndr/shape/Rectangle;", "drawRectangle", "x", "y", "openrndr-draw"})
@SourceDebugExtension(value={"SMAP\nRectangleDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RectangleDrawer.kt\norg/openrndr/internal/RectangleDrawer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n1557#2:159\n1628#2,3:160\n1872#2,3:163\n1863#2,2:166\n1863#2,2:168\n*S KotlinDebug\n*F\n+ 1 RectangleDrawer.kt\norg/openrndr/internal/RectangleDrawer\n*L\n26#1:159\n26#1:160,3\n77#1:163,3\n96#1:166,2\n114#1:168,2\n*E\n"})
public final class RectangleDrawer {
    @NotNull
    private final VertexBuffer vertices;
    private int count;
    @NotNull
    private final List<RectangleBatch> singleBatches;
    @NotNull
    private RectangleBatch batch;
    @NotNull
    private final ShadeStyleManager shaderManager;

    /*
     * WARNING - void declaration
     */
    public RectangleDrawer() {
        BufferWriter bufferWriter;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$vertices_u24lambda_u240;
        Object object = new VertexFormat(null, 1, null);
        VertexFormat vertexFormat = object;
        Object object2 = VertexBuffer.Companion;
        RectangleDrawer rectangleDrawer = this;
        boolean $i$a$-apply-RectangleDrawer$vertices$22 = false;
        $this$vertices_u24lambda_u240.position(3);
        $this$vertices_u24lambda_u240.normal(3);
        VertexFormat.textureCoordinate$default((VertexFormat)$this$vertices_u24lambda_u240, 2, 0, 2, null);
        Unit unit = Unit.INSTANCE;
        rectangleDrawer.vertices = ((VertexBuffer.Companion)object2).createDynamic((VertexFormat)object, 6, Session.Companion.getRoot());
        object = RangesKt.until(0, DrawerConfiguration.INSTANCE.getVertexBufferMultiBufferCount());
        rectangleDrawer = this;
        boolean $i$f$map = false;
        void $i$a$-apply-RectangleDrawer$vertices$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            object2 = destination$iv$iv;
            boolean bl = false;
            object2.add(RectangleBatch.Companion.create$default(RectangleBatch.Companion, 1, null, 2, null));
        }
        rectangleDrawer.singleBatches = (List)destination$iv$iv;
        this.batch = RectangleBatch.Companion.create(10000, Session.Companion.getRoot());
        this.shaderManager = ShadeStyleManager.Companion.fromGenerators$default(ShadeStyleManager.Companion, "rectangle", new Function1<ShadeStructure, String>((Object)Driver.Companion.getInstance().getShaderGenerators()){

            public final String invoke(ShadeStructure p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((ShaderGenerators)this.receiver).rectangleVertexShader(p0);
            }
        }, null, null, null, new Function1<ShadeStructure, String>((Object)Driver.Companion.getInstance().getShaderGenerators()){

            public final String invoke(ShadeStructure p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((ShaderGenerators)this.receiver).rectangleFragmentShader(p0);
            }
        }, 28, null);
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        double x = 0.0;
        double y = 0.0;
        double radius = 1.0;
        Vector3 pa = new Vector3(x, y, 0.0);
        Vector3 pb = new Vector3(x + radius, y, 0.0);
        Vector3 pc = new Vector3(x + radius, y + radius, 0.0);
        Vector3 pd = new Vector3(x, y + radius, 0.0);
        Vector2 ta = new Vector2(0.0, 0.0);
        Vector2 tb = new Vector2(1.0, 0.0);
        Vector2 tc = new Vector2(1.0, 1.0);
        Vector2 td = new Vector2(0.0, 1.0);
        Vector3 n = new Vector3(0.0, 0.0, -1.0);
        BufferWriter $this$_init__u24lambda_u242 = bufferWriter = w;
        boolean bl = false;
        $this$_init__u24lambda_u242.write(pa);
        $this$_init__u24lambda_u242.write(n);
        $this$_init__u24lambda_u242.write(ta);
        $this$_init__u24lambda_u242.write(pd);
        $this$_init__u24lambda_u242.write(n);
        $this$_init__u24lambda_u242.write(td);
        $this$_init__u24lambda_u242.write(pc);
        $this$_init__u24lambda_u242.write(n);
        $this$_init__u24lambda_u242.write(tc);
        $this$_init__u24lambda_u242.write(pc);
        $this$_init__u24lambda_u242.write(n);
        $this$_init__u24lambda_u242.write(tc);
        $this$_init__u24lambda_u242.write(pb);
        $this$_init__u24lambda_u242.write(n);
        $this$_init__u24lambda_u242.write(tb);
        $this$_init__u24lambda_u242.write(pa);
        $this$_init__u24lambda_u242.write(n);
        $this$_init__u24lambda_u242.write(ta);
        VertexBufferShadow.DefaultImpls.upload$default(this.vertices.getShadow(), 0, 0, 3, null);
    }

    @NotNull
    public final RectangleBatch getBatch$openrndr_draw() {
        return this.batch;
    }

    public final void setBatch$openrndr_draw(@NotNull RectangleBatch rectangleBatch) {
        Intrinsics.checkNotNullParameter(rectangleBatch, "<set-?>");
        this.batch = rectangleBatch;
    }

    public final void ensureBatchSize$openrndr_draw(int size) {
        if (this.batch.getSize() < size) {
            this.batch.destroy();
            this.batch = RectangleBatch.Companion.create(size, Session.Companion.getRoot());
        }
    }

    public final void drawRectangles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector2> positions, @NotNull List<Vector2> dimensions) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(positions, "positions");
        Intrinsics.checkNotNullParameter(dimensions, "dimensions");
        this.ensureBatchSize$openrndr_draw(positions.size());
        if (!(positions.size() == dimensions.size())) {
            boolean bl = false;
            String string = "`positions.size` and `dimensions.size` must be equal in drawRectangles()";
            throw new IllegalArgumentException(string.toString());
        }
        VertexBuffer.put$default(this.batch.getGeometry(), 0, arg_0 -> RectangleDrawer.drawRectangles$lambda$5(dimensions, positions, arg_0), 1, null);
        VertexBuffer.put$default(this.batch.getDrawStyle(), 0, arg_0 -> RectangleDrawer.drawRectangles$lambda$6(positions, drawStyle, arg_0), 1, null);
        this.drawRectangles(drawContext, drawStyle, this.batch, positions.size());
    }

    public final void drawRectangles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector2> positions, double width, double height) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(positions, "positions");
        this.ensureBatchSize$openrndr_draw(positions.size());
        VertexBuffer.put$default(this.batch.getGeometry(), 0, arg_0 -> RectangleDrawer.drawRectangles$lambda$8(positions, width, height, arg_0), 1, null);
        VertexBuffer.put$default(this.batch.getDrawStyle(), 0, arg_0 -> RectangleDrawer.drawRectangles$lambda$9(positions, drawStyle, arg_0), 1, null);
        this.drawRectangles(drawContext, drawStyle, this.batch, positions.size());
    }

    public final void drawRectangles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Rectangle> rectangles) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(rectangles, "rectangles");
        this.ensureBatchSize$openrndr_draw(rectangles.size());
        VertexBuffer.put$default(this.batch.getGeometry(), 0, arg_0 -> RectangleDrawer.drawRectangles$lambda$11(rectangles, arg_0), 1, null);
        VertexBuffer.put$default(this.batch.getDrawStyle(), 0, arg_0 -> RectangleDrawer.drawRectangles$lambda$12(rectangles, drawStyle, arg_0), 1, null);
        this.drawRectangles(drawContext, drawStyle, this.batch, rectangles.size());
    }

    public final void drawRectangle(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, double x, double y, double width, double height) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        this.ensureBatchSize$openrndr_draw(1);
        int n = this.count;
        int n2 = this.singleBatches.size();
        int n3 = n % n2;
        RectangleBatch batch = this.singleBatches.get(n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31));
        VertexBuffer.put$default(batch.getGeometry(), 0, arg_0 -> RectangleDrawer.drawRectangle$lambda$13(x, width, y, height, arg_0), 1, null);
        VertexBuffer.put$default(batch.getDrawStyle(), 0, arg_0 -> RectangleDrawer.drawRectangle$lambda$14(drawStyle, arg_0), 1, null);
        this.drawRectangles(drawContext, drawStyle, batch, 1);
        n = this.count;
        this.count = n + 1;
    }

    public final void drawRectangles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull RectangleBatch batch, int count2) {
        Object object;
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(batch, "batch");
        Object[] objectArray = new VertexFormat[]{batch.getGeometry().getVertexFormat(), batch.getDrawStyle().getVertexFormat()};
        Shader shader = this.shaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()), CollectionsKt.listOf(objectArray));
        shader.begin();
        drawContext.applyToShader(shader);
        drawStyle.applyToShader(shader);
        Driver.Companion.getInstance().setState(drawStyle);
        objectArray = new VertexBuffer[]{batch.getDrawStyle(), batch.getGeometry()};
        Driver.DefaultImpls.drawInstances$default(Driver.Companion.getInstance(), shader, CollectionsKt.listOf(this.vertices), CollectionsKt.plus((Collection)CollectionsKt.listOf(objectArray), (object = drawStyle.getShadeStyle()) != null && (object = ((ShadeStyle)object).getAttributes()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList()), DrawPrimitive.TRIANGLES, 0, 6, 0, count2, 0, 256, null);
        shader.end();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit drawRectangles$lambda$5(List $dimensions, List $positions, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        Iterable $this$forEachIndexed$iv = $dimensions;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void sz;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Vector2 vector2 = (Vector2)item$iv;
            int i = n;
            boolean bl = false;
            $this$put.write(new Vector3(((Vector2)$positions.get(i)).x() + Math.min(0.0, sz.x()), ((Vector2)$positions.get(i)).y() + Math.min(0.0, sz.y()), 0.0));
            $this$put.write(new Vector3(Math.abs(sz.x()), Math.abs(sz.y()), 0.0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawRectangles$lambda$6(List $positions, DrawStyle $drawStyle, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        int n = ((Collection)$positions).size();
        for (int i = 0; i < n; ++i) {
            BatchesKt.write($this$put, $drawStyle);
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawRectangles$lambda$8(List $positions, double $width, double $height, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        Iterable $this$forEach$iv = $positions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vector2 it = (Vector2)element$iv;
            boolean bl = false;
            $this$put.write(new Vector3(it.x() + Math.min(0.0, $width), it.y() + Math.min(0.0, $height), 0.0));
            $this$put.write(new Vector3(Math.abs($width), Math.abs($height), 0.0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawRectangles$lambda$9(List $positions, DrawStyle $drawStyle, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        int n = ((Collection)$positions).size();
        for (int i = 0; i < n; ++i) {
            BatchesKt.write($this$put, $drawStyle);
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawRectangles$lambda$11(List $rectangles, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        Iterable $this$forEach$iv = $rectangles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Rectangle it = (Rectangle)element$iv;
            boolean bl = false;
            $this$put.write(new Vector3(it.x() + Math.min(0.0, it.width()), it.y() + Math.min(0.0, it.height()), 0.0));
            $this$put.write(new Vector3(Math.abs(it.width()), Math.abs(it.height()), 0.0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawRectangles$lambda$12(List $rectangles, DrawStyle $drawStyle, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        int n = ((Collection)$rectangles).size();
        for (int i = 0; i < n; ++i) {
            BatchesKt.write($this$put, $drawStyle);
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawRectangle$lambda$13(double $x, double $width, double $y, double $height, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        $this$put.write((float)($x + Math.min(0.0, $width)), (float)($y + Math.min(0.0, $height)), 0.0f);
        $this$put.write((float)Math.abs($width), (float)Math.abs($height), 0.0f);
        return Unit.INSTANCE;
    }

    private static final Unit drawRectangle$lambda$14(DrawStyle $drawStyle, BufferWriter $this$put) {
        Intrinsics.checkNotNullParameter($this$put, "$this$put");
        BatchesKt.write($this$put, $drawStyle);
        return Unit.INSTANCE;
    }
}

