/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.DrawerConfiguration;
import org.openrndr.draw.Session;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.VertexFormat;
import org.openrndr.draw.VertexFormatKt;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000bH\u0007\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\rH\u0002J$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000bJ*\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u000b0\u000bJ1\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u000b0\u000bH\u0007\u00a2\u0006\u0002\b\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/openrndr/internal/PerformanceLineDrawer;", "", "<init>", "()V", "vertexFormat", "Lorg/openrndr/draw/VertexFormat;", "getVertexFormat", "()Lorg/openrndr/draw/VertexFormat;", "manyVertices", "Lorg/openrndr/draw/VertexBuffer;", "fewVertices", "", "counter", "", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "drawLineSegments", "", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "segments", "Lorg/openrndr/math/Vector3;", "drawLineSegments3d", "vertices", "count", "Lorg/openrndr/math/Vector2;", "drawLineLoops", "loops", "drawLineLoops3d", "openrndr-draw"})
@SourceDebugExtension(value={"SMAP\nPerformanceLineDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerformanceLineDrawer.kt\norg/openrndr/internal/PerformanceLineDrawer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1#2:219\n1872#3,3:220\n1872#3,3:223\n1872#3,3:226\n1872#3,3:229\n*S KotlinDebug\n*F\n+ 1 PerformanceLineDrawer.kt\norg/openrndr/internal/PerformanceLineDrawer\n*L\n70#1:220,3\n117#1:223,3\n156#1:226,3\n202#1:229,3\n*E\n"})
public final class PerformanceLineDrawer {
    @NotNull
    private final VertexFormat vertexFormat = VertexFormatKt.vertexFormat$default(null, PerformanceLineDrawer::vertexFormat$lambda$0, 1, null);
    @NotNull
    private final VertexBuffer manyVertices = VertexBufferKt.vertexBuffer(this.vertexFormat, 0x100000, Session.Companion.getRoot());
    @NotNull
    private final List<VertexBuffer> fewVertices;
    private int counter;
    @NotNull
    private final ShadeStyleManager shaderManager;

    public PerformanceLineDrawer() {
        int n = DrawerConfiguration.INSTANCE.getVertexBufferMultiBufferCount();
        PerformanceLineDrawer performanceLineDrawer = this;
        ArrayList<VertexBuffer> arrayList = new ArrayList<VertexBuffer>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<VertexBuffer> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(VertexBufferKt.vertexBuffer(this.vertexFormat, 128, Session.Companion.getRoot()));
        }
        performanceLineDrawer.fewVertices = arrayList;
        this.shaderManager = ShadeStyleManager.Companion.fromGenerators$default(ShadeStyleManager.Companion, "performance-line", new Function1<ShadeStructure, String>((Object)Driver.Companion.getInstance().getShaderGenerators()){

            public final String invoke(ShadeStructure p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((ShaderGenerators)this.receiver).fastLineVertexShader(p0);
            }
        }, null, null, null, new Function1<ShadeStructure, String>((Object)Driver.Companion.getInstance().getShaderGenerators()){

            public final String invoke(ShadeStructure p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((ShaderGenerators)this.receiver).fastLineFragmentShader(p0);
            }
        }, 28, null);
    }

    @NotNull
    public final VertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="drawLineSegments3d")
    public final void drawLineSegments3d(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector3> segments) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(segments, "segments");
        VertexBuffer vertices = this.vertices(segments.size());
        Shader shader = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertexFormat);
        shader.begin();
        drawContext.applyToShader(shader);
        drawStyle.applyToShader(shader);
        BufferWriter w = vertices.getShadow().writer();
        w.rewind();
        int vertexCount = 0;
        Iterable $this$forEachIndexed$iv = segments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Vector3 vector3 = (Vector3)item$iv;
            int index = n;
            boolean bl = false;
            w.write((Vector3)it);
            w.write((float)(index / 2));
            w.write((float)(index % 2));
            ++vertexCount;
        }
        vertices.getShadow().uploadElements(0, vertexCount);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(vertices), DrawPrimitive.LINES, 0, vertexCount, 0);
        shader.end();
    }

    private final VertexBuffer vertices(int count2) {
        VertexBuffer vertexBuffer;
        if (count2 < 64) {
            int n = this.counter;
            n = this.counter = n + 1;
            int n2 = this.fewVertices.size();
            int n3 = n % n2;
            vertexBuffer = this.fewVertices.get(n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31));
        } else {
            vertexBuffer = this.manyVertices;
        }
        return vertexBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public final void drawLineSegments(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector2> segments) {
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(segments, "segments");
        VertexBuffer vertices = this.vertices(segments.size());
        Shader shader = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertexFormat);
        shader.begin();
        drawContext.applyToShader(shader);
        drawStyle.applyToShader(shader);
        BufferWriter w = vertices.getShadow().writer();
        w.rewind();
        int vertexCount = 0;
        Iterable $this$forEachIndexed$iv = segments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Vector2 vector2 = (Vector2)item$iv;
            int index = n;
            boolean bl = false;
            w.write((Vector2)it);
            w.write(0.0f);
            w.write((float)(index / 2));
            w.write((float)(index % 2));
            ++vertexCount;
        }
        vertices.getShadow().uploadElements(0, vertexCount);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(vertices), DrawPrimitive.LINES, 0, vertexCount, 0);
        shader.end();
    }

    /*
     * WARNING - void declaration
     */
    public final void drawLineLoops(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<? extends List<Vector2>> loops) {
        int n;
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(loops, "loops");
        Iterable iterable = loops;
        PerformanceLineDrawer performanceLineDrawer = this;
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            List list = (List)t;
            n = n2;
            boolean bl = false;
            int n3 = it.size();
            n2 = n + n3;
        }
        n = n2;
        VertexBuffer vertices = performanceLineDrawer.vertices(n);
        Shader shader = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertexFormat);
        shader.begin();
        drawContext.applyToShader(shader);
        drawStyle.applyToShader(shader);
        BufferWriter w = vertices.getShadow().writer();
        w.rewind();
        int vertexCount = 0;
        Iterable $this$forEachIndexed$iv = loops;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void loop2;
            int n4;
            if ((n4 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int loopIndex = n4;
            boolean bl = false;
            int n5 = loop2.size() - 1;
            for (int i = 0; i < n5; ++i) {
                w.write((Vector2)loop2.get(i));
                w.write(0.0f);
                w.write((float)loopIndex);
                w.write(1.0f);
                w.write((Vector2)loop2.get(i + 1));
                w.write(0.0f);
                w.write((float)loopIndex);
                w.write(1.0f);
                vertexCount += 2;
            }
        }
        vertices.getShadow().uploadElements(0, vertexCount);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(vertices), DrawPrimitive.LINES, 0, vertexCount, 0);
        shader.end();
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="drawLineLoops3d")
    public final void drawLineLoops3d(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<? extends List<Vector3>> loops) {
        int n;
        Intrinsics.checkNotNullParameter(drawContext, "drawContext");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(loops, "loops");
        Iterable iterable = loops;
        PerformanceLineDrawer performanceLineDrawer = this;
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            List list = (List)t;
            n = n2;
            boolean bl = false;
            int n3 = it.size();
            n2 = n + n3;
        }
        n = n2;
        VertexBuffer vertices = performanceLineDrawer.vertices(n);
        Shader shader = this.shaderManager.shader(drawStyle.getShadeStyle(), vertices.getVertexFormat());
        shader.begin();
        drawContext.applyToShader(shader);
        drawStyle.applyToShader(shader);
        BufferWriter w = vertices.getShadow().writer();
        w.rewind();
        int vertexCount = 0;
        Iterable $this$forEachIndexed$iv = loops;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void loop2;
            int n4;
            if ((n4 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int loopIndex = n4;
            boolean bl = false;
            int n5 = loop2.size() - 1;
            for (int i = 0; i < n5; ++i) {
                w.write((Vector3)loop2.get(i));
                w.write((float)loopIndex);
                w.write(1.0f);
                w.write((Vector3)loop2.get(i + 1));
                w.write((float)loopIndex);
                w.write(1.0f);
                vertexCount += 2;
            }
        }
        vertices.getShadow().uploadElements(0, vertexCount);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(vertices), DrawPrimitive.LINES, 0, vertexCount, 0);
        shader.end();
    }

    private static final Unit vertexFormat$lambda$0(VertexFormat $this$vertexFormat) {
        Intrinsics.checkNotNullParameter($this$vertexFormat, "$this$vertexFormat");
        $this$vertexFormat.position(3);
        VertexFormat.attribute$default($this$vertexFormat, "instance", VertexElementType.FLOAT32, 0, 4, null);
        VertexFormat.attribute$default($this$vertexFormat, "vertexOffset", VertexElementType.FLOAT32, 0, 4, null);
        return Unit.INSTANCE;
    }
}

