/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.DrawerConfiguration;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.FontMap;
import org.openrndr.draw.GlyphMetrics;
import org.openrndr.draw.KernMode;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.TextSettingMode;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.internal.GlyphRectangle;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.shape.IntRectangle;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0007J:\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u000b0\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ>\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u000b0\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u000bJH\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\b\b\u0002\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\fJ\u001e\u00100\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\fJN\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u0017022\u0006\u0010(\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u001f2\u0006\u00109\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010%\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/openrndr/internal/FontImageMapDrawer;", "", "<init>", "()V", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "maxQuads", "", "vertexFormat", "Lorg/openrndr/draw/VertexFormat;", "fewQuads", "", "Lorg/openrndr/draw/VertexBuffer;", "manyQuads", "quadCount", "counter", "getCounter", "()I", "setCounter", "(I)V", "getQueue", "size", "drawText", "Lorg/openrndr/internal/GlyphRectangle;", "context", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "text", "", "x", "", "y", "drawTexts", "texts", "positions", "Lorg/openrndr/math/Vector2;", "queuedInstances", "queueText", "", "fontMap", "Lorg/openrndr/draw/FontMap;", "tracking", "kerning", "Lorg/openrndr/draw/KernMode;", "textSetting", "Lorg/openrndr/draw/TextSettingMode;", "vertices", "flush", "insertCharacterQuad", "Lkotlin/Pair;", "Lorg/openrndr/draw/FontImageMap;", "bw", "Lorg/openrndr/draw/BufferWriter;", "character", "", "cx", "cy", "instance", "openrndr-draw"})
@SourceDebugExtension(value={"SMAP\nFontImageMapDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontImageMapDrawer.kt\norg/openrndr/internal/FontImageMapDrawer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,300:1\n1#2:301\n1179#3,2:302\n1179#3,2:304\n*S KotlinDebug\n*F\n+ 1 FontImageMapDrawer.kt\norg/openrndr/internal/FontImageMapDrawer\n*L\n112#1:302,2\n170#1:304,2\n*E\n"})
public final class FontImageMapDrawer {
    @NotNull
    private final ShadeStyleManager shaderManager = ShadeStyleManager.Companion.fromGenerators$default(ShadeStyleManager.Companion, "font-image-map", new Function1<ShadeStructure, String>((Object)Driver.Companion.getInstance().getShaderGenerators()){

        public final String invoke(ShadeStructure p0) {
            Intrinsics.checkNotNullParameter(p0, "p0");
            return ((ShaderGenerators)this.receiver).fontImageMapVertexShader(p0);
        }
    }, null, null, null, new Function1<ShadeStructure, String>((Object)Driver.Companion.getInstance().getShaderGenerators()){

        public final String invoke(ShadeStructure p0) {
            Intrinsics.checkNotNullParameter(p0, "p0");
            return ((ShaderGenerators)this.receiver).fontImageMapFragmentShader(p0);
        }
    }, 28, null);
    private final int maxQuads;
    @NotNull
    private final VertexFormat vertexFormat;
    @NotNull
    private final List<VertexBuffer> fewQuads;
    @NotNull
    private final VertexBuffer manyQuads;
    private int quadCount;
    private int counter;
    private int queuedInstances;

    /*
     * WARNING - void declaration
     */
    public FontImageMapDrawer() {
        void $this$vertexFormat_u24lambda_u240;
        this.maxQuads = 20000;
        VertexFormat vertexFormat = new VertexFormat(null, 1, null);
        Object object = vertexFormat;
        FontImageMapDrawer fontImageMapDrawer = this;
        boolean bl = false;
        VertexFormat.textureCoordinate$default((VertexFormat)$this$vertexFormat_u24lambda_u240, 2, 0, 2, null);
        VertexFormat.attribute$default((VertexFormat)$this$vertexFormat_u24lambda_u240, "bounds", VertexElementType.VECTOR4_FLOAT32, 0, 4, null);
        $this$vertexFormat_u24lambda_u240.position(3);
        VertexFormat.attribute$default((VertexFormat)$this$vertexFormat_u24lambda_u240, "instance", VertexElementType.FLOAT32, 0, 4, null);
        fontImageMapDrawer.vertexFormat = vertexFormat;
        int n = DrawerConfiguration.INSTANCE.getVertexBufferMultiBufferCount();
        fontImageMapDrawer = this;
        object = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            Object object2 = object;
            boolean bl2 = false;
            ((ArrayList)object2).add(VertexBufferKt.vertexBuffer$default(this.vertexFormat, 768, null, 4, null));
        }
        fontImageMapDrawer.fewQuads = (List)object;
        this.manyQuads = VertexBuffer.Companion.createDynamic$default(VertexBuffer.Companion, this.vertexFormat, 6 * this.maxQuads, null, 4, null);
    }

    public final int getCounter() {
        return this.counter;
    }

    public final void setCounter(int n) {
        this.counter = n;
    }

    @NotNull
    public final VertexBuffer getQueue(int size) {
        VertexBuffer vertexBuffer;
        if (size < 128) {
            int n = this.counter;
            int n2 = this.fewQuads.size();
            int n3 = n % n2;
            vertexBuffer = this.fewQuads.get(n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31));
        } else {
            vertexBuffer = this.manyQuads;
        }
        return vertexBuffer;
    }

    @NotNull
    public final List<List<GlyphRectangle>> drawText(@NotNull DrawContext context, @NotNull DrawStyle drawStyle, @NotNull String text, double x, double y) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(text, "text");
        return this.drawTexts(context, drawStyle, CollectionsKt.listOf(text), CollectionsKt.listOf(new Vector2(x, y)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<GlyphRectangle>> drawTexts(@NotNull DrawContext context, @NotNull DrawStyle drawStyle, @NotNull List<String> texts, @NotNull List<Vector2> positions) {
        FontImageMap fontMap;
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(texts, "texts");
        Intrinsics.checkNotNullParameter(positions, "positions");
        Iterable iterable = texts;
        int n = 0;
        for (Object t : iterable) {
            void it;
            String string = (String)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.length();
            n = n2 + n3;
        }
        int count2 = n;
        VertexBuffer vertices = this.getQueue(count2);
        FontMap fontMap2 = drawStyle.getFontMap();
        FontImageMap fontImageMap = fontMap = fontMap2 instanceof FontImageMap ? (FontImageMap)fontMap2 : null;
        if (fontMap != null) {
            int instance = 0;
            List textAndPositionPairs = CollectionsKt.zip((Iterable)texts, (Iterable)positions);
            for (Pair pair : textAndPositionPairs) {
                String text = (String)pair.component1();
                Vector2 position = (Vector2)pair.component2();
                double cursorX = 0.0;
                double cursorY = 0.0;
                BufferWriter bw = vertices.getShadow().writer();
                bw.setPosition(vertices.getVertexFormat().getSize() * this.quadCount * 6);
                Character lastChar = null;
                CharSequence $this$forEach$iv = text;
                boolean $i$f$forEach = false;
                for (int i = 0; i < $this$forEach$iv.length(); ++i) {
                    GlyphMetrics glyphMetrics;
                    char element$iv;
                    char it = element$iv = $this$forEach$iv.charAt(i);
                    boolean bl = false;
                    Character lc = lastChar;
                    if (drawStyle.getKerning() == KernMode.METRIC) {
                        Character c2 = lc;
                        cursorX += c2 != null ? fontMap.kerning(c2.charValue(), it) : 0.0;
                    }
                    if ((glyphMetrics = fontMap.getGlyphMetrics().get(Character.valueOf(it))) == null) {
                        glyphMetrics = MapsKt.getValue(fontMap.getGlyphMetrics(), Character.valueOf(' '));
                    }
                    GlyphMetrics glyphMetrics2 = glyphMetrics;
                    double dx = ((Number)this.insertCharacterQuad(fontMap, bw, it, position.x() + cursorX, position.y() + cursorY, instance, drawStyle.getTextSetting()).component1()).doubleValue();
                    cursorX += glyphMetrics2.advanceWidth() + dx;
                    lastChar = Character.valueOf(it);
                }
                int n4 = instance;
                instance = n4 + 1;
            }
            this.flush(context, drawStyle, vertices);
        }
        return CollectionsKt.emptyList();
    }

    public final void queueText(@NotNull FontMap fontMap, @NotNull String text, double x, double y, double tracking, @NotNull KernMode kerning, @NotNull TextSettingMode textSetting, @NotNull VertexBuffer vertices) {
        Intrinsics.checkNotNullParameter(fontMap, "fontMap");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter((Object)kerning, "kerning");
        Intrinsics.checkNotNullParameter((Object)textSetting, "textSetting");
        Intrinsics.checkNotNullParameter(vertices, "vertices");
        BufferWriter bw = vertices.getShadow().writer();
        bw.setPosition(vertices.getVertexFormat().getSize() * this.quadCount * 6);
        FontImageMap cfr_ignored_0 = (FontImageMap)fontMap;
        double cursorX = 0.0;
        double cursorY = 0.0;
        Character lastChar = null;
        CharSequence $this$forEach$iv = text;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            GlyphMetrics m;
            char element$iv;
            char it = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            Character lc = lastChar;
            GlyphMetrics metrics = ((FontImageMap)fontMap).getGlyphMetrics().get(Character.valueOf(it));
            if (metrics == null) continue;
            boolean bl2 = false;
            if (kerning == KernMode.METRIC) {
                cursorX += lc != null ? ((FontImageMap)fontMap).kerning(lc.charValue(), it) : 0.0;
            }
            double dx = ((Number)this.insertCharacterQuad((FontImageMap)fontMap, bw, it, x + cursorX, y + cursorY, 0, textSetting).component1()).doubleValue();
            cursorX += m.advanceWidth() + tracking + dx;
            lastChar = Character.valueOf(it);
        }
        int n = this.queuedInstances;
        this.queuedInstances = n + 1;
    }

    public static /* synthetic */ void queueText$default(FontImageMapDrawer fontImageMapDrawer, FontMap fontMap, String string, double d, double d2, double d3, KernMode kernMode, TextSettingMode textSettingMode, VertexBuffer vertexBuffer, int n, Object object) {
        if ((n & 0x10) != 0) {
            d3 = 0.0;
        }
        fontImageMapDrawer.queueText(fontMap, string, d, d2, d3, kernMode, textSettingMode, vertexBuffer);
    }

    public final void flush(@NotNull DrawContext context, @NotNull DrawStyle drawStyle, @NotNull VertexBuffer vertices) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(drawStyle, "drawStyle");
        Intrinsics.checkNotNullParameter(vertices, "vertices");
        if (this.quadCount > 0) {
            vertices.getShadow().uploadElements(0, this.quadCount * 6);
            Shader shader = this.shaderManager.shader(drawStyle.getShadeStyle(), vertices.getVertexFormat());
            shader.begin();
            context.applyToShader(shader);
            Driver.Companion.getInstance().setState(drawStyle);
            drawStyle.applyToShader(shader);
            FontMap fontMap = drawStyle.getFontMap();
            Intrinsics.checkNotNull(fontMap, "null cannot be cast to non-null type org.openrndr.draw.FontImageMap");
            ((FontImageMap)fontMap).getTexture().bind(0);
            Driver.Companion.getInstance().drawVertexBuffer(shader, CollectionsKt.listOf(vertices), DrawPrimitive.TRIANGLES, 0, this.quadCount * 6, 0);
            shader.end();
            this.quadCount = 0;
        }
        this.queuedInstances = 0;
        if (!Intrinsics.areEqual(vertices, this.manyQuads)) {
            int n = this.counter;
            this.counter = n + 1;
        }
    }

    private final Pair<Double, GlyphRectangle> insertCharacterQuad(FontImageMap fontMap, BufferWriter bw, char character, double cx, double cy, int instance, TextSettingMode textSetting) {
        GlyphRectangle glyphRectangle;
        double y;
        IntRectangle intRectangle = fontMap.getMap().get(Character.valueOf(character));
        if (intRectangle == null) {
            intRectangle = fontMap.getMap().get(Character.valueOf(' '));
        }
        IntRectangle rectangle = intRectangle;
        double targetContentScale = RenderTarget.Companion.getActive().getContentScale();
        float fmcs = (float)fontMap.getContentScale();
        GlyphMetrics glyphMetrics = fontMap.getGlyphMetrics().get(Character.valueOf(character));
        if (glyphMetrics == null && (glyphMetrics = fontMap.getGlyphMetrics().get(Character.valueOf(' '))) == null) {
            throw new IllegalStateException("glyph or space substitute not found".toString());
        }
        GlyphMetrics metrics = glyphMetrics;
        float xshift = (float)(metrics.xBitmapShift() / (double)fmcs);
        float yshift = (float)(metrics.yBitmapShift() / (double)fmcs);
        double sx = cx + (double)xshift;
        double sy = cy + (double)yshift;
        double x = textSetting == TextSettingMode.PIXEL ? Math.floor(sx * targetContentScale) / targetContentScale : sx;
        double d = y = textSetting == TextSettingMode.PIXEL ? Math.floor(sy * targetContentScale) / targetContentScale : sy;
        if (rectangle != null) {
            float pad = 2.0f;
            float u0 = ((float)rectangle.x() - pad) / (float)fontMap.getTexture().getEffectiveWidth();
            float u1 = ((float)rectangle.x() + (float)rectangle.width() + pad) / (float)fontMap.getTexture().getEffectiveWidth();
            float v0 = ((float)rectangle.y() - pad) / (float)fontMap.getTexture().getEffectiveHeight();
            float v1 = v0 + (pad * (float)2 + (float)rectangle.height()) / (float)fontMap.getTexture().getEffectiveHeight();
            float x0 = (float)x - pad / fmcs;
            float x1 = (float)x + (float)rectangle.width() / fmcs + pad / fmcs;
            float y0 = (float)y - pad / fmcs;
            float y1 = (float)y + (float)rectangle.height() / fmcs + pad / fmcs;
            float s0 = 0.0f;
            float t0 = 0.0f;
            float s1 = 1.0f;
            float t1 = 1.0f;
            float w = x1 - x0;
            float h = y1 - y0;
            float z = this.quadCount;
            float floatInstance = instance;
            if (this.quadCount < this.maxQuads) {
                BufferWriter bufferWriter;
                BufferWriter $this$insertCharacterQuad_u24lambda_u246 = bufferWriter = bw;
                boolean bl = false;
                $this$insertCharacterQuad_u24lambda_u246.write(u0, v0);
                $this$insertCharacterQuad_u24lambda_u246.write(s0, t0, w, h);
                $this$insertCharacterQuad_u24lambda_u246.write(x0, y0, z);
                $this$insertCharacterQuad_u24lambda_u246.write(floatInstance);
                $this$insertCharacterQuad_u24lambda_u246.write(u1, v0);
                $this$insertCharacterQuad_u24lambda_u246.write(s1, t0, w, h);
                $this$insertCharacterQuad_u24lambda_u246.write(x1, y0, z);
                $this$insertCharacterQuad_u24lambda_u246.write(floatInstance);
                $this$insertCharacterQuad_u24lambda_u246.write(u1, v1);
                $this$insertCharacterQuad_u24lambda_u246.write(s1, t1, w, h);
                $this$insertCharacterQuad_u24lambda_u246.write(x1, y1, z);
                $this$insertCharacterQuad_u24lambda_u246.write(floatInstance);
                $this$insertCharacterQuad_u24lambda_u246.write(u0, v0);
                $this$insertCharacterQuad_u24lambda_u246.write(s0, t0, w, h);
                $this$insertCharacterQuad_u24lambda_u246.write(x0, y0, z);
                $this$insertCharacterQuad_u24lambda_u246.write(floatInstance);
                $this$insertCharacterQuad_u24lambda_u246.write(u0, v1);
                $this$insertCharacterQuad_u24lambda_u246.write(s0, t1, w, h);
                $this$insertCharacterQuad_u24lambda_u246.write(x0, y1, z);
                $this$insertCharacterQuad_u24lambda_u246.write(floatInstance);
                $this$insertCharacterQuad_u24lambda_u246.write(u1, v1);
                $this$insertCharacterQuad_u24lambda_u246.write(s1, t1, w, h);
                $this$insertCharacterQuad_u24lambda_u246.write(x1, y1, z);
                $this$insertCharacterQuad_u24lambda_u246.write(floatInstance);
                int n = this.quadCount;
                this.quadCount = n + 1;
            }
            glyphRectangle = new GlyphRectangle(character, x0, y0, x1 - x0, y1 - y0);
        } else {
            glyphRectangle = null;
        }
        GlyphRectangle glyphRectangle2 = glyphRectangle;
        return new Pair<Double, Object>(x - sx, glyphRectangle2);
    }
}

