/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.internal.ExpansionType;
import org.openrndr.internal.PathPoint;
import org.openrndr.math.Vector2;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020\u0015H\u0002J>\u0010.\u001a\u00020/2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0015JF\u00105\u001a\u00020/2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0015J>\u00107\u001a\u00020/2\u0006\u00108\u001a\u00020+2\u0006\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0015J>\u0010=\u001a\u00020/2\u0006\u00108\u001a\u00020+2\u0006\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0015J6\u0010>\u001a\u00020/2\u0006\u00108\u001a\u00020+2\u0006\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0015J6\u0010?\u001a\u00020/2\u0006\u00108\u001a\u00020+2\u0006\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0015J\u000e\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0007J.\u0010C\u001a\u00020/2\u0006\u0010D\u001a\u00020\u00152\u0006\u0010E\u001a\u00020\u00152\u0006\u0010F\u001a\u00020\u00152\u0006\u0010G\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u001a\u0010 \u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0017\"\u0004\b\"\u0010\u0019R\u001a\u0010#\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u000f\"\u0004\b%\u0010\u0013\u00a8\u0006H"}, d2={"Lorg/openrndr/internal/Expansion;", "", "type", "Lorg/openrndr/internal/ExpansionType;", "fb", "", "bufferStart", "", "<init>", "(Lorg/openrndr/internal/ExpansionType;[FI)V", "getType", "()Lorg/openrndr/internal/ExpansionType;", "getFb", "()[F", "getBufferStart", "()I", "vertexCount", "getVertexCount", "setVertexCount", "(I)V", "minx", "", "getMinx", "()D", "setMinx", "(D)V", "maxx", "getMaxx", "setMaxx", "miny", "getMiny", "setMiny", "maxy", "getMaxy", "setMaxy", "bufferPosition", "getBufferPosition", "setBufferPosition", "chooseBevel", "", "bevel", "", "p0", "Lorg/openrndr/internal/PathPoint;", "p1", "w", "bevelJoin", "", "lw", "rw", "lu", "ru", "offset", "roundJoin", "ncap", "buttCapStart", "p", "dx", "dy", "d", "aa", "buttCapEnd", "roundCapStart", "roundCapEnd", "vertex", "Lorg/openrndr/math/Vector2;", "idx", "addVertex", "x", "y", "u", "v", "openrndr-draw"})
public final class Expansion {
    @NotNull
    private final ExpansionType type;
    @NotNull
    private final float[] fb;
    private final int bufferStart;
    private int vertexCount;
    private double minx;
    private double maxx;
    private double miny;
    private double maxy;
    private int bufferPosition;

    public Expansion(@NotNull ExpansionType type, @NotNull float[] fb, int bufferStart) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(fb, "fb");
        this.type = type;
        this.fb = fb;
        this.bufferStart = bufferStart;
        this.minx = Double.POSITIVE_INFINITY;
        this.maxx = Double.NEGATIVE_INFINITY;
        this.miny = Double.POSITIVE_INFINITY;
        this.maxy = Double.NEGATIVE_INFINITY;
        this.bufferPosition = this.bufferStart;
    }

    @NotNull
    public final ExpansionType getType() {
        return this.type;
    }

    @NotNull
    public final float[] getFb() {
        return this.fb;
    }

    public final int getBufferStart() {
        return this.bufferStart;
    }

    public final int getVertexCount() {
        return this.vertexCount;
    }

    public final void setVertexCount(int n) {
        this.vertexCount = n;
    }

    public final double getMinx() {
        return this.minx;
    }

    public final void setMinx(double d) {
        this.minx = d;
    }

    public final double getMaxx() {
        return this.maxx;
    }

    public final void setMaxx(double d) {
        this.maxx = d;
    }

    public final double getMiny() {
        return this.miny;
    }

    public final void setMiny(double d) {
        this.miny = d;
    }

    public final double getMaxy() {
        return this.maxy;
    }

    public final void setMaxy(double d) {
        this.maxy = d;
    }

    public final int getBufferPosition() {
        return this.bufferPosition;
    }

    public final void setBufferPosition(int n) {
        this.bufferPosition = n;
    }

    private final double[] chooseBevel(boolean bevel, PathPoint p0, PathPoint p1, double w) {
        double x0 = 0.0;
        double y0 = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        if (bevel) {
            x0 = p1.getX() + p0.getDy() * w;
            y0 = p1.getY() - p0.getDx() * w;
            x1 = p1.getX() + p1.getDy() * w;
            y1 = p1.getY() - p1.getDx() * w;
        } else {
            x0 = p1.getX() + p1.getDmx() * w;
            y0 = p1.getY() + p1.getDmy() * w;
            x1 = p1.getX() + p1.getDmx() * w;
            y1 = p1.getY() + p1.getDmy() * w;
        }
        double[] dArray = new double[]{x0, y0, x1, y1};
        return dArray;
    }

    public final void bevelJoin(@NotNull PathPoint p0, @NotNull PathPoint p1, double lw, double rw, double lu, double ru, double offset) {
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        double dlx0 = p0.getDy();
        double dly0 = -p0.getDx();
        double dlx1 = p1.getDy();
        double dly1 = -p1.getDx();
        if (!(dlx0 == dlx0 && dly0 == dly0 && dlx1 == dlx1 && dly1 == dly1 && lw == lw && rw == rw && p0.getX() == p0.getX() && p0.getY() == p0.getY() && p1.getX() == p1.getX() && p1.getY() == p1.getY())) {
            return;
        }
        if ((p1.getFlags() & 2) != 0) {
            double[] r = this.chooseBevel((p1.getFlags() & 8) != 0, p0, p1, lw);
            double lx0 = r[0];
            double ly0 = r[1];
            double lx1 = r[2];
            double ly1 = r[3];
            this.addVertex(lx0, ly0, lu, 1.0, offset);
            this.addVertex(p1.getX() - dlx0 * rw, p1.getY() - dly0 * rw, ru, 1.0, offset);
            if ((p1.getFlags() & 4) != 0) {
                this.addVertex(lx0, ly0, lu, 1.0, offset);
                this.addVertex(p1.getX() - dlx0 * rw, p1.getY() - dly0 * rw, ru, 1.0, offset);
                this.addVertex(lx1, ly1, lu, 1.0, offset);
                this.addVertex(p1.getX() - dlx1 * rw, p1.getY() - dly1 * rw, ru, 1.0, offset);
            } else {
                double rx0 = p1.getX() - p1.getDmx() * rw;
                double ry0 = p1.getY() - p1.getDmy() * rw;
                this.addVertex(p1.getX(), p1.getY(), 0.5, 1.0, offset);
                this.addVertex(p1.getX() - dlx0 * rw, p1.getY() - dly0 * rw, ru, 1.0, offset);
                this.addVertex(rx0, ry0, ru, 1.0, offset);
                this.addVertex(rx0, ry0, ru, 1.0, offset);
                this.addVertex(p1.getX(), p1.getY(), 0.5, 1.0, offset);
                this.addVertex(p1.getX() - dlx1 * rw, p1.getY() - dly1 * rw, ru, 1.0, offset);
            }
            this.addVertex(lx1, ly1, lu, 1.0, offset);
            this.addVertex(p1.getX() - dlx1 * rw, p1.getY() - dly1 * rw, ru, 1.0, offset);
        } else {
            double[] r = this.chooseBevel((p1.getFlags() & 8) != 0, p0, p1, -rw);
            double rx0 = r[0];
            double ry0 = r[1];
            double rx1 = r[2];
            double ry1 = r[3];
            this.addVertex(p1.getX() + dlx0 * lw, p1.getY() + dly0 * lw, lu, 1.0, offset);
            this.addVertex(rx0, ry0, ru, 1.0, offset);
            if ((p1.getFlags() & 4) != 0) {
                this.addVertex(p1.getX() + dlx0 * lw, p1.getY() + dly0 * lw, lu, 1.0, offset);
                this.addVertex(rx0, ry0, ru, 1.0, offset);
                this.addVertex(p1.getX() + dlx1 * lw, p1.getY() + dly1 * lw, lu, 1.0, offset);
                this.addVertex(rx1, ry1, ru, 1.0, offset);
            } else {
                double lx0 = p1.getX() + p1.getDmx() * lw;
                double ly0 = p1.getY() + p1.getDmy() * lw;
                this.addVertex(p1.getX() + dlx0 * lw, p1.getY() + dly0 * lw, lu, 1.0, offset);
                this.addVertex(p1.getX(), p1.getY(), 0.5, 1.0, offset);
                this.addVertex(lx0, ly0, lu, 1.0, offset);
                this.addVertex(lx0, ly0, lu, 1.0, offset);
                this.addVertex(p1.getX() + dlx1 * lw, p1.getY() + dly1 * lw, lu, 1.0, offset);
                this.addVertex(p1.getX(), p1.getY(), 0.5, 1.0, offset);
            }
            this.addVertex(p1.getX() + dlx1 * lw, p1.getY() + dly1 * lw, lu, 1.0, offset);
            this.addVertex(rx1, ry1, ru, 1.0, offset);
        }
    }

    public final void roundJoin(@NotNull PathPoint p0, @NotNull PathPoint p1, double lw, double rw, double lu, double ru, int ncap, double offset) {
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        double dlx0 = p0.getDy();
        double dly0 = -p0.getDx();
        double dlx1 = p1.getDy();
        double dly1 = -p1.getDx();
        if ((p1.getFlags() & 2) != 0) {
            double[] r = this.chooseBevel((p1.getFlags() & 8) != 0, p0, p1, lw);
            double lx0 = r[0];
            double ly0 = r[1];
            double lx1 = r[2];
            double ly1 = r[3];
            double a0 = Math.atan2(-dly0, -dlx0);
            double a1 = Math.atan2(-dly1, -dlx1);
            if (a1 > a0) {
                a0 += Math.PI * 2;
            }
            if (a0 < 0.0 || a1 < 0.0) {
                a0 += Math.PI * 2;
                a1 += Math.PI * 2;
            }
            this.addVertex(lx0, ly0, lu, 1.0, offset);
            this.addVertex(p1.getX() - dlx0 * rw, p1.getY() - dly0 * rw, ru, 1.0, offset);
            int n = RangesKt.coerceAtLeast(RangesKt.coerceAtMost(ncap, (int)Math.ceil((a0 - a1) / Math.PI * (double)ncap)), 2);
            for (int i = 0; i < n; ++i) {
                double u = (double)i / ((double)n - 1.0);
                double a = a0 + u * (a1 - a0);
                double rx = p1.getX() + Math.cos(a) * rw;
                double ry = p1.getY() + Math.sin(a) * rw;
                this.addVertex(p1.getX(), p1.getY(), 0.5, 1.0, offset);
                this.addVertex(rx, ry, ru, 1.0, offset);
            }
            this.addVertex(lx1, ly1, lu, 1.0, offset);
            this.addVertex(p1.getX() - dlx1 * rw, p1.getY() - dly1 * rw, ru, 1.0, offset);
        } else {
            double[] r = this.chooseBevel((p1.getFlags() & 8) != 0, p0, p1, -rw);
            double rx0 = r[0];
            double ry0 = r[1];
            double rx1 = r[2];
            double ry1 = r[3];
            double a0 = Math.atan2(dly0, dlx0);
            double a1 = Math.atan2(dly1, dlx1);
            if (a1 < a0) {
                a1 += Math.PI * 2;
            }
            this.addVertex(p1.getX() + dlx0 * rw, p1.getY() + dly0 * rw, lu, 1.0, offset);
            this.addVertex(rx0, ry0, ru, 1.0, offset);
            int n = RangesKt.coerceAtLeast(RangesKt.coerceAtMost(ncap, (int)Math.ceil((a1 - a0) / Math.PI * (double)ncap)), 2);
            for (int i = 0; i < n; ++i) {
                double a = a0 + (double)i / ((double)n - 1.0) * (a1 - a0);
                this.addVertex(p1.getX() + Math.cos(a) * lw, p1.getY() + Math.sin(a) * lw, lu, 1.0, offset);
                this.addVertex(p1.getX(), p1.getY(), 0.5, 1.0, offset);
            }
            this.addVertex(p1.getX() + dlx1 * rw, p1.getY() + dly1 * rw, lu, 1.0, offset);
            this.addVertex(rx1, ry1, ru, 1.0, offset);
        }
    }

    public final void buttCapStart(@NotNull PathPoint p, double dx, double dy, double w, double d, double aa, double offset) {
        Intrinsics.checkNotNullParameter(p, "p");
        if (dx == dx && dy == dy && d == d) {
            double px = p.getX() - dx * d;
            double py = p.getY() - dy * d;
            double dly = -dx;
            this.addVertex(px + dy * w - dx * aa, py + dly * w - dy * aa, 0.0, 0.0, offset);
            this.addVertex(px - dy * w - dx * aa, py - dly * w - dy * aa, 1.0, 0.0, offset);
            this.addVertex(px + dy * w, py + dly * w, 0.0, 1.0, offset);
            this.addVertex(px - dy * w, py - dly * w, 1.0, 1.0, offset);
        }
    }

    public final void buttCapEnd(@NotNull PathPoint p, double dx, double dy, double w, double d, double aa, double offset) {
        Intrinsics.checkNotNullParameter(p, "p");
        if (dx == dx && dy == dy && d == d) {
            double px = p.getX() - dx * d;
            double py = p.getY() - dy * d;
            double dly = -dx;
            this.addVertex(px + dy * w, py + dly * w, 0.0, 1.0, offset);
            this.addVertex(px - dy * w, py - dly * w, 1.0, 1.0, offset);
            this.addVertex(px + dy * w + dx * aa, py + dly * w + dy * aa, 0.0, 0.0, offset);
            this.addVertex(px - dy * w + dx * aa, py - dly * w + dy * aa, 1.0, 0.0, offset);
        }
    }

    public final void roundCapStart(@NotNull PathPoint p, double dx, double dy, double w, int ncap, double offset) {
        Intrinsics.checkNotNullParameter(p, "p");
        if (dx == dx && dy == dy) {
            double px = p.getX();
            double py = p.getY();
            double dly = -dx;
            for (int i = 0; i < ncap; ++i) {
                double a = (double)i / ((double)ncap - 1.0) * Math.PI;
                double ax = Math.cos(a) * w;
                double ay = Math.sin(a) * w;
                this.addVertex(px - dy * ax - dx * ay, py - dly * ax - dy * ay, 0.0, 1.0, offset);
                this.addVertex(px, py, 0.5, 1.0, offset);
            }
            this.addVertex(px + dy * w, py + dly * w, 0.0, 1.0, offset);
            this.addVertex(px - dy * w, py - dly * w, 1.0, 1.0, offset);
        }
    }

    public final void roundCapEnd(@NotNull PathPoint p, double dx, double dy, double w, int ncap, double offset) {
        Intrinsics.checkNotNullParameter(p, "p");
        if (dx == dx && dy == dy) {
            double px = p.getX();
            double py = p.getY();
            double dly = -dx;
            this.addVertex(px + dy * w, py + dly * w, 0.0, 1.0, offset);
            this.addVertex(px - dy * w, py - dly * w, 1.0, 1.0, offset);
            for (int i = 0; i < ncap; ++i) {
                double a = (double)i / (double)(ncap - 1) * Math.PI;
                double ax = Math.cos(a) * w;
                double ay = Math.sin(a) * w;
                this.addVertex(px, py, 0.5, 1.0, offset);
                this.addVertex(px - dy * ax + dx * ay, py - dly * ax + dy * ay, 0.0, 1.0, offset);
            }
        }
    }

    @NotNull
    public final Vector2 vertex(int idx) {
        return new Vector2(this.fb[this.bufferStart + idx * 5], this.fb[this.bufferStart + idx * 5 + 1]);
    }

    public final void addVertex(double x, double y, double u, double v, double offset) {
        if (!(x == x) || !(y == y)) {
            return;
        }
        this.minx = Math.min(this.minx, x);
        this.maxx = Math.max(this.maxx, x);
        this.miny = Math.min(this.miny, y);
        this.maxy = Math.max(this.maxy, y);
        int n = this.bufferPosition;
        this.bufferPosition = n + 1;
        this.fb[n] = (float)x;
        n = this.bufferPosition;
        this.bufferPosition = n + 1;
        this.fb[n] = (float)y;
        n = this.bufferPosition;
        this.bufferPosition = n + 1;
        this.fb[n] = (float)u;
        n = this.bufferPosition;
        this.bufferPosition = n + 1;
        this.fb[n] = (float)v;
        n = this.bufferPosition;
        this.bufferPosition = n + 1;
        this.fb[n] = (float)offset;
        n = this.vertexCount;
        this.vertexCount = n + 1;
    }
}

