/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.textwriter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.FontMap;
import org.openrndr.draw.GlyphMetrics;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.extra.textwriter.Cursor;
import org.openrndr.extra.textwriter.TextToken;
import org.openrndr.extra.textwriter.WriteStyle;
import org.openrndr.internal.FontImageMapDrawer;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u00104\u001a\u000205J\u0006\u00106\u001a\u000205J\u0016\u00107\u001a\u0002052\u0006\u00108\u001a\u00020\u001f2\u0006\u00109\u001a\u00020\u001fJ\u000e\u0010:\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020(J\u001e\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<2\u0006\u0010;\u001a\u00020(2\b\b\u0002\u0010>\u001a\u00020?J\u0014\u0010@\u001a\u0002052\f\u0010A\u001a\b\u0012\u0004\u0012\u00020=0<J \u0010B\u001a\b\u0012\u0004\u0012\u00020=0<2\u0006\u0010;\u001a\u00020(2\b\b\u0002\u0010C\u001a\u00020?H\u0002J&\u0010D\u001a\u0002052\u0006\u0010\b\u001a\u00020\t2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020=0F2\u0006\u0010G\u001a\u00020=H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR$\u0010 \u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R$\u0010%\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R(\u0010)\u001a\u0004\u0018\u00010(2\b\u0010\u000e\u001a\u0004\u0018\u00010(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R&\u0010/\u001a\u00020.2\u0006\u0010\u000e\u001a\u00020.8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103\u00a8\u0006H"}, d2={"Lorg/openrndr/extra/textwriter/TextWriter;", "", "drawerRef", "Lorg/openrndr/draw/Drawer;", "<init>", "(Lorg/openrndr/draw/Drawer;)V", "getDrawerRef", "()Lorg/openrndr/draw/Drawer;", "cursor", "Lorg/openrndr/extra/textwriter/Cursor;", "getCursor", "()Lorg/openrndr/extra/textwriter/Cursor;", "setCursor", "(Lorg/openrndr/extra/textwriter/Cursor;)V", "value", "Lorg/openrndr/shape/Rectangle;", "box", "getBox", "()Lorg/openrndr/shape/Rectangle;", "setBox", "(Lorg/openrndr/shape/Rectangle;)V", "style", "Lorg/openrndr/extra/textwriter/WriteStyle;", "getStyle", "()Lorg/openrndr/extra/textwriter/WriteStyle;", "setStyle", "(Lorg/openrndr/extra/textwriter/WriteStyle;)V", "styleStack", "Lkotlin/collections/ArrayDeque;", "getStyleStack", "()Lkotlin/collections/ArrayDeque;", "", "leading", "getLeading", "()D", "setLeading", "(D)V", "tracking", "getTracking", "setTracking", "", "ellipsis", "getEllipsis", "()Ljava/lang/String;", "setEllipsis", "(Ljava/lang/String;)V", "Lorg/openrndr/draw/DrawStyle;", "drawStyle", "getDrawStyle", "()Lorg/openrndr/draw/DrawStyle;", "setDrawStyle", "(Lorg/openrndr/draw/DrawStyle;)V", "newLine", "", "gaplessNewLine", "move", "x", "y", "textWidth", "text", "", "Lorg/openrndr/extra/textwriter/TextToken;", "visible", "", "drawTextTokens", "tokens", "makeTextTokens", "mustFit", "emitToken", "textTokens", "", "textToken", "orx-text-writer"})
@SourceDebugExtension(value={"SMAP\nTextWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextWriter.kt\norg/openrndr/extra/textwriter/TextWriter\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,218:1\n1104#2,3:219\n1#3:222\n1863#4,2:223\n739#4,9:225\n37#5:234\n36#5,3:235\n13402#6,2:238\n*S KotlinDebug\n*F\n+ 1 TextWriter.kt\norg/openrndr/extra/textwriter/TextWriter\n*L\n85#1:219,3\n115#1:223,2\n136#1:225,9\n136#1:234\n136#1:235,3\n138#1:238,2\n*E\n"})
public final class TextWriter {
    @Nullable
    private final Drawer drawerRef;
    @NotNull
    private Cursor cursor;
    @NotNull
    private Rectangle box;
    @NotNull
    private WriteStyle style;
    @NotNull
    private final ArrayDeque<WriteStyle> styleStack;
    @NotNull
    private DrawStyle drawStyle;

    public TextWriter(@Nullable Drawer drawerRef) {
        this.drawerRef = drawerRef;
        this.cursor = new Cursor(0.0, 0.0, 3, null);
        Drawer drawer = this.drawerRef;
        Drawer drawer2 = this.drawerRef;
        this.box = new Rectangle(Vector2.Companion.getZERO(), drawer != null ? (double)drawer.getWidth() : Double.POSITIVE_INFINITY, drawer2 != null ? (double)drawer2.getHeight() : Double.POSITIVE_INFINITY);
        this.style = new WriteStyle();
        this.styleStack = new ArrayDeque();
        this.drawStyle = new DrawStyle(null, null, null, null, null, 0.0, false, 0.0, null, null, false, null, null, null, false, null, null, null, null, null, null, null, null, 0x7FFFFF, null);
    }

    @Nullable
    public final Drawer getDrawerRef() {
        return this.drawerRef;
    }

    @NotNull
    public final Cursor getCursor() {
        return this.cursor;
    }

    public final void setCursor(@NotNull Cursor cursor) {
        Intrinsics.checkNotNullParameter(cursor, "<set-?>");
        this.cursor = cursor;
    }

    @NotNull
    public final Rectangle getBox() {
        return this.box;
    }

    public final void setBox(@NotNull Rectangle value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.box = value;
        this.cursor.setX(value.corner().x());
        this.cursor.setY(value.corner().y());
    }

    @NotNull
    public final WriteStyle getStyle() {
        return this.style;
    }

    public final void setStyle(@NotNull WriteStyle writeStyle) {
        Intrinsics.checkNotNullParameter(writeStyle, "<set-?>");
        this.style = writeStyle;
    }

    @NotNull
    public final ArrayDeque<WriteStyle> getStyleStack() {
        return this.styleStack;
    }

    public final double getLeading() {
        return this.style.getLeading();
    }

    public final void setLeading(double value) {
        this.style.setLeading(value);
    }

    public final double getTracking() {
        return this.style.getTracking();
    }

    public final void setTracking(double value) {
        this.style.setTracking(value);
    }

    @Nullable
    public final String getEllipsis() {
        return this.style.getEllipsis();
    }

    public final void setEllipsis(@Nullable String value) {
        this.style.setEllipsis(value);
    }

    @NotNull
    public final DrawStyle getDrawStyle() {
        Object object = this.drawerRef;
        if (object == null || (object = ((Drawer)object).getDrawStyle()) == null) {
            object = this.drawStyle;
        }
        return object;
    }

    public final void setDrawStyle(@NotNull DrawStyle value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.drawStyle = this.getDrawStyle();
    }

    public final void newLine() {
        this.cursor.setX(this.box.corner().x());
        Cursor cursor = this.cursor;
        FontMap fontMap = this.getDrawStyle().getFontMap();
        cursor.setY(cursor.getY() + ((fontMap != null ? fontMap.getLeading() : 0.0) + this.style.getLeading()));
    }

    public final void gaplessNewLine() {
        this.cursor.setX(this.box.corner().x());
        Cursor cursor = this.cursor;
        FontMap fontMap = this.getDrawStyle().getFontMap();
        cursor.setY(cursor.getY() + (fontMap != null ? fontMap.getHeight() : 0.0));
    }

    public final void move(double x, double y) {
        Cursor cursor = this.cursor;
        cursor.setX(cursor.getX() + x);
        cursor = this.cursor;
        cursor.setY(cursor.getY() + y);
    }

    /*
     * WARNING - void declaration
     */
    public final double textWidth(@NotNull String text) {
        void $this$count$iv;
        char it;
        double d;
        int n;
        Intrinsics.checkNotNullParameter(text, "text");
        CharSequence charSequence = text;
        double d2 = 0.0;
        for (n = 0; n < charSequence.length(); ++n) {
            char c2;
            char c3 = c2 = charSequence.charAt(n);
            d = d2;
            boolean bl = false;
            FontMap fontMap = this.getDrawStyle().getFontMap();
            Intrinsics.checkNotNull(fontMap, "null cannot be cast to non-null type org.openrndr.draw.FontImageMap");
            GlyphMetrics glyphMetrics = ((FontImageMap)fontMap).getGlyphMetrics().get(Character.valueOf(it));
            double d3 = (glyphMetrics != null ? glyphMetrics.advanceWidth() : 0.0) + this.style.getTracking();
            d2 = d + d3;
        }
        charSequence = text;
        d = d2;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (n = 0; n < $this$count$iv.length(); ++n) {
            char element$iv;
            it = element$iv = $this$count$iv.charAt(n);
            boolean bl = false;
            if (!(it == ' ')) continue;
            ++count$iv;
        }
        int n2 = count$iv;
        return d - (double)(n2 + 1) * this.style.getTracking();
    }

    @NotNull
    public final List<TextToken> text(@NotNull String text, boolean visible) {
        Intrinsics.checkNotNullParameter(text, "text");
        Drawer drawer = this.drawerRef;
        if (drawer != null) {
            drawer.getFontMap();
        }
        List<TextToken> renderTokens = this.makeTextTokens(text, false);
        if (visible) {
            this.drawTextTokens(renderTokens);
        }
        return renderTokens;
    }

    public static /* synthetic */ List text$default(TextWriter textWriter, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return textWriter.text(string, bl);
    }

    public final void drawTextTokens(@NotNull List<TextToken> tokens) {
        block2: {
            TextToken it;
            int n;
            Intrinsics.checkNotNullParameter(tokens, "tokens");
            Drawer drawer = this.drawerRef;
            if (drawer == null) break block2;
            Drawer d = drawer;
            boolean bl = false;
            FontImageMapDrawer renderer = d.getFontImageMapDrawer();
            Iterable iterable = tokens;
            FontImageMapDrawer fontImageMapDrawer = renderer;
            int n2 = 0;
            for (Object t : iterable) {
                TextToken textToken = (TextToken)t;
                n = n2;
                boolean bl2 = false;
                int n3 = it.getToken().length();
                n2 = n + n3;
            }
            n = n2;
            VertexBuffer queue = fontImageMapDrawer.getQueue(n);
            Iterable $this$forEach$iv = tokens;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (TextToken)element$iv;
                boolean bl3 = false;
                FontMap fontMap = d.getDrawStyle().getFontMap();
                Intrinsics.checkNotNull(fontMap);
                renderer.queueText(fontMap, it.getToken(), it.getX(), it.getY(), this.style.getTracking(), this.getDrawStyle().getKerning(), this.getDrawStyle().getTextSetting(), queue);
            }
            renderer.flush(d.getContext(), d.getDrawStyle(), queue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextToken> makeTextTokens(String text, boolean mustFit) {
        FontMap fontMap = this.getDrawStyle().getFontMap();
        if (fontMap != null) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            FontMap font = fontMap;
            boolean bl = false;
            boolean fits = true;
            FontImageMap cfr_ignored_0 = (FontImageMap)font;
            Object object = text;
            Regex regex = new Regex("((?<=\n)|(?=\n))");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] lines = thisCollection$iv.toArray(new String[0]);
            List tokens = new ArrayList();
            String[] $this$forEach$iv = lines;
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (int i = 0; i < n2; ++i) {
                String element$iv;
                String line = element$iv = $this$forEach$iv[i];
                boolean bl3 = false;
                String[] stringArray = new String[]{" "};
                List lineTokens = StringsKt.split$default((CharSequence)line, stringArray, false, 0, 6, null);
                tokens.addAll(lineTokens);
            }
            Cursor localCursor = new Cursor(this.cursor);
            GlyphMetrics glyphMetrics = ((FontImageMap)font).getGlyphMetrics().get(Character.valueOf(' '));
            if (glyphMetrics == null) {
                throw new IllegalStateException("no metrics for space".toString());
            }
            double spaceWidth = glyphMetrics.advanceWidth();
            double verticalSpace = this.style.getLeading() + ((FontImageMap)font).getLeading();
            List textTokens = new ArrayList();
            int n3 = tokens.size();
            for (int i = 0; i < n3; ++i) {
                String token = (String)tokens.get(i);
                if (Intrinsics.areEqual(token, "\n")) {
                    localCursor.setX(this.box.corner().x());
                    localCursor.setY(localCursor.getY() + verticalSpace);
                    continue;
                }
                CharSequence charSequence = token;
                double d = 0.0;
                for (int j = 0; j < charSequence.length(); ++j) {
                    void it;
                    char c2;
                    char c3 = c2 = charSequence.charAt(j);
                    double d2 = d;
                    boolean bl4 = false;
                    GlyphMetrics glyphMetrics2 = ((FontImageMap)font).getGlyphMetrics().get(Character.valueOf((char)it));
                    double d3 = glyphMetrics2 != null ? glyphMetrics2.advanceWidth() : 0.0;
                    d = d2 + d3;
                }
                double tokenWidth = d + this.style.getTracking() * (double)RangesKt.coerceAtLeast(token.length() - 1, 0);
                if (localCursor.getX() + tokenWidth < this.box.x() + this.box.width() && localCursor.getY() <= this.box.y() + this.box.height()) {
                    TextWriter $this$makeTextTokens_u24lambda_u249_u24lambda_u248 = this;
                    boolean bl5 = false;
                    TextToken textToken = new TextToken(token, localCursor.getX(), localCursor.getY(), tokenWidth, $this$makeTextTokens_u24lambda_u249_u24lambda_u248.style.getTracking());
                    $this$makeTextTokens_u24lambda_u249_u24lambda_u248.emitToken(localCursor, textTokens, textToken);
                } else {
                    if (localCursor.getY() > this.box.corner().y() + this.box.height()) {
                        fits = false;
                    }
                    if (localCursor.getY() + verticalSpace <= this.box.y() + this.box.height()) {
                        localCursor.setY(localCursor.getY() + verticalSpace);
                        localCursor.setX(this.box.x());
                        this.emitToken(localCursor, textTokens, new TextToken(token, localCursor.getX(), localCursor.getY(), tokenWidth, this.style.getTracking()));
                    } else {
                        if (!mustFit && this.style.getEllipsis() != null && this.cursor.getY() <= this.box.y() + this.box.height()) {
                            String string = this.style.getEllipsis();
                            if (string == null) {
                                string = "";
                            }
                            this.emitToken(localCursor, textTokens, new TextToken(string, localCursor.getX(), localCursor.getY(), tokenWidth, this.style.getTracking()));
                            break;
                        }
                        fits = false;
                    }
                }
                localCursor.setX(localCursor.getX() + tokenWidth);
                if (i == CollectionsKt.getLastIndex(tokens)) continue;
                localCursor.setX(localCursor.getX() + (spaceWidth + this.getTracking()));
            }
            if (fits || !fits && !mustFit) {
                this.cursor = new Cursor(localCursor);
            } else {
                textTokens.clear();
            }
            return textTokens;
        }
        return CollectionsKt.emptyList();
    }

    static /* synthetic */ List makeTextTokens$default(TextWriter textWriter, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return textWriter.makeTextTokens(string, bl);
    }

    private final void emitToken(Cursor cursor, List<TextToken> textTokens, TextToken textToken) {
        textTokens.add(textToken);
    }
}

