/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.svg;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Entities;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.extra.composition.AttributeOrPropertyKey;
import org.openrndr.extra.composition.AttributeOrPropertyValue;
import org.openrndr.extra.composition.Composition;
import org.openrndr.extra.composition.CompositionNode;
import org.openrndr.extra.composition.GroupNode;
import org.openrndr.extra.composition.ImageNode;
import org.openrndr.extra.composition.ShapeNode;
import org.openrndr.extra.composition.Styleable;
import org.openrndr.extra.composition.TextNode;
import org.openrndr.extra.svg.ShapeExtensionsKt;
import org.openrndr.extra.svg.VisitStage;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u001a\u0018\u0010\r\u001a\u00020\u0006*\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u0006\u001a>\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\b2,\u0010\u0015\u001a(\u0012\u0004\u0012\u00020\b\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00010\u0016\u00a2\u0006\u0002\b\u001bH\u0002\"\u0018\u0010\u0007\u001a\u00020\u0006*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0018\u0010\u000b\u001a\u00020\u0006*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001c"}, d2={"saveToFile", "", "Lorg/openrndr/extra/composition/Composition;", "file", "Ljava/io/File;", "toSVG", "", "svgId", "Lorg/openrndr/extra/composition/CompositionNode;", "getSvgId", "(Lorg/openrndr/extra/composition/CompositionNode;)Ljava/lang/String;", "svgAttributes", "getSvgAttributes", "serialize", "Lorg/openrndr/extra/composition/Styleable;", "parentStyleable", "writeSVG", "composition", "topLevelId", "process", "compositionNode", "visitor", "Lkotlin/Function2;", "Lorg/openrndr/extra/svg/VisitStage;", "Lkotlin/ParameterName;", "name", "stage", "Lkotlin/ExtensionFunctionType;", "orx-svg"})
@SourceDebugExtension(value={"SMAP\nSVGWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SVGWriter.kt\norg/openrndr/extra/svg/SVGWriterKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n126#2:180\n153#2,3:181\n216#2,2:191\n216#2,2:193\n126#2:195\n153#2,3:196\n535#3:184\n520#3,6:185\n1863#4,2:199\n774#4:201\n865#4,2:202\n774#4:204\n865#4,2:205\n*S KotlinDebug\n*F\n+ 1 SVGWriter.kt\norg/openrndr/extra/svg/SVGWriterKt\n*L\n50#1:180\n50#1:181,3\n67#1:191,2\n72#1:193,2\n102#1:195\n102#1:196,3\n62#1:184\n62#1:185,6\n176#1:199,2\n120#1:201\n120#1:202,2\n133#1:204\n133#1:205,2\n*E\n"})
public final class SVGWriterKt {
    public static final void saveToFile(@NotNull Composition $this$saveToFile, @NotNull File file) {
        Intrinsics.checkNotNullParameter($this$saveToFile, "<this>");
        Intrinsics.checkNotNullParameter(file, "file");
        if (!Intrinsics.areEqual(FilesKt.getExtension(file), "svg")) {
            throw new IllegalArgumentException("can only write svg files, the extension '" + FilesKt.getExtension(file) + "' is not supported");
        }
        String svg = SVGWriterKt.writeSVG$default($this$saveToFile, null, 2, null);
        FilesKt.writeText$default(file, svg, null, 2, null);
    }

    @NotNull
    public static final String toSVG(@NotNull Composition $this$toSVG) {
        Intrinsics.checkNotNullParameter($this$toSVG, "<this>");
        return SVGWriterKt.writeSVG$default($this$toSVG, null, 2, null);
    }

    private static final String getSvgId(CompositionNode $this$svgId) {
        String tempId = $this$svgId.getId();
        return Intrinsics.areEqual(tempId, "") ? "" : (tempId == null ? "" : "id=\"" + tempId + "\"");
    }

    /*
     * WARNING - void declaration
     */
    private static final String getSvgAttributes(CompositionNode $this$svgAttributes) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = $this$svgAttributes.getAttributes();
        boolean $i$f$map = false;
        Map<String, String> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object;
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it.getValue() != null && !Intrinsics.areEqual(it.getValue(), "")) {
                Object k = it.getKey();
                String string = (String)it.getValue();
                if (string == null) {
                    string = "";
                }
                object = k + "=\"" + Entities.escape(string) + "\"";
            } else {
                object = (String)it.getKey();
            }
            collection.add(object);
        }
        return CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, null, 62, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final String serialize(Styleable $this$serialize, Styleable parentStyleable) {
        void $this$filterTo$iv$iv;
        StringBuilder sb = new StringBuilder();
        Map $this$filter$iv = $this$serialize.getProperties();
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Map.Entry entry = $this$filterTo$iv$iv.entrySet().iterator();
        while (entry.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = entry.next();
            boolean bl = false;
            if (!(it.getKey() != AttributeOrPropertyKey.SHADESTYLE)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map filtered = destination$iv$iv;
        if (parentStyleable == null) {
            Map $this$forEach$iv = filtered;
            boolean $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                entry = element$iv;
                boolean bl = false;
                t = (AttributeOrPropertyKey)((Object)entry.getKey());
                AttributeOrPropertyValue u = (AttributeOrPropertyValue)entry.getValue();
                if (!(((CharSequence)String.valueOf(u)).length() > 0)) continue;
                sb.append(t + "=\"" + u + "\" ");
            }
        } else {
            Map $this$forEach$iv = filtered;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                entry = element$iv = iterator2.next();
                boolean bl = false;
                t = (AttributeOrPropertyKey)((Object)entry.getKey());
                AttributeOrPropertyValue u = (AttributeOrPropertyValue)entry.getValue();
                if (!(((CharSequence)String.valueOf(u)).length() > 0) || $this$serialize.isInherited(parentStyleable, t)) continue;
                sb.append(t + "=\"" + u + "\" ");
            }
        }
        return ((Object)StringsKt.trim(sb)).toString();
    }

    static /* synthetic */ String serialize$default(Styleable styleable, Styleable styleable2, int n, Object object) {
        if ((n & 1) != 0) {
            styleable2 = null;
        }
        return SVGWriterKt.serialize(styleable, styleable2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String writeSVG(@NotNull Composition composition, @NotNull String topLevelId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(composition, "composition");
        Intrinsics.checkNotNullParameter(topLevelId, "topLevelId");
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        Pair[] pairArray = new Pair[]{TuplesKt.to("xmlns", "http://www.w3.org/2000/svg"), TuplesKt.to("xmlns:xlink", "http://www.w3.org/1999/xlink")};
        Map defaultNamespaces = MapsKt.mapOf(pairArray);
        Map<String, String> $this$map$iv = MapsKt.plus(defaultNamespaces, composition.getNamespaces());
        boolean $i$f$map = false;
        Map<String, String> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            collection.add(k + "=\"" + v + "\"");
        }
        String namespaces = CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, null, 62, null);
        String styleSer = SVGWriterKt.serialize$default(composition.getStyle(), null, 1, null);
        String docStyleSer = SVGWriterKt.serialize$default(composition.getDocumentStyle(), null, 1, null);
        sb.append("<svg version=\"1.2\" baseProfile=\"tiny\" id=\"" + topLevelId + "\" " + namespaces + " " + styleSer + " " + docStyleSer + ">");
        Ref.IntRef textPathID = new Ref.IntRef();
        SVGWriterKt.process(composition.getRoot(), (arg_0, arg_1) -> SVGWriterKt.writeSVG$lambda$6(sb, textPathID, arg_0, arg_1));
        sb.append("</svg>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public static /* synthetic */ String writeSVG$default(Composition composition, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "openrndr-svg";
        }
        return SVGWriterKt.writeSVG(composition, string);
    }

    private static final void process(CompositionNode compositionNode, Function2<? super CompositionNode, ? super VisitStage, Unit> visitor2) {
        visitor2.invoke(compositionNode, VisitStage.PRE);
        if (compositionNode instanceof GroupNode) {
            Iterable $this$forEach$iv = ((GroupNode)compositionNode).getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompositionNode it = (CompositionNode)element$iv;
                boolean bl = false;
                SVGWriterKt.process(it, visitor2);
            }
        }
        visitor2.invoke(compositionNode, VisitStage.POST);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Unit writeSVG$lambda$6(StringBuilder $sb, Ref.IntRef $textPathID, CompositionNode $this$process, VisitStage stage) {
        Intrinsics.checkNotNullParameter($this$process, "$this$process");
        Intrinsics.checkNotNullParameter((Object)stage, "stage");
        if (stage == VisitStage.PRE) {
            CompositionNode compositionNode = $this$process.getParent();
            String styleSerialized = SVGWriterKt.serialize($this$process.getStyle(), compositionNode != null ? compositionNode.getStyle() : null);
            CompositionNode compositionNode2 = $this$process;
            if (compositionNode2 instanceof GroupNode) {
                void $this$filterTo$iv$iv;
                String[] stringArray = new String[]{SVGWriterKt.getSvgId($this$process), styleSerialized, SVGWriterKt.getSvgAttributes($this$process)};
                Iterable iterable = CollectionsKt.listOf(stringArray);
                boolean bl = false;
                Iterable iterable2 = iterable;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String p0 = (String)element$iv$iv;
                    boolean bl2 = false;
                    boolean bl3 = ((CharSequence)p0).length() > 0;
                    if (!bl3) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                String attributes = CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, null, 62, null);
                v2 = $sb.append("<g " + attributes + ">\n");
                return Unit.INSTANCE;
            } else if (compositionNode2 instanceof ShapeNode) {
                void $this$filterTo$iv$iv;
                String pathAttribute = "d=\"" + ShapeExtensionsKt.toSvg(((ShapeNode)$this$process).getShape()) + "\"";
                String[] stringArray = new String[]{SVGWriterKt.getSvgId($this$process), styleSerialized, SVGWriterKt.getSvgAttributes($this$process), pathAttribute};
                Iterable iterable = CollectionsKt.listOf(stringArray);
                boolean $i$f$filter = false;
                Iterable destination$iv$iv = iterable;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String p0 = (String)element$iv$iv;
                    boolean bl = false;
                    boolean bl4 = ((CharSequence)p0).length() > 0;
                    if (!bl4) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                String string = CollectionsKt.joinToString$default((List)destination$iv$iv2, " ", null, null, 0, null, null, 62, null);
                v2 = $sb.append("<path " + string + "/>\n");
                return Unit.INSTANCE;
            } else if (compositionNode2 instanceof TextNode) {
                ShapeContour contour = ((TextNode)$this$process).getContour();
                String string = Entities.escape(((TextNode)$this$process).getText());
                Intrinsics.checkNotNullExpressionValue(string, "escape(...)");
                String string2 = string;
                if (contour == null) {
                    v2 = $sb.append("<text " + SVGWriterKt.getSvgId($this$process) + " " + SVGWriterKt.getSvgAttributes($this$process) + ">" + string2 + "</text>");
                    return Unit.INSTANCE;
                } else {
                    $sb.append("<defs>");
                    $sb.append("<path id=\"text" + $textPathID.element + "\" d=\"" + ShapeExtensionsKt.toSvg(contour) + "\"/>");
                    $sb.append("</defs>");
                    $sb.append("<text " + styleSerialized + "><textPath href=\"#text" + $textPathID.element + "\">" + string2 + "</textPath></text>");
                    int n = $textPathID.element;
                    $textPathID.element = n + 1;
                    v2 = n;
                }
                return Unit.INSTANCE;
            } else {
                if (!(compositionNode2 instanceof ImageNode)) throw new NoWhenBranchMatchedException();
                String dataUrl = ColorBuffer.toDataUrl$default(((ImageNode)$this$process).getImage(), null, 1, null);
                v2 = $sb.append("<image xlink:href=\"" + dataUrl + "\" height=\"" + ((ImageNode)$this$process).getImage().getHeight() + "\" width=\"" + ((ImageNode)$this$process).getImage().getWidth() + "\"/>");
            }
            return Unit.INSTANCE;
        } else {
            if ($this$process instanceof GroupNode) {
                $sb.append("</g>\n");
            }
            v2 = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }
}

