/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.svg;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Element;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferJVM;
import org.openrndr.extra.composition.CompositionStyleSheetKt;
import org.openrndr.extra.svg.Prop;
import org.openrndr.extra.svg.SVGElement;
import org.openrndr.extra.svg.SVGParse;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/openrndr/extra/svg/SVGImage;", "Lorg/openrndr/extra/svg/SVGElement;", "element", "Lorg/jsoup/nodes/Element;", "<init>", "(Lorg/jsoup/nodes/Element;)V", "getElement", "()Lorg/jsoup/nodes/Element;", "x", "", "getX", "()D", "y", "getY", "width", "getWidth", "height", "getHeight", "image", "Lorg/openrndr/draw/ColorBuffer;", "handleAttribute", "", "attribute", "Lorg/jsoup/nodes/Attribute;", "orx-svg"})
public final class SVGImage
extends SVGElement {
    @Nullable
    private final Element element;
    private final double x;
    private final double y;
    private final double width;
    private final double height;

    public SVGImage(@Nullable Element element) {
        super(element, null);
        this.element = element;
        Object object = this.element;
        this.x = object != null && (object = ((Element)object).attribute("x")) != null && (object = ((Attribute)object).getValue()) != null && (object = StringsKt.toDoubleOrNull((String)object)) != null ? (Double)object : 0.0;
        Object object2 = this.element;
        this.y = object2 != null && (object2 = ((Element)object2).attribute("y")) != null && (object2 = ((Attribute)object2).getValue()) != null && (object2 = StringsKt.toDoubleOrNull((String)object2)) != null ? (Double)object2 : 0.0;
        Object object3 = this.element;
        this.width = object3 != null && (object3 = ((Element)object3).attribute("width")) != null && (object3 = ((Attribute)object3).getValue()) != null && (object3 = StringsKt.toDoubleOrNull((String)object3)) != null ? (Double)object3 : 0.0;
        Object object4 = this.element;
        this.height = object4 != null && (object4 = ((Element)object4).attribute("height")) != null && (object4 = ((Attribute)object4).getValue()) != null && (object4 = StringsKt.toDoubleOrNull((String)object4)) != null ? (Double)object4 : 0.0;
        if (this.element != null) {
            CompositionStyleSheetKt.setTransform(this.getStyle(), SVGParse.INSTANCE.transform(this.element));
        }
    }

    public /* synthetic */ SVGImage(Element element, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            element = null;
        }
        this(element);
    }

    @Nullable
    public final Element getElement() {
        return this.element;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    @NotNull
    public final ColorBuffer image() {
        Element element = this.element;
        Intrinsics.checkNotNull(element);
        String string = element.attr("xlink:href");
        Intrinsics.checkNotNullExpressionValue(string, "attr(...)");
        return ColorBufferJVM.loadImage$default(string, null, false, false, null, 30, null);
    }

    @Override
    public void handleAttribute(@NotNull Attribute attribute) {
        Intrinsics.checkNotNullParameter(attribute, "attribute");
        if (this.element != null) {
            String string = attribute.getKey();
            if (Prop.INSTANCE.getList().contains(string)) {
                String string2 = attribute.getKey();
                Intrinsics.checkNotNullExpressionValue(string2, "<get-key>(...)");
                String string3 = attribute.getValue();
                Intrinsics.checkNotNullExpressionValue(string3, "<get-value>(...)");
                this.styleProperty(string2, string3);
            } else if (Intrinsics.areEqual(string, "transform")) {
                CompositionStyleSheetKt.setTransform(this.getStyle(), SVGParse.INSTANCE.transform(this.element));
            }
        }
    }

    public SVGImage() {
        this(null, 1, null);
    }
}

