/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.shadestyles;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ConvertibleToColorRGBa;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.extra.color.phrases.ColorPhraseBook;
import org.openrndr.extra.parameters.ColorParameter;
import org.openrndr.extra.parameters.Description;
import org.openrndr.extra.parameters.DoubleParameter;
import org.openrndr.extra.shaderphrases.ShaderPreprocessorKt;
import org.openrndr.extra.shadestyles.ColorspaceHelperKt;
import org.openrndr.math.Vector2;

@Description(title="Radial gradient")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b%\b\u0017\u0018\u0000*\u0016\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u0003*\u00020\u00042\u00020\u0005B?\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fR1\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u00008F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0017\u0010\u0018\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R1\u0010\u0007\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u00008F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001c\u0010\u0018\u0012\u0004\b\u0019\u0010\u0012\u001a\u0004\b\u001a\u0010\u0014\"\u0004\b\u001b\u0010\u0016R+\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u0018\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R1\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b'\u0010\u0018\u0012\u0004\b\"\u0010\u0012\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R1\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b+\u0010\u0018\u0012\u0004\b(\u0010\u0012\u001a\u0004\b)\u0010$\"\u0004\b*\u0010&R1\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b/\u0010\u0018\u0012\u0004\b,\u0010\u0012\u001a\u0004\b-\u0010$\"\u0004\b.\u0010&\u00a8\u00060"}, d2={"Lorg/openrndr/extra/shadestyles/RadialGradientBase;", "C", "Lorg/openrndr/color/ConvertibleToColorRGBa;", "Lorg/openrndr/color/AlgebraicColor;", "Lorg/openrndr/math/CastableToVector4;", "Lorg/openrndr/draw/ShadeStyle;", "color0", "color1", "offset", "Lorg/openrndr/math/Vector2;", "rotation", "", "length", "exponent", "<init>", "(Lorg/openrndr/color/ConvertibleToColorRGBa;Lorg/openrndr/color/ConvertibleToColorRGBa;Lorg/openrndr/math/Vector2;DDD)V", "<set-?>", "getColor0$annotations", "()V", "getColor0", "()Lorg/openrndr/color/ConvertibleToColorRGBa;", "setColor0", "(Lorg/openrndr/color/ConvertibleToColorRGBa;)V", "color0$delegate", "Lorg/openrndr/draw/ShadeStyle$Parameter;", "getColor1$annotations", "getColor1", "setColor1", "color1$delegate", "getOffset", "()Lorg/openrndr/math/Vector2;", "setOffset", "(Lorg/openrndr/math/Vector2;)V", "offset$delegate", "getRotation$annotations", "getRotation", "()D", "setRotation", "(D)V", "rotation$delegate", "getLength$annotations", "getLength", "setLength", "length$delegate", "getExponent$annotations", "getExponent", "setExponent", "exponent$delegate", "orx-shade-styles"})
public class RadialGradientBase<C extends ConvertibleToColorRGBa & AlgebraicColor<C>>
extends ShadeStyle {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ShadeStyle.Parameter color0$delegate;
    @NotNull
    private final ShadeStyle.Parameter color1$delegate;
    @NotNull
    private final ShadeStyle.Parameter offset$delegate;
    @NotNull
    private final ShadeStyle.Parameter rotation$delegate;
    @NotNull
    private final ShadeStyle.Parameter length$delegate;
    @NotNull
    private final ShadeStyle.Parameter exponent$delegate;

    public RadialGradientBase(@NotNull C color0, @NotNull C color1, @NotNull Vector2 offset, double rotation, double length, double exponent) {
        Intrinsics.checkNotNullParameter(color0, "color0");
        Intrinsics.checkNotNullParameter(color1, "color1");
        Intrinsics.checkNotNullParameter(offset, "offset");
        this.color0$delegate = new ShadeStyle.Parameter(this);
        this.color1$delegate = new ShadeStyle.Parameter(this);
        this.offset$delegate = new ShadeStyle.Parameter(this);
        this.rotation$delegate = new ShadeStyle.Parameter(this);
        this.length$delegate = new ShadeStyle.Parameter(this);
        this.exponent$delegate = new ShadeStyle.Parameter(this);
        ColorPhraseBook.INSTANCE.register();
        this.setColor0(color0);
        this.setColor1(color1);
        this.setOffset(offset);
        this.setRotation(rotation);
        this.setLength(length);
        this.setExponent(exponent);
        this.setFragmentPreamble(ShaderPreprocessorKt.preprocess("#pragma import color.oklab_to_linear_rgb\n#pragma import color.linear_rgb_to_srgb"));
        this.setFragmentTransform("\n            vec2 coord = (c_boundsPosition.xy - 0.5 + p_offset/2.0) * 2.0;\n            \n            float cr = cos(radians(p_rotation));\n            float sr = sin(radians(p_rotation));\n            mat2 rm = mat2(cr, -sr, sr, cr); \n            vec2 rc = rm * coord;\n            float f =  clamp(p_length * length(rc), 0.0, 1.0);            \n\n            vec4 color0 = p_color0;\n            vec4 color1 = p_color1; \n\n            vec4 gradient = mix(color0, color1, pow(f, p_exponent));\n            " + ColorspaceHelperKt.generateColorTransform(Reflection.getOrCreateKotlinClass(color0.getClass())) + "\n\n            x_fill *= gradient;\n        ");
    }

    public /* synthetic */ RadialGradientBase(ConvertibleToColorRGBa convertibleToColorRGBa, ConvertibleToColorRGBa convertibleToColorRGBa2, Vector2 vector2, double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            vector2 = Vector2.Companion.getZERO();
        }
        if ((n & 8) != 0) {
            d = 0.0;
        }
        if ((n & 0x10) != 0) {
            d2 = 1.0;
        }
        if ((n & 0x20) != 0) {
            d3 = 1.0;
        }
        this(convertibleToColorRGBa, convertibleToColorRGBa2, vector2, d, d2, d3);
    }

    @NotNull
    public final C getColor0() {
        return (C)((ConvertibleToColorRGBa)this.color0$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]));
    }

    public final void setColor0(@NotNull C c2) {
        Intrinsics.checkNotNullParameter(c2, "<set-?>");
        this.color0$delegate.setValue(this, (KProperty<?>)$$delegatedProperties[0], c2);
    }

    @ColorParameter(label="start color", order=0)
    public static /* synthetic */ void getColor0$annotations() {
    }

    @NotNull
    public final C getColor1() {
        return (C)((ConvertibleToColorRGBa)this.color1$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]));
    }

    public final void setColor1(@NotNull C c2) {
        Intrinsics.checkNotNullParameter(c2, "<set-?>");
        this.color1$delegate.setValue(this, (KProperty<?>)$$delegatedProperties[1], c2);
    }

    @ColorParameter(label="end color", order=1)
    public static /* synthetic */ void getColor1$annotations() {
    }

    @NotNull
    public final Vector2 getOffset() {
        return (Vector2)this.offset$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    public final void setOffset(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter(vector2, "<set-?>");
        this.offset$delegate.setValue(this, (KProperty<?>)$$delegatedProperties[2], vector2);
    }

    public final double getRotation() {
        return ((Number)this.rotation$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3])).doubleValue();
    }

    public final void setRotation(double d) {
        this.rotation$delegate.setValue(this, (KProperty<?>)$$delegatedProperties[3], d);
    }

    @DoubleParameter(label="rotation", low=-180.0, high=180.0, order=2)
    public static /* synthetic */ void getRotation$annotations() {
    }

    public final double getLength() {
        return ((Number)this.length$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[4])).doubleValue();
    }

    public final void setLength(double d) {
        this.length$delegate.setValue(this, (KProperty<?>)$$delegatedProperties[4], d);
    }

    @DoubleParameter(label="length", low=0.0, high=10.0)
    public static /* synthetic */ void getLength$annotations() {
    }

    public final double getExponent() {
        return ((Number)this.exponent$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[5])).doubleValue();
    }

    public final void setExponent(double d) {
        this.exponent$delegate.setValue(this, (KProperty<?>)$$delegatedProperties[5], d);
    }

    @DoubleParameter(label="exponent", low=0.01, high=10.0, order=3)
    public static /* synthetic */ void getExponent$annotations() {
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(RadialGradientBase.class, "color0", "getColor0()Lorg/openrndr/color/ConvertibleToColorRGBa;", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(RadialGradientBase.class, "color1", "getColor1()Lorg/openrndr/color/ConvertibleToColorRGBa;", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(RadialGradientBase.class, "offset", "getOffset()Lorg/openrndr/math/Vector2;", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(RadialGradientBase.class, "rotation", "getRotation()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(RadialGradientBase.class, "length", "getLength()D", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(RadialGradientBase.class, "exponent", "getExponent()D", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

