/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.objloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.extra.mesh.CompoundMeshData;
import org.openrndr.extra.mesh.IPolygon;
import org.openrndr.extra.objloader.ObjReaderKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00012\u0006\u0010\u0005\u001a\u00020\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u001a \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b\u001a \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000f"}, d2={"loadOBJ", "", "", "", "Lorg/openrndr/extra/mesh/IPolygon;", "fileOrUrl", "loadOBJasVertexBuffer", "Lorg/openrndr/draw/VertexBuffer;", "url", "Ljava/net/URL;", "file", "Ljava/io/File;", "loadOBJEx", "Lorg/openrndr/extra/mesh/CompoundMeshData;", "loadOBJMeshData", "orx-obj-loader"})
public final class OBJLoaderKt {
    @NotNull
    public static final Map<String, List<IPolygon>> loadOBJ(@NotNull String fileOrUrl) {
        Map<String, List<IPolygon>> map2;
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        try {
            URL url = new URL(fileOrUrl);
            map2 = OBJLoaderKt.loadOBJ(url);
        }
        catch (MalformedURLException e) {
            map2 = OBJLoaderKt.loadOBJ(new File(fileOrUrl));
        }
        return map2;
    }

    @NotNull
    public static final VertexBuffer loadOBJasVertexBuffer(@NotNull String fileOrUrl) {
        VertexBuffer vertexBuffer;
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        try {
            URL url = new URL(fileOrUrl);
            vertexBuffer = OBJLoaderKt.loadOBJasVertexBuffer(url);
        }
        catch (MalformedURLException e) {
            vertexBuffer = OBJLoaderKt.loadOBJasVertexBuffer(new File(fileOrUrl));
        }
        return vertexBuffer;
    }

    @NotNull
    public static final VertexBuffer loadOBJasVertexBuffer(@NotNull URL url) {
        Intrinsics.checkNotNullParameter(url, "url");
        String[] stringArray = url;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)stringArray);
        stringArray = new String[]{"\n"};
        return ObjReaderKt.loadOBJasVertexBuffer(StringsKt.split$default((CharSequence)new String(byArray, charset), stringArray, false, 0, 6, null));
    }

    @NotNull
    public static final VertexBuffer loadOBJasVertexBuffer(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return ObjReaderKt.loadOBJasVertexBuffer(FilesKt.readLines$default(file, null, 1, null));
    }

    @NotNull
    public static final Map<String, List<IPolygon>> loadOBJ(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return ObjReaderKt.loadOBJ(FilesKt.readLines$default(file, null, 1, null));
    }

    @NotNull
    public static final CompoundMeshData loadOBJEx(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return ObjReaderKt.readObjMeshData(FilesKt.readLines$default(file, null, 1, null));
    }

    @NotNull
    public static final Map<String, List<IPolygon>> loadOBJ(@NotNull URL url) {
        Intrinsics.checkNotNullParameter(url, "url");
        String[] stringArray = url;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)stringArray);
        stringArray = new String[]{"\n"};
        return ObjReaderKt.loadOBJ(StringsKt.split$default((CharSequence)new String(byArray, charset), stringArray, false, 0, 6, null));
    }

    @NotNull
    public static final CompoundMeshData loadOBJEx(@NotNull URL url) {
        Intrinsics.checkNotNullParameter(url, "url");
        String[] stringArray = url;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)stringArray);
        stringArray = new String[]{"\n"};
        return ObjReaderKt.readObjMeshData(StringsKt.split$default((CharSequence)new String(byArray, charset), stringArray, false, 0, 6, null));
    }

    @NotNull
    public static final CompoundMeshData loadOBJMeshData(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return ObjReaderKt.readObjMeshData(FilesKt.readLines$default(file, null, 1, null));
    }
}

